/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.db;

import com.fr.base.FRContext;
import com.fr.data.core.db.DBUtils;
import com.fr.data.impl.JDBCDatabaseConnection;
import com.fr.general.FRLogger;
import com.fr.general.GeneralContext;
import com.fr.general.IOUtils;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.web.ServletContext;
import com.fr.stable.web.ServletContextAdapter;
import com.fr.stable.web.ServletContextListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;

public class FineDB {
    private static JDBCDatabaseConnection db = null;
    private static String serverConfigBackupPath = "";
    private static final String FR_SERVER_CONFIG_BAK = "frbak";
    private static final String FINEDB_DATA = "db.data";
    private static final String FINEDB_BACKUP = "db.backup";
    private static final String FINEDB_PROP = "db.properties";
    private static final String FINEDB_SCRIPT = "db.script";
    private static final String[] FINEDB_FILES = new String[]{"db.data", "db.backup", "db.properties", "db.script"};
    private static final String[] DESIGNER_LIB_FILES = new String[]{"fr-designer-chart-8.0.jar", "fr-designer-core-8.0.jar", "fr-designer-report-8.0.jar"};

    public static JDBCDatabaseConnection getDB() {
        if (db == null) {
            FineDB.refreshDB();
        }
        return db;
    }

    private static synchronized void refreshDB() {
        db = DBUtils.getEmbeddedDB((String)"finedb", (int)2);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Class<FineDB> clazz = FineDB.class;
                    synchronized (FineDB.class) {
                        FineDB.shutdownDB();
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                    }
                }
                catch (Exception exception) {
                    FRLogger.getLogger().error(exception.getMessage());
                }
                {
                    return;
                }
            }
        });
    }

    private static synchronized void shutdownDB() throws Exception {
        if (db != null) {
            try {
                db.createConnection().createStatement().execute("shutdown");
            }
            finally {
                db = null;
            }
            if (StringUtils.isNotEmpty((String)FineDB.getServerConfigBackupPath())) {
                FineDB.deleteCurServerConfig(FineDB.getServerConfigBackupPath());
                FineDB.restoreCurServerProjectFiles(FineDB.getServerConfigBackupPath());
                FineDB.setServerConfigBackupPath("");
            }
        }
    }

    private static void deleteDirectory(String string) {
        try {
            File file = new File(string);
            if (file.isDirectory()) {
                File[] fileArray;
                for (File file2 : fileArray = file.listFiles()) {
                    FineDB.deleteDirectory(file2.toString());
                    file2.delete();
                }
            } else {
                file.delete();
            }
            file.delete();
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
        }
    }

    private static void deleteXmlFiles(File file) {
        if (file.isFile() && file.getPath().endsWith(".xml")) {
            file.delete();
        } else if (file.isDirectory()) {
            File[] fileArray = file.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.isFile() && file.getName().endsWith(".xml");
                }
            });
            if (fileArray == null) {
                return;
            }
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                FineDB.deleteXmlFiles(fileArray[i2]);
            }
        }
    }

    private static void moveXmlFiles(String string, String string2) {
        File file = new File(string2);
        try {
            if (file.isDirectory()) {
                File[] fileArray;
                for (File file2 : fileArray = file.listFiles()) {
                    IOUtils.copy((File)new File(StableUtils.pathJoin((String[])new String[]{string2, file2.getName()})), (File)new File(StableUtils.pathJoin((String[])new String[]{string, "resources"})));
                }
            }
            FineDB.deleteDirectory(string2);
        }
        catch (IOException iOException) {
            FRLogger.getLogger().error(iOException.getMessage());
        }
    }

    private static void moveDirectory(String string, String string2) {
        File file = new File(string);
        File file2 = new File(string2);
        try {
            if (file.exists() && file2.exists() && file.isDirectory() && file2.isDirectory()) {
                IOUtils.copy((File)file2, (File)file);
            }
            FineDB.deleteDirectory(string2);
        }
        catch (IOException iOException) {
            FRLogger.getLogger().error(iOException.getMessage());
        }
    }

    private static void moveDesignerLibDirectory(String string) {
        try {
            String string2 = StableUtils.pathJoin((String[])new String[]{string, "designer"});
            String string3 = StableUtils.pathJoin((String[])new String[]{StableUtils.getInstallHome(), "lib"});
            for (String string4 : DESIGNER_LIB_FILES) {
                IOUtils.copy((File)new File(string2, string4), (File)new File(StableUtils.pathJoin((String[])new String[]{string3})));
            }
            FineDB.deleteDirectory(string2);
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
        }
    }

    private static boolean isRestoring2OldBackup(String string) {
        File[] fileArray;
        File file = new File(string);
        return !file.exists() || !file.isDirectory() || (fileArray = file.listFiles()) == null || fileArray.length <= 2;
    }

    private static void deleteCurServerConfig(String string) {
        String string2 = FRContext.getCurrentEnv().getPath();
        FineDB.deleteXmlFiles(new File(StableUtils.pathJoin((String[])new String[]{string2, "resources"})));
        FineDB.deleteDirectory(StableUtils.pathJoin((String[])new String[]{string2, "finedb"}));
        if (!FineDB.isRestoring2OldBackup(StableUtils.pathJoin((String[])new String[]{string2, FR_SERVER_CONFIG_BAK, string}))) {
            String[] stringArray;
            for (String string3 : stringArray = new String[]{StableUtils.pathJoin((String[])new String[]{string2, "reportlets"}), StableUtils.pathJoin((String[])new String[]{string2, "plugins"}), StableUtils.pathJoin((String[])new String[]{string2, "classes"})}) {
                FineDB.deleteDirectory(string3);
            }
        }
    }

    private static void restoreCurServerConfig(String string) {
        String string2 = FRContext.getCurrentEnv().getPath();
        String string3 = StableUtils.pathJoin((String[])new String[]{string2, FR_SERVER_CONFIG_BAK, string, "finedb"});
        String string4 = StableUtils.pathJoin((String[])new String[]{string2, FR_SERVER_CONFIG_BAK, string, "resources"});
        FineDB.moveDirectory(string2, string3);
        FineDB.moveXmlFiles(string2, string4);
    }

    private static void restoreCurServerProjectFiles(String string) {
        String[] stringArray;
        String string2 = FRContext.getCurrentEnv().getPath();
        String string3 = StableUtils.pathJoin((String[])new String[]{string2, FR_SERVER_CONFIG_BAK, string});
        for (String string4 : stringArray = new String[]{StableUtils.pathJoin((String[])new String[]{string3, "finedb"}), StableUtils.pathJoin((String[])new String[]{string3, "resources"}), StableUtils.pathJoin((String[])new String[]{string3, "lib"}), StableUtils.pathJoin((String[])new String[]{string3, "reportlets"}), StableUtils.pathJoin((String[])new String[]{string3, "plugins"}), StableUtils.pathJoin((String[])new String[]{string3, "classes"})}) {
            FineDB.moveDirectory(string2, string4);
        }
        FineDB.moveDesignerLibDirectory(string3);
    }

    public static String getServerConfigBackupPath() {
        return serverConfigBackupPath;
    }

    public static void setServerConfigBackupPath(String string) {
        serverConfigBackupPath = string;
    }

    static {
        GeneralContext.addEnvChangedListener((EnvChangedListener)new EnvChangedListener(){

            public void envChanged() {
                db = null;
            }
        });
        ServletContext.addServletContextListener((ServletContextListener)new ServletContextAdapter(){

            public void onServletStop() {
                try {
                    FineDB.shutdownDB();
                }
                catch (Throwable throwable) {
                    FRContext.getLogger().error("shutdown embdb failed" + throwable.getMessage());
                }
            }
        });
    }
}

