/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.write;

import com.fr.base.FRContext;
import com.fr.base.ParameterMapNameSpace;
import com.fr.data.TableDataSource;
import com.fr.data.Verifier;
import com.fr.data.core.db.DBUtils;
import com.fr.data.impl.NameDatabaseConnection;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.GeneralUtils;
import com.fr.general.Inter;
import com.fr.general.RegistEditionException;
import com.fr.general.VT4FR;
import com.fr.general.data.MOD_COLUMN_ROW;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.report.extension.AttributeTarget;
import com.fr.report.report.WriteECReport;
import com.fr.report.worksheet.WorkSheet;
import com.fr.report.write.BuiltInSQLSubmiter;
import com.fr.report.write.CompatibleClassSubmiter;
import com.fr.report.write.FreeSQLSubmiter;
import com.fr.report.write.SubmitVisitor;
import com.fr.report.write.ValueVerifier;
import com.fr.report.write.WClassSubmiter;
import com.fr.script.Calculator;
import com.fr.stable.script.NameSpace;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import com.fr.web.core.A.wD;
import com.fr.write.DBManipulation;
import com.fr.write.DMLReport;
import com.fr.write.WriteException;
import com.fr.write.WriteSubmitException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportWriteAttr
implements AttributeTarget {
    public static final String XML_TAG = "ReportWriteAttr";
    public static final String ERROR_PREFIX = Inter.getLocText((String)"FR-Engine-Data_Submit_Error") + "\n";
    private List<SubmitVisitor> submitVisitorList = new ArrayList<SubmitVisitor>();
    private List<Verifier> verifierList = new ArrayList<Verifier>();

    public int getSubmitVisitorCount() {
        return this.submitVisitorList.size();
    }

    public SubmitVisitor getSubmitVisitor(int n2) {
        return this.submitVisitorList.get(n2);
    }

    public void addSubmitVisitor(SubmitVisitor submitVisitor) {
        this.submitVisitorList.add(submitVisitor);
    }

    public void addSubmitVisitor(String string, SubmitVisitor submitVisitor) {
        submitVisitor.setName(string);
        this.submitVisitorList.add(submitVisitor);
    }

    public void clearSubmitVisitors() {
        this.submitVisitorList.clear();
    }

    public void addVerifier(Verifier verifier) {
        this.verifierList.add(verifier);
    }

    public void addVerifier(String string, Verifier verifier) {
        boolean bl = false;
        for (Verifier verifier2 : this.verifierList) {
            if (!ComparatorUtils.equals((String)verifier2.getName(), (String)verifier.getName())) continue;
            bl = true;
            int n2 = verifier.getVerifyItemsCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                verifier2.addVerifyItem(verifier.getVerifyItem(i2));
            }
        }
        if (!bl) {
            this.verifierList.add(verifier);
        }
    }

    public void removeVerifier(int n2) {
        this.verifierList.remove(n2);
    }

    public int getVerifierCount() {
        return this.verifierList.size();
    }

    public int getValueVerifierCount() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.verifierList.size(); ++i2) {
            if (!(this.getVerifier(i2) instanceof ValueVerifier)) continue;
            ++n2;
        }
        return n2;
    }

    public Verifier getVerifier(int n2) {
        return this.verifierList.get(n2);
    }

    public void clearVerifiers() {
        this.verifierList.clear();
    }

    public void clearVerifiers(boolean bl) {
        int n2 = 0;
        int n3 = this.verifierList.size();
        while (n2 < n3 && n2 < this.verifierList.size()) {
            if (this.needToRemove(bl, this.verifierList.get(n2))) {
                this.verifierList.remove(n2);
                continue;
            }
            ++n2;
        }
    }

    private boolean needToRemove(boolean bl, Object object) {
        return bl && object instanceof ValueVerifier || !bl && !(object instanceof ValueVerifier);
    }

    public void submit(WriteECReport writeECReport, TableDataSource tableDataSource, Map<String, wD> map) throws WriteException {
        this.submit(writeECReport, tableDataSource, map, false, new HashMap<String, Connection>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submit(WriteECReport writeECReport, TableDataSource tableDataSource, Map<String, wD> map, boolean bl, Map<String, Connection> map2) throws WriteSubmitException {
        wD wD2 = map.get(wD.O);
        wD.A(wD2, (short)2, true, this.submitVisitorList.size());
        if (!this.submitVisitorList.isEmpty()) {
            HashMap<String, Connection> hashMap = new HashMap<String, Connection>();
            try {
                int n2 = this.submitVisitorList.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    wD.A(wD2, (short)2, false, i2);
                    if (!VT4FR.ADVANCED_ONLINE_WRITE.support() && i2 > 0) {
                        throw new RegistEditionException(VT4FR.ADVANCED_ONLINE_WRITE);
                    }
                    SubmitVisitor submitVisitor = this.submitVisitorList.get(i2);
                    try {
                        this.dealWithConn(submitVisitor, bl, map2, hashMap, writeECReport, tableDataSource, map);
                        submitVisitor.execute(writeECReport, tableDataSource, map);
                        continue;
                    }
                    catch (Exception exception) {
                        if (!bl) {
                            for (Map.Entry entry : hashMap.entrySet()) {
                                DBUtils.rollback((Connection)((Connection)entry.getValue()));
                            }
                        }
                        throw new WriteSubmitException(ERROR_PREFIX + exception.getMessage(), (Throwable)exception).setBuiltinFail(submitVisitor.isBuiltin());
                    }
                }
            }
            finally {
                this.dealWithCommitFinally(bl, hashMap);
            }
        } else {
            FRContext.getLogger().info("No Sumbitter defined!");
        }
    }

    private void dealWithConn(SubmitVisitor submitVisitor, boolean bl, Map<String, Connection> map, Map<String, Connection> map2, WriteECReport writeECReport, TableDataSource tableDataSource, Map map3) throws WriteException {
        Connection connection = null;
        if (submitVisitor instanceof BuiltInSQLSubmiter) {
            connection = this.dealWithConnOfBuiltInSQLSubmiter(submitVisitor, bl, map, map2, writeECReport, tableDataSource, map3);
        } else if (submitVisitor instanceof FreeSQLSubmiter) {
            connection = this.dealWithConnOfFreeSQLSubmiter(submitVisitor, bl, map, map2, writeECReport, tableDataSource, map3);
        } else if (submitVisitor instanceof WClassSubmiter) {
            connection = this.dealWithConnOfWClassSubmiter(submitVisitor, bl, map, map2, writeECReport, tableDataSource, map3);
        }
        submitVisitor.setConnection(connection);
    }

    private Connection dealWithConnOfBuiltInSQLSubmiter(SubmitVisitor submitVisitor, boolean bl, Map<String, Connection> map, Map<String, Connection> map2, WriteECReport writeECReport, TableDataSource tableDataSource, Map map3) throws WriteException {
        Connection connection = null;
        Calculator calculator = Calculator.createCalculator();
        calculator.setAttribute(DMLReport.KEY, (Object)writeECReport);
        calculator.setAttribute(TableDataSource.KEY, (Object)tableDataSource);
        calculator.pushNameSpace((NameSpace)ParameterMapNameSpace.create((Map)map3));
        DBManipulation dBManipulation = ((BuiltInSQLSubmiter)submitVisitor).getDBManipulation();
        if (dBManipulation.getDmlConfig() != null) {
            String string = dBManipulation.getDBName(calculator);
            NameDatabaseConnection nameDatabaseConnection = new NameDatabaseConnection(string);
            connection = map2.get(string);
            if (connection == null && bl) {
                connection = map.get(string);
            }
            if (connection == null) {
                try {
                    connection = nameDatabaseConnection.createConnection();
                    map2.put(string, connection);
                    map.put(string, connection);
                }
                catch (Exception exception) {
                    throw new WriteException(Inter.getLocText((String)"Utils-Can_not_create_connection") + ":" + dBManipulation.getDBName() + "\n" + exception.getMessage(), (Throwable)exception);
                }
            }
        }
        return connection;
    }

    private Connection dealWithConnOfFreeSQLSubmiter(SubmitVisitor submitVisitor, boolean bl, Map<String, Connection> map, Map<String, Connection> map2, WriteECReport writeECReport, TableDataSource tableDataSource, Map map3) throws WriteException {
        Connection connection = null;
        String string = ((FreeSQLSubmiter)submitVisitor).getDBName();
        NameDatabaseConnection nameDatabaseConnection = new NameDatabaseConnection(string);
        connection = map2.get(string);
        if (connection == null && bl) {
            connection = map.get(string);
        }
        if (connection == null) {
            try {
                connection = nameDatabaseConnection.createConnection();
                map2.put(((FreeSQLSubmiter)submitVisitor).getDBName(), connection);
                map.put(((FreeSQLSubmiter)submitVisitor).getDBName(), connection);
            }
            catch (Exception exception) {
                DBUtils.rollback((Connection)connection);
                throw new WriteException("can't connect to Database: " + ((FreeSQLSubmiter)submitVisitor).getDBName() + "\n" + exception.getMessage(), (Throwable)exception);
            }
        }
        return connection;
    }

    private Connection dealWithConnOfWClassSubmiter(SubmitVisitor submitVisitor, boolean bl, Map<String, Connection> map, Map<String, Connection> map2, WriteECReport writeECReport, TableDataSource tableDataSource, Map map3) throws WriteException {
        Connection connection = null;
        Calculator calculator = Calculator.createCalculator();
        calculator.setAttribute(DMLReport.KEY, (Object)writeECReport);
        calculator.setAttribute(TableDataSource.KEY, (Object)tableDataSource);
        calculator.pushNameSpace((NameSpace)ParameterMapNameSpace.create((Map)map3));
        String string = ((WClassSubmiter)submitVisitor).getDBName(calculator);
        if (string != null) {
            NameDatabaseConnection nameDatabaseConnection = new NameDatabaseConnection(string);
            connection = map2.get(string);
            if (connection == null && bl) {
                connection = map.get(string);
            }
            if (connection == null) {
                try {
                    connection = nameDatabaseConnection.createConnection();
                    map2.put(string, connection);
                    map.put(string, connection);
                }
                catch (Exception exception) {
                    DBUtils.rollback((Connection)connection);
                    throw new WriteException("can't connect to Database: " + string + "\n" + exception.getMessage(), (Throwable)exception);
                }
            }
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealWithCommitFinally(boolean bl, Map map) throws WriteSubmitException {
        if (!bl) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Connection connection = (Connection)entry.getValue();
                try {
                    if (connection == null || connection.isClosed()) continue;
                    try {
                        if (connection.getAutoCommit()) continue;
                        connection.commit();
                    }
                    catch (SQLException sQLException) {
                        DBUtils.rollback((Connection)connection);
                        while (iterator.hasNext()) {
                            Connection connection2 = (Connection)iterator.next().getValue();
                            DBUtils.rollback((Connection)connection2);
                            DBUtils.closeConnection((Connection)connection2);
                        }
                        throw new WriteSubmitException("Could not commit to Database : " + entry.getKey() + "\n" + sQLException.getMessage(), (Throwable)sQLException);
                    }
                }
                catch (SQLException sQLException) {
                    FRContext.getLogger().error(sQLException.getMessage(), (Throwable)sQLException);
                }
                finally {
                    DBUtils.closeConnection((Connection)connection);
                }
            }
        }
    }

    @Override
    public Object __mod_column_row(MOD_COLUMN_ROW mOD_COLUMN_ROW, WorkSheet workSheet) {
        ReportWriteAttr reportWriteAttr = null;
        try {
            reportWriteAttr = (ReportWriteAttr)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            FRLogger.getLogger().error(cloneNotSupportedException.getMessage());
        }
        this.__mod_report_write_attr(mOD_COLUMN_ROW, reportWriteAttr);
        workSheet.addAttributeTarget(reportWriteAttr);
        return mOD_COLUMN_ROW;
    }

    private void __mod_report_write_attr(MOD_COLUMN_ROW mOD_COLUMN_ROW, ReportWriteAttr reportWriteAttr) {
        if (reportWriteAttr != null) {
            int n2;
            int n3 = reportWriteAttr.getSubmitVisitorCount();
            for (n2 = 0; n2 < n3; ++n2) {
                reportWriteAttr.getSubmitVisitor(n2).__mod_column_row(mOD_COLUMN_ROW);
            }
            n2 = reportWriteAttr.getVerifierCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                reportWriteAttr.getVerifier(i2).__mod_column_row(mOD_COLUMN_ROW);
            }
        }
    }

    @Override
    public String xmlTag() {
        return XML_TAG;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("SubmitVisitor".equals(string)) {
                SubmitVisitor submitVisitor = (SubmitVisitor)GeneralXMLTools.readXMLable((XMLableReader)xMLableReader);
                this.addSubmitVisitor(submitVisitor);
            } else if ("TopVerifier".equals(string)) {
                Verifier verifier = (Verifier)GeneralXMLTools.readXMLable((XMLableReader)xMLableReader);
                this.addVerifier(verifier);
            } else if ("Verifier".equals(string)) {
                this.readOldVerifier(xMLableReader);
            } else if ("Submiter".equals(string)) {
                this.readOldSubmitter(xMLableReader);
            }
        }
    }

    private void readOldVerifier(XMLableReader xMLableReader) {
        String string = null;
        String string2 = null;
        string = xMLableReader.getAttrAsString("class", null);
        if (string != null) {
            string2 = string;
        }
        String string3 = null;
        string = xMLableReader.getAttrAsString("name", null);
        if (string != null) {
            string3 = string;
        }
        if (string2 != null && string3 != null) {
            ValueVerifier valueVerifier = null;
            if (string2.endsWith("VV")) {
                valueVerifier = new ValueVerifier();
            } else {
                try {
                    valueVerifier = (Verifier)GeneralUtils.classForName((String)string2).newInstance();
                }
                catch (Exception exception) {
                    FRContext.getLogger().errorWithServerLevel("Load class with name: " + string, (Throwable)exception);
                }
            }
            valueVerifier.setName(string3);
            xMLableReader.readXMLObject((XMLReadable)valueVerifier);
            this.addVerifier(string3, valueVerifier);
        }
    }

    private void readOldSubmitter(XMLableReader xMLableReader) {
        String string = null;
        String string2 = null;
        string = xMLableReader.getAttrAsString("class", null);
        if (string != null) {
            string2 = string;
        }
        String string3 = null;
        string = xMLableReader.getAttrAsString("name", null);
        if (string != null) {
            string3 = string;
        }
        if (string2 != null && string3 != null) {
            SubmitVisitor submitVisitor = null;
            if (string2.endsWith(".BuiltInSQLSubmiter")) {
                submitVisitor = new BuiltInSQLSubmiter();
            } else if (string2.endsWith(".FreeSQLSubmiter")) {
                submitVisitor = new FreeSQLSubmiter();
            } else if (string2.endsWith(".ClassSubmiter")) {
                submitVisitor = new CompatibleClassSubmiter();
            } else {
                try {
                    submitVisitor = (SubmitVisitor)GeneralUtils.classForName((String)string2).newInstance();
                }
                catch (Exception exception) {
                    FRContext.getLogger().errorWithServerLevel("Load class with name: " + string, (Throwable)exception);
                }
            }
            xMLableReader.readXMLObject((XMLReadable)submitVisitor);
            this.addSubmitVisitor(string3, submitVisitor);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        int n2;
        xMLPrintWriter.startTAG(XML_TAG);
        int n3 = this.getSubmitVisitorCount();
        for (n2 = 0; n2 < n3; ++n2) {
            SubmitVisitor submitVisitor = this.getSubmitVisitor(n2);
            GeneralXMLTools.writeXMLable((XMLPrintWriter)xMLPrintWriter, (XMLable)submitVisitor, (String)"SubmitVisitor");
        }
        n2 = this.getVerifierCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Verifier verifier = this.getVerifier(i2);
            GeneralXMLTools.writeXMLable((XMLPrintWriter)xMLPrintWriter, (XMLable)verifier, (String)"TopVerifier");
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        int n2;
        ReportWriteAttr reportWriteAttr = (ReportWriteAttr)super.clone();
        if (this.submitVisitorList != null) {
            reportWriteAttr.submitVisitorList = new ArrayList<SubmitVisitor>();
            for (n2 = 0; n2 < this.submitVisitorList.size(); ++n2) {
                reportWriteAttr.submitVisitorList.add((SubmitVisitor)this.submitVisitorList.get(n2).clone());
            }
        }
        if (this.verifierList != null) {
            reportWriteAttr.verifierList = new ArrayList<Verifier>();
            for (n2 = 0; n2 < this.verifierList.size(); ++n2) {
                reportWriteAttr.verifierList.add((Verifier)this.verifierList.get(n2).clone());
            }
        }
        return reportWriteAttr;
    }
}

