/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.log;

import com.fr.base.FRContext;
import com.fr.base.Parameter;
import com.fr.base.ParameterHelper;
import com.fr.data.AbstractParameterTableData;
import com.fr.data.core.db.DBUtils;
import com.fr.data.impl.MemCachedDBDataModel;
import com.fr.general.data.DataModel;
import com.fr.record.DBRecordManager;
import com.fr.record.RecordTables;
import com.fr.script.Calculator;
import com.fr.stable.ParameterProvider;
import java.sql.Connection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class LogRecordDBTableData
extends AbstractParameterTableData {
    private static boolean TABLE_CHECKED = false;

    public LogRecordDBTableData() {
        this.parameters = this.getDefineParameters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void checkTableExsit() {
        if (TABLE_CHECKED) {
            return;
        }
        Class<LogRecordDBTableData> clazz = LogRecordDBTableData.class;
        synchronized (LogRecordDBTableData.class) {
            if (!TABLE_CHECKED) {
                Connection connection = null;
                try {
                    connection = DBRecordManager.getDB().createConnection();
                    RecordTables recordTables = new RecordTables();
                    recordTables.generatorModuleTables(connection);
                }
                catch (Exception exception) {
                    FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
                }
                finally {
                    DBUtils.closeConnection((Connection)connection);
                }
                TABLE_CHECKED = true;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public DataModel createDataModel(Calculator calculator) {
        Object object;
        LogRecordDBTableData.checkTableExsit();
        ParameterProvider[] parameterProviderArray = super.processParameters(calculator);
        if (parameterProviderArray != null && this.onlyDay()) {
            for (int i2 = 0; i2 < parameterProviderArray.length; ++i2) {
                if ("START_TIME".equals(parameterProviderArray[i2].getName())) {
                    object = parameterProviderArray[i2].getValue();
                    if (object instanceof String) {
                        object = ((String)object).substring(0, 10);
                    }
                    parameterProviderArray[i2].setValue(object);
                    continue;
                }
                if (!"END_TIME".equals(parameterProviderArray[i2].getName())) continue;
                object = parameterProviderArray[i2].getValue();
                if (object instanceof String) {
                    String string = ((String)object).substring(0, 10);
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                    try {
                        Date date = simpleDateFormat.parse(string);
                        date = new Date(date.getTime() + 86400000L);
                        object = simpleDateFormat.format(date);
                    }
                    catch (ParseException parseException) {
                        throw new RuntimeException(parseException);
                    }
                }
                parameterProviderArray[i2].setValue(object);
            }
        }
        String string = ParameterHelper.analyzeCurrentContextTableData4Templatee((String)this.getQuery(), (ParameterProvider[])parameterProviderArray);
        object = new MemCachedDBDataModel(this.getDataBaseConnection(), string);
        return object;
    }

    protected boolean onlyDay() {
        return true;
    }

    protected com.fr.data.impl.Connection getDataBaseConnection() {
        return DBRecordManager.getDB();
    }

    protected abstract String getQuery();

    protected abstract Parameter[] getDefineParameters();
}

