/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.core;

import com.fr.general.ComparatorUtils;
import com.fr.general.FRFont;
import com.fr.general.Inter;
import com.fr.report.cell.cellattr.CurrencyLineAttr;
import com.fr.report.cell.painter.barcode.BarcodeException;
import com.fr.stable.StringUtils;
import com.fr.stable.pinyin.ChineseHelper;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;

public class CurrencyLineImpl {
    private static final String[] UNITS = new String[]{"in", "px", "cm", "mm"};
    private static final double DEFAULT_BAR_HEIGHT = 50.0;
    protected String data;
    protected double barWidth = 1.0;
    protected double barHeight;
    private Font font;
    private Color foreground;
    private Color background;
    private int defaultIntPart = 9;
    private int defaultDeciPart = 3;
    private boolean negative = false;
    private String intPart = "";
    private String deciPart = "";

    public CurrencyLineImpl(String string, CurrencyLineAttr currencyLineAttr) throws BarcodeException {
        this.defaultIntPart = currencyLineAttr.intPart;
        this.defaultDeciPart = currencyLineAttr.deciPart;
        if (string == null || string.length() == 0) {
            throw new BarcodeException(Inter.getLocText((String)"FR-Designer_Bar-Code-Exception-Tip"));
        }
        this.data = string;
        this.barHeight = 50.0;
        this.font = FRFont.getInstance((String)"Verdana", (int)0, (float)9.0f);
        this.background = Color.white;
        this.foreground = Color.black;
        this.setSVGScalar("in");
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setForeground(Color color) {
        this.foreground = color;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setFont(FRFont fRFont) {
        this.font = fRFont;
    }

    public void draw(Graphics2D graphics2D, int n2, int n3) {
        Object object;
        if (this.data.startsWith("-")) {
            object = "";
            this.negative = true;
            for (int i2 = 1; i2 < this.data.length(); ++i2) {
                object = (String)object + this.data.subSequence(i2, i2 + 1);
            }
            this.data = object;
        }
        object = graphics2D.getFontMetrics();
        String string = CurrencyLineImpl.containChinese(this.data) ? this.chineseText(this.data) : this.formatText(this.data);
        int n4 = n2 / (this.defaultIntPart + this.defaultDeciPart);
        int n5 = 3 - this.defaultIntPart % 3;
        graphics2D.setFont(this.font);
        graphics2D.setBackground(this.background);
        for (int i3 = 0; i3 < this.defaultIntPart + this.defaultDeciPart; ++i3) {
            graphics2D.setColor(Color.black);
            if (this.negative) {
                graphics2D.setColor(Color.red);
            }
            graphics2D.drawString(string.substring(i3, i3 + 1), this.xPoint(n4 * i3, n4, ((FontMetrics)object).stringWidth(string.substring(i3, i3 + 1))), this.yPoint(n3, ((FontMetrics)object).stringWidth(string.substring(i3, i3 + 1))));
            if (i3 < this.intPart.length() && (i3 + 1 + n5) % 3 == 0) {
                graphics2D.setColor(Color.green);
            } else {
                graphics2D.setColor(Color.gray);
            }
            if (i3 == this.defaultIntPart - 1) {
                graphics2D.setColor(Color.RED);
            }
            if (i3 == this.defaultIntPart + this.defaultDeciPart) continue;
            graphics2D.drawLine(n4 * (i3 + 1), 0, n4 * (i3 + 1), n3);
        }
    }

    private String formatText(String string) {
        int n2;
        int n3;
        if (string == null) {
            string = " ";
        }
        for (n3 = 0; n3 < (string.indexOf(".") == -1 ? string.length() : string.indexOf(".")); ++n3) {
            this.intPart = this.intPart + string.substring(n3, n3 + 1);
        }
        if (string.indexOf(".") == -1) {
            for (n3 = 0; n3 < this.defaultDeciPart; ++n3) {
                this.deciPart = this.deciPart + " ";
            }
        } else {
            for (n3 = string.indexOf(".") + 1; n3 < string.length(); ++n3) {
                this.deciPart = this.deciPart + string.substring(n3, n3 + 1);
            }
        }
        if (this.intPart.length() < this.defaultIntPart) {
            String string2 = "";
            for (n2 = 0; n2 < this.defaultIntPart - this.intPart.length(); ++n2) {
                string2 = string2 + " ";
            }
            this.intPart = string2 = string2 + this.intPart;
        }
        if (this.deciPart.length() < this.defaultDeciPart) {
            String string3 = "";
            string3 = string3 + this.deciPart;
            for (n2 = 0; n2 < this.defaultDeciPart - this.deciPart.length(); ++n2) {
                string3 = string3 + " ";
            }
            this.deciPart = string3;
        }
        return this.intPart + this.deciPart;
    }

    private String chineseText(String string) {
        if (string.length() < this.defaultIntPart + this.defaultDeciPart) {
            for (int i2 = string.length(); i2 < this.defaultIntPart + this.defaultDeciPart; ++i2) {
                string = string + " ";
            }
        }
        return string;
    }

    private int xPoint(int n2, int n3, int n4) {
        return n2 + (n3 - n4) / 2;
    }

    private int yPoint(int n2, int n3) {
        return (n2 + n3) / 2;
    }

    private void setSVGScalar(String string) {
        String string2 = "";
        boolean bl = false;
        for (int i2 = 0; !bl && i2 < UNITS.length; ++i2) {
            if (ComparatorUtils.equals((String)string, (String)UNITS[i2])) {
                bl = true;
            }
            if (i2 != 0) {
                string2 = string2 + ", ";
            }
            string2 = string2 + UNITS[i2];
        }
        if (!bl) {
            throw new IllegalArgumentException("SVG Units must be one of " + string2);
        }
    }

    private static boolean containChinese(String string) {
        if (StringUtils.isBlank((String)string)) {
            return false;
        }
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (!ChineseHelper.isChinese((char)c2)) continue;
            return true;
        }
        return false;
    }
}

