/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.cell.cellattr;

import com.fr.report.cell.painter.barcode.core.BarCodeUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;

public class BarcodeAttr
implements XMLable {
    public static final int CODE39 = 0;
    public static final int CODE39CHECK = 1;
    public static final int CODABAR = 2;
    public static final int CODE128 = 3;
    public static final int CODE128A = 4;
    public static final int CODE128B = 5;
    public static final int CODE128C = 6;
    public static final int EAN128 = 7;
    public static final int USPS = 8;
    public static final int SHIPMENT_ID = 9;
    public static final int SSCC_18 = 10;
    public static final int SCC_14 = 11;
    public static final int GTIN = 12;
    public static final int PDF417 = 13;
    public static final int USD_4 = 14;
    public static final int NW_7 = 15;
    public static final int QRCODE = 16;
    public static final int ITF25 = 17;
    public static final int EAN13 = 18;
    private static final int DEFAULT_WIDTH = 1;
    private static final int DEFAULT_HEIGHT = 30;
    private int type;
    private double barWidth = 1.0;
    private int barHeight = 30;
    private int RCodeVersion = 7;
    private int RCodeErrorCorrect = 1;
    private int RcodeDrawPix = 1;
    private boolean drawingText = true;

    public BarcodeAttr() {
        this(0);
    }

    public BarcodeAttr(int n2) {
        this.type = n2;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n2) {
        this.type = n2;
    }

    public double getBarWidth() {
        return this.barWidth;
    }

    public void setBarWidth(double d2) {
        this.barWidth = d2;
    }

    public int getBarHeight() {
        return this.barHeight;
    }

    public void setBarHeight(int n2) {
        this.barHeight = n2;
    }

    public boolean isDrawingText() {
        return this.drawingText;
    }

    public void setDrawingText(boolean bl) {
        this.drawingText = bl;
    }

    public void setRCodeVersion(int n2) {
        this.RCodeVersion = n2;
    }

    public void setRCodeErrorCorrect(int n2) {
        this.RCodeErrorCorrect = n2;
    }

    public void setRcodeDrawPix(int n2) {
        this.RcodeDrawPix = n2;
    }

    public int getRCodeVersion() {
        return this.RCodeVersion;
    }

    public int getRCodeErrorCorrect() {
        return this.RCodeErrorCorrect;
    }

    public int getRcodeDrawPix() {
        return this.RcodeDrawPix;
    }

    public void readXML(XMLableReader xMLableReader) {
        this.type = xMLableReader.getAttrAsInt("type", 0);
        this.barWidth = xMLableReader.getAttrAsDouble("width", 1.0);
        this.barHeight = xMLableReader.getAttrAsInt("height", 12);
        this.drawingText = xMLableReader.getAttrAsBoolean("draw", true);
        this.RCodeVersion = xMLableReader.getAttrAsInt("RCodeVersion", 7);
        this.RCodeErrorCorrect = xMLableReader.getAttrAsInt("RCodeErrorCorrect", 1);
        this.RcodeDrawPix = xMLableReader.getAttrAsInt("RcodeDrawPix", 1);
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("BarcodeAttr");
        if (this.type != 0) {
            xMLPrintWriter.attr("type", this.type);
        }
        if (this.barWidth != 1.0) {
            xMLPrintWriter.attr("width", this.barWidth);
        }
        if (this.barHeight != 30) {
            xMLPrintWriter.attr("height", this.barHeight);
        }
        if (!this.drawingText) {
            xMLPrintWriter.attr("draw", this.drawingText);
        }
        if (this.RCodeVersion >= 0) {
            xMLPrintWriter.attr("RCodeVersion", this.RCodeVersion);
        }
        if (this.RCodeErrorCorrect >= 0) {
            xMLPrintWriter.attr("RCodeErrorCorrect", this.RCodeErrorCorrect);
        }
        if (this.RcodeDrawPix > 0) {
            xMLPrintWriter.attr("RcodeDrawPix", this.RcodeDrawPix);
        }
        xMLPrintWriter.end();
    }

    public String toString() {
        return BarCodeUtils.getBarCodeTypeName(this.type);
    }

    public boolean equals(Object object) {
        return object instanceof BarcodeAttr && this.type == ((BarcodeAttr)object).type && this.barHeight == ((BarcodeAttr)object).barHeight && this.barWidth == ((BarcodeAttr)object).barWidth && this.drawingText == ((BarcodeAttr)object).drawingText && this.RCodeVersion == ((BarcodeAttr)object).RCodeVersion && this.RCodeErrorCorrect == ((BarcodeAttr)object).RCodeErrorCorrect && this.RcodeDrawPix == ((BarcodeAttr)object).RcodeDrawPix;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

