/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.cell;

import com.fr.base.BaseUtils;
import com.fr.base.Style;
import com.fr.base.background.ImageSerializable;
import com.fr.form.ui.Widget;
import com.fr.form.ui.WidgetXmlUtils;
import com.fr.general.ComparatorUtils;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.js.NameJavaScriptGroup;
import com.fr.privilege.finegrain.CellPrivilegeControl;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.cellattr.CellExpandAttr;
import com.fr.report.cell.cellattr.CellGUIAttr;
import com.fr.report.cell.cellattr.CellPageAttr;
import com.fr.report.cell.cellattr.core.attribute.CellElementAttribute;
import com.fr.report.cell.cellattr.core.attribute.OptionalAttribute;
import com.fr.report.cell.cellattr.core.attribute.SharedOptionalAttribute;
import com.fr.report.cell.cellattr.core.attribute.TemplateCellElementAttribute;
import com.fr.report.report.ResultECReport;
import com.fr.stable.Primitive;
import com.fr.stable.xml.XMLObject;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import com.fr.xml.SynchronizedStyleList;
import java.awt.Image;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public abstract class AbstractCellElement
implements CellElement {
    protected Style style = Style.DEFAULT_STYLE;
    protected OptionalAttribute optionalAttributes = SharedOptionalAttribute.EMPTY_ATTR;
    protected transient Object value = Primitive.NULL;
    private CellPrivilegeControl cellPrivilegeControl;

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        this.value = object;
    }

    public Object getShowValue() {
        return this.value;
    }

    public boolean isExist() {
        return true;
    }

    public void doExcelImportWithLeftSon(ResultECReport resultECReport, CellElement cellElement, int n2, int n3, int n4) {
    }

    public void doExcelImportWithUpSon(ResultECReport resultECReport, CellElement cellElement, int n2, int n3, int n4) {
    }

    public boolean isReadyToDelete() {
        return false;
    }

    public CellPrivilegeControl getCellPrivilegeControl() {
        if (this.cellPrivilegeControl == null) {
            this.cellPrivilegeControl = new CellPrivilegeControl();
        }
        return this.cellPrivilegeControl;
    }

    public void setCellPrivilegeControl(CellPrivilegeControl cellPrivilegeControl) {
        this.cellPrivilegeControl = cellPrivilegeControl;
    }

    public CellExpandAttr getCellExpandAttr() {
        return new CellExpandAttr();
    }

    public boolean isDoneAuthority(String string) {
        if (string == null) {
            return false;
        }
        return this.getCellPrivilegeControl().checkInvisible(string);
    }

    public boolean isDoneNewValueAuthority(String string) {
        if (string == null) {
            return false;
        }
        return this.getCellPrivilegeControl().getNewValueMap().containsKey(string);
    }

    public void changeAuthorityState(String string, boolean bl) {
        if (string == null) {
            return;
        }
        if (bl) {
            this.getCellPrivilegeControl().removeInvisibleRole(string);
        } else {
            this.getCellPrivilegeControl().addInvisibleRole(string);
            this.getCellPrivilegeControl().addInvisibleRole(string);
            if (this.getCellPrivilegeControl().getNewValueMap().containsKey(string)) {
                this.getCellPrivilegeControl().getNewValueMap().remove(string);
            }
        }
    }

    public void changeNewValueAuthorityState(String string, boolean bl, Object object) {
        if (string == null) {
            return;
        }
        this.getCellPrivilegeControl().getNewValueMap().remove(string);
        if (bl) {
            this.getCellPrivilegeControl().getNewValueMap().put(string, object);
        }
    }

    public void cleanAuthority(String string) {
        if (string == null) {
            return;
        }
        if (this.getCellPrivilegeControl().checkInvisible(string)) {
            this.getCellPrivilegeControl().removeInvisibleRole(string);
        }
        if (this.getCellPrivilegeControl().getNewValueMap().containsKey(string)) {
            this.getCellPrivilegeControl().getNewValueMap().remove(string);
        }
    }

    public Style getStyle() {
        if (this.style == null) {
            this.style = Style.DEFAULT_STYLE;
        }
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    protected abstract CellElementAttribute getNameHyperLinkGroupAttr();

    public NameJavaScriptGroup getNameHyperlinkGroup() {
        return (NameJavaScriptGroup)this.optionalAttributes.get(this.getNameHyperLinkGroupAttr());
    }

    public void setNameHyperlinkGroup(NameJavaScriptGroup nameJavaScriptGroup) {
        this.putAttr(this.getNameHyperLinkGroupAttr(), nameJavaScriptGroup);
    }

    protected void putAttr(CellElementAttribute cellElementAttribute, Object object) {
        this.ensureAttrNotShared();
        if (object == null) {
            this.removeAttr(cellElementAttribute);
            return;
        }
        this.optionalAttributes.put(cellElementAttribute, object);
    }

    protected void removeAttr(CellElementAttribute cellElementAttribute) {
        this.optionalAttributes.remove(cellElementAttribute);
        if (this.optionalAttributes.size() == 0) {
            this.optionalAttributes = SharedOptionalAttribute.EMPTY_ATTR;
        }
    }

    protected abstract CellElementAttribute getCellGUIAttrAttr();

    public CellGUIAttr getCellGUIAttr() {
        return (CellGUIAttr)this.optionalAttributes.get(this.getCellGUIAttrAttr());
    }

    public void setCellGUIAttr(CellGUIAttr cellGUIAttr) {
        this.putAttr(this.getCellGUIAttrAttr(), cellGUIAttr);
    }

    protected abstract CellElementAttribute getPageAttr();

    public CellPageAttr getCellPageAttr() {
        return (CellPageAttr)this.optionalAttributes.get(this.getPageAttr());
    }

    public Object getCellWidgetAttr() {
        return this.optionalAttributes.get(TemplateCellElementAttribute.WIDGET);
    }

    public void setCellPageAttr(CellPageAttr cellPageAttr) {
        this.putAttr(this.getPageAttr(), cellPageAttr);
    }

    protected void ensureAttrNotShared() {
        if (this.optionalAttributes == OptionalAttribute.EMPTY_ATTR) {
            this.optionalAttributes = new OptionalAttribute();
        } else if (this.optionalAttributes instanceof SharedOptionalAttribute) {
            this.optionalAttributes = ((SharedOptionalAttribute)this.optionalAttributes).copyToNewOptionalAttribute();
        }
    }

    public OptionalAttribute getOptionalAttributes() {
        return this.optionalAttributes;
    }

    public void setOptionalAttributes(OptionalAttribute optionalAttribute) {
        this.optionalAttributes = optionalAttribute;
    }

    public CellElement deriveCellElement(int n2, int n3) {
        try {
            AbstractCellElement abstractCellElement = (AbstractCellElement)this.lightClone();
            abstractCellElement.setRow(n3);
            abstractCellElement.setColumn(n2);
            return abstractCellElement;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    public CellElement deriveCellElement(int n2, int n3, int n4, int n5) {
        try {
            AbstractCellElement abstractCellElement = (AbstractCellElement)this.lightClone();
            abstractCellElement.setRow(n3);
            abstractCellElement.setRowSpan(n5);
            abstractCellElement.setColumn(n2);
            abstractCellElement.setColumnSpan(n4);
            return abstractCellElement;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    public CellElement clone(int n2, int n3, int n4, int n5) throws CloneNotSupportedException {
        AbstractCellElement abstractCellElement = (AbstractCellElement)this.clone();
        abstractCellElement.setColumn(n2);
        abstractCellElement.setRow(n3);
        abstractCellElement.setColumnSpan(n4);
        abstractCellElement.setRowSpan(n5);
        return abstractCellElement;
    }

    public Object lightClone() throws CloneNotSupportedException {
        return super.clone();
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractCellElement abstractCellElement = (AbstractCellElement)super.clone();
        if (this.getValue() != null) {
            abstractCellElement.setValue(BaseUtils.cloneObject((Object)this.getValue()));
        }
        abstractCellElement.optionalAttributes = (OptionalAttribute)this.optionalAttributes.clone();
        if (this.getStyle() != null) {
            abstractCellElement.setStyle(this.getStyle());
        }
        abstractCellElement.setCellPrivilegeControl((CellPrivilegeControl)this.getCellPrivilegeControl().clone());
        return abstractCellElement;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        Object object = objectInputStream.readObject();
        if (object != null) {
            this.value = object instanceof ImageSerializable ? ((ImageSerializable)object).getImage() : object;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.value != null && this.value instanceof Image) {
            ImageSerializable imageSerializable = new ImageSerializable((Image)this.value);
            objectOutputStream.writeObject(imageSerializable);
        } else {
            objectOutputStream.writeObject(this.value);
        }
    }

    public void writeCommonResultAttrXML(XMLPrintWriter xMLPrintWriter) {
        Object object = this.getShowValue();
        if (object != null) {
            GeneralXMLTools.writeObject((XMLPrintWriter)xMLPrintWriter, (Object)object);
        }
        this.writerAttrXML(xMLPrintWriter);
    }

    private void writerAttrXML(XMLPrintWriter xMLPrintWriter) {
        Object object = this.getNameHyperlinkGroup();
        if (object != null) {
            object.writeXML(xMLPrintWriter);
        }
        if ((object = this.getCellGUIAttr()) != null) {
            ((CellGUIAttr)object).writeXML(xMLPrintWriter);
        }
        if ((object = this.getCellPageAttr()) != null) {
            ((CellPageAttr)object).writeXML(xMLPrintWriter);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        Object object = this.getValue();
        if (object != null) {
            GeneralXMLTools.writeObject((XMLPrintWriter)xMLPrintWriter, (Object)object);
        }
        if ((object = this.getCellPrivilegeControl()) != null) {
            ((CellPrivilegeControl)object).writeXML(xMLPrintWriter);
        }
        this.writerAttrXML(xMLPrintWriter);
    }

    protected void setCompatibleWidget(Widget widget) {
    }

    protected abstract Object dealWithSaveValue4Compatible(Object var1);

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            this.setColumn(Math.max(xMLableReader.getAttrAsInt("c", 0), 0));
            this.setRow(Math.max(xMLableReader.getAttrAsInt("r", 0), 0));
            this.setColumnSpan(Math.max(xMLableReader.getAttrAsInt("cs", 1), 1));
            this.setRowSpan(Math.max(xMLableReader.getAttrAsInt("rs", 1), 1));
            String string = xMLableReader.getAttrAsString("s", null);
            if (string != null) {
                SynchronizedStyleList.getSynchronizedStyleList().put(Integer.parseInt(string), this);
            }
        }
        if (xMLableReader.isChildNode()) {
            this.doWithChildNode(xMLableReader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWithChildNode(XMLableReader xMLableReader) {
        boolean bl;
        String string = xMLableReader.getTagName();
        boolean bl2 = ComparatorUtils.equals((String)"NameJavaScriptGroup", (String)string) || ComparatorUtils.equals((String)"NameHyperlinkGroup", (String)string);
        boolean bl3 = bl = ComparatorUtils.equals((String)"NameHyperlinks", (String)string) || ComparatorUtils.equals((String)"HyperlinkMap", (String)string);
        if (ComparatorUtils.equals((String)"Object", (String)string) || ComparatorUtils.equals((String)"O", (String)string)) {
            Object object;
            try {
                xMLableReader.ckeckBlankContent = true;
                Object object2 = xMLableReader.getContextAttribute((Object)"string2Formula");
                boolean bl4 = object2 != null && ComparatorUtils.equals((Object)Boolean.TRUE, (Object)object2);
                object = GeneralXMLTools.readObject((XMLableReader)xMLableReader, (boolean)bl4);
            }
            finally {
                xMLableReader.ckeckBlankContent = false;
            }
            this.setValue(this.dealWithSaveValue4Compatible(object));
        } else if (bl2 || bl) {
            NameJavaScriptGroup nameJavaScriptGroup = new NameJavaScriptGroup();
            xMLableReader.readXMLObject((XMLReadable)nameJavaScriptGroup);
            this.setNameHyperlinkGroup(nameJavaScriptGroup);
        } else if ("CellGUIAttr".equals(string)) {
            XMLObject xMLObject = this.readCellGUIAttr(xMLableReader);
            this.setCellGUIAttr((CellGUIAttr)xMLObject.getObject());
        } else if ("CellPageAttr".equals(string) || "CellAttr".equals(string)) {
            CellPageAttr cellPageAttr = new CellPageAttr();
            xMLableReader.readXMLObject((XMLReadable)cellPageAttr);
            this.setCellPageAttr(cellPageAttr);
        } else if (ComparatorUtils.equals((String)"PrivilegeControl", (String)string)) {
            CellPrivilegeControl cellPrivilegeControl = new CellPrivilegeControl();
            xMLableReader.readXMLObject((XMLReadable)cellPrivilegeControl);
            this.setCellPrivilegeControl(cellPrivilegeControl);
        } else if ("PrivilegeInvisible".equals(string)) {
            String[] stringArray = xMLableReader.getAttrAsString("privilegeInvisibleSet", "").split(",");
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.getCellPrivilegeControl().addInvisibleRole(stringArray[i2]);
            }
        }
    }

    private XMLObject readCellGUIAttr(XMLableReader xMLableReader) {
        XMLObject xMLObject = new XMLObject(new CellGUIAttr()){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isAttr()) {
                    ((CellGUIAttr)this.obj).readXML(xMLableReader);
                } else if (xMLableReader.isChildNode()) {
                    String string = xMLableReader.getTagName();
                    if (ComparatorUtils.equals((String)"Widget", (String)string) || ComparatorUtils.equals((String)"CellEditorDef", (String)string)) {
                        AbstractCellElement.this.setCompatibleWidget(WidgetXmlUtils.readCellWidget((XMLableReader)xMLableReader));
                    } else {
                        ((CellGUIAttr)this.obj).readXML(xMLableReader);
                    }
                }
            }
        };
        xMLableReader.readXMLObject((XMLReadable)xMLObject);
        return xMLObject;
    }

    public boolean equals(Object object) {
        return object instanceof AbstractCellElement && ComparatorUtils.equals((Object)this.style, (Object)((AbstractCellElement)object).style) && ComparatorUtils.equals((Object)this.optionalAttributes, (Object)((AbstractCellElement)object).optionalAttributes) && ComparatorUtils.equals((Object)this.value, (Object)((AbstractCellElement)object).value);
    }
}

