/*
 * Decompiled with CFR 0.152.
 */
package com.fr.page.generator;

import com.fr.base.DynamicUnitList;
import com.fr.base.FRContext;
import com.fr.cache.list.IntList;
import com.fr.general.Inter;
import com.fr.page.ClippedECPage;
import com.fr.page.PG;
import com.fr.page.PaperSettingProvider;
import com.fr.page.ReportPage;
import com.fr.report.ReportHelper;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.FloatElement;
import com.fr.report.cell.cellattr.CellPageAttr;
import com.fr.report.report.ResultECReport;
import com.fr.report.stable.ReportSettings;
import com.fr.stable.FT;
import com.fr.stable.unit.UNIT;
import java.awt.Point;
import java.util.Iterator;
import java.util.List;

public abstract class PageGenerator
extends PG {
    protected ResultECReport showReport;
    protected DynamicUnitList columnWidthList;
    protected DynamicUnitList rowHeightList;

    public PageGenerator(ResultECReport resultECReport, PaperSettingProvider paperSettingProvider) {
        super(resultECReport, paperSettingProvider);
        this.showReport = resultECReport;
        this.columnWidthList = ReportHelper.getColumnWidthList(resultECReport);
        this.rowHeightList = ReportHelper.getRowHeightList(resultECReport);
    }

    protected void collectBreaks(IntList intList, IntList intList2, IntList intList3, IntList intList4) {
        Iterator iterator = this.showReport.cellIterator();
        while (iterator.hasNext()) {
            int n2;
            CellElement cellElement = (CellElement)iterator.next();
            CellPageAttr cellPageAttr = cellElement.getCellPageAttr();
            if (cellPageAttr == null || cellPageAttr.equals(CellPageAttr.DEFAULT_CELLPAGEATTR)) continue;
            if (!cellPageAttr.isCanBreakOnPaginate()) {
                int n3;
                int n4 = cellElement.getRow() + cellElement.getRowSpan();
                for (n3 = cellElement.getRow() + 1; n3 < n4; ++n3) {
                    intList3.add(n3);
                }
                n4 = cellElement.getColumn() + cellElement.getColumnSpan();
                for (n3 = cellElement.getColumn() + 1; n3 < n4; ++n3) {
                    intList4.add(n3);
                }
                continue;
            }
            if (cellPageAttr.isPageAfterColumn() && (n2 = cellElement.getColumn() + cellElement.getColumnSpan()) > 0) {
                intList.add(n2);
            }
            if (cellPageAttr.isPageBeforeColumn() && (n2 = cellElement.getColumn()) > 0) {
                intList.add(n2);
            }
            if (cellPageAttr.isPageAfterRow() && (n2 = cellElement.getRow() + cellElement.getRowSpan()) > 0) {
                intList2.add(n2);
            }
            if (!cellPageAttr.isPageBeforeRow() || (n2 = cellElement.getRow()) <= 0) continue;
            intList2.add(n2);
        }
    }

    protected void dealWithPageInforByPaperSize(UNIT uNIT, UNIT uNIT2) {
        int n2 = 0;
        int n3 = 0;
        Iterator iterator = this.showReport.floatIterator();
        while (iterator.hasNext()) {
            FloatElement floatElement = (FloatElement)iterator.next();
            Object[] objectArray = ReportHelper.calculateLastColumnAndRowOfFloatElement(this.showReport, floatElement);
            n2 = Math.max(n2, ((Point)objectArray[0]).x + 1);
            n3 = Math.max(n3, ((Point)objectArray[0]).y + 1);
        }
        n2 = Math.max(n2, this.showReport.getColumnCount());
        n3 = Math.max(n3, this.showReport.getRowCount());
        this.calcPageCount(n3, n2, uNIT, uNIT2);
    }

    protected abstract void calcPageCount(int var1, int var2, UNIT var3, UNIT var4);

    protected void generatePages() {
        int n2 = 0;
        List list = this.get_page_column_ft_LL();
        List list2 = this.get_page_row_ft_LL();
        switch (this.reportSettings.getPageOrder()) {
            case 0: {
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    for (int i3 = 0; i3 < list2.size(); ++i3) {
                        this.dealWithReportPage((List)list2.get(i3), (List)list.get(i2), n2, i2, i3);
                        ++n2;
                    }
                }
                break;
            }
            default: {
                for (int i4 = 0; i4 < list2.size(); ++i4) {
                    for (int i5 = 0; i5 < list.size(); ++i5) {
                        this.dealWithReportPage((List)list2.get(i4), (List)list.get(i5), n2, i5, i4);
                        ++n2;
                    }
                }
            }
        }
        FRContext.getLogger().info(Inter.getLocText((String)"INFO-Page_is_Generated"));
    }

    protected abstract List get_page_column_ft_LL();

    protected abstract List get_page_row_ft_LL();

    private void dealWithReportPage(List list, List list2, int n2, int n3, int n4) {
        try {
            ReportSettings reportSettings = (ReportSettings)this.reportSettings.clone();
            reportSettings.setPaperSetting(this.paperSetting);
            ReportPage reportPage = new ReportPage(this.showReport, 1, n3, n4, reportSettings);
            ClippedECPage clippedECPage = new ClippedECPage(this.showReport, this.showReport, 1, this.paperSetting, list.toArray(new FT[list.size()]), list2.toArray(new FT[list2.size()]), n3, n4);
            reportPage.addClippedPage(clippedECPage);
            this.addReportPage2List(reportPage, n2);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            FRContext.getLogger().error(cloneNotSupportedException.getMessage(), (Throwable)cloneNotSupportedException);
        }
    }
}

