/*
 * Decompiled with CFR 0.152.
 */
package com.fr.page;

import com.fr.base.BaseUtils;
import com.fr.base.BaseXMLUtils;
import com.fr.base.DynamicNumberList;
import com.fr.base.DynamicPixList;
import com.fr.base.DynamicUnitList;
import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.base.ParameterMapNameSpace;
import com.fr.base.Style;
import com.fr.base.background.ColorBackground;
import com.fr.cache.list.IntList;
import com.fr.data.DataUtils;
import com.fr.data.TableDataSource;
import com.fr.general.Background;
import com.fr.general.ComparatorUtils;
import com.fr.general.FArray;
import com.fr.general.PageCalObj;
import com.fr.js.JavaScript;
import com.fr.js.NameJavaScript;
import com.fr.js.NameJavaScriptGroup;
import com.fr.page.ClippedPage;
import com.fr.page.ClippedPageProvider;
import com.fr.page.PagePainterProvider;
import com.fr.page.PaperSettingProvider;
import com.fr.page.ReportPageAttrProvider;
import com.fr.page.stable.ReportPageAttr;
import com.fr.parser.ColumnRowRangeInPage;
import com.fr.report.ExtraReportClassManager;
import com.fr.report.ReportHelper;
import com.fr.report.cell.Cell;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.FloatElement;
import com.fr.report.cell.cellattr.BrokenCellInfo;
import com.fr.report.cell.cellattr.CellGUIAttr;
import com.fr.report.cell.cellattr.CellPageAttr;
import com.fr.report.cell.cellattr.PageExportCellElement;
import com.fr.report.cell.cellattr.core.ResultSubReport;
import com.fr.report.cellcase.CellCase;
import com.fr.report.cellcase.DefaultCellCase;
import com.fr.report.core.A.e;
import com.fr.report.core.PaintUtils;
import com.fr.report.core.ReportUtils;
import com.fr.report.elementcase.ElementCase;
import com.fr.report.elementcase.ElementGetter;
import com.fr.report.elementcase.ResultElementCase;
import com.fr.report.fun.PageCalObjectProcessor;
import com.fr.report.report.Report;
import com.fr.report.report.ResultReport;
import com.fr.script.Calculator;
import com.fr.stable.CoreGraphHelper;
import com.fr.stable.DeathCycleException;
import com.fr.stable.FCloneable;
import com.fr.stable.FT;
import com.fr.stable.ParameterProvider;
import com.fr.stable.Primitive;
import com.fr.stable.StringUtils;
import com.fr.stable.UtilEvalError;
import com.fr.stable.core.NodeVisitor;
import com.fr.stable.script.AbstractNameSpace;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.script.ColumnRowRange;
import com.fr.stable.script.NameSpace;
import com.fr.stable.unit.FU;
import com.fr.stable.unit.PT;
import com.fr.stable.unit.UNIT;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.FRFile;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import com.fr.web.output.Outlet;
import com.fr.xml.ReportXMLUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.imageio.ImageIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClippedECPage
extends ClippedPage
implements ElementGetter,
Serializable,
FCloneable {
    protected static final String XML_TAG = "ClippedPage";
    protected ResultReport source_report;
    protected ResultElementCase source_element_case;
    private FT[] column_line_array;
    private FT[] row_line_array;
    private IntList row_height_index_list = null;
    private IntList column_width_index_list = null;
    private DynamicPixList columnWidthList;
    private DynamicPixList rowHeightList;
    private int[] minColWidths;
    private PaperSettingProvider paperSetting;
    private static Iterator emptyIterator = new Iterator(){

        public void remove() {
        }

        public Object next() {
            return null;
        }

        public boolean hasNext() {
            return false;
        }
    };

    public ClippedECPage() {
        super((UNIT)UNIT.ZERO, (UNIT)UNIT.ZERO, 0, 0);
    }

    public ClippedECPage(ResultReport resultReport, ResultElementCase resultElementCase, int n2, PaperSettingProvider paperSettingProvider, FT[] fTArray, FT[] fTArray2, int n3, int n4) {
        this(resultReport, resultElementCase, n2, paperSettingProvider, fTArray, fTArray2, (UNIT)UNIT.ZERO, (UNIT)UNIT.ZERO, n3, n4);
    }

    public ClippedECPage(ResultReport resultReport, ResultElementCase resultElementCase, int n2, PaperSettingProvider paperSettingProvider, FT[] fTArray, FT[] fTArray2, UNIT uNIT, UNIT uNIT2, int n3, int n4) {
        super(uNIT, uNIT2, n3, n4);
        this.source_report = resultReport;
        this.source_element_case = resultElementCase;
        this.totalPageNumber = n2;
        this.row_line_array = fTArray;
        this.column_line_array = fTArray2;
        this.paperSetting = paperSettingProvider;
        this.columnWidthList = ReportHelper.getColumnWidthList(this.source_element_case).toDynamicPixList();
        this.rowHeightList = ReportHelper.getRowHeightList(this.source_element_case).toDynamicPixList();
        this.initRowHeightArray();
        this.initColumnWidthArray();
    }

    @Override
    public UNIT getActualWidth() {
        FU fU = UNIT.ZERO;
        for (int i2 = 0; i2 < this.getColumnCount(); ++i2) {
            fU = fU.add((UNIT)this.getColumnWidth(i2));
        }
        return fU;
    }

    @Override
    public UNIT getActualHeight() {
        FU fU = UNIT.ZERO;
        for (int i2 = 0; i2 < this.getRowCount(); ++i2) {
            fU = fU.add((UNIT)this.getRowHeight(i2));
        }
        return fU;
    }

    private void initColumnWidthArray() {
        if (this.column_width_index_list == null) {
            this.column_width_index_list = new IntList();
            for (int i2 = 0; i2 < this.column_line_array.length; ++i2) {
                FT fT = this.column_line_array[i2];
                for (int i3 = fT.from; i3 < fT.to; ++i3) {
                    this.column_width_index_list.add(i3);
                }
            }
        }
    }

    private void initRowHeightArray() {
        if (this.row_height_index_list == null) {
            this.row_height_index_list = new IntList();
            for (int i2 = 0; i2 < this.row_line_array.length; ++i2) {
                FT fT = this.row_line_array[i2];
                for (int i3 = fT.from; i3 < fT.to; ++i3) {
                    this.row_height_index_list.add(i3);
                }
            }
        }
    }

    private Iterator cellIterator(Rectangle rectangle) {
        return this.source_element_case.intersect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public void paintPage(PagePainterProvider pagePainterProvider, Graphics2D graphics2D, int n2) {
        DynamicNumberList dynamicNumberList = this.getColumnWidthDynamicPixList();
        DynamicNumberList dynamicNumberList2 = this.getRowHeightDynamicPixList();
        int n3 = this.getOffsetX().toPixI(n2);
        int n4 = this.getOffsetY().toPixI(n2);
        pagePainterProvider.prepareCell((ClippedPageProvider)this, dynamicNumberList, dynamicNumberList2, n3, n4);
        pagePainterProvider.prepareFloat((ClippedPageProvider)this, dynamicNumberList, dynamicNumberList2, n3, n4);
    }

    @Override
    public int[] getMinColWidths() {
        return this.minColWidths;
    }

    public <T> T output(Outlet<T> outlet, T t2, Repository repository, String string, NodeVisitor nodeVisitor) throws Exception {
        if (StringUtils.isNotEmpty((String)string)) {
            this.executeMinColumnWidth();
        }
        return (T)outlet.clippedPageOutput((ClippedPageProvider)this, t2, string, nodeVisitor);
    }

    private void executeMinColumnWidth() {
        if (this.source_element_case == null) {
            return;
        }
        int n2 = this.source_element_case.getColumnCount();
        IntList intList = new IntList(n2);
        int n3 = n2;
        for (int i2 = 0; i2 < n3; ++i2) {
            intList.add(0);
        }
        DynamicUnitList dynamicUnitList = ReportHelper.getRowHeightList(this.source_element_case);
        DynamicUnitList dynamicUnitList2 = ReportHelper.getColumnWidthList(this.source_element_case);
        Iterator iterator = this.source_element_case.cellIterator();
        int n4 = ReportUtils.getReportSettings(this.source_report).getShrinkToFitMode();
        while (iterator.hasNext()) {
            CellElement cellElement = (CellElement)iterator.next();
            this.iteratorEachCell(cellElement, intList, dynamicUnitList, dynamicUnitList2, n4);
        }
        this.minColWidths = intList.toArray();
    }

    private void iteratorEachCell(CellElement cellElement, IntList intList, DynamicUnitList dynamicUnitList, DynamicUnitList dynamicUnitList2, int n2) {
        int n3 = cellElement.getColumn();
        int n4 = cellElement.getColumn() + cellElement.getColumnSpan();
        int n5 = cellElement.getColumn();
        int n6 = cellElement.getRow();
        int n7 = cellElement.getColumnSpan();
        int n8 = cellElement.getRowSpan();
        long l2 = dynamicUnitList2.getRangeValue(n3, n4).toFU();
        long l3 = dynamicUnitList.getRangeValue(n6, n6 + n8).toFU();
        if (l2 == 0L) {
            return;
        }
        CellGUIAttr cellGUIAttr = cellElement.getCellGUIAttr();
        cellGUIAttr = cellGUIAttr == null ? new CellGUIAttr() : cellGUIAttr;
        long l4 = PaintUtils.getPreferredWidth(cellElement, (UNIT)PT.valueOfFU((long)l3)).toFU();
        if (l4 > l2 && !cellGUIAttr.needFitWidth(n2)) {
            l4 = l2;
        }
        int n9 = FU.getInstance((long)l4).toPixI(this.resolution);
        int n10 = intList.get(n5);
        int n11 = Math.max(n10, n9 / n7);
        intList.set(n5, n11);
    }

    @Override
    public ReportPageAttrProvider getReportPageAttr() {
        return this.source_element_case.getReportPageAttr();
    }

    @Override
    public FU getColumnWidth(int n2) {
        return this.source_element_case.getColumnWidth(this.column_width_index_list.get(n2));
    }

    @Override
    public FU getRowHeight(int n2) {
        return this.source_element_case.getRowHeight(this.row_height_index_list.get(n2));
    }

    public DynamicNumberList getColumnWidthDynamicPixList(int n2) {
        this.resolution = n2;
        return this.getColumnWidthDynamicPixList();
    }

    public DynamicNumberList getColumnWidthDynamicPixList() {
        int n2 = this.column_width_index_list.size();
        DynamicNumberList dynamicNumberList = new DynamicNumberList(0, n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            dynamicNumberList.set(i2, this.columnWidthList.get(this.column_width_index_list.get(i2), this.resolution));
        }
        return dynamicNumberList;
    }

    public void setColumnWidthDynamicPixList(DynamicPixList dynamicPixList) {
        this.columnWidthList = dynamicPixList;
    }

    public DynamicNumberList getRowHeightDynamicPixList(int n2) {
        this.resolution = n2;
        return this.getRowHeightDynamicPixList();
    }

    public DynamicNumberList getRowHeightDynamicPixList() {
        if (this.row_height_index_list == null) {
            this.initRowHeightArray();
        }
        int n2 = this.row_height_index_list.size();
        DynamicNumberList dynamicNumberList = new DynamicNumberList(0, n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.rowHeightList == null) continue;
            int n3 = this.rowHeightList.get(this.row_height_index_list.get(i2), this.resolution);
            dynamicNumberList.set(i2, n3);
        }
        return dynamicNumberList;
    }

    public void setRowHeightDynamicPixList(DynamicPixList dynamicPixList) {
        this.rowHeightList = dynamicPixList;
    }

    @Override
    public Iterator cellIterator() {
        return new PageCellIterator();
    }

    @Override
    public int getColumnCount() {
        return this.column_width_index_list.size();
    }

    @Override
    public Iterator getRow(int n2) {
        return new PageRowIterator(n2);
    }

    @Override
    public int getRowCount() {
        return this.row_height_index_list.size();
    }

    @Override
    public Iterator floatIterator() {
        return new PageFloatIterator();
    }

    public int getWebPageWidth() {
        if (this.paperSetting != null) {
            return ReportUtils.getPaperWidth(this.paperSetting).toPixI(this.resolution);
        }
        return this.getContentWidth();
    }

    @Override
    public int getContentWidth() {
        DynamicUnitList dynamicUnitList = ReportHelper.createColumnWidthList(this);
        int n2 = Math.max(dynamicUnitList.getRangeValueFromZero(this.getColumnCount()).toPixI(96), 1);
        Iterator iterator = this.floatIterator();
        while (iterator.hasNext()) {
            FloatElement floatElement = (FloatElement)iterator.next();
            float f2 = floatElement.getLeftDistance_inClippedPage().toPixF(96);
            float f3 = floatElement.getWidth().toPixF(96) + 1.0f;
            n2 = Math.max(n2, (int)(f2 + f3));
        }
        return n2;
    }

    public int getWebPageHeight() {
        if (this.paperSetting != null) {
            return ReportUtils.getPaperHeight(this.paperSetting).toPixI(this.resolution);
        }
        return this.getContentHeight();
    }

    @Override
    public int getContentHeight() {
        DynamicUnitList dynamicUnitList = ReportHelper.createRowHeightList(this);
        int n2 = Math.max(dynamicUnitList.getRangeValueFromZero(this.getRowCount()).toPixI(96), 1);
        Iterator iterator = this.floatIterator();
        while (iterator.hasNext()) {
            FloatElement floatElement = (FloatElement)iterator.next();
            float f2 = floatElement.getTopDistance_inClippedPage().toPixF(96);
            float f3 = floatElement.getHeight().toPixF(96) + 1.0f;
            n2 = Math.max(n2, (int)(f2 + f3));
        }
        return n2;
    }

    public UNIT getMarginTop() {
        if (this.paperSetting != null) {
            return this.paperSetting.getMargin().getTop();
        }
        return UNIT.ZERO;
    }

    public UNIT getMarginLeft() {
        if (this.paperSetting != null) {
            return this.paperSetting.getMargin().getLeft();
        }
        return UNIT.ZERO;
    }

    public UNIT getMarginBottom() {
        if (this.paperSetting != null) {
            return this.paperSetting.getMargin().getBottom();
        }
        return UNIT.ZERO;
    }

    public UNIT getMarginRight() {
        if (this.paperSetting != null) {
            return this.paperSetting.getMargin().getRight();
        }
        return UNIT.ZERO;
    }

    protected PageExportCellElement createPageExportCellElement(CellElement cellElement, int n2, int n3, int n4, int n5) {
        return new PageExportCellElement(cellElement, n2, n3, n4, n5);
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        Object object;
        Object object2;
        xMLPrintWriter.startTAG("CellElementList");
        Iterator iterator = this.cellIterator();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            if (!(object2 instanceof CellElement)) continue;
            ReportXMLUtils.writeReportPageCellElement(xMLPrintWriter, (PageExportCellElement)object2);
        }
        xMLPrintWriter.end();
        xMLPrintWriter.startTAG("FloatElementList");
        object2 = this.floatIterator();
        while (object2.hasNext()) {
            object = object2.next();
            if (!(object instanceof FloatElement)) continue;
            FloatElement floatElement = (FloatElement)object;
            ReportXMLUtils.writeFloatElement(xMLPrintWriter, floatElement);
        }
        xMLPrintWriter.end();
        object = new long[this.getColumnCount()];
        for (int i2 = 0; i2 < ((E)object).length; ++i2) {
            object[i2] = this.getColumnWidth(i2).toFU();
        }
        xMLPrintWriter.startTAG("WIDTH").textNode(BaseUtils.toLongArrayString(object, (char)',')).end();
        long[] lArray = new long[this.getRowCount()];
        for (int i3 = 0; i3 < lArray.length; ++i3) {
            lArray[i3] = this.getRowHeight(i3).toFU();
        }
        xMLPrintWriter.startTAG("HEIGHT").textNode(BaseUtils.toLongArrayString((long[])lArray, (char)',')).end();
        xMLPrintWriter.startTAG("PixWidth");
        BaseXMLUtils.writeDynamicNumberList((XMLPrintWriter)xMLPrintWriter, (DynamicNumberList)this.getColumnWidthDynamicPixList(96));
        xMLPrintWriter.end();
        xMLPrintWriter.startTAG("PixHeight");
        BaseXMLUtils.writeDynamicNumberList((XMLPrintWriter)xMLPrintWriter, (DynamicNumberList)this.getRowHeightDynamicPixList(96));
        xMLPrintWriter.end();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private static class IntersectObejct {
        protected int count = 0;
        protected int tmpWidth = 0;
        protected int tmpHeight = 0;

        public int getCount() {
            return this.count;
        }

        public void setCount(int n2) {
            this.count = n2;
        }

        public int getTmpWidth() {
            return this.tmpWidth;
        }

        public void setTmpWidth(int n2) {
            this.tmpWidth = n2;
        }

        public int getTmpHeight() {
            return this.tmpHeight;
        }

        public void setTmpHeight(int n2) {
            this.tmpHeight = n2;
        }
    }

    public static class EmptyClippedReportPage
    extends ClippedECPage {
        public ReportPageAttrProvider getReportPageAttr() {
            return new ReportPageAttr();
        }

        public DynamicNumberList getColumnWidthDynamicPixList() {
            return new DynamicNumberList(0, 0);
        }

        public DynamicNumberList getRowHeightDynamicPixList() {
            return new DynamicNumberList(0, 0);
        }

        public Iterator cellIterator() {
            return emptyIterator;
        }

        public int getColumnCount() {
            return 0;
        }

        public FU getColumnWidth(int n2) {
            return UNIT.ZERO;
        }

        public Iterator getRow(int n2) {
            return emptyIterator;
        }

        public int getRowCount() {
            return 0;
        }

        public FU getRowHeight(int n2) {
            return UNIT.ZERO;
        }

        public Iterator floatIterator() {
            return emptyIterator;
        }
    }

    public static class XMLClippedReportPage
    extends ClippedECPage
    implements XMLReadable {
        private CellCase cellCase = new DefaultCellCase();
        private List floatElementList = new ArrayList();
        private long[] columnWidthArray;
        private long[] rowHeightArray;
        private DynamicNumberList colPixList;
        private DynamicNumberList rowPixList;

        public Iterator cellIterator() {
            return this.cellCase.cellIterator();
        }

        public int getColumnCount() {
            return this.cellCase.getColumnCount();
        }

        public FU getColumnWidth(int n2) {
            return FU.getInstance((long)this.columnWidthArray[n2]);
        }

        public Iterator getRow(int n2) {
            return this.cellCase.getRow(n2);
        }

        public DynamicNumberList getColumnWidthDynamicPixList() {
            return this.colPixList;
        }

        public DynamicNumberList getRowHeightDynamicPixList() {
            return this.rowPixList;
        }

        public int getRowCount() {
            return this.cellCase.getRowCount();
        }

        public FU getRowHeight(int n2) {
            return FU.getInstance((long)this.rowHeightArray[n2]);
        }

        public Iterator floatIterator() {
            return this.floatElementList.iterator();
        }

        public void readXML(XMLableReader xMLableReader) {
            xMLableReader.readXMLObject(new XMLReadable(){

                public void readXML(XMLableReader xMLableReader) {
                    if (xMLableReader.isChildNode()) {
                        String string = xMLableReader.getTagName();
                        if ("CellElementList".equals(string)) {
                            xMLableReader.readXMLObject(new XMLReadable(){

                                public void readXML(XMLableReader xMLableReader) {
                                    if (xMLableReader.isChildNode()) {
                                        PageExportCellElement pageExportCellElement = new PageExportCellElement();
                                        xMLableReader.readXMLObject((XMLReadable)pageExportCellElement);
                                        XMLClippedReportPage.this.cellCase.add(pageExportCellElement, true);
                                    }
                                }
                            });
                        } else if ("FloatElementList".equals(string)) {
                            ReportXMLUtils.readFloatElementList(xMLableReader, XMLClippedReportPage.this.floatElementList, XMLClippedReportPage.this);
                        } else if ("WIDTH".equals(string)) {
                            XMLClippedReportPage.access$1102(XMLClippedReportPage.this, BaseUtils.toLongArrayFromStr((String)xMLableReader.getElementValue(), (char)','));
                        } else if ("HEIGHT".equals(string)) {
                            XMLClippedReportPage.access$1202(XMLClippedReportPage.this, BaseUtils.toLongArrayFromStr((String)xMLableReader.getElementValue(), (char)','));
                        } else if ("PixWidth".equals(string)) {
                            XMLClippedReportPage.this.colPixList = BaseXMLUtils.readDynamicNumberList((XMLableReader)xMLableReader);
                        } else if ("PixHeight".equals(string)) {
                            XMLClippedReportPage.this.rowPixList = BaseXMLUtils.readDynamicNumberList((XMLableReader)xMLableReader);
                        } else if ("ClippedAttr".equals(string)) {
                            XMLClippedReportPage.this.offsetX = FU.getInstance((long)xMLableReader.getAttrAsLong("x", 0L));
                            XMLClippedReportPage.this.offsetY = FU.getInstance((long)xMLableReader.getAttrAsLong("y", 0L));
                        }
                    }
                }
            });
        }

        static /* synthetic */ long[] access$1102(XMLClippedReportPage xMLClippedReportPage, long[] lArray) {
            xMLClippedReportPage.columnWidthArray = lArray;
            return lArray;
        }

        static /* synthetic */ long[] access$1202(XMLClippedReportPage xMLClippedReportPage, long[] lArray) {
            xMLClippedReportPage.rowHeightArray = lArray;
            return lArray;
        }
    }

    private class PageFloatIterator
    implements Iterator {
        private Iterator current_it;
        private FloatElement next = null;
        private int resolution;

        private PageFloatIterator() {
            this.resolution = ClippedECPage.this.resolution;
            this.current_it = ClippedECPage.this.source_element_case.floatIterator();
            this.findNext();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("At last element");
            }
            FloatElement floatElement = this.next;
            this.findNext();
            return floatElement;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void findNext() {
            while (this.current_it.hasNext()) {
                Point point = new Point(0, 0);
                FloatElement floatElement = (FloatElement)this.current_it.next();
                for (int i2 = 0; i2 < ClippedECPage.this.column_line_array.length; ++i2) {
                    FT fT = ClippedECPage.this.column_line_array[i2];
                    for (int i3 = 0; i3 < ClippedECPage.this.row_line_array.length; ++i3) {
                        FT fT2 = ClippedECPage.this.row_line_array[i3];
                        Rectangle rectangle = new Rectangle(fT.from, fT2.from, fT.to - fT.from, fT2.to - fT2.from);
                        Rectangle rectangle2 = new Rectangle(ClippedECPage.this.columnWidthList.getRangeValueFromZero(rectangle.x, this.resolution), ClippedECPage.this.rowHeightList.getRangeValueFromZero(rectangle.y, this.resolution), ClippedECPage.this.columnWidthList.getRangeValue(rectangle.x, rectangle.x + rectangle.width, this.resolution), ClippedECPage.this.rowHeightList.getRangeValue(rectangle.y, rectangle.y + rectangle.height, this.resolution));
                        FloatElement floatElement2 = this.intersectFloatElement(floatElement, rectangle, rectangle2, point, ClippedECPage.this.columnWidthList, ClippedECPage.this.rowHeightList);
                        if (floatElement2 != null) {
                            this.next = floatElement2;
                            return;
                        }
                        point.y += fT2.to - fT2.from;
                    }
                    point.y = 0;
                    point.x += fT.to - fT.from;
                }
            }
            this.next = null;
        }

        private FloatElement intersectFloatElement(FloatElement floatElement, Rectangle rectangle, Rectangle rectangle2, Point point, DynamicPixList dynamicPixList, DynamicPixList dynamicPixList2) {
            Rectangle rectangle3 = new Rectangle(floatElement.getLeftDistance().toPixI(this.resolution), floatElement.getTopDistance().toPixI(this.resolution), floatElement.getWidth().toPixI(this.resolution), floatElement.getHeight().toPixI(this.resolution));
            Rectangle rectangle4 = rectangle2.intersection(rectangle3);
            if (rectangle4.width > 0 && rectangle4.height > 0) {
                try {
                    floatElement = floatElement.deriveFloatElement((UNIT)FU.valueOfPix((int)rectangle4.x, (int)this.resolution), (UNIT)FU.valueOfPix((int)rectangle4.y, (int)this.resolution), (UNIT)FU.valueOfPix((int)rectangle4.width, (int)this.resolution), (UNIT)FU.valueOfPix((int)rectangle4.height, (int)this.resolution));
                    if (rectangle3.y < rectangle2.y && rectangle3.y + rectangle3.height > rectangle2.y) {
                        floatElement.setTopDistance_inClippedPage(FU.getInstance((long)1L));
                    }
                    if (rectangle3.x < rectangle2.x && rectangle3.x + rectangle3.width > rectangle2.x) {
                        floatElement.setLeftDistance_inClippedPage(FU.getInstance((long)1L));
                    }
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    FRContext.getLogger().error(cloneNotSupportedException.getMessage(), (Throwable)cloneNotSupportedException);
                    floatElement.setLeftDistance(FU.valueOfPix((int)rectangle4.x, (int)this.resolution));
                    floatElement.setTopDistance(FU.valueOfPix((int)rectangle4.y, (int)this.resolution));
                    floatElement.setWidth(FU.valueOfPix((int)rectangle4.width, (int)this.resolution));
                    floatElement.setHeight(FU.valueOfPix((int)rectangle4.height, (int)this.resolution));
                }
                return floatElement;
            }
            return null;
        }
    }

    private class PageRowIterator
    extends RPCellIterator {
        private int current_ri;
        private int row_offset;

        private PageRowIterator(int n2) {
            this.current_ri = -1;
            this.row_offset = -1;
            this.offsetColumnRow = new Point(0, this.initial_row_of_offset_columnrow(n2));
            this.findNext();
        }

        protected int initial_row_of_offset_columnrow(int n2) {
            int n3 = n2;
            for (int i2 = 0; i2 < ClippedECPage.this.row_line_array.length; ++i2) {
                FT fT = ClippedECPage.this.row_line_array[i2];
                int n4 = fT.to - fT.from;
                if (n4 > n3) {
                    this.current_ri = i2;
                    this.row_offset = n3;
                    break;
                }
                n3 -= n4;
            }
            return n2 - n3;
        }

        protected void findNext() {
            if (this.current_ri == -1) {
                return;
            }
            FT fT = ClippedECPage.this.row_line_array[this.current_ri];
            if (this.iterate_columns_by_row(fT, this.row_offset)) {
                return;
            }
            this.next = null;
        }

        protected boolean isCellBelongToThisColumnArea(int n2) {
            return this.current_ci <= n2;
        }

        protected boolean isCellBelongToThisRowArea(int n2) {
            return this.current_ri <= n2;
        }
    }

    private class PageCellIterator
    extends RPCellIterator {
        private int current_ri;
        private int current_row;

        private PageCellIterator() {
            this.current_ri = 0;
            this.current_row = 0;
            this.offsetColumnRow = new Point(0, 0);
            this.findNext();
        }

        protected void findNext() {
            for (int i2 = this.current_ri; i2 < ClippedECPage.this.row_line_array.length; ++i2) {
                FT fT = ClippedECPage.this.row_line_array[i2];
                this.current_ri = i2;
                for (int i3 = this.current_row; i3 < fT.to - fT.from; ++i3) {
                    this.current_row = i3;
                    if (this.iterate_columns_by_row(fT, i3)) {
                        return;
                    }
                    this.current_ci = 0;
                    this.offsetColumnRow.x = 0;
                }
                this.current_row = 0;
                this.offsetColumnRow.y += fT.to - fT.from;
            }
            this.next = null;
        }

        protected boolean isCellBelongToThisColumnArea(int n2) {
            return true;
        }

        protected boolean isCellBelongToThisRowArea(int n2) {
            return true;
        }
    }

    private abstract class RPCellIterator
    implements Iterator {
        private Set executing_cr_set = null;
        private Map executed_statement_map = null;
        private Calculator calculator = Calculator.createCalculator();
        private Iterator current_it;
        protected int current_ci = 0;
        protected Cell next = null;
        protected Point offsetColumnRow;
        private List mergedCellList;

        public RPCellIterator() {
            if (ClippedECPage.this.source_report.getResultWorkBook() != null) {
                this.calculator.pushNameSpace((NameSpace)ParameterMapNameSpace.create((Map)ClippedECPage.this.source_report.getResultWorkBook().getExecuteParameters()));
            }
            this.calculator.pushNameSpace((NameSpace)new PageCalNameSpace());
            this.calculator.setAttribute(Report.KEY, (Object)ClippedECPage.this.source_report);
            this.calculator.setAttribute(ElementCase.KEY, (Object)ClippedECPage.this.source_element_case);
            this.calculator.setAttribute(TableDataSource.KEY, (Object)ClippedECPage.this.source_report.getTableDataSource());
            this.mergedCellList = new ArrayList();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("At last element");
            }
            Cell cell = this.next;
            this.findNext();
            return cell;
        }

        protected abstract void findNext();

        protected boolean iterate_columns_by_row(FT fT, int n2) {
            for (int i2 = this.current_ci; i2 < ClippedECPage.this.column_line_array.length; ++i2) {
                Cloneable cloneable;
                this.current_ci = i2;
                FT fT2 = ClippedECPage.this.column_line_array[i2];
                Rectangle rectangle = new Rectangle(fT2.from, fT.from, fT2.to - fT2.from, fT.to - fT.from);
                if (this.current_it == null) {
                    cloneable = new Rectangle(fT2.from, fT.from + n2, fT2.to - fT2.from, 1);
                    this.current_it = ClippedECPage.this.cellIterator((Rectangle)cloneable);
                }
                while (this.current_it.hasNext()) {
                    PageExportCellElement pageExportCellElement;
                    cloneable = (CellElement)this.current_it.next();
                    if (n2 > 0 && cloneable.getRow() < fT.from + n2 || (pageExportCellElement = this.intersectCell((CellElement)cloneable, rectangle, this.offsetColumnRow, ClippedECPage.this.column_line_array, ClippedECPage.this.row_line_array, ClippedECPage.this.columnWidthList, ClippedECPage.this.rowHeightList)) == null) continue;
                    this.next = pageExportCellElement;
                    return true;
                }
                this.current_it = null;
                this.offsetColumnRow.x += fT2.to - fT2.from;
            }
            return false;
        }

        private IntersectObejct dealMergeRec(Rectangle rectangle) {
            FT fT;
            int n2;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            for (n2 = 0; n2 < ClippedECPage.this.column_line_array.length; ++n2) {
                fT = ClippedECPage.this.column_line_array[n2];
                if (rectangle.x >= fT.to || fT.from >= rectangle.x + rectangle.width) continue;
                if (!this.isCellBelongToThisColumnArea(n2)) {
                    return null;
                }
                ++n3;
                n4 += Math.min(fT.to, rectangle.x + rectangle.width) - Math.max(rectangle.x, fT.from);
            }
            for (n2 = 0; n2 < ClippedECPage.this.row_line_array.length; ++n2) {
                fT = ClippedECPage.this.row_line_array[n2];
                if (rectangle.y >= fT.to || fT.from >= rectangle.y + rectangle.height) continue;
                if (!this.isCellBelongToThisRowArea(n2)) {
                    return null;
                }
                ++n3;
                n5 += Math.min(fT.to, rectangle.y + rectangle.height) - Math.max(rectangle.y, fT.from);
            }
            IntersectObejct intersectObejct = new IntersectObejct();
            intersectObejct.setCount(n3);
            intersectObejct.setTmpHeight(n5);
            intersectObejct.setTmpWidth(n4);
            return intersectObejct;
        }

        private PageExportCellElement getValueFromMergeResult(PageExportCellElement pageExportCellElement, IntersectObejct intersectObejct, CellElement cellElement, Rectangle rectangle, Rectangle rectangle2) {
            int n2 = intersectObejct.getCount();
            int n3 = intersectObejct.getTmpWidth();
            int n4 = intersectObejct.getTmpHeight();
            if (n2 > 1) {
                this.mergedCellList.add(cellElement);
                n3 = n3 == 0 ? rectangle.width : n3;
                n4 = n4 == 0 ? rectangle.height : n4;
                return ClippedECPage.this.createPageExportCellElement(cellElement, this.offsetColumnRow.x + rectangle.x - rectangle2.x, this.offsetColumnRow.y + rectangle.y - rectangle2.y, n3, n4);
            }
            return pageExportCellElement;
        }

        protected PageExportCellElement intersectCell(CellElement cellElement, Rectangle rectangle, Point point, FT[] fTArray, FT[] fTArray2, DynamicPixList dynamicPixList, DynamicPixList dynamicPixList2) {
            Rectangle rectangle2 = new Rectangle(cellElement.getColumn(), cellElement.getRow(), cellElement.getColumnSpan(), cellElement.getRowSpan());
            Rectangle rectangle3 = rectangle2.intersection(rectangle);
            PageExportCellElement pageExportCellElement = null;
            CellPageAttr cellPageAttr = cellElement.getCellPageAttr() == null ? CellPageAttr.DEFAULT_CELLPAGEATTR : cellElement.getCellPageAttr();
            boolean bl = cellPageAttr.isRepeat() && !(cellElement.getValue() instanceof ResultSubReport);
            Rectangle rectangle4 = null;
            Rectangle rectangle5 = null;
            if (!this.isTheSameRect(rectangle3, rectangle2)) {
                if (!bl) {
                    int n2 = ClippedECPage.this.resolution;
                    rectangle4 = new Rectangle(dynamicPixList.getRangeValue(rectangle3.x, rectangle2.x, n2), dynamicPixList2.getRangeValue(rectangle3.y, rectangle2.y, n2), dynamicPixList.getRangeValue(rectangle2.x, rectangle2.x + rectangle2.width, n2), dynamicPixList2.getRangeValue(rectangle2.y, rectangle2.y + rectangle2.height, n2));
                    rectangle5 = new Rectangle(-rectangle4.x, -rectangle4.y, dynamicPixList.getRangeValue(rectangle3.x, rectangle3.x + rectangle3.width, n2), dynamicPixList2.getRangeValue(rectangle3.y, rectangle3.y + rectangle3.height, n2));
                }
                if (this.mergedCellList.contains(cellElement)) {
                    return null;
                }
                IntersectObejct intersectObejct = this.dealMergeRec(rectangle2);
                if (intersectObejct == null) {
                    return null;
                }
                pageExportCellElement = this.getValueFromMergeResult(pageExportCellElement, intersectObejct, cellElement, rectangle3, rectangle);
            }
            if (pageExportCellElement == null) {
                pageExportCellElement = ClippedECPage.this.createPageExportCellElement(cellElement, point.x + rectangle3.x - rectangle.x, point.y + rectangle3.y - rectangle.y, rectangle3.width, rectangle3.height);
            }
            if (rectangle4 != null) {
                pageExportCellElement.setBrokenCellInfo(new BrokenCellInfo(rectangle4, rectangle5, cellElement.getValue()));
            }
            this.checkCellElementValue(pageExportCellElement, cellElement, rectangle3, rectangle2, rectangle4, rectangle5);
            return pageExportCellElement;
        }

        private boolean isTheSameRect(Rectangle rectangle, Rectangle rectangle2) {
            return rectangle.getX() == rectangle2.getX() && rectangle.getY() == rectangle2.getY() && rectangle.getWidth() == rectangle2.getWidth() && rectangle.getHeight() == rectangle2.getHeight();
        }

        protected abstract boolean isCellBelongToThisRowArea(int var1);

        protected abstract boolean isCellBelongToThisColumnArea(int var1);

        private Object resolveFRFile(FRFile fRFile, CellElement cellElement) {
            if (ComparatorUtils.equals((String)"image", (String)fRFile.getType())) {
                try {
                    return ImageIO.read(new ByteArrayInputStream(fRFile.getBytes()));
                }
                catch (IOException iOException) {
                    FRContext.getLogger().error(iOException.getMessage(), (Throwable)iOException);
                }
            }
            return fRFile;
        }

        private void checkCellElementValue(CellElement cellElement, CellElement cellElement2, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, Rectangle rectangle4) {
            PageCalObjectProcessor pageCalObjectProcessor;
            Object object;
            Object object2 = cellElement.getValue();
            if (cellElement2.getShowValue() != object2) {
                object2 = cellElement2.getShowValue();
            }
            if (object2 instanceof Formula) {
                object = (Formula)object2;
                object2 = object.getResult();
            }
            if (object2 instanceof PageCalObj) {
                object2 = this.resolvePageCalObj(cellElement2, (PageCalObj)object2);
            }
            object = (object = cellElement2.getCellGUIAttr()) == null ? new CellGUIAttr() : object;
            object2 = DataUtils.resolveOtherValue((Object)object2, (boolean)((CellGUIAttr)object).isShowAsImage(), (boolean)((CellGUIAttr)object).isShowAsDownload(), (Object)((CellGUIAttr)object).getFileName(), (boolean)false);
            object2 = this.resolveStringValue(rectangle3, rectangle4, object2, cellElement, cellElement2);
            cellElement.setValue(object2);
            NameJavaScriptGroup nameJavaScriptGroup = cellElement2.getNameHyperlinkGroup();
            if (nameJavaScriptGroup != null) {
                this.dealWithNameJSGroup(nameJavaScriptGroup);
            }
            if ((pageCalObjectProcessor = (PageCalObjectProcessor)ExtraReportClassManager.getInstance().getSingle("PageCalObjectProcessor")) != null) {
                pageCalObjectProcessor.resolvePageCalHighlight(this.calculator, cellElement);
            }
        }

        private Object resolveStringValue(Rectangle rectangle, Rectangle rectangle2, Object object, CellElement cellElement, CellElement cellElement2) {
            if (rectangle != null && object instanceof String) {
                if (rectangle.width == rectangle2.width && !(object instanceof Image)) {
                    return PaintUtils.clipBlockValue(object, cellElement.getStyle(), rectangle, rectangle2, ClippedECPage.this.resolution);
                }
                boolean bl = cellElement2.getCellGUIAttr() != null && cellElement2.getCellGUIAttr().isShowAsHTML();
                BufferedImage bufferedImage = CoreGraphHelper.createBufferedImage((int)rectangle2.width, (int)rectangle2.height, (int)2);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.setPaint(Color.white);
                Background background = cellElement2.getStyle().getBackground();
                if (background == null) {
                    background = ColorBackground.getInstance((Color)Color.white);
                }
                background.paint((Graphics)graphics2D, (Shape)new Rectangle2D.Double(0.0, 0.0, rectangle2.width, rectangle2.height));
                if (bl) {
                    PaintUtils.paintHTMLContent(graphics2D, (String)object, ClippedECPage.this.resolution, cellElement2.getStyle(), rectangle, rectangle2);
                } else {
                    Style.paintContent((Graphics2D)graphics2D, (Object)object, (int)ClippedECPage.this.resolution, (Style)cellElement2.getStyle(), (Rectangle)rectangle, (Rectangle)rectangle2);
                }
                bufferedImage.flush();
                graphics2D.dispose();
                return bufferedImage;
            }
            return object;
        }

        private void dealWithNameJSGroup(NameJavaScriptGroup nameJavaScriptGroup) {
            for (int i2 = 0; i2 < nameJavaScriptGroup.size(); ++i2) {
                NameJavaScript nameJavaScript = nameJavaScriptGroup.getNameHyperlink(i2);
                if (nameJavaScript == null || nameJavaScript.getJavaScript() == null) continue;
                JavaScript javaScript = nameJavaScript.getJavaScript();
                ParameterProvider[] parameterProviderArray = javaScript.getParameters();
                for (int i3 = 0; i3 < parameterProviderArray.length; ++i3) {
                    Object object;
                    if (!(parameterProviderArray[i3].getValue() instanceof Formula) || (object = ((Formula)parameterProviderArray[i3].getValue()).getResult()) != PageCalObj.MARK) continue;
                    PageCalObj pageCalObj = new PageCalObj(((Formula)parameterProviderArray[i3].getValue()).getContent());
                    try {
                        parameterProviderArray[i3].setValue(pageCalObj.resolve((CalculatorProvider)this.calculator));
                        continue;
                    }
                    catch (UtilEvalError utilEvalError) {
                        FRContext.getLogger().error(utilEvalError.getMessage());
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object resolvePageCalObj(CellElement cellElement, PageCalObj pageCalObj) {
            if (pageCalObj == null || StringUtils.isBlank((String)pageCalObj.getContent())) {
                return null;
            }
            ClippedECPage clippedECPage = ClippedECPage.this;
            synchronized (clippedECPage) {
                Object object;
                String string = pageCalObj.getContent();
                if (this.executed_statement_map == null) {
                    this.executed_statement_map = new HashMap(4);
                }
                if (this.executed_statement_map.containsKey(string)) {
                    return this.executed_statement_map.get(string);
                }
                if (this.executing_cr_set == null) {
                    this.executing_cr_set = new HashSet(8);
                }
                if (this.executing_cr_set.contains(cellElement)) {
                    throw new DeathCycleException("Death cycle exists: " + this.executing_cr_set);
                }
                this.executing_cr_set.add(cellElement);
                try {
                    object = pageCalObj.resolve((CalculatorProvider)this.calculator);
                }
                catch (UtilEvalError utilEvalError) {
                    String string2 = "error happens at calculating formula\ncell is " + cellElement + "\nformula expression is " + pageCalObj.getContent() + "\nerror message is " + utilEvalError.getMessage();
                    FRContext.getLogger().error(string2);
                    object = null;
                }
                this.executing_cr_set.remove(cellElement);
                this.executed_statement_map.put(string, object);
                return object;
            }
        }

        private class PageCalNameSpace
        extends AbstractNameSpace {
            PageCalNameSpace() {
            }

            public Object getVariable(Object object, CalculatorProvider calculatorProvider) {
                if (object instanceof ColumnRowRangeInPage) {
                    if ((object = ((ColumnRowRangeInPage)object).getAtom()) instanceof ColumnRowRange) {
                        int[] nArray = e.A((ColumnRowRange)object);
                        if (nArray[0] == Integer.MAX_VALUE) {
                            return Primitive.NULL;
                        }
                        return this.resolveColumnRowInPageIntersect(calculatorProvider, nArray[0], nArray[1], nArray[2], nArray[3]);
                    }
                    return null;
                }
                if (ComparatorUtils.equals((Object)"$$totalPage_number", (Object)object)) {
                    return new Integer(ClippedECPage.this.getTotalPageNumber() + ClippedECPage.this.getFirstPageNumber() - 1);
                }
                if (ComparatorUtils.equals((Object)"$$page_number", (Object)object)) {
                    return new Integer(ClippedECPage.this.getCurrentPageNumber() + ClippedECPage.this.getFirstPageNumber() - 1);
                }
                if (object instanceof ColumnRowRange) {
                    int[] nArray = e.A((ColumnRowRange)object);
                    if (nArray[0] == Integer.MAX_VALUE) {
                        return Primitive.NULL;
                    }
                    return this.resolveColumnRowIntersect(calculatorProvider, nArray[0], nArray[1], nArray[2], nArray[3]);
                }
                return null;
            }

            private Object dealWithCellElemenetValue(CellElement cellElement) {
                Object object = cellElement.getValue();
                if (object instanceof Formula) {
                    Formula formula = (Formula)object;
                    object = formula.getResult();
                }
                if (object instanceof PageCalObj) {
                    object = RPCellIterator.this.resolvePageCalObj(cellElement, (PageCalObj)object);
                }
                return object;
            }

            private Object resolveColumnRowInPageIntersect(CalculatorProvider calculatorProvider, int n2, int n3, int n4, int n5) {
                int n6;
                FT fT;
                int n7;
                int n8;
                int[] nArray = ClippedECPage.this.source_element_case.getRowMappingArray();
                int[] nArray2 = ClippedECPage.this.source_element_case.getColumnMappingArray();
                if (nArray == null || nArray2 == null) {
                    return Primitive.NULL;
                }
                ArrayList arrayList = new ArrayList();
                IntList intList = new IntList(ClippedECPage.this.getRowCount());
                IntList intList2 = new IntList(ClippedECPage.this.getColumnCount());
                for (n8 = n3; n8 < n3 + n5; ++n8) {
                    for (n7 = 0; n7 < ClippedECPage.this.row_line_array.length; ++n7) {
                        fT = ClippedECPage.this.row_line_array[n7];
                        for (n6 = fT.from; n6 < fT.to; ++n6) {
                            if (nArray[n6] != n8) continue;
                            intList.add(n6);
                        }
                    }
                }
                for (n8 = n2; n8 < n2 + n4; ++n8) {
                    for (n7 = 0; n7 < ClippedECPage.this.column_line_array.length; ++n7) {
                        fT = ClippedECPage.this.column_line_array[n7];
                        for (n6 = fT.from; n6 < fT.to; ++n6) {
                            if (nArray2[n6] != n8) continue;
                            intList2.add(n6);
                        }
                    }
                }
                this.addCellToList(arrayList, intList, intList2);
                return this.validResult(arrayList);
            }

            private Object validResult(List list) {
                Object object = null;
                switch (list.size()) {
                    case 0: {
                        object = Primitive.NULL;
                        break;
                    }
                    case 1: {
                        object = list.get(0);
                        break;
                    }
                    default: {
                        object = new FArray((Collection)list);
                    }
                }
                return object == null ? Primitive.NULL : object;
            }

            protected Object resolveColumnRowIntersect(CalculatorProvider calculatorProvider, int n2, int n3, int n4, int n5) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                Iterator iterator = ClippedECPage.this.source_element_case.intersect(n2, n3, n4, n5);
                while (iterator.hasNext()) {
                    CellElement cellElement = (CellElement)iterator.next();
                    if (!cellElement.isExist()) continue;
                    arrayList.add(this.dealWithCellElemenetValue(cellElement));
                }
                return this.validResult(arrayList);
            }

            private void addCellToList(List list, IntList intList, IntList intList2) {
                HashSet<CellElement> hashSet = new HashSet<CellElement>();
                for (int i2 = 0; i2 < intList.size(); ++i2) {
                    for (int i3 = 0; i3 < intList2.size(); ++i3) {
                        CellElement cellElement = ClippedECPage.this.source_element_case.getCellElement(intList2.get(i3), intList.get(i2));
                        if (!cellElement.isExist() || hashSet.contains(cellElement)) continue;
                        int n2 = cellElement.getRowSpan();
                        if (n2 > 1) {
                            hashSet.add(cellElement);
                        }
                        list.add(this.dealWithCellElemenetValue(cellElement));
                    }
                }
            }
        }
    }
}

