/*
 * Decompiled with CFR 0.152.
 */
package com.fr.io.exporter;

import com.fr.base.FRContext;
import com.fr.cache.list.IntList;
import com.fr.io.core.ExporterUtils;
import com.fr.io.exporter.WordExporter;
import com.fr.page.ClippedPageProvider;
import com.fr.page.PageSetChainProvider;
import com.fr.page.PageSetProvider;
import com.fr.page.ReportPageProvider;
import com.fr.third.com.lowagie.text.BadElementException;
import com.fr.third.com.lowagie.text.Document;
import com.fr.third.com.lowagie.text.Element;
import com.fr.third.com.lowagie.text.Row;
import com.fr.third.com.lowagie.text.Table;
import com.fr.third.com.lowagie.text.rtf.RtfWriter2;
import java.io.OutputStream;

public class WordTableExporter
extends WordExporter {
    private static final int CAL_TABLE_ROW_HEIGHT_ARG = 13;

    public void export(OutputStream outputStream, PageSetProvider pageSetProvider) {
        Document document = new Document();
        RtfWriter2 rtfWriter2 = RtfWriter2.getInstance((Document)document, (OutputStream)outputStream);
        document.open();
        IntList intList = new IntList();
        if (pageSetProvider instanceof PageSetChainProvider) {
            intList = ((PageSetChainProvider)pageSetProvider).getChainPageInfo();
        }
        try {
            int n2 = intList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ClippedPageProvider clippedPageProvider;
                ReportPageProvider reportPageProvider;
                if (i2 != 0) {
                    document.newPage();
                }
                int n3 = 0;
                int n4 = 0;
                int n5 = intList.get(i2);
                int n6 = i2 == n2 - 1 ? pageSetProvider.size() - 1 : intList.get(i2 + 1) - 1;
                for (int i3 = n5; i3 < n6 + 1; ++i3) {
                    reportPageProvider = pageSetProvider.getPage(i3);
                    clippedPageProvider = ExporterUtils.support(reportPageProvider);
                    if (clippedPageProvider == null) {
                        return;
                    }
                    n3 = Math.max(n3, clippedPageProvider.getColumnCount());
                    n4 += clippedPageProvider.getRowCount();
                }
                ReportPageProvider reportPageProvider2 = pageSetProvider.getPage(n5);
                reportPageProvider = ExporterUtils.support(reportPageProvider2);
                this.initPaperSetting(reportPageProvider2, document, n5);
                clippedPageProvider = new Table(Math.max(1, n3), Math.max(1, n4));
                this.initTable((Table)clippedPageProvider, reportPageProvider2, n3, (ClippedPageProvider)reportPageProvider, document);
                this.adujstTableHeight(n5, n6, pageSetProvider, (Table)clippedPageProvider);
                document.add((Element)clippedPageProvider);
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
        if (document != null) {
            document.close();
        }
    }

    private void adujstTableHeight(int n2, int n3, PageSetProvider pageSetProvider, Table table) {
        int n4;
        int n5 = 0;
        int n6 = 0;
        IntList intList = new IntList();
        for (n4 = n2; n4 < n3 + 1; ++n4) {
            int n7;
            int n8;
            ReportPageProvider reportPageProvider = pageSetProvider.getPage(n4);
            ClippedPageProvider clippedPageProvider = ExporterUtils.support(reportPageProvider);
            if (clippedPageProvider == null) {
                return;
            }
            n5 = this.addToTable(clippedPageProvider, table, n5, n6);
            int n9 = clippedPageProvider.getRowCount();
            for (n8 = n9 - 1; n8 >= 0; --n8) {
                Row row = table.getRow(n8 + n6);
                float f2 = clippedPageProvider.getRowHeight(n8).toPixI(72);
                row.setHeight((int)f2 * 13);
            }
            n8 = 0;
            for (n7 = n9 - 1; n7 >= 0; --n7) {
                if (!clippedPageProvider.getRowHeight(n7).equal_zero()) continue;
                table.deleteRow(n7 + n6);
                if (n7 + n6 >= n5) continue;
                ++n8;
            }
            n5 -= n8;
            if (n4 == n2) {
                for (n7 = clippedPageProvider.getColumnCount() - 1; n7 >= 0; --n7) {
                    if (!clippedPageProvider.getColumnWidth(n7).equal_zero()) continue;
                    intList.add(n7);
                }
            }
            n6 = n5;
        }
        int n10 = intList.size();
        for (n4 = 0; n4 < n10; ++n4) {
            try {
                table.deleteColumn(intList.get(n4));
                continue;
            }
            catch (BadElementException badElementException) {
                FRContext.getLogger().error(badElementException.getMessage());
            }
        }
    }
}

