/*
 * Decompiled with CFR 0.152.
 */
package com.fr.io.core;

import com.fr.base.DynamicUnitList;
import com.fr.data.TableDataSource;
import com.fr.io.core.ExcelReport;
import com.fr.io.core.ExporterUtils;
import com.fr.main.FineBook;
import com.fr.main.workbook.ResultWorkBook;
import com.fr.page.ClippedPageProvider;
import com.fr.page.PageSetProvider;
import com.fr.page.ReportHFProvider;
import com.fr.page.ReportPageAttrProvider;
import com.fr.page.ReportPageProvider;
import com.fr.page.ReportSettingsProvider;
import com.fr.report.cell.CellElement;
import com.fr.report.core.ReportUtils;
import com.fr.report.report.ECReport;
import com.fr.report.report.PageECReport;
import com.fr.stable.ExportConstants;
import com.fr.stable.FT;
import com.fr.stable.unit.FU;
import com.fr.stable.unit.UNITConstants;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LargeDataExcelExporterReport
extends ExcelReport
implements PageECReport {
    private ECReport sourceReport;
    private PageSetProvider pageSet;
    private FT pn_area;
    private ResultWorkBook workbook = null;
    private boolean isPage = true;
    private int max_count = ExportConstants.MAX_ROWS;

    public LargeDataExcelExporterReport(ECReport eCReport, PageSetProvider pageSetProvider, FT fT, boolean bl, int n2) {
        this.sourceReport = eCReport;
        this.pageSet = pageSetProvider;
        this.pn_area = fT;
        this.isPage = bl;
        this.max_count = n2;
        this.columnWidthList = new DynamicUnitList(UNITConstants.DEFAULT_ROW_HEIGHT, n2);
        this.rowHeightList = new DynamicUnitList(UNITConstants.DEFAULT_ROW_HEIGHT, n2);
    }

    public int getColumnCount() {
        return this.sourceReport.getColumnCount();
    }

    public ECReport getSourceReport() {
        return this.sourceReport;
    }

    public void setSourceReport(ECReport eCReport) {
        this.sourceReport = eCReport;
    }

    public int getMaxCount() {
        return this.max_count;
    }

    public void setMaxCount(int n2) {
        this.max_count = n2;
    }

    public FU getColumnWidth(int n2) {
        return this.columnWidthList.get(n2);
    }

    public FU getRowHeight(int n2) {
        return this.rowHeightList.get(n2);
    }

    public Iterator cellIterator() {
        return new PageExcelCellIterator();
    }

    public ReportHFProvider getFooter(int n2) {
        return this.sourceReport.getFooter(n2);
    }

    public ReportHFProvider getHeader(int n2) {
        return this.sourceReport.getHeader(n2);
    }

    public ReportPageAttrProvider getReportPageAttr() {
        return this.sourceReport.getReportPageAttr();
    }

    public ReportSettingsProvider getReportSettings() {
        return ReportUtils.getReportSettings(this.sourceReport);
    }

    public ResultWorkBook getResultWorkBook() {
        return this.workbook;
    }

    public void setResultWorkBook(ResultWorkBook resultWorkBook) {
        this.workbook = resultWorkBook;
    }

    public FineBook getBook() {
        return this.workbook;
    }

    public TableDataSource getTableDataSource() {
        return null;
    }

    public void shrinkTOFitRowHeightForCellElement(CellElement cellElement) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void shrinkTOFitColumnWidthForCellElement(CellElement cellElement) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private class PageExcelCellIterator
    extends ExcelReport.ExcelCellIterator {
        private int first_y;
        private List reportPageList = null;
        private int row_count;
        private int pn;

        private PageExcelCellIterator() {
        }

        protected int initial_x_checklast_size() {
            return 1;
        }

        protected void initial_varibles_by_constructor() {
            this.pn = ((LargeDataExcelExporterReport)LargeDataExcelExporterReport.this).pn_area.from;
            this.maxX = Integer.MAX_VALUE;
            this.maxY = Integer.MAX_VALUE;
        }

        protected void findNext() {
            while (this.reportPageList != null || this.maxY == Integer.MAX_VALUE) {
                ReportPageProvider reportPageProvider;
                if (this.reportPageList == null) {
                    this.reportPageList = new ArrayList();
                    reportPageProvider = null;
                    ClippedPageProvider clippedPageProvider = null;
                    while ((reportPageProvider = LargeDataExcelExporterReport.this.pageSet.getPage(this.pn)) != null && (clippedPageProvider = ExporterUtils.support(reportPageProvider)) != null) {
                        if (this.reportPageList.size() == 0) {
                            this.current_page_y = reportPageProvider.getXY()[1] + 1;
                            if (((LargeDataExcelExporterReport)LargeDataExcelExporterReport.this).pn_area.from == this.pn) {
                                this.row_count += clippedPageProvider.getRowCount();
                                this.first_y = this.current_page_y;
                            }
                        } else if (reportPageProvider.getXY()[1] + 1 != this.current_page_y) {
                            if (this.current_page_y == this.first_y) {
                                this.maxX = this.reportPageList.size();
                                this.x_checklast = new boolean[this.maxX];
                            }
                            this.row_count += clippedPageProvider.getRowCount();
                            if (this.row_count <= LargeDataExcelExporterReport.this.max_count) break;
                            this.maxY = this.current_page_y;
                            ((LargeDataExcelExporterReport)LargeDataExcelExporterReport.this).pn_area.to = this.pn;
                            break;
                        }
                        this.reportPageList.add(reportPageProvider);
                        ++this.pn;
                    }
                    if (reportPageProvider == null) {
                        this.maxY = this.reportPageList.size() == 0 ? 0 : this.current_page_y;
                        this.pn = -1;
                        ((LargeDataExcelExporterReport)LargeDataExcelExporterReport.this).pn_area.to = -1;
                    }
                }
                if (this.reportPageList.size() > 0 && this.iteratePageArray((ReportPageProvider[])(reportPageProvider = this.reportPageList.toArray(new ReportPageProvider[this.reportPageList.size()])), this.first_y, LargeDataExcelExporterReport.this.isPage, this.maxX, this.maxY)) {
                    return;
                }
                this.reportPageList = null;
            }
            this.next = null;
        }
    }
}

