/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui.container.cardlayout;

import com.fr.base.GraphHelper;
import com.fr.form.ui.CardSwitchButton;
import com.fr.form.ui.FreeButton;
import com.fr.form.ui.Label;
import com.fr.form.ui.Widget;
import com.fr.form.ui.container.WHorizontalBoxLayout;
import com.fr.general.FRFont;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.core.NodeVisitor;
import com.fr.stable.core.UUID;
import com.fr.stable.web.Repository;
import java.awt.Font;
import java.awt.FontMetrics;

public class WCardTagLayout
extends WHorizontalBoxLayout {
    private static final int DESIGNER_DEFAULT_GAP = 1;
    private static final int WEB_DEFAULT_GAP = 3;
    private static final int FIRST = 0;
    private static final int FIRST_OPACITY = 1;
    private static final int DEFAULT_PADING = 15;
    private transient FRFont titleFont;
    private boolean WEB_WIDGET_INITIALIZED = false;

    public WCardTagLayout() {
        this.setHgap(1);
        this.setAlignment(0);
        this.clearMargin();
        this.setWidgetName(UUID.randomUUID().toString());
    }

    public FRFont getTitleFont() {
        return this.titleFont;
    }

    public void setTitleFont(FRFont fRFont) {
        this.titleFont = fRFont;
    }

    public String getXType() {
        return "cardtaglayout";
    }

    public void adjustPreferWidth() {
        int n2 = this.widgetList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            FreeButton freeButton = (FreeButton)this.widgetList.get(i2);
            String string = freeButton.getText();
            freeButton.setFont(this.titleFont);
            FontMetrics fontMetrics = this.getSwitchButtonFontMetrics(freeButton);
            this.setWidthAtIndex(i2, fontMetrics.stringWidth(string) + 15);
        }
    }

    private FontMetrics getDefaultFontMetrics() {
        return GraphHelper.getFontMetrics((Font)this.titleFont.applyResolutionNP(96));
    }

    private FontMetrics getSwitchButtonFontMetrics(FreeButton freeButton) {
        FRFont fRFont = freeButton.getFont();
        if (fRFont == null) {
            fRFont = this.titleFont;
        }
        return GraphHelper.getFontMetrics((Font)fRFont.applyResolutionNP(96));
    }

    public CardSwitchButton getSwitchButton(int n2) {
        if (n2 == -1 || n2 >= this.widgetList.size()) {
            throw new RuntimeException("Error Switch Button Index !");
        }
        return (CardSwitchButton)((Object)this.widgetList.get(n2));
    }

    private void prepareWebStyle() {
        if (this.WEB_WIDGET_INITIALIZED) {
            return;
        }
        CardSwitchButton cardSwitchButton = this.getSwitchButton(0);
        cardSwitchButton.setOpacity(1.0);
        this.setHgap(3);
        this.addWidget((Widget)new Label(), 0);
        this.setWidthAtIndex(0, 0);
        this.WEB_WIDGET_INITIALIZED = true;
    }

    public JSONObject createJSONConfig(Repository repository, Calculator calculator, NodeVisitor nodeVisitor) throws JSONException {
        this.prepareWebStyle();
        return super.createJSONConfig(repository, calculator, nodeVisitor);
    }
}

