/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.share;

import com.fr.base.Env;
import com.fr.base.FRContext;
import com.fr.file.CacheManager;
import com.fr.form.ui.ElCaseBindInfo;
import com.fr.form.ui.ElementCaseEditor;
import com.fr.form.ui.SharableElementCaseEditor;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.GeneralContext;
import com.fr.general.IOUtils;
import com.fr.general.Inter;
import com.fr.stable.ArrayUtils;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLTools;
import com.fr.stable.xml.XMLWriter;
import com.fr.stable.xml.XMLableReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShareLoader
implements XMLWriter,
XMLReadable {
    private static ShareLoader loader;
    private static Set<String> moduleCategory;
    private Map<String, ElCaseBindInfo> bindInfoMap = new HashMap<String, ElCaseBindInfo>();
    private Map<String, SharableElementCaseEditor> elementCaseMap = new HashMap<String, SharableElementCaseEditor>();
    private List<String> removedModuleList = new ArrayList<String>();

    public static synchronized ShareLoader getLoader() {
        ShareLoader.init();
        return loader;
    }

    public static synchronized void init() {
        if (loader == null) {
            loader = new ShareLoader();
            try {
                loader.readShareElements();
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), (Throwable)exception);
            }
        }
    }

    public static synchronized void foreInit() {
        loader = null;
        ShareLoader.init();
    }

    private void readShareElements() throws Exception {
        Env env = FRContext.getCurrentEnv();
        if (env == null) {
            return;
        }
        this.readFromEnv();
    }

    public ElCaseBindInfo getElCaseBindInfoById(String string) {
        ElCaseBindInfo elCaseBindInfo = this.bindInfoMap.get(string);
        try {
            return elCaseBindInfo == null ? null : elCaseBindInfo.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            FRLogger.getLogger().error(cloneNotSupportedException.getMessage(), (Throwable)cloneNotSupportedException);
            return null;
        }
    }

    public SharableElementCaseEditor getSharedElCaseEditorById(String string) {
        SharableElementCaseEditor sharableElementCaseEditor = this.elementCaseMap.get(string);
        try {
            return sharableElementCaseEditor == null ? null : (SharableElementCaseEditor)((Object)sharableElementCaseEditor.clone());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            FRLogger.getLogger().error(cloneNotSupportedException.getMessage(), (Throwable)cloneNotSupportedException);
            return null;
        }
    }

    public ElementCaseEditor getElCaseEditorById(String string) {
        ElementCaseEditor elementCaseEditor = this.elementCaseMap.containsKey(string) ? this.elementCaseMap.get(string).getElementCaseEditor() : new ElementCaseEditor();
        try {
            return elementCaseEditor == null ? null : (ElementCaseEditor)((Object)elementCaseEditor.clone());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            FRLogger.getLogger().error(cloneNotSupportedException.getMessage(), (Throwable)cloneNotSupportedException);
            return null;
        }
    }

    public boolean installModuleFromDiskZipFile(File file) throws IOException {
        return FRContext.getCurrentEnv().installREUFile(file);
    }

    public boolean removeModulesFromList() {
        boolean bl = false;
        for (int i2 = 0; i2 < this.removedModuleList.size(); ++i2) {
            bl = FRContext.getCurrentEnv().removeREUFilesByName(this.removedModuleList.get(i2));
        }
        this.removedModuleList.clear();
        return bl;
    }

    public void addModuleToList(String string) {
        this.removedModuleList.add(string);
    }

    public void removeModuleForList(String string) {
        this.removedModuleList.remove(string);
    }

    public List<String> getRemovedModuleList() {
        return this.removedModuleList;
    }

    public void resetRemovedModuleList() {
        this.removedModuleList.clear();
    }

    public void refreshModule() throws Exception {
        this.readFromEnv();
    }

    private void readFromEnv() throws Exception {
        Object[] objectArray;
        this.checkReadMe();
        this.bindInfoMap.clear();
        this.elementCaseMap.clear();
        Env env = FRContext.getCurrentEnv();
        File file = new File(CacheManager.getProviderInstance().getCacheDirectory(), "fr_share");
        StableUtils.deleteFile((File)file);
        StableUtils.mkdirs((File)file);
        try {
            objectArray = env.loadREUFile();
        }
        catch (Exception exception) {
            FRLogger.getLogger().info("reu files loaded failed!");
            return;
        }
        if (objectArray == null || ArrayUtils.isEmpty((Object[])objectArray)) {
            FRLogger.getLogger().info("no reu file exists!");
            return;
        }
        String string = file.getAbsolutePath();
        String string2 = StableUtils.pathJoin((String[])new String[]{string, "tmp_share"});
        File file2 = new File(string2);
        StableUtils.deleteFile((File)file2);
        StableUtils.mkdirs((File)file2);
        this.readReuFiles((File[])objectArray, string2);
        StableUtils.deleteFile((File)file2);
    }

    private void readReuFiles(File[] fileArray, String string) throws Exception {
        moduleCategory = new HashSet<String>();
        for (File file : fileArray) {
            ElementCaseEditor elementCaseEditor;
            if (!file.getName().endsWith(".reu")) continue;
            IOUtils.unzip((File)file, (String)string);
            String string2 = StableUtils.pathJoin((String[])new String[]{string, "help.xml"});
            String string3 = StableUtils.pathJoin((String[])new String[]{string, "module.xml"});
            ElCaseBindInfo elCaseBindInfo = new ElCaseBindInfo();
            SharableElementCaseEditor sharableElementCaseEditor = new SharableElementCaseEditor();
            File file2 = new File(string2);
            File file3 = new File(string3);
            XMLTools.readFileXML((XMLReadable)elCaseBindInfo, (File)file2);
            XMLTools.readFileXML((XMLReadable)sharableElementCaseEditor, (File)file3);
            file2.delete();
            file3.delete();
            String string4 = elCaseBindInfo.getId();
            String string5 = elCaseBindInfo.getClassifycn();
            if (string5 != null) {
                moduleCategory.add(string5);
            }
            if ((elementCaseEditor = sharableElementCaseEditor.getElementCaseEditor()) != null) {
                elementCaseEditor.setDescription(elCaseBindInfo.getGuideInfo());
            }
            if (string4 == null) continue;
            this.bindInfoMap.put(string4, elCaseBindInfo);
            this.elementCaseMap.put(string4, sharableElementCaseEditor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkReadMe() {
        String string = FRContext.getCurrentEnv().getSharePath();
        if (StringUtils.isEmpty((String)string)) {
            return;
        }
        String string2 = StableUtils.pathJoin((String[])new String[]{string, "readme.txt"});
        File file = new File(string2);
        if (file != null && file.exists()) {
            return;
        }
        BufferedWriter bufferedWriter = null;
        try {
            StableUtils.makesureFileExist((File)file);
            String string3 = Inter.getLocText((String)"FR-Plugin_Share_Read_Me_Tip");
            bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write(string3, 0, string3.length() - 1);
        }
        catch (IOException iOException) {
            FRLogger.getLogger().info("readme.txt create failed");
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
            catch (IOException iOException) {
                FRLogger.getLogger().info("readme.txt create failed");
            }
        }
    }

    public Map<String, ElCaseBindInfo> getAllBindInfos() {
        return this.bindInfoMap;
    }

    public ElCaseBindInfo[] getAllBindInfoList() {
        if (this.bindInfoMap.isEmpty()) {
            return null;
        }
        ArrayList<ElCaseBindInfo> arrayList = new ArrayList<ElCaseBindInfo>();
        try {
            for (ElCaseBindInfo elCaseBindInfo : this.bindInfoMap.values()) {
                arrayList.add(elCaseBindInfo.clone());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            FRLogger.getLogger().error(cloneNotSupportedException.getMessage(), (Throwable)cloneNotSupportedException);
        }
        return arrayList.toArray(new ElCaseBindInfo[arrayList.size()]);
    }

    public ElCaseBindInfo[] getFilterBindInfoList(String string) {
        if (this.bindInfoMap.isEmpty()) {
            return null;
        }
        ArrayList<ElCaseBindInfo> arrayList = new ArrayList<ElCaseBindInfo>();
        try {
            for (ElCaseBindInfo elCaseBindInfo : this.bindInfoMap.values()) {
                String string2 = elCaseBindInfo.getClassifycn();
                if (!ComparatorUtils.equals((String)string2, (String)string)) continue;
                arrayList.add(elCaseBindInfo.clone());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            FRLogger.getLogger().error(cloneNotSupportedException.getMessage(), (Throwable)cloneNotSupportedException);
        }
        return arrayList.toArray(new ElCaseBindInfo[arrayList.size()]);
    }

    public Map<String, SharableElementCaseEditor> getAllElementCase() {
        return this.elementCaseMap;
    }

    public String[] getModuleCategory() {
        return moduleCategory == null ? new String[]{} : moduleCategory.toArray(new String[moduleCategory.size()]);
    }

    public void readXML(XMLableReader xMLableReader) {
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
    }

    static {
        GeneralContext.addEnvChangedListenerToLast((EnvChangedListener)new EnvChangedListener(){

            public void envChanged() {
                ShareLoader.foreInit();
            }
        });
        loader = null;
    }
}

