/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.platform.msg.cache;

import com.fr.base.platform.msg.Message;
import com.fr.base.platform.msg.cache.PCMessageCache;
import com.fr.base.platform.msg.cache.PCMessageCacheProvider;
import com.fr.cluster.rpc.RPC;
import com.fr.file.BaseClusterHelper;
import com.fr.general.GeneralContext;
import com.fr.stable.EnvChangedListener;

public class PCMessageCacheImpl
implements PCMessageCacheProvider {
    private static PCMessageCacheProvider messageCacheProvider;

    public static PCMessageCacheProvider getInstance() {
        if (messageCacheProvider == null) {
            PCMessageCacheImpl.initCacheImpl();
        }
        return messageCacheProvider;
    }

    private static synchronized void initCacheImpl() {
        switch (BaseClusterHelper.getClusterState()) {
            case LEADER: {
                messageCacheProvider = new PCMessageCacheImpl();
                RPC.registerSkeleton((Object)messageCacheProvider);
                break;
            }
            case MEMBER: {
                String string = BaseClusterHelper.getMainServiceIP();
                messageCacheProvider = (PCMessageCacheProvider)RPC.getProxy(PCMessageCacheImpl.class, (String)string);
                break;
            }
            default: {
                messageCacheProvider = new PCMessageCacheImpl();
            }
        }
    }

    public boolean cache(String string, Message message) throws Exception {
        return PCMessageCache.cache(string, message);
    }

    public boolean removeCache(String string) throws Exception {
        return PCMessageCache.removeCache(string);
    }

    public Message[] getMessages(String string) throws Exception {
        return PCMessageCache.getAllMessages(string);
    }

    public boolean updateToasted(String string) throws Exception {
        return PCMessageCache.updateToasted(string);
    }

    static {
        GeneralContext.addEnvChangedListener((EnvChangedListener)new EnvChangedListener(){

            public void envChanged() {
                messageCacheProvider = null;
            }
        });
    }
}

