/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core;

import com.fr.base.ConfigManager;
import com.fr.base.ParameterMapNameSpace;
import com.fr.base.TableDataNameSpace;
import com.fr.base.chart.ChartWebSource;
import com.fr.cache.Attachment;
import com.fr.cache.AttachmentSource;
import com.fr.data.TableDataSource;
import com.fr.data.cache.AttachmentCacheManager;
import com.fr.general.ComparatorUtils;
import com.fr.general.FArray;
import com.fr.general.FRLogger;
import com.fr.general.LogDuration;
import com.fr.general.data.DataModel;
import com.fr.general.privilege.PrivilegeConstants;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.performance.PerformanceManager;
import com.fr.performance.info.IReportPerformanceInfo;
import com.fr.performance.info.IRuntimeInfo;
import com.fr.performance.status.ReportStatus;
import com.fr.script.Calculator;
import com.fr.script.CalculatorMap;
import com.fr.stable.fun.IOFileAttrMark;
import com.fr.stable.script.AbstractNameSpace;
import com.fr.stable.script.CalculatorKey;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.script.NameSpace;
import com.fr.stable.web.SessionProvider;
import com.fr.web.AttachmentHelper;
import com.fr.web.core.SessionDealWith;
import com.fr.web.utils.WebUtils;
import java.awt.Image;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SessionIDInfor
implements SessionProvider,
Serializable,
LogDuration {
    public static final CalculatorKey KEY = CalculatorKey.createKey(SessionIDInfor.class.getName());
    protected long lastTime;
    protected final long startTime = System.currentTimeMillis();
    protected String sessionID;
    protected String remoteAddress;
    protected String browser;
    protected String bookPath;
    protected Map<String, Object> attributeMap = new HashMap<String, Object>(2);
    protected CalculatorMap<String, Object> parameterMap4Execute;
    protected List<String> attachmentList = new ArrayList<String>();
    protected String webTitle = null;
    protected Map<String, Object> resolvedParameterMap4Exe = null;
    private Map<String, DataModel> cachedDataModels = new ConcurrentHashMap<String, DataModel>();
    private final Object mapLock = new Object();
    private IReportPerformanceInfo performanceInfo = PerformanceManager.getInfoFactory().createReportInfo();
    private IRuntimeInfo runtimeInfo = PerformanceManager.getInfoFactory().createRuntimeInfo();
    private ReportStatus status = ReportStatus.INIT;

    public void putDataModelToCache(String string, DataModel dataModel) {
        this.cachedDataModels.put(string, dataModel);
    }

    public DataModel getCachedDataModel(String string) {
        return this.cachedDataModels.get(string);
    }

    public void clearDataModelCaches() {
        this.cachedDataModels.clear();
    }

    public void updateTime() {
        this.lastTime = System.currentTimeMillis();
    }

    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public boolean isTimeout() {
        return System.currentTimeMillis() - this.lastTime > ConfigManager.getProviderInstance().getSessionDeadTime();
    }

    @Override
    public String getSessionID() {
        return this.sessionID;
    }

    @Override
    public void setSessionID(String string) {
        this.sessionID = string;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public Calculator createSessionCalculator(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Calculator calculator = Calculator.createCalculator();
        calculator.pushNameSpace(ParameterMapNameSpace.create(this.getParameterMap4Execute()));
        calculator.pushNameSpace(TableDataNameSpace.getInstance());
        calculator.setAttribute(TableDataSource.KEY, (Object)this.getTableDataSource());
        return calculator;
    }

    public abstract TableDataSource getTableDataSource();

    public void updateTableDataSource() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getParameterMap4Execute() {
        Object object = this.mapLock;
        synchronized (object) {
            Map<String, Object> map = this.getParameterMap4Execute4Consisent();
            if (map == null) {
                return null;
            }
            CalculatorMap<String, Object> calculatorMap = CalculatorMap.createEmptyMap();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                calculatorMap.put(entry.getKey(), entry.getValue());
            }
            return calculatorMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getParameterMap4Execute4Consisent() {
        Object object = this.mapLock;
        synchronized (object) {
            if (this.resolvedParameterMap4Exe == null) {
                return WebUtils.dealWithExecuteParamMap(this.parameterMap4Execute);
            }
            return this.resolvedParameterMap4Exe;
        }
    }

    public Object getParameterValue(String string) {
        if (this.parameterMap4Execute == null) {
            return null;
        }
        return this.parameterMap4Execute.get(string);
    }

    public void setAttribute(String string, Object object) {
        this.attributeMap.put(string, object);
    }

    public Object getAttribute(String string) {
        return this.attributeMap.get(string);
    }

    @Override
    public IReportPerformanceInfo getPerformanceInfo() {
        return this.performanceInfo;
    }

    @Override
    public void setPerformanceInfo(IReportPerformanceInfo iReportPerformanceInfo) {
        this.performanceInfo = iReportPerformanceInfo;
    }

    public IRuntimeInfo getRuntimeInfo() {
        return this.runtimeInfo;
    }

    public ReportStatus getStatus() {
        return this.status;
    }

    public void setStatus(ReportStatus reportStatus) {
        this.status = reportStatus;
    }

    public String getBookPath() {
        return this.bookPath;
    }

    public Object removeAttribute(String string) {
        return this.attributeMap.remove(string);
    }

    public String addImage(Image image) {
        Attachment attachment = AttachmentHelper.addAttachment(image);
        this.attachmentList.add(attachment.getID());
        return attachment.getID();
    }

    @Deprecated
    public void addImageID(String string) {
        this.attachmentList.add(string);
    }

    public void addAttachmentID(String string) {
        this.attachmentList.add(string);
    }

    public Attachment addAttachment(String string, String string2, byte[] byArray, int n, int n2) {
        Attachment attachment = AttachmentCacheManager.addAttachment(string, string2, byArray, n, n2);
        this.attachmentList.add(attachment.getID());
        return attachment;
    }

    public void clearAttachmentsAndChartMap() {
        int n = this.attachmentList.size();
        for (int i = 0; i < n; ++i) {
            AttachmentSource.removeAttachment(this.attachmentList.get(i));
        }
        this.attachmentList.clear();
        ChartWebSource.clear(this.getSessionID());
    }

    protected abstract Object resolveVariable(Object var1, CalculatorProvider var2);

    public static NameSpace asNameSpace(String string) {
        return new SessionIDInforNameSpace(string);
    }

    public void resetRuntimeInfo() {
        this.runtimeInfo.reset();
    }

    @Override
    public Map<String, Object> durationParameters() {
        String string = null;
        String string2 = null;
        String string3 = null;
        string = this.getRemoteAddress();
        if (ComparatorUtils.equals(string, "0:0:0:0:0:0:0:1") || ComparatorUtils.equals(string, "127.0.0.1")) {
            string = "localhost";
        }
        if (this.getParameterValue("fr_username") == null) {
            string2 = PrivilegeConstants.USER_UNLOGIN;
            string3 = PrivilegeConstants.ROLE_UNKNOWN;
        } else {
            string2 = (String)this.getParameterValue("fr_username");
            string3 = this.getUserRoleString();
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("ip", string);
        hashMap.put("username", string2);
        hashMap.put("userrole", string3);
        hashMap.put("browser", this.browser);
        return hashMap;
    }

    private String getUserRoleString() {
        FArray fArray;
        Object object = this.getParameterValue("fr_authority");
        Object object2 = this.getParameterValue("fr_userposition");
        if (object == null && object2 == null) {
            return PrivilegeConstants.ROLE_UNDEFINED;
        }
        FArray<Object> fArray2 = new FArray<Object>();
        if (object instanceof FArray) {
            fArray = (FArray)object;
            fArray2.add(fArray);
        } else if (object != null) {
            fArray2.add(object);
        }
        if (object2 instanceof FArray) {
            fArray = (FArray)object2;
            for (int i = 0; i < fArray.length(); ++i) {
                JSONObject jSONObject = (JSONObject)fArray.elementAt(i);
                try {
                    fArray2.add(jSONObject.getString("departments") + "-" + jSONObject.getString("jobTitle"));
                    continue;
                }
                catch (JSONException jSONException) {
                    FRLogger.getLogger().info(jSONException.getMessage());
                }
            }
        } else if (object2 != null) {
            fArray2.add(object2);
        }
        if (fArray2.length() > 0) {
            return fArray2.toString();
        }
        return PrivilegeConstants.ROLE_UNDEFINED;
    }

    public void applySessionIDInforParameters(HttpServletRequest httpServletRequest) {
    }

    public void clearPrintPreviewPageSet() {
    }

    public void clearPageSet() {
    }

    public void clearPerformanceInfo() {
    }

    public void handleUnregister() {
    }

    public Map getParameterMap() {
        return this.getParameterMap4Execute();
    }

    public abstract IOFileAttrMark getIOFileAttrMark(String var1);

    private static final class SessionIDInforNameSpace
    extends AbstractNameSpace {
        SessionIDInfor info;

        SessionIDInforNameSpace(String string) {
            this.info = SessionDealWith.getSessionIDInfor(string);
        }

        public Object getVariable(Object object, CalculatorProvider calculatorProvider) {
            if (this.info == null || object == null) {
                return null;
            }
            String string = object.toString();
            if (ComparatorUtils.equals("sessionID", string)) {
                return this.info.getSessionID();
            }
            Object object2 = this.info.getParameterValue(string);
            if (object2 != null) {
                return object2;
            }
            if (string.startsWith("$")) {
                string = string.substring(1).toUpperCase();
            }
            if ((object2 = this.info.getParameterValue(string)) != null) {
                return object2;
            }
            return this.info.resolveVariable(object, calculatorProvider);
        }
    }
}

