/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core;

import com.fr.base.ConfigManager;
import com.fr.base.Env;
import com.fr.base.FRContext;
import com.fr.base.TemplateUtils;
import com.fr.general.FRLogger;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.CodeUtils;
import com.fr.stable.FRException;
import com.fr.stable.ProductConstants;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.web.Weblet;
import com.fr.web.factory.WebletFactory;
import com.fr.web.utils.WebUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HandlerMethodHelper {
    private static final String DEFAULT_ERROR_TEMPLATE = "/com/fr/web/core/errorIframe.html";
    private static final int DEFAULT_ERROR_CODE = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createJSONObject(HttpServletResponse httpServletResponse, String string, Throwable throwable, int n) {
        JSONObject jSONObject = new JSONObject();
        PrintWriter printWriter = null;
        try {
            printWriter = WebUtils.createPrintWriter(httpServletResponse);
            if (n > 0) {
                jSONObject.put("errorCode", n);
            }
            jSONObject.put("message", string);
            jSONObject.put("exception", throwable == null ? Integer.valueOf(n) : HandlerMethodHelper.createThrowableMessage(throwable, false));
            printWriter.println(jSONObject);
            printWriter.flush();
            printWriter.close();
        }
        catch (Exception exception) {
            try {
                jSONObject.put("exception", throwable == null ? Integer.valueOf(n) : HandlerMethodHelper.createThrowableMessage(exception.getCause(), false));
            }
            catch (JSONException jSONException) {
                FRContext.getLogger().error(exception.getMessage(), exception);
            }
        }
        finally {
            if (printWriter != null) {
                printWriter.flush();
                printWriter.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String createThrowableMessage(Throwable throwable, boolean bl) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        try {
            String string = bl ? CodeUtils.htmlEncode(CodeUtils.cjkEncode(stringWriter.toString())) : stringWriter.toString();
            return string;
        }
        finally {
            printWriter.flush();
            printWriter.close();
        }
    }

    private static void userDefineHandler(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map map) throws Exception {
        Env env = FRContext.getCurrentEnv();
        if (env == null) {
            throw new IllegalStateException("Env is null..");
        }
        String string = ConfigManager.getProviderInstance().getErrorTemplate();
        if (StringUtils.isNotEmpty(string) && !string.endsWith(".html")) {
            if (string.length() > 0 && string.charAt(0) == '/') {
                string = httpServletRequest.getContextPath() + string;
            }
            map.put("redirectURL", string);
            WebUtils.writeOutTemplate("/com/fr/web/core/errorPostRedirect.html", httpServletResponse, map);
        } else {
            String string2 = env.getPath();
            File file = new File(StableUtils.pathJoin(new File(string2).getParent(), string));
            PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
            TemplateUtils.dealWithTemplate(new FileInputStream(file), "UTF-8", printWriter, map);
            printWriter.flush();
            printWriter.close();
        }
    }

    public static void postTemplateOnPC(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, Throwable throwable, String string2) {
        Weblet weblet = WebletFactory.createEmbeddedWeblet(string2);
        try {
            weblet.dealWeblet(httpServletRequest, httpServletResponse);
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
        }
    }

    public static void solveWebletOnPC(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, Weblet weblet) {
        try {
            weblet.dealWeblet(httpServletRequest, httpServletResponse);
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
        }
    }

    public static void postErrorMessageOnPC(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, Throwable throwable) {
        HandlerMethodHelper.postErrorMessageOnPC(httpServletRequest, httpServletResponse, string, throwable, DEFAULT_ERROR_TEMPLATE);
    }

    public static void postErrorMessageOnPC(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, Throwable throwable, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string == null) {
            string = "";
        }
        hashMap.put("message", CodeUtils.htmlEncode(CodeUtils.cjkEncode(string)));
        hashMap.put("duration", ProductConstants.HISTORY);
        hashMap.put("companyname", ProductConstants.COMPANY_NAME);
        try {
            if (httpServletRequest.getParameter("frload") != null) {
                PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
                printWriter.println(new StringBuffer().append("alert(\"").append(string.replaceAll("\"", "\\\\\"")).append("\")"));
                printWriter.flush();
                printWriter.close();
                return;
            }
            if (throwable != null) {
                hashMap.put("exception", HandlerMethodHelper.createThrowableMessage(throwable, true));
            }
            hashMap.put("charset", CodeUtils.htmlEncode(ConfigManager.getProviderInstance().getServerCharset()));
            if (StringUtils.isBlank(string2)) {
                string2 = DEFAULT_ERROR_TEMPLATE;
            }
            if (StringUtils.isNotEmpty(ConfigManager.getProviderInstance().getErrorTemplate())) {
                try {
                    HandlerMethodHelper.userDefineHandler(httpServletRequest, httpServletResponse, hashMap);
                }
                catch (Exception exception) {
                    WebUtils.writeOutTemplate(string2, httpServletResponse, hashMap);
                    FRContext.getLogger().error(exception.getMessage());
                }
            } else {
                WebUtils.writeOutTemplate(string2, httpServletResponse, hashMap);
            }
        }
        catch (IOException iOException) {
            FRContext.getLogger().errorWithServerLevel(iOException.getMessage(), iOException);
        }
    }

    public static void postErrorMessageWithJSONObject(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, Throwable throwable) {
        HandlerMethodHelper.createJSONObject(httpServletResponse, string, throwable, -1);
    }

    public static void postErrorMessageWithJSONObject(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FRException fRException) {
        String string = fRException.getMessage();
        Throwable throwable = fRException.getCause();
        int n = fRException.getErrorCode();
        HandlerMethodHelper.createJSONObject(httpServletResponse, string, throwable, n);
    }
}

