/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web;

import com.fr.base.ConfigManager;
import com.fr.base.IconManager;
import com.fr.base.TemplateUtils;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.IOUtils;
import com.fr.general.Inter;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.bridge.Aggregate;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.bridge.Transmitter;
import com.fr.stable.bridge.event.StableFactoryCustomer;
import com.fr.stable.bridge.event.StableFactoryMessageTransponder;
import com.fr.stable.bridge.event.StableFactoryResourceType;
import com.fr.web.Browser;
import com.fr.web.FileCacheKey;
import com.fr.web.utils.WebUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ResourceHelper {
    private static String UN_NECESSARY_JS = null;
    private static String NO_REPLACE_JS = null;
    private static AtomicInteger jsVersion = new AtomicInteger(1);
    private static AtomicInteger cssVersion = new AtomicInteger(1);
    private static Map<Locale, String> LOCALE_MAP = new ConcurrentHashMap<Locale, String>();
    private static final Map<FileCacheKey, String> DEFAULT_CACHE_MAP = new ConcurrentHashMap<FileCacheKey, String>();
    private static final StableFactoryCustomer STABLE_FACTORY_CUSTOMER = new StableFactoryCustomer(){

        public void resourceUpdated(StableFactoryResourceType stableFactoryResourceType) {
            ResourceHelper.clearDefaultJsCache();
            if (StableFactoryResourceType.TYPE_CSS.equals((Object)stableFactoryResourceType)) {
                cssVersion.incrementAndGet();
            } else if (StableFactoryResourceType.TYPE_JS.equals((Object)stableFactoryResourceType)) {
                jsVersion.incrementAndGet();
            }
        }
    };

    public static void clearAllJsCache() {
        UN_NECESSARY_JS = null;
        ResourceHelper.clearDefaultJsCache();
        ResourceHelper.clearLocaleJsCache();
    }

    public static int getJsVersion() {
        return jsVersion.get();
    }

    public static int getCssVersion() {
        return cssVersion.get();
    }

    public static void clearLocaleJsCache() {
        LOCALE_MAP.clear();
    }

    public static void clearDefaultJsCache() {
        DEFAULT_CACHE_MAP.clear();
        NO_REPLACE_JS = null;
    }

    public static String fetchI18NJs(Locale locale) throws Exception {
        if (!LOCALE_MAP.containsKey(locale)) {
            LOCALE_MAP.put(locale, ResourceHelper.createI18NJs(locale));
        }
        return LOCALE_MAP.get(locale);
    }

    public static void dealWithEmbResource(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "resource");
        boolean bl = WebUtils.getHTTPRequestBoolParameter(httpServletRequest, "__pre__");
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        WebUtils.setResourceContentType(string, httpServletResponse);
        if (bl) {
            Aggregate aggregate = StableFactory.getJavaScriptAggregate(string);
            Transmitter transmitter = aggregate.getTransmitter();
            String string2 = transmitter != null ? transmitter.transmit(httpServletRequest, httpServletResponse, aggregate.getFiles()) : ResourceHelper.contactArrayString(aggregate.getFiles());
            ResourceHelper.writeJS(httpServletResponse, string2);
        } else if (ComparatorUtils.equals("finereport.js", string)) {
            Locale locale = WebUtils.getLocale(httpServletRequest);
            ResourceHelper.writeJS(httpServletResponse, ResourceHelper.createDefaultJs(locale));
        } else if (ComparatorUtils.equals("toolbar.css", string)) {
            String string3 = ResourceHelper.createToolbarCss(httpServletRequest);
            if (string3 == null) {
                string3 = "";
            }
            ResourceHelper.writeCss(printWriter, string3);
        } else if (ComparatorUtils.equals("i18n.js", string)) {
            Locale locale = WebUtils.getLocale(httpServletRequest);
            ResourceHelper.writeJS(httpServletResponse, ResourceHelper.createI18NJs(locale));
        } else if (ComparatorUtils.equals("finereport.chart.js", string)) {
            boolean bl2 = Browser.resolve(httpServletRequest).shouldLoadCanvas();
            if (bl2) {
                ResourceHelper.writeJS(httpServletResponse, ResourceHelper.createJavaScriptWithCache("chart_ie"));
            } else {
                ResourceHelper.writeJS(httpServletResponse, ResourceHelper.createJavaScriptWithCache("finereport.chart.js"));
            }
        } else if (string.toLowerCase().endsWith(".js")) {
            ResourceHelper.writeJS(httpServletResponse, ResourceHelper.createJavaScriptWithCache(string));
        } else if (string.toLowerCase().endsWith(".css")) {
            ResourceHelper.writeCss(printWriter, ResourceHelper.createStyleWithCache(string));
        }
        printWriter.flush();
        printWriter.close();
    }

    public static String forceInitJSCache(String string) {
        FileCacheKey fileCacheKey = new FileCacheKey(string);
        String string2 = ResourceHelper.contactArrayString(StableFactory.getJavaScriptFiles(string));
        DEFAULT_CACHE_MAP.put(fileCacheKey, string2);
        return string2;
    }

    public static String forceInitStyleCache(String string) {
        FileCacheKey fileCacheKey = new FileCacheKey(string);
        String string2 = ResourceHelper.contactArrayString(StableFactory.getStyleFiles(string));
        DEFAULT_CACHE_MAP.put(fileCacheKey, string2);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String createJavaScriptWithCache(String string) {
        FileCacheKey fileCacheKey = new FileCacheKey(string);
        String string2 = DEFAULT_CACHE_MAP.get(fileCacheKey);
        if (string2 != null) return string2;
        Class<ResourceHelper> clazz = ResourceHelper.class;
        synchronized (ResourceHelper.class) {
            string2 = DEFAULT_CACHE_MAP.get(fileCacheKey);
            if (string2 != null) return string2;
            return ResourceHelper.forceInitJSCache(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String createStyleWithCache(String string) {
        FileCacheKey fileCacheKey = new FileCacheKey(string);
        String string2 = DEFAULT_CACHE_MAP.get(fileCacheKey);
        if (string2 != null) return string2;
        Class<ResourceHelper> clazz = ResourceHelper.class;
        synchronized (ResourceHelper.class) {
            string2 = DEFAULT_CACHE_MAP.get(fileCacheKey);
            if (string2 != null) return string2;
            return ResourceHelper.forceInitStyleCache(string);
        }
    }

    public static void writeJS(HttpServletResponse httpServletResponse, String string) throws IOException {
        String string2 = ConfigManager.getProviderInstance().getServerCharset();
        httpServletResponse.setContentType("text/javascript;charset=" + string2);
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        printWriter.write(string);
        printWriter.flush();
        printWriter.close();
    }

    public static PrintWriter createJSWriter(HttpServletResponse httpServletResponse) throws IOException {
        String string = ConfigManager.getProviderInstance().getServerCharset();
        httpServletResponse.setContentType("text/javascript;charset=" + string);
        return WebUtils.createPrintWriter(httpServletResponse);
    }

    private static void writeCss(PrintWriter printWriter, String string) throws IOException {
        TemplateUtils.dealWithTemplate(new StringReader(string), printWriter);
    }

    private static String createI18NJs(Locale locale) throws Exception {
        return ResourceHelper.ensureI18n(locale).toString();
    }

    private static StringBuffer ensureI18n(Locale locale) {
        String[] stringArray;
        StringBuffer stringBuffer = new StringBuffer();
        JSONObject jSONObject = JSONObject.create();
        for (String string : stringArray = StableFactory.getLocaleFiles()) {
            ResourceBundle resourceBundle = null;
            try {
                resourceBundle = ResourceBundle.getBundle(string, locale, Inter.class.getClassLoader());
            }
            catch (Exception exception) {
                try {
                    resourceBundle = ResourceBundle.getBundle(string, Locale.US, Inter.class.getClassLoader());
                    FRLogger.getLogger().error("No suitable international properties file, use EN_US to replace!");
                }
                catch (Exception exception2) {
                    FRLogger.getLogger().error("No suitable international properties file");
                }
            }
            ResourceHelper.mixLocaleData(resourceBundle, jSONObject);
        }
        ResourceBundle resourceBundle = Inter.getCustomResourceBundle(locale);
        ResourceHelper.mixLocaleData(resourceBundle, jSONObject);
        HashMap<String, JSONObject> hashMap = new HashMap<String, JSONObject>();
        hashMap.put("i18n_props", jSONObject);
        try {
            stringBuffer = new StringBuffer().append(TemplateUtils.renderTemplate("/com/fr/web/core/js/i18n4properties.js", hashMap));
        }
        catch (IOException iOException) {
            FRLogger.getLogger().error(iOException.getMessage(), iOException);
        }
        return stringBuffer;
    }

    private static void mixLocaleData(ResourceBundle resourceBundle, JSONObject jSONObject) {
        if (resourceBundle == null) {
            return;
        }
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            try {
                jSONObject.put(string, resourceBundle.getString(string));
            }
            catch (JSONException jSONException) {
                FRLogger.getLogger().error(jSONException.getMessage(), jSONException);
            }
        }
    }

    public static String createDefaultJs(Locale locale) throws Exception {
        FileCacheKey fileCacheKey = new FileCacheKey("finereport.js", locale);
        String string = DEFAULT_CACHE_MAP.get(fileCacheKey);
        if (string == null) {
            string = ResourceHelper.initDefaultJs(locale, fileCacheKey);
        }
        String string2 = TemplateUtils.render("if (window.FR == null) {window.FR = {};}FR.servletURL = '${servletURL}';FR.serverURL = '${serverURL}';FR.server = '${serverURL}${contextPath}';FR.PROJECTNAME = '${lic_PROJECTNAME}';FR.shouldSendHeartBeat = ${session_heart_beat};", Calculator.createCalculator());
        StringBuffer stringBuffer = new StringBuffer().append(string2);
        return stringBuffer.append(string).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String initDefaultJs(Locale locale, FileCacheKey fileCacheKey) throws Exception {
        Class<ResourceHelper> clazz = ResourceHelper.class;
        synchronized (ResourceHelper.class) {
            String[] stringArray;
            String string = DEFAULT_CACHE_MAP.get(fileCacheKey);
            if (string != null) {
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return string;
            }
            String string2 = UN_NECESSARY_JS;
            if (string2 == null) {
                stringArray = new String[]{"/com/fr/web/underscore.js", "/com/fr/web/jquery.js", "/com/fr/web/jquery-migrate.js", "/com/fr/web/core/js/third/jquery.hotkeys.js", "/com/fr/web/core/js/third/jquery.draggable.js", "/com/fr/web/core/js/third/jquery.droppable.js", "/com/fr/web/core/js/third/jquery.resizable.js", "/com/fr/web/core/js/third/jquery.sortable.js"};
                UN_NECESSARY_JS = string2 = new StringBuffer().append(ResourceHelper.contactArrayString(stringArray)).append("\n").toString();
            }
            if ((stringArray = NO_REPLACE_JS) == null) {
                stringArray = ResourceHelper.contactArrayString(StableFactory.getJavaScriptFiles("finereport.js"));
                NO_REPLACE_JS = stringArray;
            }
            string = new StringBuffer().append(string2).append(ResourceHelper.createI18NJs(locale)).append((String)stringArray).toString();
            DEFAULT_CACHE_MAP.put(fileCacheKey, string);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return string;
        }
    }

    public static String createDefaultCss() throws Exception {
        return ResourceHelper.createStyleWithCache("finereport.css");
    }

    private static String createToolbarCss(HttpServletRequest httpServletRequest) {
        return IconManager.getIconManager().getCssFile(WebUtils.createServletURL(httpServletRequest), Browser.resolve(httpServletRequest));
    }

    private static String contactArrayString(String[] stringArray) {
        return IOUtils.concatFiles(stringArray, '\n');
    }

    static {
        StableFactoryMessageTransponder.getInstance().addCustomer(STABLE_FACTORY_CUSTOMER, new StableFactoryResourceType[]{StableFactoryResourceType.TYPE_CSS, StableFactoryResourceType.TYPE_JS});
    }
}

