/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web;

import java.awt.Point;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageDataUrlCacheManager {
    private static ConcurrentHashMap<String, ConcurrentHashMap<Integer, ConcurrentHashMap<Point, String>>> imageUrlMap = new ConcurrentHashMap();
    private static final ImageDataUrlCacheManager INSTANCE = new ImageDataUrlCacheManager();

    private ImageDataUrlCacheManager() {
    }

    public static ImageDataUrlCacheManager getInstance() {
        return INSTANCE;
    }

    public String getImageDataUrl(String string, int n, Point point) {
        ConcurrentHashMap<Point, String> concurrentHashMap = this.getSheetIndexMap(string, n);
        if (concurrentHashMap != null) {
            return concurrentHashMap.get(point);
        }
        return null;
    }

    public ConcurrentHashMap<Point, String> getSheetIndexMap(String string, int n) {
        ConcurrentHashMap<Integer, ConcurrentHashMap<Point, String>> concurrentHashMap = this.getSessionIDMap(string);
        if (concurrentHashMap != null) {
            return concurrentHashMap.get(n);
        }
        return null;
    }

    public ConcurrentHashMap<Integer, ConcurrentHashMap<Point, String>> getSessionIDMap(String string) {
        return string != null ? imageUrlMap.get(string) : null;
    }

    public void putImageUrl2Map(String string, int n, Point point, String string2) {
        ConcurrentHashMap<Point, String> concurrentHashMap = this.getSheetIndexMap(string, n);
        if (concurrentHashMap != null) {
            concurrentHashMap.put(point, string2);
        }
    }

    public void putSheetIndex2Map(ConcurrentHashMap<Point, String> concurrentHashMap, String string, int n) {
        ConcurrentHashMap<Integer, ConcurrentHashMap<Point, String>> concurrentHashMap2 = this.getSessionIDMap(string);
        if (concurrentHashMap2 != null) {
            concurrentHashMap2.put(n, concurrentHashMap);
        }
    }

    public void putSessionID2Map(ConcurrentHashMap<Integer, ConcurrentHashMap<Point, String>> concurrentHashMap, String string) {
        imageUrlMap.put(string, concurrentHashMap);
    }

    public void clearImageUrlMapByReportIndex(String string, int n) {
        ConcurrentHashMap<Point, String> concurrentHashMap = this.getSheetIndexMap(string, n);
        if (concurrentHashMap != null) {
            concurrentHashMap.clear();
        }
    }

    public void clearImageUrlMapBySessionID(String string) {
        ConcurrentHashMap<Integer, ConcurrentHashMap<Point, String>> concurrentHashMap = this.getSessionIDMap(string);
        if (concurrentHashMap != null) {
            concurrentHashMap.clear();
        }
    }
}

