/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web;

import com.fr.base.ConfigManager;
import com.fr.base.FRContext;
import com.fr.base.Utils;
import com.fr.file.ClusterConfigManager;
import com.fr.file.ClusterService;
import com.fr.general.ComparatorUtils;
import com.fr.general.http.HttpClient;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.plugin.ExtraClassManager;
import com.fr.stable.ArrayUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.fun.ClusterDispatchProcessor;
import com.fr.web.cluster.ClusterManager;
import com.fr.web.utils.WebUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterHelper {
    private static final String SERVER_ID = "serverID";
    private static final String JSESSIONID = "JSESSIONID";
    private static final String REDIRECT = "redirect";

    public static boolean checkClusterDispatch(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map<String, String> map) throws IOException {
        return ClusterHelper.checkClusterDispatch(httpServletRequest, httpServletResponse, map.get("op"), map.get("sessionID"), map.get(SERVER_ID));
    }

    public static boolean CheckClusterDispatch(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2) throws IOException {
        String string3 = WebUtils.getHTTPRequestParameter(httpServletRequest, SERVER_ID);
        return ClusterHelper.checkClusterDispatch(httpServletRequest, httpServletResponse, string, string2, string3);
    }

    public static boolean checkClusterDispatch(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2, String string3) throws IOException {
        ClusterManager.getInstance().initClusterServiceConfig(httpServletRequest);
        ClusterDispatchProcessor clusterDispatchProcessor = (ClusterDispatchProcessor)ExtraClassManager.getInstance().getSingle("ClusterDispatchProcessor");
        if (null != clusterDispatchProcessor && clusterDispatchProcessor.doSthBeforeClusterOperation(httpServletRequest, httpServletResponse, string, string2, string3)) {
            return false;
        }
        if (WebUtils.getHTTPRequestParameter(httpServletRequest, "__redirect_from") != null) {
            return false;
        }
        String string4 = WebUtils.getHTTPRequestParameter(httpServletRequest, "cluster_redirect");
        String string5 = ClusterHelper.findServiceName(httpServletRequest, string, string2, string3, string4);
        ClusterService clusterService = ClusterManager.getInstance().getSelfService();
        if (string5 != null) {
            if (clusterService != null && ComparatorUtils.equals(clusterService.getServiceName(), string5)) {
                return false;
            }
            ClusterService clusterService2 = ClusterConfigManager.getInstance().getService(string5);
            if (clusterService2 != null) {
                ClusterHelper.doRedirect(httpServletRequest, httpServletResponse, clusterService2, clusterService);
                return true;
            }
        }
        return false;
    }

    private static String findServiceName(HttpServletRequest httpServletRequest, String string, String string2, String string3, String string4) {
        String[] stringArray;
        String string5;
        String string6 = null;
        if (string4 != null) {
            string6 = string4;
        } else if (string2 != null) {
            String[] stringArray2 = string2.split("_");
            if (stringArray2.length > 0) {
                string6 = stringArray2[0];
            }
        } else if (string3 != null) {
            String[] stringArray3 = string3.split("_");
            if (stringArray3.length > 0) {
                string6 = stringArray3[0];
            }
        } else if (ClusterHelper.isAttach(string) && (string5 = WebUtils.getHTTPRequestParameter(httpServletRequest, "id")) != null && (stringArray = string5.split("_")).length > 0) {
            string6 = stringArray[0];
        }
        return string6;
    }

    private static boolean isAttach(String string) {
        return string != null && (string.startsWith("fr_attach") || string.startsWith("attach"));
    }

    public static void doRedirect(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ClusterService clusterService, ClusterService clusterService2) throws IOException {
        ClusterHelper.doRedirect(httpServletRequest, httpServletResponse, clusterService, clusterService2, new HashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doRedirect(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ClusterService clusterService, ClusterService clusterService2, Map map) throws IOException {
        ServletOutputStream servletOutputStream;
        Object object;
        Object object3;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("gzip", "false");
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            object3 = (String)enumeration.nextElement();
            hashMap.put((String)object3, WebUtils.getHTTPRequestParameter(httpServletRequest, (String)object3));
        }
        hashMap.put("__redirect_from", clusterService2 == null ? "unknown" : clusterService2.getServiceName());
        hashMap.putAll(map);
        hashMap.put("_", UUID.randomUUID().toString());
        object3 = ClusterHelper.initHeaderJson(httpServletRequest);
        HttpClient httpClient = ClusterHelper.initClient(ClusterConfigManager.getInstance().isEncode(), (JSONObject)object3, clusterService, hashMap, httpServletRequest);
        int n = httpClient.getResponseCode();
        if (n != 200) {
            httpClient = ClusterHelper.retryConnectByPost(httpServletRequest, clusterService, hashMap, (JSONObject)object3, httpClient, n);
        }
        Map<String, List<String>> map2 = httpClient.getAllHeader();
        for (Map.Entry<String, List<String>> object22 : map2.entrySet()) {
            object = object22.getKey();
            servletOutputStream = object22.getValue();
            ClusterHelper.setHeader((String)object, servletOutputStream, httpServletResponse);
        }
        String string = ClusterHelper.checkRedirect(map2, n);
        ClusterHelper.dispatchCookie(httpServletResponse, map2);
        if (StringUtils.isNotEmpty(string)) {
            httpServletResponse.sendRedirect(string);
        }
        try {
            object = httpClient.getResponseStream();
            if (object == null) {
                return;
            }
            httpServletResponse.setCharacterEncoding(ConfigManager.getProviderInstance().getServerCharset());
            servletOutputStream = httpServletResponse.getOutputStream();
            Utils.copyBinaryTo((InputStream)object, (OutputStream)servletOutputStream);
        }
        finally {
            httpClient.release();
        }
    }

    private static String checkRedirect(Map<String, List<String>> map, int n) {
        List<String> list;
        String string = "";
        if (n == 302 && (list = map.get("Set-Cookie")) != null) {
            for (String string2 : list) {
                String[] stringArray;
                if (string2.indexOf(REDIRECT) == -1 || ArrayUtils.getLength(stringArray = string2.split(";")) <= 1) continue;
                string = stringArray[0].substring(string2.indexOf("=") + 2, stringArray[0].length() - 1);
            }
        }
        return string;
    }

    private static void dispatchCookie(HttpServletResponse httpServletResponse, Map<String, List<String>> map) {
        List<String> list = map.get("Set-Cookie");
        if (list != null) {
            Pattern pattern = Pattern.compile("=");
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (String string : list) {
                String string2;
                String[] stringArray = pattern.split(string);
                if (ArrayUtils.getLength(stringArray) <= 1 || JSESSIONID.equals((string2 = stringArray[0]).toUpperCase()) || REDIRECT.equals(string2.toUpperCase())) continue;
                String string3 = stringArray[1];
                if (hashMap.containsKey(string2)) {
                    if (!StringUtils.isNotEmpty(string3) || "\"\"".equals(string3)) continue;
                    hashMap.put(string2, string3);
                    httpServletResponse.addCookie(new Cookie(string2, string3));
                    continue;
                }
                hashMap.put(string2, string3);
                httpServletResponse.addCookie(new Cookie(string2, string3));
            }
        }
    }

    private static HttpClient retryConnectByPost(HttpServletRequest httpServletRequest, ClusterService clusterService, HashMap<String, String> hashMap, JSONObject jSONObject, HttpClient httpClient, int n) {
        if (n == 505) {
            httpClient = ClusterHelper.initClient(true, jSONObject, clusterService, hashMap, httpServletRequest);
            n = httpClient.getResponseCode();
        }
        if (n == 304) {
            httpClient = new HttpClient(ClusterHelper.getDefaultUrl(clusterService), hashMap);
            n = httpClient.getResponseCode();
        }
        if (n != 200) {
            FRContext.getLogger().error("Cluster Redirect Method failed: " + n);
        }
        return httpClient;
    }

    private static HttpClient initClient(boolean bl, JSONObject jSONObject, ClusterService clusterService, HashMap<String, String> hashMap, HttpServletRequest httpServletRequest) {
        HttpClient httpClient = new HttpClient(ClusterHelper.getDefaultUrl(clusterService), hashMap, bl);
        byte[] byArray = (byte[])httpServletRequest.getAttribute("__inputstream__");
        if (byArray != null && !bl) {
            httpClient.setCharSet("ISO-8859-1");
            httpClient.setContent(byArray);
        } else {
            if (bl) {
                ClusterHelper.encodePara(hashMap);
            }
            httpClient.asGet();
            httpClient.setCharSet("GBK");
        }
        httpClient.setHeader(jSONObject.toString());
        return httpClient;
    }

    private static void encodePara(HashMap<String, String> hashMap) {
        try {
            Iterator<Map.Entry<String, String>> iterator = hashMap.entrySet().iterator();
            String string = "UTF-8";
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                if (entry.getValue() == null) continue;
                hashMap.put(entry.getKey(), URLEncoder.encode(entry.getValue(), string));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FRContext.getLogger().error(unsupportedEncodingException.getMessage());
        }
    }

    private static void setHeader(String string, List<String> list, HttpServletResponse httpServletResponse) {
        if (string == null || list == null) {
            return;
        }
        if (string.equalsIgnoreCase("transfer-encoding") || string.equalsIgnoreCase("content-length")) {
            return;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            httpServletResponse.setHeader(string, list.get(i));
        }
    }

    private static String getDefaultUrl(ClusterService clusterService) {
        return "http://" + clusterService.getIp() + ":" + clusterService.getPort() + "/" + clusterService.getWebAppName() + "/" + ConfigManager.getProviderInstance().getServletMapping();
    }

    private static boolean validHeaderName(String string) {
        return string.equalsIgnoreCase("host") || string.equalsIgnoreCase("refer") || string.equalsIgnoreCase("content-length");
    }

    private static JSONObject initHeaderJson(HttpServletRequest httpServletRequest) {
        JSONObject jSONObject = new JSONObject();
        Enumeration enumeration = httpServletRequest.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (ClusterHelper.validHeaderName(string)) continue;
            try {
                jSONObject.put(string, httpServletRequest.getHeader(string));
            }
            catch (JSONException jSONException) {
                FRContext.getLogger().error(jSONException.getMessage());
            }
        }
        return jSONObject;
    }
}

