/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.plugin.event;

import com.fr.stable.plugin.event.PluginActiveListener;
import com.fr.stable.plugin.event.PluginChangeEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginChangeTransponder {
    private static PluginChangeTransponder transponder = new PluginChangeTransponder();
    private Map<String, Map<String, Set<PluginActiveListener>>> moduleInterfaceListenerMap = new HashMap<String, Map<String, Set<PluginActiveListener>>>();
    private Map<String, Set<PluginActiveListener>> interfaceListenerMap = new HashMap<String, Set<PluginActiveListener>>();
    private Map<String, Set<PluginActiveListener>> moduleListenerMap = new HashMap<String, Set<PluginActiveListener>>();
    private Set<PluginActiveListener> pluginListenerSet = new HashSet<PluginActiveListener>();
    private Map<String, Set<PluginActiveListener>> specificPluginListenerMap = new HashMap<String, Set<PluginActiveListener>>();

    private PluginChangeTransponder() {
    }

    public static PluginChangeTransponder getInstance() {
        return transponder;
    }

    public synchronized void clearSpecificPluginListener() {
        this.specificPluginListenerMap.clear();
    }

    public synchronized void clear() {
        this.moduleInterfaceListenerMap.clear();
        this.interfaceListenerMap.clear();
        this.moduleListenerMap.clear();
        this.pluginListenerSet.clear();
        this.clearSpecificPluginListener();
    }

    public synchronized void removeListener(PluginActiveListener pluginActiveListener) {
        this.removeFromPluginLevel(pluginActiveListener);
        this.removeFromSpecificPluginLevel(pluginActiveListener);
        this.removeFromModuleLevel(pluginActiveListener);
        this.removeFromInterfaceLevel(pluginActiveListener);
        this.removeFromModuleInterfaceLevel(pluginActiveListener);
    }

    private void removeFromSpecificPluginLevel(PluginActiveListener pluginActiveListener) {
        for (Map.Entry<String, Set<PluginActiveListener>> entry : this.specificPluginListenerMap.entrySet()) {
            entry.getValue().remove(pluginActiveListener);
        }
    }

    private void removeFromInterfaceLevel(PluginActiveListener pluginActiveListener) {
        for (Map.Entry<String, Set<PluginActiveListener>> entry : this.interfaceListenerMap.entrySet()) {
            entry.getValue().remove(pluginActiveListener);
        }
    }

    private void removeFromModuleInterfaceLevel(PluginActiveListener pluginActiveListener) {
        for (Map.Entry<String, Map<String, Set<PluginActiveListener>>> entry : this.moduleInterfaceListenerMap.entrySet()) {
            Map<String, Set<PluginActiveListener>> map = entry.getValue();
            for (Map.Entry<String, Set<PluginActiveListener>> entry2 : map.entrySet()) {
                entry2.getValue().remove(pluginActiveListener);
            }
        }
    }

    private void removeFromModuleLevel(PluginActiveListener pluginActiveListener) {
        for (Map.Entry<String, Set<PluginActiveListener>> entry : this.moduleListenerMap.entrySet()) {
            entry.getValue().remove(pluginActiveListener);
        }
    }

    private void removeFromPluginLevel(PluginActiveListener pluginActiveListener) {
        this.pluginListenerSet.remove(pluginActiveListener);
    }

    public synchronized void addListener(PluginActiveListener pluginActiveListener) {
        if (pluginActiveListener == null) {
            return;
        }
        this.pluginListenerSet.add(pluginActiveListener);
    }

    public synchronized void addSpecificListener(String string, PluginActiveListener pluginActiveListener) {
        if (pluginActiveListener == null) {
            return;
        }
        Set<PluginActiveListener> set = this.specificPluginListenerMap.get(string);
        if (set == null) {
            set = new HashSet<PluginActiveListener>();
            this.specificPluginListenerMap.put(string, set);
        }
        set.add(pluginActiveListener);
    }

    public synchronized void addInterfaceLevelListener(PluginActiveListener pluginActiveListener, String string) {
        if (pluginActiveListener == null) {
            return;
        }
        Set<PluginActiveListener> set = this.interfaceListenerMap.get(string);
        if (set == null) {
            set = new HashSet<PluginActiveListener>();
            this.interfaceListenerMap.put(string, set);
        }
        set.add(pluginActiveListener);
    }

    public synchronized void addModuleLevelListener(PluginActiveListener pluginActiveListener, String string) {
        if (pluginActiveListener == null) {
            return;
        }
        Set<PluginActiveListener> set = this.moduleListenerMap.get(string);
        if (set == null) {
            set = new HashSet<PluginActiveListener>();
            this.moduleListenerMap.put(string, set);
        }
        set.add(pluginActiveListener);
    }

    public synchronized void addModuleInterfaceLevelListener(PluginActiveListener pluginActiveListener, String string, String[] stringArray) {
        if (pluginActiveListener == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.addModuleInterfaceLevelListener(pluginActiveListener, string, stringArray[i]);
        }
    }

    public synchronized void addModuleInterfaceLevelListener(PluginActiveListener pluginActiveListener, String string, String string2) {
        Set<PluginActiveListener> set;
        if (pluginActiveListener == null) {
            return;
        }
        Map<String, Set<PluginActiveListener>> map = this.moduleInterfaceListenerMap.get(string);
        if (map == null) {
            map = new HashMap<String, Set<PluginActiveListener>>();
            this.moduleInterfaceListenerMap.put(string, map);
        }
        if ((set = map.get(string2)) == null) {
            set = new HashSet<PluginActiveListener>();
            map.put(string2, set);
        }
        set.add(pluginActiveListener);
    }

    public synchronized void firePluginActiveChanged(PluginChangeEvent pluginChangeEvent) {
        List<PluginActiveListener> list = this.collectConcernedSortedListeners(pluginChangeEvent);
        this.firePluginActiveChanged(list, pluginChangeEvent);
    }

    private void firePluginActiveChanged(List<PluginActiveListener> list, PluginChangeEvent pluginChangeEvent) {
        for (PluginActiveListener pluginActiveListener : list) {
            try {
                pluginActiveListener.pluginActiveStateChanged(pluginChangeEvent);
            }
            catch (Throwable throwable) {}
        }
    }

    private List<PluginActiveListener> collectConcernedSortedListeners(PluginChangeEvent pluginChangeEvent) {
        Set<PluginActiveListener> set = this.collectConcernedListeners(pluginChangeEvent);
        LinkedList<PluginActiveListener> linkedList = new LinkedList<PluginActiveListener>(set);
        Collections.sort(linkedList, new Comparator<PluginActiveListener>(){

            @Override
            public int compare(PluginActiveListener pluginActiveListener, PluginActiveListener pluginActiveListener2) {
                return pluginActiveListener2.priority() - pluginActiveListener.priority();
            }
        });
        return linkedList;
    }

    private Set<PluginActiveListener> collectConcernedListeners(PluginChangeEvent pluginChangeEvent) {
        Set<PluginActiveListener> set = this.collectConcernedInterfaceListeners(pluginChangeEvent.getModuleInterfaceMap());
        set.addAll(this.collectionConcernedModuleListeners(pluginChangeEvent.getConcernedModuleTags()));
        set.addAll(this.collectionInterfaceListener(pluginChangeEvent.getConcernedInterfaceTags()));
        set.addAll(this.collectPluginListener());
        set.addAll(this.collectSpecificPluginListener(pluginChangeEvent.getPluginID()));
        return set;
    }

    private Collection<? extends PluginActiveListener> collectSpecificPluginListener(String string) {
        if (string == null) {
            return new HashSet();
        }
        Set<PluginActiveListener> set = this.specificPluginListenerMap.get(string);
        if (set == null) {
            set = new HashSet<PluginActiveListener>();
        }
        return set;
    }

    private Set<PluginActiveListener> collectionInterfaceListener(Set<String> set) {
        HashSet<PluginActiveListener> hashSet = new HashSet<PluginActiveListener>();
        for (String string : set) {
            Set<PluginActiveListener> set2 = this.interfaceListenerMap.get(string);
            if (set2 == null) continue;
            hashSet.addAll(set2);
        }
        return Collections.unmodifiableSet(hashSet);
    }

    private Set<PluginActiveListener> collectPluginListener() {
        return Collections.unmodifiableSet(this.pluginListenerSet);
    }

    private Set<PluginActiveListener> collectionConcernedModuleListeners(Set<String> set) {
        HashSet<PluginActiveListener> hashSet = new HashSet<PluginActiveListener>();
        for (String string : set) {
            Set<PluginActiveListener> set2 = this.moduleListenerMap.get(string);
            if (set2 == null) continue;
            hashSet.addAll(set2);
        }
        return hashSet;
    }

    private Set<PluginActiveListener> collectConcernedInterfaceListeners(Map<String, Set<String>> map) {
        HashSet<PluginActiveListener> hashSet = new HashSet<PluginActiveListener>();
        for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
            String string = entry.getKey();
            Set<String> set = entry.getValue();
            for (String string2 : set) {
                Set<PluginActiveListener> set2 = this.getInterfaceListeners(string, string2);
                if (set2 == null) continue;
                hashSet.addAll(set2);
            }
        }
        return hashSet;
    }

    private Set<PluginActiveListener> getInterfaceListeners(String string, String string2) {
        Map<String, Set<PluginActiveListener>> map = this.moduleInterfaceListenerMap.get(string);
        if (map != null) {
            return map.get(string2);
        }
        return null;
    }
}

