/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.pinyin;

import com.fr.stable.pinyin.ChineseHelper;
import com.fr.stable.pinyin.PinyinChar;
import com.fr.stable.pinyin.PinyinFormat;
import com.fr.stable.pinyin.PinyinResource;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Properties;

public class PinyinHelper {
    private static final Properties PINYIN_TABLE = PinyinResource.getPinyinTable();
    private static final Properties MUTIL_PINYIN_TABLE = PinyinResource.getMultiPinyinTable();
    private static final String PINYIN_SEPARATOR = ",";
    private static final int TONE_SUM = 4;
    private static final int VOWEL_UPPER_INDEX = 477;
    private static final String ALL_UNMARKED_VOWEL = "aeiouv";
    private static final String ALL_MARKED_VOWEL = "\u0101\u00e1\u01ce\u00e0\u0113\u00e9\u011b\u00e8\u012b\u00ed\u01d0\u00ec\u014d\u00f3\u01d2\u00f2\u016b\u00fa\u01d4\u00f9\u01d6\u01d8\u01da\u01dc";
    private static final String[] NULL = null;
    private static PinyinChar[] vowelsMap = new PinyinChar[477];

    private static String[] convertWithToneNumber(String string) {
        String[] stringArray = string.split(PINYIN_SEPARATOR);
        for (int i = stringArray.length - 1; i >= 0; --i) {
            boolean bl = false;
            String string2 = stringArray[i].replaceAll("\u00fc", "v");
            for (int j = string2.length() - 1; j >= 0; --j) {
                char c = string2.charAt(j);
                if (c >= 'a' && c <= 'z') continue;
                int n = ALL_MARKED_VOWEL.indexOf(c);
                int n2 = n % 4 + 1;
                char c2 = ALL_UNMARKED_VOWEL.charAt((n - n % 4) / 4);
                stringArray[i] = string2.replaceAll(String.valueOf(c), String.valueOf(c2)) + n2;
                bl = true;
                break;
            }
            if (bl) continue;
            stringArray[i] = string2 + "5";
        }
        return stringArray;
    }

    private static String[] convertWithoutTone(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            if (c >= '\u01dd' || vowelsMap[c] == null) continue;
            cArray[i] = vowelsMap[c].charValue();
        }
        String[] stringArray = new String(cArray).split(PINYIN_SEPARATOR);
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        Collections.addAll(linkedHashSet, stringArray);
        return linkedHashSet.toArray(new String[linkedHashSet.size()]);
    }

    private static String[] formatPinyin(String string, PinyinFormat pinyinFormat) {
        if (pinyinFormat == PinyinFormat.WITH_TONE_MARK) {
            return string.split(PINYIN_SEPARATOR);
        }
        if (pinyinFormat == PinyinFormat.WITH_TONE_NUMBER) {
            return PinyinHelper.convertWithToneNumber(string);
        }
        if (pinyinFormat == PinyinFormat.WITHOUT_TONE) {
            return PinyinHelper.convertWithoutTone(string);
        }
        return NULL;
    }

    public static String[] convertToPinyinArray(char c, PinyinFormat pinyinFormat) {
        String string = PINYIN_TABLE.getProperty(String.valueOf(c));
        if (string != null && !string.equals("null")) {
            return PinyinHelper.formatPinyin(string, pinyinFormat);
        }
        return NULL;
    }

    public static String[] convertToPinyinArray(char c) {
        return PinyinHelper.convertToPinyinArray(c, PinyinFormat.WITH_TONE_MARK);
    }

    public static String convertToPinyinString(String string, String string2, PinyinFormat pinyinFormat) {
        string = ChineseHelper.convertToSimplifiedChinese(string);
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (ChineseHelper.isChinese(c)) {
                int n2;
                boolean bl = false;
                int n3 = 3;
                int n4 = n2 = i + n3 < n ? i + n3 : n - 1;
                while (n2 > i) {
                    String string3 = string.substring(i, n2 + 1);
                    if (MUTIL_PINYIN_TABLE.containsKey(string3)) {
                        String[] stringArray = PinyinHelper.formatPinyin(MUTIL_PINYIN_TABLE.getProperty(string3), pinyinFormat);
                        int n5 = stringArray.length;
                        for (int j = 0; j < n5; ++j) {
                            stringBuilder.append(stringArray[j]);
                            if (j >= n5 - 1) continue;
                            stringBuilder.append(string2);
                        }
                        i = n2;
                        bl = true;
                        break;
                    }
                    --n2;
                }
                if (!bl) {
                    String[] stringArray = PinyinHelper.convertToPinyinArray(string.charAt(i), pinyinFormat);
                    if (stringArray != null) {
                        stringBuilder.append(stringArray[0]);
                    } else {
                        stringBuilder.append(string.charAt(i));
                    }
                }
                if (i >= n - 1) continue;
                stringBuilder.append(string2);
                continue;
            }
            stringBuilder.append(c);
            if (i + 1 >= n || !ChineseHelper.isChinese(string.charAt(i + 1))) continue;
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    public static String convertToPinyinString(String string, String string2) {
        return PinyinHelper.convertToPinyinString(string, string2, PinyinFormat.WITH_TONE_MARK);
    }

    public static boolean hasMultiPinyin(char c) {
        String[] stringArray = PinyinHelper.convertToPinyinArray(c);
        return stringArray != null && stringArray.length > 1;
    }

    public static String getShortPinyin(String string) {
        String string2 = "#";
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = new char[string.length()];
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            String[] stringArray;
            char c = string.charAt(i);
            if (!ChineseHelper.isChinese(c)) {
                cArray[i] = c;
                continue;
            }
            stringBuilder.append(c);
            for (int j = i + 1; j < n && ChineseHelper.isChinese(string.charAt(j)); ++j) {
                stringBuilder.append(string.charAt(j));
            }
            String string3 = PinyinHelper.convertToPinyinString(stringBuilder.toString(), string2, PinyinFormat.WITHOUT_TONE);
            for (String string4 : stringArray = string3.split(string2)) {
                cArray[i] = string4.charAt(0);
                ++i;
            }
            --i;
            stringBuilder.delete(0, stringBuilder.toString().length());
            stringBuilder.trimToSize();
        }
        return String.valueOf(cArray);
    }

    public static boolean isChinese(char c) {
        return ChineseHelper.isChinese(c);
    }

    public static Object parseCNToPinyin(String string) {
        if (ChineseHelper.containChinese(string)) {
            return PinyinHelper.convertToPinyinString(string, "", PinyinFormat.WITHOUT_TONE);
        }
        return string;
    }

    static {
        char[] cArray = ALL_MARKED_VOWEL.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            PinyinHelper.vowelsMap[cArray[i]] = new PinyinChar(ALL_UNMARKED_VOWEL.charAt((i - i % 4) / 4));
            PinyinHelper.vowelsMap[252] = new PinyinChar('v');
        }
    }
}

