/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.encoder;

import com.fr.stable.encoder.GifEncoderHashitem;
import com.fr.stable.encoder.ImageEncoder;
import com.fr.stable.encoder.IntHashtable;
import java.awt.Image;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.io.OutputStream;

public class GIFEncoder
extends ImageEncoder {
    private boolean interlace = false;
    int width;
    int height;
    int[][] rgbPixels;
    IntHashtable colorHash;
    int Width;
    int Height;
    boolean Interlace;
    int curx;
    int cury;
    int CountDown;
    int Pass = 0;
    static final int EOF = -1;
    static final int BITS = 12;
    static final int HSIZE = 5003;
    int n_bits;
    int maxbits = 12;
    int maxcode;
    int maxmaxcode = 4096;
    int[] htab = new int[5003];
    int[] codetab = new int[5003];
    int hsize = 5003;
    int free_ent = 0;
    boolean clear_flg = false;
    int g_init_bits;
    int ClearCode;
    int EOFCode;
    int cur_accum = 0;
    int cur_bits = 0;
    int[] masks = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535};
    int a_count;
    byte[] accum = new byte[256];

    public GIFEncoder(Image image, OutputStream outputStream) throws IOException {
        super(image, outputStream);
    }

    public GIFEncoder(Image image, OutputStream outputStream, boolean bl) throws IOException {
        super(image, outputStream);
        this.interlace = bl;
    }

    public GIFEncoder(ImageProducer imageProducer, OutputStream outputStream) throws IOException {
        super(imageProducer, outputStream);
    }

    public GIFEncoder(ImageProducer imageProducer, OutputStream outputStream, boolean bl) throws IOException {
        super(imageProducer, outputStream);
        this.interlace = bl;
    }

    void encodeStart(int n, int n2) throws IOException {
        this.width = n;
        this.height = n2;
        this.rgbPixels = new int[n2][n];
    }

    void encodePixels(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) throws IOException {
        for (int i = 0; i < n4; ++i) {
            System.arraycopy(nArray, i * n6 + n5, this.rgbPixels[n2 + i], n, n3);
        }
    }

    void encodeDone() throws IOException {
        Object object;
        int n;
        int n2;
        int n3 = -1;
        int n4 = -1;
        this.colorHash = new IntHashtable();
        int n5 = 0;
        for (n2 = 0; n2 < this.height; ++n2) {
            n = n2 * this.width;
            for (int i = 0; i < this.width; ++i) {
                boolean bl;
                int n6 = this.rgbPixels[n2][i];
                boolean bl2 = bl = n6 >>> 24 < 128;
                if (bl) {
                    if (n3 < 0) {
                        n3 = n5;
                        n4 = n6;
                    } else if (n6 != n4) {
                        this.rgbPixels[n2][i] = n6 = n4;
                    }
                }
                if ((object = (GifEncoderHashitem)this.colorHash.get(n6)) == null) {
                    if (n5 >= 256) {
                        throw new IOException("too many colors for a GIF");
                    }
                    object = new GifEncoderHashitem(n6, 1, n5, bl);
                    ++n5;
                    this.colorHash.put(n6, object);
                    continue;
                }
                ++((GifEncoderHashitem)object).count;
            }
        }
        n2 = n5 <= 2 ? 1 : (n5 <= 4 ? 2 : (n5 <= 16 ? 4 : 8));
        n = 1 << n2;
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n];
        object = this.colorHash.elements();
        while (object.hasMoreElements()) {
            GifEncoderHashitem gifEncoderHashitem = (GifEncoderHashitem)object.nextElement();
            byArray[gifEncoderHashitem.index] = (byte)(gifEncoderHashitem.rgb >> 16 & 0xFF);
            byArray2[gifEncoderHashitem.index] = (byte)(gifEncoderHashitem.rgb >> 8 & 0xFF);
            byArray3[gifEncoderHashitem.index] = (byte)(gifEncoderHashitem.rgb & 0xFF);
        }
        this.GIFEncode(this.out, this.width, this.height, this.interlace, (byte)0, n3, n2, byArray, byArray2, byArray3);
    }

    byte GetPixel(int n, int n2) throws IOException {
        GifEncoderHashitem gifEncoderHashitem = (GifEncoderHashitem)this.colorHash.get(this.rgbPixels[n2][n]);
        if (gifEncoderHashitem == null) {
            throw new IOException("color not found");
        }
        return (byte)gifEncoderHashitem.index;
    }

    static void writeString(OutputStream outputStream, String string) throws IOException {
        byte[] byArray = string.getBytes();
        outputStream.write(byArray);
    }

    void GIFEncode(OutputStream outputStream, int n, int n2, boolean bl, byte by, int n3, int n4, byte[] byArray, byte[] byArray2, byte[] byArray3) throws IOException {
        this.Width = n;
        this.Height = n2;
        this.Interlace = bl;
        int n5 = 1 << n4;
        int n6 = 0;
        int n7 = 0;
        this.CountDown = n * n2;
        this.Pass = 0;
        int n8 = n4 <= 1 ? 2 : n4;
        this.curx = 0;
        this.cury = 0;
        GIFEncoder.writeString(outputStream, "GIF89a");
        this.Putword(n, outputStream);
        this.Putword(n2, outputStream);
        byte by2 = -128;
        by2 = (byte)(by2 | 0x70);
        by2 = (byte)(by2 | (byte)(n4 - 1));
        this.Putbyte(by2, outputStream);
        this.Putbyte(by, outputStream);
        this.Putbyte((byte)0, outputStream);
        for (int i = 0; i < n5; ++i) {
            this.Putbyte(byArray[i], outputStream);
            this.Putbyte(byArray2[i], outputStream);
            this.Putbyte(byArray3[i], outputStream);
        }
        if (n3 != -1) {
            this.Putbyte((byte)33, outputStream);
            this.Putbyte((byte)-7, outputStream);
            this.Putbyte((byte)4, outputStream);
            this.Putbyte((byte)1, outputStream);
            this.Putbyte((byte)0, outputStream);
            this.Putbyte((byte)0, outputStream);
            this.Putbyte((byte)n3, outputStream);
            this.Putbyte((byte)0, outputStream);
        }
        this.Putbyte((byte)44, outputStream);
        this.Putword(n7, outputStream);
        this.Putword(n6, outputStream);
        this.Putword(n, outputStream);
        this.Putword(n2, outputStream);
        if (bl) {
            this.Putbyte((byte)64, outputStream);
        } else {
            this.Putbyte((byte)0, outputStream);
        }
        this.Putbyte((byte)n8, outputStream);
        this.compress(n8 + 1, outputStream);
        this.Putbyte((byte)0, outputStream);
        this.Putbyte((byte)59, outputStream);
    }

    void BumpPixel() {
        ++this.curx;
        if (this.curx == this.Width) {
            this.curx = 0;
            if (!this.Interlace) {
                ++this.cury;
            } else {
                switch (this.Pass) {
                    case 0: {
                        this.cury += 8;
                        if (this.cury < this.Height) break;
                        ++this.Pass;
                        this.cury = 4;
                        break;
                    }
                    case 1: {
                        this.cury += 8;
                        if (this.cury < this.Height) break;
                        ++this.Pass;
                        this.cury = 2;
                        break;
                    }
                    case 2: {
                        this.cury += 4;
                        if (this.cury < this.Height) break;
                        ++this.Pass;
                        this.cury = 1;
                        break;
                    }
                    case 3: {
                        this.cury += 2;
                    }
                }
            }
        }
    }

    int GIFNextPixel() throws IOException {
        if (this.CountDown == 0) {
            return -1;
        }
        --this.CountDown;
        byte by = this.GetPixel(this.curx, this.cury);
        this.BumpPixel();
        return by & 0xFF;
    }

    void Putword(int n, OutputStream outputStream) throws IOException {
        this.Putbyte((byte)(n & 0xFF), outputStream);
        this.Putbyte((byte)(n >> 8 & 0xFF), outputStream);
    }

    void Putbyte(byte by, OutputStream outputStream) throws IOException {
        outputStream.write(by);
    }

    final int MAXCODE(int n) {
        return (1 << n) - 1;
    }

    void compress(int n, OutputStream outputStream) throws IOException {
        int n2;
        int n3;
        this.g_init_bits = n;
        this.clear_flg = false;
        this.n_bits = this.g_init_bits;
        this.maxcode = this.MAXCODE(this.n_bits);
        this.ClearCode = 1 << n - 1;
        this.EOFCode = this.ClearCode + 1;
        this.free_ent = this.ClearCode + 2;
        this.char_init();
        int n4 = this.GIFNextPixel();
        int n5 = 0;
        for (n3 = this.hsize; n3 < 65536; n3 *= 2) {
            ++n5;
        }
        n5 = 8 - n5;
        int n6 = this.hsize;
        this.cl_hash(n6);
        this.output(this.ClearCode, outputStream);
        block1: while ((n2 = this.GIFNextPixel()) != -1) {
            int n7 = n2 << n5 ^ n4;
            n3 = (n2 << this.maxbits) + n4;
            if (this.htab[n7] == n3) {
                n4 = this.codetab[n7];
                continue;
            }
            if (this.htab[n7] >= 0) {
                int n8 = n6 - n7;
                if (n7 == 0) {
                    n8 = 1;
                }
                do {
                    if ((n7 -= n8) < 0) {
                        n7 += n6;
                    }
                    if (this.htab[n7] != n3) continue;
                    n4 = this.codetab[n7];
                    continue block1;
                } while (this.htab[n7] >= 0);
            }
            this.output(n4, outputStream);
            n4 = n2;
            if (this.free_ent < this.maxmaxcode) {
                ++this.free_ent;
                this.htab[n7] = n3;
                continue;
            }
            this.cl_block(outputStream);
        }
        this.output(n4, outputStream);
        this.output(this.EOFCode, outputStream);
    }

    void output(int n, OutputStream outputStream) throws IOException {
        this.cur_accum &= this.masks[this.cur_bits];
        this.cur_accum = this.cur_bits > 0 ? (this.cur_accum |= n << this.cur_bits) : n;
        this.cur_bits += this.n_bits;
        while (this.cur_bits >= 8) {
            this.char_out((byte)(this.cur_accum & 0xFF), outputStream);
            this.cur_accum >>= 8;
            this.cur_bits -= 8;
        }
        if (this.free_ent > this.maxcode || this.clear_flg) {
            if (this.clear_flg) {
                this.n_bits = this.g_init_bits;
                this.maxcode = this.MAXCODE(this.n_bits);
                this.clear_flg = false;
            } else {
                ++this.n_bits;
                this.maxcode = this.n_bits == this.maxbits ? this.maxmaxcode : this.MAXCODE(this.n_bits);
            }
        }
        if (n == this.EOFCode) {
            while (this.cur_bits > 0) {
                this.char_out((byte)(this.cur_accum & 0xFF), outputStream);
                this.cur_accum >>= 8;
                this.cur_bits -= 8;
            }
            this.flush_char(outputStream);
        }
    }

    void cl_block(OutputStream outputStream) throws IOException {
        this.cl_hash(this.hsize);
        this.free_ent = this.ClearCode + 2;
        this.clear_flg = true;
        this.output(this.ClearCode, outputStream);
    }

    void cl_hash(int n) {
        for (int i = 0; i < n; ++i) {
            this.htab[i] = -1;
        }
    }

    void char_init() {
        this.a_count = 0;
    }

    void char_out(byte by, OutputStream outputStream) throws IOException {
        this.accum[this.a_count++] = by;
        if (this.a_count >= 254) {
            this.flush_char(outputStream);
        }
    }

    void flush_char(OutputStream outputStream) throws IOException {
        if (this.a_count > 0) {
            outputStream.write(this.a_count);
            outputStream.write(this.accum, 0, this.a_count);
            this.a_count = 0;
        }
    }
}

