/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.collections.utils;

import java.util.Arrays;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TimSort<T> {
    private static final int MIN_MERGE = 32;
    private T[] a;
    private Comparator<? super T> c;
    private static final int MIN_GALLOP = 7;
    private int minGallop = 7;
    private static final int INITIAL_TMP_STORAGE_LENGTH = 256;
    private T[] tmp;
    private int tmpCount;
    private int stackSize = 0;
    private final int[] runBase;
    private final int[] runLen;
    private static final boolean DEBUG = false;

    TimSort() {
        this.tmp = new Object[256];
        this.runBase = new int[40];
        this.runLen = new int[40];
    }

    public void doSort(T[] TArray, Comparator<T> comparator, int n, int n2) {
        int n3;
        int n4;
        this.stackSize = 0;
        TimSort.rangeCheck(TArray.length, n, n2);
        int n5 = n2 - n;
        if (n5 < 2) {
            return;
        }
        if (n5 < 32) {
            int n6 = TimSort.countRunAndMakeAscending(TArray, n, n2, comparator);
            TimSort.binarySort(TArray, n, n2, n + n6, comparator);
            return;
        }
        this.a = TArray;
        this.c = comparator;
        this.tmpCount = 0;
        int n7 = TimSort.minRunLength(n5);
        do {
            if ((n4 = TimSort.countRunAndMakeAscending(TArray, n, n2, comparator)) < n7) {
                n3 = n5 <= n7 ? n5 : n7;
                TimSort.binarySort(TArray, n, n + n3, n + n4, comparator);
                n4 = n3;
            }
            this.pushRun(n, n4);
            this.mergeCollapse();
            n += n4;
        } while ((n5 -= n4) != 0);
        this.mergeForceCollapse();
        this.a = null;
        this.c = null;
        T[] TArray2 = this.tmp;
        int n8 = this.tmpCount;
        for (n3 = 0; n3 < n8; ++n3) {
            TArray2[n3] = null;
        }
    }

    private TimSort(T[] TArray, Comparator<? super T> comparator) {
        this.a = TArray;
        this.c = comparator;
        int n = TArray.length;
        Object[] objectArray = new Object[n < 512 ? n >>> 1 : 256];
        this.tmp = objectArray;
        int n2 = n < 120 ? 5 : (n < 1542 ? 10 : (n < 119151 ? 19 : 40));
        this.runBase = new int[n2];
        this.runLen = new int[n2];
    }

    static <T> void sort(T[] TArray, Comparator<? super T> comparator) {
        TimSort.sort(TArray, 0, TArray.length, comparator);
    }

    static <T> void sort(T[] TArray, int n, int n2, Comparator<? super T> comparator) {
        int n3;
        if (comparator == null) {
            Arrays.sort(TArray, n, n2);
            return;
        }
        TimSort.rangeCheck(TArray.length, n, n2);
        int n4 = n2 - n;
        if (n4 < 2) {
            return;
        }
        if (n4 < 32) {
            int n5 = TimSort.countRunAndMakeAscending(TArray, n, n2, comparator);
            TimSort.binarySort(TArray, n, n2, n + n5, comparator);
            return;
        }
        TimSort<? super T> timSort = new TimSort<T>(TArray, comparator);
        int n6 = TimSort.minRunLength(n4);
        do {
            if ((n3 = TimSort.countRunAndMakeAscending(TArray, n, n2, comparator)) < n6) {
                int n7 = n4 <= n6 ? n4 : n6;
                TimSort.binarySort(TArray, n, n + n7, n + n3, comparator);
                n3 = n7;
            }
            super.pushRun(n, n3);
            super.mergeCollapse();
            n += n3;
        } while ((n4 -= n3) != 0);
        super.mergeForceCollapse();
    }

    private static <T> void binarySort(T[] TArray, int n, int n2, int n3, Comparator<? super T> comparator) {
        if (n3 == n) {
            ++n3;
        }
        while (n3 < n2) {
            int n4;
            T t = TArray[n3];
            int n5 = n;
            int n6 = n3;
            while (n5 < n6) {
                n4 = n5 + n6 >>> 1;
                if (comparator.compare(t, TArray[n4]) < 0) {
                    n6 = n4;
                    continue;
                }
                n5 = n4 + 1;
            }
            n4 = n3 - n5;
            switch (n4) {
                case 2: {
                    TArray[n5 + 2] = TArray[n5 + 1];
                }
                case 1: {
                    TArray[n5 + 1] = TArray[n5];
                    break;
                }
                default: {
                    System.arraycopy(TArray, n5, TArray, n5 + 1, n4);
                }
            }
            TArray[n5] = t;
            ++n3;
        }
    }

    private static <T> int countRunAndMakeAscending(T[] TArray, int n, int n2, Comparator<? super T> comparator) {
        int n3 = n + 1;
        if (n3 == n2) {
            return 1;
        }
        if (comparator.compare(TArray[n3++], TArray[n]) < 0) {
            while (n3 < n2 && comparator.compare(TArray[n3], TArray[n3 - 1]) < 0) {
                ++n3;
            }
            TimSort.reverseRange(TArray, n, n3);
        } else {
            while (n3 < n2 && comparator.compare(TArray[n3], TArray[n3 - 1]) >= 0) {
                ++n3;
            }
        }
        return n3 - n;
    }

    private static void reverseRange(Object[] objectArray, int n, int n2) {
        --n2;
        while (n < n2) {
            Object object = objectArray[n];
            objectArray[n++] = objectArray[n2];
            objectArray[n2--] = object;
        }
    }

    private static int minRunLength(int n) {
        int n2 = 0;
        while (n >= 32) {
            n2 |= n & 1;
            n >>= 1;
        }
        return n + n2;
    }

    private void pushRun(int n, int n2) {
        this.runBase[this.stackSize] = n;
        this.runLen[this.stackSize] = n2;
        ++this.stackSize;
    }

    private void mergeCollapse() {
        while (this.stackSize > 1) {
            int n = this.stackSize - 2;
            if (n >= 1 && this.runLen[n - 1] <= this.runLen[n] + this.runLen[n + 1] || n >= 2 && this.runLen[n - 2] <= this.runLen[n] + this.runLen[n - 1]) {
                if (this.runLen[n - 1] < this.runLen[n + 1]) {
                    --n;
                }
            } else if (this.runLen[n] > this.runLen[n + 1]) break;
            this.mergeAt(n);
        }
    }

    private void mergeForceCollapse() {
        while (this.stackSize > 1) {
            int n = this.stackSize - 2;
            if (n > 0 && this.runLen[n - 1] < this.runLen[n + 1]) {
                --n;
            }
            this.mergeAt(n);
        }
    }

    private void mergeAt(int n) {
        int n2 = this.runBase[n];
        int n3 = this.runLen[n];
        int n4 = this.runBase[n + 1];
        int n5 = this.runLen[n + 1];
        this.runLen[n] = n3 + n5;
        if (n == this.stackSize - 3) {
            this.runBase[n + 1] = this.runBase[n + 2];
            this.runLen[n + 1] = this.runLen[n + 2];
        }
        --this.stackSize;
        int n6 = TimSort.gallopRight(this.a[n4], this.a, n2, n3, 0, this.c);
        n2 += n6;
        if ((n3 -= n6) == 0) {
            return;
        }
        if ((n5 = TimSort.gallopLeft(this.a[n2 + n3 - 1], this.a, n4, n5, n5 - 1, this.c)) == 0) {
            return;
        }
        if (n3 <= n5) {
            this.mergeLo(n2, n3, n4, n5);
        } else {
            this.mergeHi(n2, n3, n4, n5);
        }
    }

    private static <T> int gallopLeft(T t, T[] TArray, int n, int n2, int n3, Comparator<? super T> comparator) {
        int n4;
        int n5 = 0;
        int n6 = 1;
        if (comparator.compare(t, TArray[n + n3]) > 0) {
            n4 = n2 - n3;
            while (n6 < n4 && comparator.compare(t, TArray[n + n3 + n6]) > 0) {
                n5 = n6;
                if ((n6 = (n6 << 1) + 1) > 0) continue;
                n6 = n4;
            }
            if (n6 > n4) {
                n6 = n4;
            }
            n5 += n3;
            n6 += n3;
        } else {
            n4 = n3 + 1;
            while (n6 < n4 && comparator.compare(t, TArray[n + n3 - n6]) <= 0) {
                n5 = n6;
                if ((n6 = (n6 << 1) + 1) > 0) continue;
                n6 = n4;
            }
            if (n6 > n4) {
                n6 = n4;
            }
            int n7 = n5;
            n5 = n3 - n6;
            n6 = n3 - n7;
        }
        ++n5;
        while (n5 < n6) {
            n4 = n5 + (n6 - n5 >>> 1);
            if (comparator.compare(t, TArray[n + n4]) > 0) {
                n5 = n4 + 1;
                continue;
            }
            n6 = n4;
        }
        return n6;
    }

    private static <T> int gallopRight(T t, T[] TArray, int n, int n2, int n3, Comparator<? super T> comparator) {
        int n4;
        int n5 = 1;
        int n6 = 0;
        if (comparator.compare(t, TArray[n + n3]) < 0) {
            n4 = n3 + 1;
            while (n5 < n4 && comparator.compare(t, TArray[n + n3 - n5]) < 0) {
                n6 = n5;
                if ((n5 = (n5 << 1) + 1) > 0) continue;
                n5 = n4;
            }
            if (n5 > n4) {
                n5 = n4;
            }
            int n7 = n6;
            n6 = n3 - n5;
            n5 = n3 - n7;
        } else {
            n4 = n2 - n3;
            while (n5 < n4 && comparator.compare(t, TArray[n + n3 + n5]) >= 0) {
                n6 = n5;
                if ((n5 = (n5 << 1) + 1) > 0) continue;
                n5 = n4;
            }
            if (n5 > n4) {
                n5 = n4;
            }
            n6 += n3;
            n5 += n3;
        }
        ++n6;
        while (n6 < n5) {
            n4 = n6 + (n5 - n6 >>> 1);
            if (comparator.compare(t, TArray[n + n4]) < 0) {
                n5 = n4;
                continue;
            }
            n6 = n4 + 1;
        }
        return n5;
    }

    private void mergeLo(int n, int n2, int n3, int n4) {
        T[] TArray = this.a;
        T[] TArray2 = this.ensureCapacity(n2);
        System.arraycopy(TArray, n, TArray2, 0, n2);
        int n5 = 0;
        int n6 = n3;
        int n7 = n;
        TArray[n7++] = TArray[n6++];
        if (--n4 == 0) {
            System.arraycopy(TArray2, n5, TArray, n7, n2);
            return;
        }
        if (n2 == 1) {
            System.arraycopy(TArray, n6, TArray, n7, n4);
            TArray[n7 + n4] = TArray2[n5];
            return;
        }
        Comparator<T> comparator = this.c;
        int n8 = this.minGallop;
        block0: while (true) {
            int n9 = 0;
            int n10 = 0;
            do {
                if (comparator.compare(TArray[n6], TArray2[n5]) < 0) {
                    TArray[n7++] = TArray[n6++];
                    ++n10;
                    n9 = 0;
                    if (--n4 != 0) continue;
                    break block0;
                }
                TArray[n7++] = TArray2[n5++];
                ++n9;
                n10 = 0;
                if (--n2 == 1) break block0;
            } while ((n9 | n10) < n8);
            do {
                if ((n9 = TimSort.gallopRight(TArray[n6], TArray2, n5, n2, 0, comparator)) != 0) {
                    System.arraycopy(TArray2, n5, TArray, n7, n9);
                    n7 += n9;
                    n5 += n9;
                    if ((n2 -= n9) <= 1) break block0;
                }
                TArray[n7++] = TArray[n6++];
                if (--n4 == 0) break block0;
                n10 = TimSort.gallopLeft(TArray2[n5], TArray, n6, n4, 0, comparator);
                if (n10 != 0) {
                    System.arraycopy(TArray, n6, TArray, n7, n10);
                    n7 += n10;
                    n6 += n10;
                    if ((n4 -= n10) == 0) break block0;
                }
                TArray[n7++] = TArray2[n5++];
                if (--n2 == 1) break block0;
                --n8;
            } while (n9 >= 7 | n10 >= 7);
            if (n8 < 0) {
                n8 = 0;
            }
            n8 += 2;
        }
        int n11 = this.minGallop = n8 < 1 ? 1 : n8;
        if (n2 == 1) {
            System.arraycopy(TArray, n6, TArray, n7, n4);
            TArray[n7 + n4] = TArray2[n5];
        } else {
            if (n2 == 0) {
                throw new IllegalArgumentException("Comparison method violates its general contract!");
            }
            System.arraycopy(TArray2, n5, TArray, n7, n2);
        }
    }

    private void mergeHi(int n, int n2, int n3, int n4) {
        T[] TArray = this.a;
        T[] TArray2 = this.ensureCapacity(n4);
        System.arraycopy(TArray, n3, TArray2, 0, n4);
        int n5 = n + n2 - 1;
        int n6 = n4 - 1;
        int n7 = n3 + n4 - 1;
        TArray[n7--] = TArray[n5--];
        if (--n2 == 0) {
            System.arraycopy(TArray2, 0, TArray, n7 - (n4 - 1), n4);
            return;
        }
        if (n4 == 1) {
            System.arraycopy(TArray, (n5 -= n2) + 1, TArray, (n7 -= n2) + 1, n2);
            TArray[n7] = TArray2[n6];
            return;
        }
        Comparator<T> comparator = this.c;
        int n8 = this.minGallop;
        block0: while (true) {
            int n9 = 0;
            int n10 = 0;
            do {
                if (comparator.compare(TArray2[n6], TArray[n5]) < 0) {
                    TArray[n7--] = TArray[n5--];
                    ++n9;
                    n10 = 0;
                    if (--n2 != 0) continue;
                    break block0;
                }
                TArray[n7--] = TArray2[n6--];
                ++n10;
                n9 = 0;
                if (--n4 == 1) break block0;
            } while ((n9 | n10) < n8);
            do {
                if ((n9 = n2 - TimSort.gallopRight(TArray2[n6], TArray, n, n2, n2 - 1, comparator)) != 0) {
                    System.arraycopy(TArray, (n5 -= n9) + 1, TArray, (n7 -= n9) + 1, n9);
                    if ((n2 -= n9) == 0) break block0;
                }
                TArray[n7--] = TArray2[n6--];
                if (--n4 == 1) break block0;
                n10 = n4 - TimSort.gallopLeft(TArray[n5], TArray2, 0, n4, n4 - 1, comparator);
                if (n10 != 0) {
                    System.arraycopy(TArray2, (n6 -= n10) + 1, TArray, (n7 -= n10) + 1, n10);
                    if ((n4 -= n10) <= 1) break block0;
                }
                TArray[n7--] = TArray[n5--];
                if (--n2 == 0) break block0;
                --n8;
            } while (n9 >= 7 | n10 >= 7);
            if (n8 < 0) {
                n8 = 0;
            }
            n8 += 2;
        }
        int n11 = this.minGallop = n8 < 1 ? 1 : n8;
        if (n4 == 1) {
            System.arraycopy(TArray, (n5 -= n2) + 1, TArray, (n7 -= n2) + 1, n2);
            TArray[n7] = TArray2[n6];
        } else {
            if (n4 == 0) {
                throw new IllegalArgumentException("Comparison method violates its general contract!");
            }
            System.arraycopy(TArray2, 0, TArray, n7 - (n4 - 1), n4);
        }
    }

    private T[] ensureCapacity(int n) {
        this.tmpCount = Math.max(this.tmpCount, n);
        if (this.tmp.length < n) {
            int n2 = n;
            n2 |= n2 >> 1;
            n2 |= n2 >> 2;
            n2 |= n2 >> 4;
            n2 |= n2 >> 8;
            n2 |= n2 >> 16;
            n2 = ++n2 < 0 ? n : Math.min(n2, this.a.length >>> 1);
            Object[] objectArray = new Object[n2];
            this.tmp = objectArray;
        }
        return this.tmp;
    }

    private static void rangeCheck(int n, int n2, int n3) {
        if (n2 > n3) {
            throw new IllegalArgumentException("fromIndex(" + n2 + ") > toIndex(" + n3 + ")");
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        if (n3 > n) {
            throw new ArrayIndexOutOfBoundsException(n3);
        }
    }
}

