/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.collections.map;

import com.fr.stable.collections.array.Array;
import com.fr.stable.collections.array.LongArray;
import com.fr.stable.collections.utils.GdxRuntimeException;
import com.fr.stable.collections.utils.MathUtils;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongMap<V>
implements Iterable<Entry<V>> {
    private static final int PRIME1 = -1105259343;
    private static final int PRIME2 = -1262997959;
    private static final int PRIME3 = -825114047;
    private static final int EMPTY = 0;
    public int size;
    long[] keyTable;
    V[] valueTable;
    int capacity;
    int stashSize;
    V zeroValue;
    boolean hasZeroValue;
    private float loadFactor;
    private int hashShift;
    private int mask;
    private int threshold;
    private int stashCapacity;
    private int pushIterations;
    private Entries entries1;
    private Entries entries2;
    private Values values1;
    private Values values2;
    private Keys keys1;
    private Keys keys2;

    public LongMap() {
        this(51, 0.8f);
    }

    public LongMap(int n) {
        this(n, 0.8f);
    }

    public LongMap(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("initialCapacity must be >= 0: " + n);
        }
        if ((n = MathUtils.nextPowerOfTwo((int)Math.ceil((float)n / f))) > 0x40000000) {
            throw new IllegalArgumentException("initialCapacity is too large: " + n);
        }
        this.capacity = n;
        if (f <= 0.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0: " + f);
        }
        this.loadFactor = f;
        this.threshold = (int)((float)this.capacity * f);
        this.mask = this.capacity - 1;
        this.hashShift = 63 - Long.numberOfTrailingZeros(this.capacity);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(this.capacity)) * 2);
        this.pushIterations = Math.max(Math.min(this.capacity, 8), (int)Math.sqrt(this.capacity) / 8);
        this.keyTable = new long[this.capacity + this.stashCapacity];
        this.valueTable = new Object[this.keyTable.length];
    }

    public LongMap(LongMap<? extends V> longMap) {
        this((int)Math.floor((float)longMap.capacity * longMap.loadFactor), longMap.loadFactor);
        this.stashSize = longMap.stashSize;
        System.arraycopy(longMap.keyTable, 0, this.keyTable, 0, longMap.keyTable.length);
        System.arraycopy(longMap.valueTable, 0, this.valueTable, 0, longMap.valueTable.length);
        this.size = longMap.size;
        this.zeroValue = longMap.zeroValue;
        this.hasZeroValue = longMap.hasZeroValue;
    }

    public V put(long l, V v2) {
        int n;
        if (l == 0L) {
            V v3 = this.zeroValue;
            this.zeroValue = v2;
            if (!this.hasZeroValue) {
                this.hasZeroValue = true;
                ++this.size;
            }
            return v3;
        }
        long[] lArray = this.keyTable;
        int n2 = (int)(l & (long)this.mask);
        long l2 = lArray[n2];
        if (l2 == l) {
            V v4 = this.valueTable[n2];
            this.valueTable[n2] = v2;
            return v4;
        }
        int n3 = this.hash2(l);
        long l3 = lArray[n3];
        if (l3 == l) {
            V v5 = this.valueTable[n3];
            this.valueTable[n3] = v2;
            return v5;
        }
        int n4 = this.hash3(l);
        long l4 = lArray[n4];
        if (l4 == l) {
            V v6 = this.valueTable[n4];
            this.valueTable[n4] = v2;
            return v6;
        }
        int n5 = n + this.stashSize;
        for (n = this.capacity; n < n5; ++n) {
            if (lArray[n] != l) continue;
            V v7 = this.valueTable[n];
            this.valueTable[n] = v2;
            return v7;
        }
        if (l2 == 0L) {
            lArray[n2] = l;
            this.valueTable[n2] = v2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return null;
        }
        if (l3 == 0L) {
            lArray[n3] = l;
            this.valueTable[n3] = v2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return null;
        }
        if (l4 == 0L) {
            lArray[n4] = l;
            this.valueTable[n4] = v2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return null;
        }
        this.push(l, v2, n2, l2, n3, l3, n4, l4);
        return null;
    }

    public void putAll(LongMap<V> longMap) {
        for (Entry<V> entry : longMap.entries()) {
            this.put(entry.key, entry.value);
        }
    }

    private void putResize(long l, V v2) {
        if (l == 0L) {
            this.zeroValue = v2;
            this.hasZeroValue = true;
            return;
        }
        int n = (int)(l & (long)this.mask);
        long l2 = this.keyTable[n];
        if (l2 == 0L) {
            this.keyTable[n] = l;
            this.valueTable[n] = v2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int n2 = this.hash2(l);
        long l3 = this.keyTable[n2];
        if (l3 == 0L) {
            this.keyTable[n2] = l;
            this.valueTable[n2] = v2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int n3 = this.hash3(l);
        long l4 = this.keyTable[n3];
        if (l4 == 0L) {
            this.keyTable[n3] = l;
            this.valueTable[n3] = v2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        this.push(l, v2, n, l2, n2, l3, n3, l4);
    }

    private void push(long l, V v2, int n, long l2, int n2, long l3, int n3, long l4) {
        V v3;
        long l5;
        long[] lArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n4 = this.mask;
        int n5 = 0;
        int n6 = this.pushIterations;
        while (true) {
            switch (MathUtils.random(2)) {
                case 0: {
                    l5 = l2;
                    v3 = VArray[n];
                    lArray[n] = l;
                    VArray[n] = v2;
                    break;
                }
                case 1: {
                    l5 = l3;
                    v3 = VArray[n2];
                    lArray[n2] = l;
                    VArray[n2] = v2;
                    break;
                }
                default: {
                    l5 = l4;
                    v3 = VArray[n3];
                    lArray[n3] = l;
                    VArray[n3] = v2;
                }
            }
            n = (int)(l5 & (long)n4);
            l2 = lArray[n];
            if (l2 == 0L) {
                lArray[n] = l5;
                VArray[n] = v3;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n2 = this.hash2(l5);
            l3 = lArray[n2];
            if (l3 == 0L) {
                lArray[n2] = l5;
                VArray[n2] = v3;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n3 = this.hash3(l5);
            l4 = lArray[n3];
            if (l4 == 0L) {
                lArray[n3] = l5;
                VArray[n3] = v3;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            if (++n5 == n6) break;
            l = l5;
            v2 = v3;
        }
        this.putStash(l5, v3);
    }

    private void putStash(long l, V v2) {
        if (this.stashSize == this.stashCapacity) {
            this.resize(this.capacity << 1);
            this.put(l, v2);
            return;
        }
        int n = this.capacity + this.stashSize;
        this.keyTable[n] = l;
        this.valueTable[n] = v2;
        ++this.stashSize;
        ++this.size;
    }

    public V get(long l) {
        if (l == 0L) {
            if (!this.hasZeroValue) {
                return null;
            }
            return this.zeroValue;
        }
        int n = (int)(l & (long)this.mask);
        if (this.keyTable[n] != l && this.keyTable[n = this.hash2(l)] != l && this.keyTable[n = this.hash3(l)] != l) {
            return this.getStash(l, null);
        }
        return this.valueTable[n];
    }

    public V get(long l, V v2) {
        if (l == 0L) {
            if (!this.hasZeroValue) {
                return v2;
            }
            return this.zeroValue;
        }
        int n = (int)(l & (long)this.mask);
        if (this.keyTable[n] != l && this.keyTable[n = this.hash2(l)] != l && this.keyTable[n = this.hash3(l)] != l) {
            return this.getStash(l, v2);
        }
        return this.valueTable[n];
    }

    private V getStash(long l, V v2) {
        int n;
        long[] lArray = this.keyTable;
        int n2 = n + this.stashSize;
        for (n = this.capacity; n < n2; ++n) {
            if (lArray[n] != l) continue;
            return this.valueTable[n];
        }
        return v2;
    }

    public V remove(long l) {
        if (l == 0L) {
            if (!this.hasZeroValue) {
                return null;
            }
            V v2 = this.zeroValue;
            this.zeroValue = null;
            this.hasZeroValue = false;
            --this.size;
            return v2;
        }
        int n = (int)(l & (long)this.mask);
        if (this.keyTable[n] == l) {
            this.keyTable[n] = 0L;
            V v3 = this.valueTable[n];
            this.valueTable[n] = null;
            --this.size;
            return v3;
        }
        n = this.hash2(l);
        if (this.keyTable[n] == l) {
            this.keyTable[n] = 0L;
            V v4 = this.valueTable[n];
            this.valueTable[n] = null;
            --this.size;
            return v4;
        }
        n = this.hash3(l);
        if (this.keyTable[n] == l) {
            this.keyTable[n] = 0L;
            V v5 = this.valueTable[n];
            this.valueTable[n] = null;
            --this.size;
            return v5;
        }
        return this.removeStash(l);
    }

    V removeStash(long l) {
        int n;
        long[] lArray = this.keyTable;
        int n2 = n + this.stashSize;
        for (n = this.capacity; n < n2; ++n) {
            if (lArray[n] != l) continue;
            V v2 = this.valueTable[n];
            this.removeStashIndex(n);
            --this.size;
            return v2;
        }
        return null;
    }

    void removeStashIndex(int n) {
        --this.stashSize;
        int n2 = this.capacity + this.stashSize;
        if (n < n2) {
            this.keyTable[n] = this.keyTable[n2];
            this.valueTable[n] = this.valueTable[n2];
            this.valueTable[n2] = null;
        } else {
            this.valueTable[n] = null;
        }
    }

    public void shrink(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("maximumCapacity must be >= 0: " + n);
        }
        if (this.size > n) {
            n = this.size;
        }
        if (this.capacity <= n) {
            return;
        }
        n = MathUtils.nextPowerOfTwo(n);
        this.resize(n);
    }

    public void clear(int n) {
        if (this.capacity <= n) {
            this.clear();
            return;
        }
        this.zeroValue = null;
        this.hasZeroValue = false;
        this.size = 0;
        this.resize(n);
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        long[] lArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n = this.capacity + this.stashSize;
        while (n-- > 0) {
            lArray[n] = 0L;
            VArray[n] = null;
        }
        this.size = 0;
        this.stashSize = 0;
        this.zeroValue = null;
        this.hasZeroValue = false;
    }

    public boolean containsValue(Object object, boolean bl) {
        V[] VArray = this.valueTable;
        if (object == null) {
            if (this.hasZeroValue && this.zeroValue == null) {
                return true;
            }
            long[] lArray = this.keyTable;
            int n = this.capacity + this.stashSize;
            while (n-- > 0) {
                if (lArray[n] == 0L || VArray[n] != null) continue;
                return true;
            }
        } else if (bl) {
            if (object == this.zeroValue) {
                return true;
            }
            int n = this.capacity + this.stashSize;
            while (n-- > 0) {
                if (VArray[n] != object) continue;
                return true;
            }
        } else {
            if (this.hasZeroValue && object.equals(this.zeroValue)) {
                return true;
            }
            int n = this.capacity + this.stashSize;
            while (n-- > 0) {
                if (!object.equals(VArray[n])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(long l) {
        if (l == 0L) {
            return this.hasZeroValue;
        }
        int n = (int)(l & (long)this.mask);
        if (this.keyTable[n] != l && this.keyTable[n = this.hash2(l)] != l && this.keyTable[n = this.hash3(l)] != l) {
            return this.containsKeyStash(l);
        }
        return true;
    }

    private boolean containsKeyStash(long l) {
        int n;
        long[] lArray = this.keyTable;
        int n2 = n + this.stashSize;
        for (n = this.capacity; n < n2; ++n) {
            if (lArray[n] != l) continue;
            return true;
        }
        return false;
    }

    public long findKey(Object object, boolean bl, long l) {
        V[] VArray = this.valueTable;
        if (object == null) {
            if (this.hasZeroValue && this.zeroValue == null) {
                return 0L;
            }
            long[] lArray = this.keyTable;
            int n = this.capacity + this.stashSize;
            while (n-- > 0) {
                if (lArray[n] == 0L || VArray[n] != null) continue;
                return lArray[n];
            }
        } else if (bl) {
            if (object == this.zeroValue) {
                return 0L;
            }
            int n = this.capacity + this.stashSize;
            while (n-- > 0) {
                if (VArray[n] != object) continue;
                return this.keyTable[n];
            }
        } else {
            if (this.hasZeroValue && object.equals(this.zeroValue)) {
                return 0L;
            }
            int n = this.capacity + this.stashSize;
            while (n-- > 0) {
                if (!object.equals(VArray[n])) continue;
                return this.keyTable[n];
            }
        }
        return l;
    }

    public void ensureCapacity(int n) {
        int n2 = this.size + n;
        if (n2 >= this.threshold) {
            this.resize(MathUtils.nextPowerOfTwo((int)Math.ceil((float)n2 / this.loadFactor)));
        }
    }

    private void resize(int n) {
        int n2 = this.capacity + this.stashSize;
        this.capacity = n;
        this.threshold = (int)((float)n * this.loadFactor);
        this.mask = n - 1;
        this.hashShift = 63 - Long.numberOfTrailingZeros(n);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(n)) * 2);
        this.pushIterations = Math.max(Math.min(n, 8), (int)Math.sqrt(n) / 8);
        long[] lArray = this.keyTable;
        V[] VArray = this.valueTable;
        this.keyTable = new long[n + this.stashCapacity];
        this.valueTable = new Object[n + this.stashCapacity];
        int n3 = this.size;
        this.size = this.hasZeroValue ? 1 : 0;
        this.stashSize = 0;
        if (n3 > 0) {
            for (int i = 0; i < n2; ++i) {
                long l = lArray[i];
                if (l == 0L) continue;
                this.putResize(l, VArray[i]);
            }
        }
    }

    private int hash2(long l) {
        return (int)(((l *= -1262997959L) ^ l >>> this.hashShift) & (long)this.mask);
    }

    private int hash3(long l) {
        return (int)(((l *= -825114047L) ^ l >>> this.hashShift) & (long)this.mask);
    }

    public int hashCode() {
        int n = 0;
        if (this.hasZeroValue && this.zeroValue != null) {
            n += this.zeroValue.hashCode();
        }
        long[] lArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n2 = this.capacity + this.stashSize;
        for (int i = 0; i < n2; ++i) {
            long l = lArray[i];
            if (l == 0L) continue;
            n += (int)(l ^ l >>> 32) * 31;
            V v2 = VArray[i];
            if (v2 == null) continue;
            n += v2.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LongMap)) {
            return false;
        }
        LongMap longMap = (LongMap)object;
        if (longMap.size != this.size) {
            return false;
        }
        if (longMap.hasZeroValue != this.hasZeroValue) {
            return false;
        }
        if (this.hasZeroValue && (longMap.zeroValue == null ? this.zeroValue != null : !longMap.zeroValue.equals(this.zeroValue))) {
            return false;
        }
        long[] lArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n = this.capacity + this.stashSize;
        for (int i = 0; i < n; ++i) {
            V v2;
            long l = lArray[i];
            if (l == 0L || !((v2 = VArray[i]) == null ? !longMap.containsKey(l) || longMap.get(l) != null : !v2.equals(longMap.get(l)))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        long l;
        if (this.size == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        long[] lArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n = lArray.length;
        while (n-- > 0) {
            l = lArray[n];
            if (l == 0L) continue;
            stringBuilder.append(l);
            stringBuilder.append('=');
            stringBuilder.append(VArray[n]);
            break;
        }
        while (n-- > 0) {
            l = lArray[n];
            if (l == 0L) continue;
            stringBuilder.append(", ");
            stringBuilder.append(l);
            stringBuilder.append('=');
            stringBuilder.append(VArray[n]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public Iterator<Entry<V>> iterator() {
        return this.entries();
    }

    public Entries<V> entries() {
        if (this.entries1 == null) {
            this.entries1 = new Entries(this);
            this.entries2 = new Entries(this);
        }
        if (!this.entries1.valid) {
            this.entries1.reset();
            this.entries1.valid = true;
            this.entries2.valid = false;
            return this.entries1;
        }
        this.entries2.reset();
        this.entries2.valid = true;
        this.entries1.valid = false;
        return this.entries2;
    }

    public Values<V> values() {
        if (this.values1 == null) {
            this.values1 = new Values(this);
            this.values2 = new Values(this);
        }
        if (!this.values1.valid) {
            this.values1.reset();
            this.values1.valid = true;
            this.values2.valid = false;
            return this.values1;
        }
        this.values2.reset();
        this.values2.valid = true;
        this.values1.valid = false;
        return this.values2;
    }

    public Keys keys() {
        if (this.keys1 == null) {
            this.keys1 = new Keys(this);
            this.keys2 = new Keys(this);
        }
        if (!this.keys1.valid) {
            this.keys1.reset();
            this.keys1.valid = true;
            this.keys2.valid = false;
            return this.keys1;
        }
        this.keys2.reset();
        this.keys2.valid = true;
        this.keys1.valid = false;
        return this.keys2;
    }

    public static class Keys
    extends MapIterator {
        public Keys(LongMap longMap) {
            super(longMap);
        }

        public long next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            long l = this.nextIndex == -1 ? 0L : this.map.keyTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return l;
        }

        public LongArray toArray() {
            LongArray longArray = new LongArray(true, this.map.size);
            while (this.hasNext) {
                longArray.add(this.next());
            }
            return longArray;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Values<V>
    extends MapIterator<V>
    implements Iterable<V>,
    Iterator<V> {
        public Values(LongMap<V> longMap) {
            super(longMap);
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        @Override
        public V next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            Object v2 = this.nextIndex == -1 ? this.map.zeroValue : this.map.valueTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return v2;
        }

        @Override
        public Iterator<V> iterator() {
            return this;
        }

        public Array<V> toArray() {
            Array<V> array = new Array<V>(true, this.map.size);
            while (this.hasNext) {
                array.add(this.next());
            }
            return array;
        }

        @Override
        public void remove() {
            super.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entries<V>
    extends MapIterator<V>
    implements Iterable<Entry<V>>,
    Iterator<Entry<V>> {
        private Entry<V> entry = new Entry();

        public Entries(LongMap longMap) {
            super(longMap);
        }

        @Override
        public Entry<V> next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            long[] lArray = this.map.keyTable;
            if (this.nextIndex == -1) {
                this.entry.key = 0L;
                this.entry.value = this.map.zeroValue;
            } else {
                this.entry.key = lArray[this.nextIndex];
                this.entry.value = this.map.valueTable[this.nextIndex];
            }
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return this.entry;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        @Override
        public Iterator<Entry<V>> iterator() {
            return this;
        }

        @Override
        public void remove() {
            super.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MapIterator<V> {
        static final int INDEX_ILLEGAL = -2;
        static final int INDEX_ZERO = -1;
        public boolean hasNext;
        final LongMap<V> map;
        int nextIndex;
        int currentIndex;
        boolean valid = true;

        public MapIterator(LongMap<V> longMap) {
            this.map = longMap;
            this.reset();
        }

        public void reset() {
            this.currentIndex = -2;
            this.nextIndex = -1;
            if (this.map.hasZeroValue) {
                this.hasNext = true;
            } else {
                this.findNextIndex();
            }
        }

        void findNextIndex() {
            this.hasNext = false;
            long[] lArray = this.map.keyTable;
            int n = this.map.capacity + this.map.stashSize;
            while (++this.nextIndex < n) {
                if (lArray[this.nextIndex] == 0L) continue;
                this.hasNext = true;
                break;
            }
        }

        public void remove() {
            if (this.currentIndex == -1 && this.map.hasZeroValue) {
                this.map.zeroValue = null;
                this.map.hasZeroValue = false;
            } else {
                if (this.currentIndex < 0) {
                    throw new IllegalStateException("next must be called before remove.");
                }
                if (this.currentIndex >= this.map.capacity) {
                    this.map.removeStashIndex(this.currentIndex);
                    this.nextIndex = this.currentIndex - 1;
                    this.findNextIndex();
                } else {
                    this.map.keyTable[this.currentIndex] = 0L;
                    this.map.valueTable[this.currentIndex] = null;
                }
            }
            this.currentIndex = -2;
            --this.map.size;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry<V> {
        public long key;
        public V value;

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

