/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.collections.map;

import com.fr.stable.collections.array.IntArray;
import com.fr.stable.collections.utils.GdxRuntimeException;
import com.fr.stable.collections.utils.MathUtils;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntIntMap
implements Iterable<Entry> {
    private static final int PRIME1 = -1105259343;
    private static final int PRIME2 = -1262997959;
    private static final int PRIME3 = -825114047;
    private static final int EMPTY = 0;
    public int size;
    int[] keyTable;
    int[] valueTable;
    int capacity;
    int stashSize;
    int zeroValue;
    boolean hasZeroValue;
    private float loadFactor;
    private int hashShift;
    private int mask;
    private int threshold;
    private int stashCapacity;
    private int pushIterations;
    private Entries entries1;
    private Entries entries2;
    private Values values1;
    private Values values2;
    private Keys keys1;
    private Keys keys2;

    public IntIntMap() {
        this(51, 0.8f);
    }

    public IntIntMap(int n) {
        this(n, 0.8f);
    }

    public IntIntMap(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("initialCapacity must be >= 0: " + n);
        }
        if ((n = MathUtils.nextPowerOfTwo((int)Math.ceil((float)n / f))) > 0x40000000) {
            throw new IllegalArgumentException("initialCapacity is too large: " + n);
        }
        this.capacity = n;
        if (f <= 0.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0: " + f);
        }
        this.loadFactor = f;
        this.threshold = (int)((float)this.capacity * f);
        this.mask = this.capacity - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(this.capacity);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(this.capacity)) * 2);
        this.pushIterations = Math.max(Math.min(this.capacity, 8), (int)Math.sqrt(this.capacity) / 8);
        this.keyTable = new int[this.capacity + this.stashCapacity];
        this.valueTable = new int[this.keyTable.length];
    }

    public IntIntMap(IntIntMap intIntMap) {
        this((int)Math.floor((float)intIntMap.capacity * intIntMap.loadFactor), intIntMap.loadFactor);
        this.stashSize = intIntMap.stashSize;
        System.arraycopy(intIntMap.keyTable, 0, this.keyTable, 0, intIntMap.keyTable.length);
        System.arraycopy(intIntMap.valueTable, 0, this.valueTable, 0, intIntMap.valueTable.length);
        this.size = intIntMap.size;
        this.zeroValue = intIntMap.zeroValue;
        this.hasZeroValue = intIntMap.hasZeroValue;
    }

    public void put(int n, int n2) {
        int n3;
        if (n == 0) {
            this.zeroValue = n2;
            if (!this.hasZeroValue) {
                this.hasZeroValue = true;
                ++this.size;
            }
            return;
        }
        int[] nArray = this.keyTable;
        int n4 = n & this.mask;
        int n5 = nArray[n4];
        if (n == n5) {
            this.valueTable[n4] = n2;
            return;
        }
        int n6 = this.hash2(n);
        int n7 = nArray[n6];
        if (n == n7) {
            this.valueTable[n6] = n2;
            return;
        }
        int n8 = this.hash3(n);
        int n9 = nArray[n8];
        if (n == n9) {
            this.valueTable[n8] = n2;
            return;
        }
        int n10 = n3 + this.stashSize;
        for (n3 = this.capacity; n3 < n10; ++n3) {
            if (n != nArray[n3]) continue;
            this.valueTable[n3] = n2;
            return;
        }
        if (n5 == 0) {
            nArray[n4] = n;
            this.valueTable[n4] = n2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        if (n7 == 0) {
            nArray[n6] = n;
            this.valueTable[n6] = n2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        if (n9 == 0) {
            nArray[n8] = n;
            this.valueTable[n8] = n2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        this.push(n, n2, n4, n5, n6, n7, n8, n9);
    }

    public void putAll(IntIntMap intIntMap) {
        for (Entry entry : intIntMap.entries()) {
            this.put(entry.key, entry.value);
        }
    }

    private void putResize(int n, int n2) {
        if (n == 0) {
            this.zeroValue = n2;
            this.hasZeroValue = true;
            return;
        }
        int n3 = n & this.mask;
        int n4 = this.keyTable[n3];
        if (n4 == 0) {
            this.keyTable[n3] = n;
            this.valueTable[n3] = n2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int n5 = this.hash2(n);
        int n6 = this.keyTable[n5];
        if (n6 == 0) {
            this.keyTable[n5] = n;
            this.valueTable[n5] = n2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int n7 = this.hash3(n);
        int n8 = this.keyTable[n7];
        if (n8 == 0) {
            this.keyTable[n7] = n;
            this.valueTable[n7] = n2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        this.push(n, n2, n3, n4, n5, n6, n7, n8);
    }

    private void push(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9;
        int n10;
        int[] nArray = this.keyTable;
        int[] nArray2 = this.valueTable;
        int n11 = this.mask;
        int n12 = 0;
        int n13 = this.pushIterations;
        while (true) {
            switch (MathUtils.random(2)) {
                case 0: {
                    n10 = n4;
                    n9 = nArray2[n3];
                    nArray[n3] = n;
                    nArray2[n3] = n2;
                    break;
                }
                case 1: {
                    n10 = n6;
                    n9 = nArray2[n5];
                    nArray[n5] = n;
                    nArray2[n5] = n2;
                    break;
                }
                default: {
                    n10 = n8;
                    n9 = nArray2[n7];
                    nArray[n7] = n;
                    nArray2[n7] = n2;
                }
            }
            n3 = n10 & n11;
            n4 = nArray[n3];
            if (n4 == 0) {
                nArray[n3] = n10;
                nArray2[n3] = n9;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n5 = this.hash2(n10);
            n6 = nArray[n5];
            if (n6 == 0) {
                nArray[n5] = n10;
                nArray2[n5] = n9;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n7 = this.hash3(n10);
            n8 = nArray[n7];
            if (n8 == 0) {
                nArray[n7] = n10;
                nArray2[n7] = n9;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            if (++n12 == n13) break;
            n = n10;
            n2 = n9;
        }
        this.putStash(n10, n9);
    }

    private void putStash(int n, int n2) {
        if (this.stashSize == this.stashCapacity) {
            this.resize(this.capacity << 1);
            this.put(n, n2);
            return;
        }
        int n3 = this.capacity + this.stashSize;
        this.keyTable[n3] = n;
        this.valueTable[n3] = n2;
        ++this.stashSize;
        ++this.size;
    }

    public int get(int n, int n2) {
        if (n == 0) {
            if (!this.hasZeroValue) {
                return n2;
            }
            return this.zeroValue;
        }
        int n3 = n & this.mask;
        if (this.keyTable[n3] != n && this.keyTable[n3 = this.hash2(n)] != n && this.keyTable[n3 = this.hash3(n)] != n) {
            return this.getStash(n, n2);
        }
        return this.valueTable[n3];
    }

    private int getStash(int n, int n2) {
        int n3;
        int[] nArray = this.keyTable;
        int n4 = n3 + this.stashSize;
        for (n3 = this.capacity; n3 < n4; ++n3) {
            if (n != nArray[n3]) continue;
            return this.valueTable[n3];
        }
        return n2;
    }

    public int getAndIncrement(int n, int n2, int n3) {
        if (n == 0) {
            if (this.hasZeroValue) {
                int n4 = this.zeroValue;
                this.zeroValue += n3;
                return n4;
            }
            this.hasZeroValue = true;
            this.zeroValue = n2 + n3;
            ++this.size;
            return n2;
        }
        int n5 = n & this.mask;
        if (n != this.keyTable[n5] && n != this.keyTable[n5 = this.hash2(n)] && n != this.keyTable[n5 = this.hash3(n)]) {
            return this.getAndIncrementStash(n, n2, n3);
        }
        int n6 = this.valueTable[n5];
        this.valueTable[n5] = n6 + n3;
        return n6;
    }

    private int getAndIncrementStash(int n, int n2, int n3) {
        int n4;
        int[] nArray = this.keyTable;
        int n5 = n4 + this.stashSize;
        for (n4 = this.capacity; n4 < n5; ++n4) {
            if (n != nArray[n4]) continue;
            int n6 = this.valueTable[n4];
            this.valueTable[n4] = n6 + n3;
            return n6;
        }
        this.put(n, n2 + n3);
        return n2;
    }

    public int remove(int n, int n2) {
        if (n == 0) {
            if (!this.hasZeroValue) {
                return n2;
            }
            this.hasZeroValue = false;
            --this.size;
            return this.zeroValue;
        }
        int n3 = n & this.mask;
        if (n == this.keyTable[n3]) {
            this.keyTable[n3] = 0;
            int n4 = this.valueTable[n3];
            --this.size;
            return n4;
        }
        n3 = this.hash2(n);
        if (n == this.keyTable[n3]) {
            this.keyTable[n3] = 0;
            int n5 = this.valueTable[n3];
            --this.size;
            return n5;
        }
        n3 = this.hash3(n);
        if (n == this.keyTable[n3]) {
            this.keyTable[n3] = 0;
            int n6 = this.valueTable[n3];
            --this.size;
            return n6;
        }
        return this.removeStash(n, n2);
    }

    int removeStash(int n, int n2) {
        int n3;
        int[] nArray = this.keyTable;
        int n4 = n3 + this.stashSize;
        for (n3 = this.capacity; n3 < n4; ++n3) {
            if (n != nArray[n3]) continue;
            int n5 = this.valueTable[n3];
            this.removeStashIndex(n3);
            --this.size;
            return n5;
        }
        return n2;
    }

    void removeStashIndex(int n) {
        --this.stashSize;
        int n2 = this.capacity + this.stashSize;
        if (n < n2) {
            this.keyTable[n] = this.keyTable[n2];
            this.valueTable[n] = this.valueTable[n2];
        }
    }

    public void shrink(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("maximumCapacity must be >= 0: " + n);
        }
        if (this.size > n) {
            n = this.size;
        }
        if (this.capacity <= n) {
            return;
        }
        n = MathUtils.nextPowerOfTwo(n);
        this.resize(n);
    }

    public void clear(int n) {
        if (this.capacity <= n) {
            this.clear();
            return;
        }
        this.hasZeroValue = false;
        this.size = 0;
        this.resize(n);
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        int[] nArray = this.keyTable;
        int n = this.capacity + this.stashSize;
        while (n-- > 0) {
            nArray[n] = 0;
        }
        this.size = 0;
        this.stashSize = 0;
        this.hasZeroValue = false;
    }

    public boolean containsValue(int n) {
        if (this.hasZeroValue && this.zeroValue == n) {
            return true;
        }
        int[] nArray = this.keyTable;
        int[] nArray2 = this.valueTable;
        int n2 = this.capacity + this.stashSize;
        while (n2-- > 0) {
            if (nArray[n2] == 0 || nArray2[n2] != n) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(int n) {
        if (n == 0) {
            return this.hasZeroValue;
        }
        int n2 = n & this.mask;
        if (this.keyTable[n2] != n && this.keyTable[n2 = this.hash2(n)] != n && this.keyTable[n2 = this.hash3(n)] != n) {
            return this.containsKeyStash(n);
        }
        return true;
    }

    private boolean containsKeyStash(int n) {
        int n2;
        int[] nArray = this.keyTable;
        int n3 = n2 + this.stashSize;
        for (n2 = this.capacity; n2 < n3; ++n2) {
            if (n != nArray[n2]) continue;
            return true;
        }
        return false;
    }

    public int findKey(int n, int n2) {
        if (this.hasZeroValue && this.zeroValue == n) {
            return 0;
        }
        int[] nArray = this.keyTable;
        int[] nArray2 = this.valueTable;
        int n3 = this.capacity + this.stashSize;
        while (n3-- > 0) {
            if (nArray[n3] == 0 || nArray2[n3] != n) continue;
            return nArray[n3];
        }
        return n2;
    }

    public void ensureCapacity(int n) {
        int n2 = this.size + n;
        if (n2 >= this.threshold) {
            this.resize(MathUtils.nextPowerOfTwo((int)Math.ceil((float)n2 / this.loadFactor)));
        }
    }

    private void resize(int n) {
        int n2 = this.capacity + this.stashSize;
        this.capacity = n;
        this.threshold = (int)((float)n * this.loadFactor);
        this.mask = n - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(n);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(n)) * 2);
        this.pushIterations = Math.max(Math.min(n, 8), (int)Math.sqrt(n) / 8);
        int[] nArray = this.keyTable;
        int[] nArray2 = this.valueTable;
        this.keyTable = new int[n + this.stashCapacity];
        this.valueTable = new int[n + this.stashCapacity];
        int n3 = this.size;
        this.size = this.hasZeroValue ? 1 : 0;
        this.stashSize = 0;
        if (n3 > 0) {
            for (int i = 0; i < n2; ++i) {
                int n4 = nArray[i];
                if (n4 == 0) continue;
                this.putResize(n4, nArray2[i]);
            }
        }
    }

    private int hash2(int n) {
        return ((n *= -1262997959) ^ n >>> this.hashShift) & this.mask;
    }

    private int hash3(int n) {
        return ((n *= -825114047) ^ n >>> this.hashShift) & this.mask;
    }

    public int hashCode() {
        int n = 0;
        if (this.hasZeroValue) {
            n += Float.floatToIntBits(this.zeroValue);
        }
        int[] nArray = this.keyTable;
        int[] nArray2 = this.valueTable;
        int n2 = this.capacity + this.stashSize;
        for (int i = 0; i < n2; ++i) {
            int n3 = nArray[i];
            if (n3 == 0) continue;
            n += n3 * 31;
            int n4 = nArray2[i];
            n += n4;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IntIntMap)) {
            return false;
        }
        IntIntMap intIntMap = (IntIntMap)object;
        if (intIntMap.size != this.size) {
            return false;
        }
        if (intIntMap.hasZeroValue != this.hasZeroValue) {
            return false;
        }
        if (this.hasZeroValue && intIntMap.zeroValue != this.zeroValue) {
            return false;
        }
        int[] nArray = this.keyTable;
        int[] nArray2 = this.valueTable;
        int n = this.capacity + this.stashSize;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            if (n2 == 0) continue;
            int n3 = intIntMap.get(n2, 0);
            if (n3 == 0 && !intIntMap.containsKey(n2)) {
                return false;
            }
            int n4 = nArray2[i];
            if (n3 == n4) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        int n;
        if (this.size == 0) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('{');
        int[] nArray = this.keyTable;
        int[] nArray2 = this.valueTable;
        int n2 = nArray.length;
        if (this.hasZeroValue) {
            stringBuilder.append("0=");
            stringBuilder.append(this.zeroValue);
        } else {
            while (n2-- > 0) {
                n = nArray[n2];
                if (n == 0) continue;
                stringBuilder.append(n);
                stringBuilder.append('=');
                stringBuilder.append(nArray2[n2]);
                break;
            }
        }
        while (n2-- > 0) {
            n = nArray[n2];
            if (n == 0) continue;
            stringBuilder.append(", ");
            stringBuilder.append(n);
            stringBuilder.append('=');
            stringBuilder.append(nArray2[n2]);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public Iterator<Entry> iterator() {
        return this.entries();
    }

    public Entries entries() {
        if (this.entries1 == null) {
            this.entries1 = new Entries(this);
            this.entries2 = new Entries(this);
        }
        if (!this.entries1.valid) {
            this.entries1.reset();
            this.entries1.valid = true;
            this.entries2.valid = false;
            return this.entries1;
        }
        this.entries2.reset();
        this.entries2.valid = true;
        this.entries1.valid = false;
        return this.entries2;
    }

    public Values values() {
        if (this.values1 == null) {
            this.values1 = new Values(this);
            this.values2 = new Values(this);
        }
        if (!this.values1.valid) {
            this.values1.reset();
            this.values1.valid = true;
            this.values2.valid = false;
            return this.values1;
        }
        this.values2.reset();
        this.values2.valid = true;
        this.values1.valid = false;
        return this.values2;
    }

    public Keys keys() {
        if (this.keys1 == null) {
            this.keys1 = new Keys(this);
            this.keys2 = new Keys(this);
        }
        if (!this.keys1.valid) {
            this.keys1.reset();
            this.keys1.valid = true;
            this.keys2.valid = false;
            return this.keys1;
        }
        this.keys2.reset();
        this.keys2.valid = true;
        this.keys1.valid = false;
        return this.keys2;
    }

    public static class Keys
    extends MapIterator {
        public Keys(IntIntMap intIntMap) {
            super(intIntMap);
        }

        public boolean hasNext() {
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        public int next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            int n = this.nextIndex == -1 ? 0 : this.map.keyTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return n;
        }

        public IntArray toArray() {
            IntArray intArray = new IntArray(true, this.map.size);
            while (this.hasNext) {
                intArray.add(this.next());
            }
            return intArray;
        }
    }

    public static class Values
    extends MapIterator {
        public Values(IntIntMap intIntMap) {
            super(intIntMap);
        }

        public boolean hasNext() {
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        public int next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            int n = this.nextIndex == -1 ? this.map.zeroValue : this.map.valueTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return n;
        }

        public IntArray toArray() {
            IntArray intArray = new IntArray(true, this.map.size);
            while (this.hasNext) {
                intArray.add(this.next());
            }
            return intArray;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entries
    extends MapIterator
    implements Iterable<Entry>,
    Iterator<Entry> {
        private Entry entry = new Entry();

        public Entries(IntIntMap intIntMap) {
            super(intIntMap);
        }

        @Override
        public Entry next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            int[] nArray = this.map.keyTable;
            if (this.nextIndex == -1) {
                this.entry.key = 0;
                this.entry.value = this.map.zeroValue;
            } else {
                this.entry.key = nArray[this.nextIndex];
                this.entry.value = this.map.valueTable[this.nextIndex];
            }
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return this.entry;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        @Override
        public Iterator<Entry> iterator() {
            return this;
        }

        @Override
        public void remove() {
            super.remove();
        }
    }

    private static class MapIterator {
        static final int INDEX_ILLEGAL = -2;
        static final int INDEX_ZERO = -1;
        public boolean hasNext;
        final IntIntMap map;
        int nextIndex;
        int currentIndex;
        boolean valid = true;

        public MapIterator(IntIntMap intIntMap) {
            this.map = intIntMap;
            this.reset();
        }

        public void reset() {
            this.currentIndex = -2;
            this.nextIndex = -1;
            if (this.map.hasZeroValue) {
                this.hasNext = true;
            } else {
                this.findNextIndex();
            }
        }

        void findNextIndex() {
            this.hasNext = false;
            int[] nArray = this.map.keyTable;
            int n = this.map.capacity + this.map.stashSize;
            while (++this.nextIndex < n) {
                if (nArray[this.nextIndex] == 0) continue;
                this.hasNext = true;
                break;
            }
        }

        public void remove() {
            if (this.currentIndex == -1 && this.map.hasZeroValue) {
                this.map.hasZeroValue = false;
            } else {
                if (this.currentIndex < 0) {
                    throw new IllegalStateException("next must be called before remove.");
                }
                if (this.currentIndex >= this.map.capacity) {
                    this.map.removeStashIndex(this.currentIndex);
                    this.nextIndex = this.currentIndex - 1;
                    this.findNextIndex();
                } else {
                    this.map.keyTable[this.currentIndex] = 0;
                }
            }
            this.currentIndex = -2;
            --this.map.size;
        }
    }

    public static class Entry {
        public int key;
        public int value;

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

