/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.collections.map;

import com.fr.stable.plugin.closeable.CloseableUtils;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloseableContainedMap<K, V, M extends Map>
implements Map<K, V> {
    private M innerMap;

    public CloseableContainedMap(Class<? extends M> clazz) {
        try {
            this.innerMap = (Map)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
    }

    @Override
    public int size() {
        return CloseableUtils.filterMap(this.innerMap).size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    @Override
    public boolean containsValue(Object object) {
        return this.innerMap.containsValue(object) && !CloseableUtils.isClosed(object);
    }

    @Override
    public V get(Object object) {
        Object v2 = this.innerMap.get(object);
        if (CloseableUtils.isClosed(v2)) {
            return null;
        }
        return v2;
    }

    @Override
    public V put(K k, V v2) {
        return this.innerMap.put(k, v2);
    }

    @Override
    public V remove(Object object) {
        return this.innerMap.remove(object);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.innerMap.putAll(map);
    }

    @Override
    public void clear() {
        this.innerMap.clear();
    }

    @Override
    public Set<K> keySet() {
        return CloseableUtils.filterMap(this.innerMap).keySet();
    }

    @Override
    public Collection<V> values() {
        return CloseableUtils.filterMap(this.innerMap).values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return CloseableUtils.filterMap(this.innerMap).entrySet();
    }
}

