/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.collections.lazy;

import com.fr.stable.collections.lazy.LazyValueCreator;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyCalculateContainer<T> {
    private int size = -1;
    private ConcurrentHashMap<Object, LazyValueWaiter> map = new ConcurrentHashMap();

    public LazyCalculateContainer() {
    }

    public LazyCalculateContainer(int n) {
        if (n < 1) {
            throw new RuntimeException("invalid size");
        }
        this.size = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(Object object, LazyValueCreator<T> lazyValueCreator) throws Exception {
        if (!this.map.containsKey(object)) {
            LazyCalculateContainer lazyCalculateContainer = this;
            synchronized (lazyCalculateContainer) {
                while (this.isFull() && !this.map.containsKey(object)) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (!this.map.containsKey(object)) {
                    this.map.put(object, new LazyValueWaiter(object, lazyValueCreator));
                }
            }
        }
        return this.map.get(object).get();
    }

    public boolean isFull() {
        return this.size > 0 && this.map.size() >= this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(Object object) {
        this.map.remove(object);
        LazyCalculateContainer lazyCalculateContainer = this;
        synchronized (lazyCalculateContainer) {
            this.notifyAll();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LazyValueWaiter {
        private T value;
        private Object hashKey;
        private LazyValueCreator<T> creator;
        private volatile Status status = Status.NOT_STARTED;
        private Exception exception;

        public LazyValueWaiter(Object object, LazyValueCreator<T> lazyValueCreator) {
            this.hashKey = object;
            this.creator = lazyValueCreator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        T get() throws Exception {
            if (this.status == Status.STARTED) {
                LazyValueWaiter lazyValueWaiter = this;
                synchronized (lazyValueWaiter) {
                    while (this.status == Status.STARTED) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
            LazyValueWaiter lazyValueWaiter = this;
            synchronized (lazyValueWaiter) {
                if (this.status == Status.STARTED) {
                    while (this.status == Status.STARTED) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                } else {
                    this.status = Status.STARTED;
                    this.notifyAll();
                }
            }
            if (this.status != Status.CREATED) {
                try {
                    this.value = this.creator.create();
                }
                catch (Exception exception) {
                    this.exception = exception;
                }
                this.status = Status.CREATED;
                lazyValueWaiter = this;
                synchronized (lazyValueWaiter) {
                    this.notifyAll();
                }
                LazyCalculateContainer.this.remove(this.hashKey);
            }
            if (this.exception != null) {
                throw this.exception;
            }
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Status {
        NOT_STARTED,
        STARTED,
        CREATED;

    }
}

