/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.collections.array;

import com.fr.stable.collections.utils.MathUtils;
import java.util.Arrays;

public class LongArray {
    public long[] items;
    public int size;
    public boolean ordered;

    public LongArray() {
        this(true, 16);
    }

    public LongArray(int n) {
        this(true, n);
    }

    public LongArray(boolean bl, int n) {
        this.ordered = bl;
        this.items = new long[n];
    }

    public LongArray(LongArray longArray) {
        this.ordered = longArray.ordered;
        this.size = longArray.size;
        this.items = new long[this.size];
        System.arraycopy(longArray.items, 0, this.items, 0, this.size);
    }

    public LongArray(long[] lArray) {
        this(true, lArray, 0, lArray.length);
    }

    public LongArray(boolean bl, long[] lArray, int n, int n2) {
        this(bl, n2);
        this.size = n2;
        System.arraycopy(lArray, n, this.items, 0, n2);
    }

    public void add(long l) {
        long[] lArray = this.items;
        if (this.size == lArray.length) {
            lArray = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        lArray[this.size++] = l;
    }

    public void addAll(LongArray longArray) {
        this.addAll(longArray, 0, longArray.size);
    }

    public void addAll(LongArray longArray, int n, int n2) {
        if (n + n2 > longArray.size) {
            throw new IllegalArgumentException("offset + length must be <= size: " + n + " + " + n2 + " <= " + longArray.size);
        }
        this.addAll(longArray.items, n, n2);
    }

    public void addAll(long ... lArray) {
        this.addAll(lArray, 0, lArray.length);
    }

    public void addAll(long[] lArray, int n, int n2) {
        int n3 = this.size + n2;
        long[] lArray2 = this.items;
        if (n3 > lArray2.length) {
            lArray2 = this.resize(Math.max(8, (int)((float)n3 * 1.75f)));
        }
        System.arraycopy(lArray, n, lArray2, this.size, n2);
        this.size += n2;
    }

    public long get(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + n + " >= " + this.size);
        }
        return this.items[n];
    }

    public void set(int n, long l) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + n + " >= " + this.size);
        }
        this.items[n] = l;
    }

    public void incr(int n, long l) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + n + " >= " + this.size);
        }
        int n2 = n;
        this.items[n2] = this.items[n2] + l;
    }

    public void mul(int n, long l) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + n + " >= " + this.size);
        }
        int n2 = n;
        this.items[n2] = this.items[n2] * l;
    }

    public void insert(int n, long l) {
        if (n > this.size) {
            throw new IndexOutOfBoundsException("index can't be > size: " + n + " > " + this.size);
        }
        long[] lArray = this.items;
        if (this.size == lArray.length) {
            lArray = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        if (this.ordered) {
            System.arraycopy(lArray, n, lArray, n + 1, this.size - n);
        } else {
            lArray[this.size] = lArray[n];
        }
        ++this.size;
        lArray[n] = l;
    }

    public void swap(int n, int n2) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("first can't be >= size: " + n + " >= " + this.size);
        }
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException("second can't be >= size: " + n2 + " >= " + this.size);
        }
        long[] lArray = this.items;
        long l = lArray[n];
        lArray[n] = lArray[n2];
        lArray[n2] = l;
    }

    public boolean contains(long l) {
        int n = this.size - 1;
        long[] lArray = this.items;
        while (n >= 0) {
            if (lArray[n--] != l) continue;
            return true;
        }
        return false;
    }

    public int indexOf(long l) {
        long[] lArray = this.items;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (lArray[i] != l) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(char c) {
        long[] lArray = this.items;
        for (int i = this.size - 1; i >= 0; --i) {
            if (lArray[i] != (long)c) continue;
            return i;
        }
        return -1;
    }

    public boolean removeValue(long l) {
        long[] lArray = this.items;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (lArray[i] != l) continue;
            this.removeIndex(i);
            return true;
        }
        return false;
    }

    public long removeIndex(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + n + " >= " + this.size);
        }
        long[] lArray = this.items;
        long l = lArray[n];
        --this.size;
        if (this.ordered) {
            System.arraycopy(lArray, n + 1, lArray, n, this.size - n);
        } else {
            lArray[n] = lArray[this.size];
        }
        return l;
    }

    public void removeRange(int n, int n2) {
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException("end can't be >= size: " + n2 + " >= " + this.size);
        }
        if (n > n2) {
            throw new IndexOutOfBoundsException("start can't be > end: " + n + " > " + n2);
        }
        long[] lArray = this.items;
        int n3 = n2 - n + 1;
        if (this.ordered) {
            System.arraycopy(lArray, n + n3, lArray, n, this.size - (n + n3));
        } else {
            int n4 = this.size - 1;
            for (int i = 0; i < n3; ++i) {
                lArray[n + i] = lArray[n4 - i];
            }
        }
        this.size -= n3;
    }

    public boolean removeAll(LongArray longArray) {
        int n;
        int n2 = n = this.size;
        long[] lArray = this.items;
        int n3 = longArray.size;
        block0: for (int i = 0; i < n3; ++i) {
            long l = longArray.get(i);
            for (int j = 0; j < n; ++j) {
                if (l != lArray[j]) continue;
                this.removeIndex(j);
                --n;
                continue block0;
            }
        }
        return n != n2;
    }

    public long pop() {
        return this.items[--this.size];
    }

    public long peek() {
        return this.items[this.size - 1];
    }

    public long first() {
        if (this.size == 0) {
            throw new IllegalStateException("Array is empty.");
        }
        return this.items[0];
    }

    public void clear() {
        this.size = 0;
    }

    public long[] shrink() {
        if (this.items.length != this.size) {
            this.resize(this.size);
        }
        return this.items;
    }

    public long[] ensureCapacity(int n) {
        int n2 = this.size + n;
        if (n2 > this.items.length) {
            this.resize(Math.max(8, n2));
        }
        return this.items;
    }

    public long[] setSize(int n) {
        if (n > this.items.length) {
            this.resize(Math.max(8, n));
        }
        this.size = n;
        return this.items;
    }

    protected long[] resize(int n) {
        long[] lArray = new long[n];
        long[] lArray2 = this.items;
        System.arraycopy(lArray2, 0, lArray, 0, Math.min(this.size, lArray.length));
        this.items = lArray;
        return lArray;
    }

    public void sort() {
        Arrays.sort(this.items, 0, this.size);
    }

    public void reverse() {
        long[] lArray = this.items;
        int n = this.size - 1;
        int n2 = this.size / 2;
        for (int i = 0; i < n2; ++i) {
            int n3 = n - i;
            long l = lArray[i];
            lArray[i] = lArray[n3];
            lArray[n3] = l;
        }
    }

    public void shuffle() {
        long[] lArray = this.items;
        for (int i = this.size - 1; i >= 0; --i) {
            int n = MathUtils.random(i);
            long l = lArray[i];
            lArray[i] = lArray[n];
            lArray[n] = l;
        }
    }

    public void truncate(int n) {
        if (this.size > n) {
            this.size = n;
        }
    }

    public long random() {
        if (this.size == 0) {
            return 0L;
        }
        return this.items[MathUtils.random(0, this.size - 1)];
    }

    public long[] toArray() {
        long[] lArray = new long[this.size];
        System.arraycopy(this.items, 0, lArray, 0, this.size);
        return lArray;
    }

    public int hashCode() {
        if (!this.ordered) {
            return super.hashCode();
        }
        long[] lArray = this.items;
        int n = 1;
        int n2 = this.size;
        for (int i = 0; i < n2; ++i) {
            n = n * 31 + (int)(lArray[i] ^ lArray[i] >>> 32);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!this.ordered) {
            return false;
        }
        if (!(object instanceof LongArray)) {
            return false;
        }
        LongArray longArray = (LongArray)object;
        if (!longArray.ordered) {
            return false;
        }
        int n = this.size;
        if (n != longArray.size) {
            return false;
        }
        long[] lArray = this.items;
        long[] lArray2 = longArray.items;
        for (int i = 0; i < n; ++i) {
            if (this.items[i] == longArray.items[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        long[] lArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        stringBuilder.append(lArray[0]);
        for (int i = 1; i < this.size; ++i) {
            stringBuilder.append(", ");
            stringBuilder.append(lArray[i]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public String toString(String string) {
        if (this.size == 0) {
            return "";
        }
        long[] lArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(lArray[0]);
        for (int i = 1; i < this.size; ++i) {
            stringBuilder.append(string);
            stringBuilder.append(lArray[i]);
        }
        return stringBuilder.toString();
    }

    public static LongArray with(long ... lArray) {
        return new LongArray(lArray);
    }
}

