/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.collections.array;

import com.fr.stable.collections.utils.MathUtils;
import java.util.Arrays;

public class IntArray {
    public int[] items;
    public int size;
    public boolean ordered;

    public IntArray() {
        this(true, 16);
    }

    public IntArray(int n) {
        this(true, n);
    }

    public IntArray(boolean bl, int n) {
        this.ordered = bl;
        this.items = new int[n];
    }

    public IntArray(IntArray intArray) {
        this.ordered = intArray.ordered;
        this.size = intArray.size;
        this.items = new int[this.size];
        System.arraycopy(intArray.items, 0, this.items, 0, this.size);
    }

    public IntArray(int[] nArray) {
        this(true, nArray, 0, nArray.length);
    }

    public IntArray(boolean bl, int[] nArray, int n, int n2) {
        this(bl, n2);
        this.size = n2;
        System.arraycopy(nArray, n, this.items, 0, n2);
    }

    public void add(int n) {
        int[] nArray = this.items;
        if (this.size == nArray.length) {
            nArray = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        nArray[this.size++] = n;
    }

    public void addAll(IntArray intArray) {
        this.addAll(intArray, 0, intArray.size);
    }

    public void addAll(IntArray intArray, int n, int n2) {
        if (n + n2 > intArray.size) {
            throw new IllegalArgumentException("offset + length must be <= size: " + n + " + " + n2 + " <= " + intArray.size);
        }
        this.addAll(intArray.items, n, n2);
    }

    public void addAll(int ... nArray) {
        this.addAll(nArray, 0, nArray.length);
    }

    public void addAll(int[] nArray, int n, int n2) {
        int n3 = this.size + n2;
        int[] nArray2 = this.items;
        if (n3 > nArray2.length) {
            nArray2 = this.resize(Math.max(8, (int)((float)n3 * 1.75f)));
        }
        System.arraycopy(nArray, n, nArray2, this.size, n2);
        this.size += n2;
    }

    public int get(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + n + " >= " + this.size);
        }
        return this.items[n];
    }

    public void set(int n, int n2) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + n + " >= " + this.size);
        }
        this.items[n] = n2;
    }

    public void incr(int n, int n2) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + n + " >= " + this.size);
        }
        int n3 = n;
        this.items[n3] = this.items[n3] + n2;
    }

    public void mul(int n, int n2) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + n + " >= " + this.size);
        }
        int n3 = n;
        this.items[n3] = this.items[n3] * n2;
    }

    public void insert(int n, int n2) {
        if (n > this.size) {
            throw new IndexOutOfBoundsException("index can't be > size: " + n + " > " + this.size);
        }
        int[] nArray = this.items;
        if (this.size == nArray.length) {
            nArray = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        if (this.ordered) {
            System.arraycopy(nArray, n, nArray, n + 1, this.size - n);
        } else {
            nArray[this.size] = nArray[n];
        }
        ++this.size;
        nArray[n] = n2;
    }

    public void swap(int n, int n2) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("first can't be >= size: " + n + " >= " + this.size);
        }
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException("second can't be >= size: " + n2 + " >= " + this.size);
        }
        int[] nArray = this.items;
        int n3 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = n3;
    }

    public boolean contains(int n) {
        int n2 = this.size - 1;
        int[] nArray = this.items;
        while (n2 >= 0) {
            if (nArray[n2--] != n) continue;
            return true;
        }
        return false;
    }

    public int indexOf(int n) {
        int[] nArray = this.items;
        int n2 = this.size;
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(int n) {
        int[] nArray = this.items;
        for (int i = this.size - 1; i >= 0; --i) {
            if (nArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    public boolean removeValue(int n) {
        int[] nArray = this.items;
        int n2 = this.size;
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] != n) continue;
            this.removeIndex(i);
            return true;
        }
        return false;
    }

    public int removeIndex(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + n + " >= " + this.size);
        }
        int[] nArray = this.items;
        int n2 = nArray[n];
        --this.size;
        if (this.ordered) {
            System.arraycopy(nArray, n + 1, nArray, n, this.size - n);
        } else {
            nArray[n] = nArray[this.size];
        }
        return n2;
    }

    public void removeRange(int n, int n2) {
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException("end can't be >= size: " + n2 + " >= " + this.size);
        }
        if (n > n2) {
            throw new IndexOutOfBoundsException("start can't be > end: " + n + " > " + n2);
        }
        int[] nArray = this.items;
        int n3 = n2 - n + 1;
        if (this.ordered) {
            System.arraycopy(nArray, n + n3, nArray, n, this.size - (n + n3));
        } else {
            int n4 = this.size - 1;
            for (int i = 0; i < n3; ++i) {
                nArray[n + i] = nArray[n4 - i];
            }
        }
        this.size -= n3;
    }

    public boolean removeAll(IntArray intArray) {
        int n;
        int n2 = n = this.size;
        int[] nArray = this.items;
        int n3 = intArray.size;
        block0: for (int i = 0; i < n3; ++i) {
            int n4 = intArray.get(i);
            for (int j = 0; j < n; ++j) {
                if (n4 != nArray[j]) continue;
                this.removeIndex(j);
                --n;
                continue block0;
            }
        }
        return n != n2;
    }

    public int pop() {
        return this.items[--this.size];
    }

    public int peek() {
        return this.items[this.size - 1];
    }

    public int first() {
        if (this.size == 0) {
            throw new IllegalStateException("Array is empty.");
        }
        return this.items[0];
    }

    public void clear() {
        this.size = 0;
    }

    public int[] shrink() {
        if (this.items.length != this.size) {
            this.resize(this.size);
        }
        return this.items;
    }

    public int[] ensureCapacity(int n) {
        int n2 = this.size + n;
        if (n2 > this.items.length) {
            this.resize(Math.max(8, n2));
        }
        return this.items;
    }

    public int[] setSize(int n) {
        if (n > this.items.length) {
            this.resize(Math.max(8, n));
        }
        this.size = n;
        return this.items;
    }

    protected int[] resize(int n) {
        int[] nArray = new int[n];
        int[] nArray2 = this.items;
        System.arraycopy(nArray2, 0, nArray, 0, Math.min(this.size, nArray.length));
        this.items = nArray;
        return nArray;
    }

    public void sort() {
        Arrays.sort(this.items, 0, this.size);
    }

    public void reverse() {
        int[] nArray = this.items;
        int n = this.size - 1;
        int n2 = this.size / 2;
        for (int i = 0; i < n2; ++i) {
            int n3 = n - i;
            int n4 = nArray[i];
            nArray[i] = nArray[n3];
            nArray[n3] = n4;
        }
    }

    public void shuffle() {
        int[] nArray = this.items;
        for (int i = this.size - 1; i >= 0; --i) {
            int n = MathUtils.random(i);
            int n2 = nArray[i];
            nArray[i] = nArray[n];
            nArray[n] = n2;
        }
    }

    public void truncate(int n) {
        if (this.size > n) {
            this.size = n;
        }
    }

    public int random() {
        if (this.size == 0) {
            return 0;
        }
        return this.items[MathUtils.random(0, this.size - 1)];
    }

    public int[] toArray() {
        int[] nArray = new int[this.size];
        System.arraycopy(this.items, 0, nArray, 0, this.size);
        return nArray;
    }

    public int hashCode() {
        if (!this.ordered) {
            return super.hashCode();
        }
        int[] nArray = this.items;
        int n = 1;
        int n2 = this.size;
        for (int i = 0; i < n2; ++i) {
            n = n * 31 + nArray[i];
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!this.ordered) {
            return false;
        }
        if (!(object instanceof IntArray)) {
            return false;
        }
        IntArray intArray = (IntArray)object;
        if (!intArray.ordered) {
            return false;
        }
        int n = this.size;
        if (n != intArray.size) {
            return false;
        }
        int[] nArray = this.items;
        int[] nArray2 = intArray.items;
        for (int i = 0; i < n; ++i) {
            if (this.items[i] == intArray.items[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        int[] nArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        stringBuilder.append(nArray[0]);
        for (int i = 1; i < this.size; ++i) {
            stringBuilder.append(", ");
            stringBuilder.append(nArray[i]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public String toString(String string) {
        if (this.size == 0) {
            return "";
        }
        int[] nArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(nArray[0]);
        for (int i = 1; i < this.size; ++i) {
            stringBuilder.append(string);
            stringBuilder.append(nArray[i]);
        }
        return stringBuilder.toString();
    }

    public static IntArray with(int ... nArray) {
        return new IntArray(nArray);
    }
}

