/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.collections.array;

import com.fr.stable.collections.utils.GdxRuntimeException;
import com.fr.stable.collections.utils.MathUtils;
import com.fr.stable.collections.utils.Predicate;
import com.fr.stable.collections.utils.Select;
import com.fr.stable.collections.utils.Sort;
import com.fr.stable.collections.utils.reflect.ArrayReflection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Array<T>
implements Iterable<T> {
    public T[] items;
    public int size;
    public boolean ordered;
    private ArrayIterable iterable;
    private Predicate.PredicateIterable<T> predicateIterable;

    public Array() {
        this(true, 16);
    }

    public Array(int n) {
        this(true, n);
    }

    public Array(boolean bl, int n) {
        this.ordered = bl;
        this.items = new Object[n];
    }

    public Array(boolean bl, int n, Class clazz) {
        this.ordered = bl;
        this.items = (Object[])ArrayReflection.newInstance(clazz, n);
    }

    public Array(Class clazz) {
        this(true, 16, clazz);
    }

    public Array(Array<? extends T> array) {
        this(array.ordered, array.size, array.items.getClass().getComponentType());
        this.size = array.size;
        System.arraycopy(array.items, 0, this.items, 0, this.size);
    }

    public Array(T[] TArray) {
        this(true, TArray, 0, TArray.length);
    }

    public Array(boolean bl, T[] TArray, int n, int n2) {
        this(bl, n2, TArray.getClass().getComponentType());
        this.size = n2;
        System.arraycopy(TArray, n, this.items, 0, this.size);
    }

    public void add(T t) {
        T[] TArray = this.items;
        if (this.size == TArray.length) {
            TArray = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        TArray[this.size++] = t;
    }

    public void addAll(Array<? extends T> array) {
        this.addAll(array, 0, array.size);
    }

    public void addAll(Array<? extends T> array, int n, int n2) {
        if (n + n2 > array.size) {
            throw new IllegalArgumentException("start + count must be <= size: " + n + " + " + n2 + " <= " + array.size);
        }
        this.addAll(array.items, n, n2);
    }

    public void addAll(T ... TArray) {
        this.addAll(TArray, 0, TArray.length);
    }

    public void addAll(T[] TArray, int n, int n2) {
        int n3 = this.size + n2;
        T[] TArray2 = this.items;
        if (n3 > TArray2.length) {
            TArray2 = this.resize(Math.max(8, (int)((float)n3 * 1.75f)));
        }
        System.arraycopy(TArray, n, TArray2, this.size, n2);
        this.size += n2;
    }

    public T get(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + n + " >= " + this.size);
        }
        return this.items[n];
    }

    public void set(int n, T t) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + n + " >= " + this.size);
        }
        this.items[n] = t;
    }

    public void insert(int n, T t) {
        if (n > this.size) {
            throw new IndexOutOfBoundsException("index can't be > size: " + n + " > " + this.size);
        }
        T[] TArray = this.items;
        if (this.size == TArray.length) {
            TArray = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        if (this.ordered) {
            System.arraycopy(TArray, n, TArray, n + 1, this.size - n);
        } else {
            TArray[this.size] = TArray[n];
        }
        ++this.size;
        TArray[n] = t;
    }

    public void swap(int n, int n2) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("first can't be >= size: " + n + " >= " + this.size);
        }
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException("second can't be >= size: " + n2 + " >= " + this.size);
        }
        T[] TArray = this.items;
        T t = TArray[n];
        TArray[n] = TArray[n2];
        TArray[n2] = t;
    }

    public boolean contains(T t, boolean bl) {
        T[] TArray = this.items;
        int n = this.size - 1;
        if (bl || t == null) {
            while (n >= 0) {
                if (TArray[n--] != t) continue;
                return true;
            }
        } else {
            while (n >= 0) {
                if (!t.equals(TArray[n--])) continue;
                return true;
            }
        }
        return false;
    }

    public int indexOf(T t, boolean bl) {
        T[] TArray = this.items;
        if (bl || t == null) {
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (TArray[i] != t) continue;
                return i;
            }
        } else {
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (!t.equals(TArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public int lastIndexOf(T t, boolean bl) {
        T[] TArray = this.items;
        if (bl || t == null) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (TArray[i] != t) continue;
                return i;
            }
        } else {
            for (int i = this.size - 1; i >= 0; --i) {
                if (!t.equals(TArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public boolean removeValue(T t, boolean bl) {
        T[] TArray = this.items;
        if (bl || t == null) {
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (TArray[i] != t) continue;
                this.removeIndex(i);
                return true;
            }
        } else {
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (!t.equals(TArray[i])) continue;
                this.removeIndex(i);
                return true;
            }
        }
        return false;
    }

    public T removeIndex(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + n + " >= " + this.size);
        }
        T[] TArray = this.items;
        T t = TArray[n];
        --this.size;
        if (this.ordered) {
            System.arraycopy(TArray, n + 1, TArray, n, this.size - n);
        } else {
            TArray[n] = TArray[this.size];
        }
        TArray[this.size] = null;
        return t;
    }

    public void removeRange(int n, int n2) {
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException("end can't be >= size: " + n2 + " >= " + this.size);
        }
        if (n > n2) {
            throw new IndexOutOfBoundsException("start can't be > end: " + n + " > " + n2);
        }
        T[] TArray = this.items;
        int n3 = n2 - n + 1;
        if (this.ordered) {
            System.arraycopy(TArray, n + n3, TArray, n, this.size - (n + n3));
        } else {
            int n4 = this.size - 1;
            for (int i = 0; i < n3; ++i) {
                TArray[n + i] = TArray[n4 - i];
            }
        }
        this.size -= n3;
    }

    public boolean removeAll(Array<? extends T> array, boolean bl) {
        int n;
        int n2 = n = this.size;
        T[] TArray = this.items;
        if (bl) {
            int n3 = array.size;
            block0: for (int i = 0; i < n3; ++i) {
                T t = array.get(i);
                for (int j = 0; j < n; ++j) {
                    if (t != TArray[j]) continue;
                    this.removeIndex(j);
                    --n;
                    continue block0;
                }
            }
        } else {
            int n4 = array.size;
            block2: for (int i = 0; i < n4; ++i) {
                T t = array.get(i);
                for (int j = 0; j < n; ++j) {
                    if (!t.equals(TArray[j])) continue;
                    this.removeIndex(j);
                    --n;
                    continue block2;
                }
            }
        }
        return n != n2;
    }

    public T pop() {
        if (this.size == 0) {
            throw new IllegalStateException("Array is empty.");
        }
        --this.size;
        T t = this.items[this.size];
        this.items[this.size] = null;
        return t;
    }

    public T peek() {
        if (this.size == 0) {
            throw new IllegalStateException("Array is empty.");
        }
        return this.items[this.size - 1];
    }

    public T first() {
        if (this.size == 0) {
            throw new IllegalStateException("Array is empty.");
        }
        return this.items[0];
    }

    public void clear() {
        T[] TArray = this.items;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            TArray[i] = null;
        }
        this.size = 0;
    }

    public T[] shrink() {
        if (this.items.length != this.size) {
            this.resize(this.size);
        }
        return this.items;
    }

    public T[] ensureCapacity(int n) {
        int n2 = this.size + n;
        if (n2 > this.items.length) {
            this.resize(Math.max(8, n2));
        }
        return this.items;
    }

    public T[] setSize(int n) {
        this.truncate(n);
        if (n > this.items.length) {
            this.resize(Math.max(8, n));
        }
        this.size = n;
        return this.items;
    }

    protected T[] resize(int n) {
        T[] TArray = this.items;
        Object[] objectArray = (Object[])ArrayReflection.newInstance(TArray.getClass().getComponentType(), n);
        System.arraycopy(TArray, 0, objectArray, 0, Math.min(this.size, objectArray.length));
        this.items = objectArray;
        return objectArray;
    }

    public void sort() {
        Sort.instance().sort(this.items, 0, this.size);
    }

    public void sort(Comparator<? super T> comparator) {
        Sort.instance().sort(this.items, comparator, 0, this.size);
    }

    public T selectRanked(Comparator<T> comparator, int n) {
        if (n < 1) {
            throw new GdxRuntimeException("nth_lowest must be greater than 0, 1 = first, 2 = second...");
        }
        return Select.instance().select(this.items, comparator, n, this.size);
    }

    public int selectRankedIndex(Comparator<T> comparator, int n) {
        if (n < 1) {
            throw new GdxRuntimeException("nth_lowest must be greater than 0, 1 = first, 2 = second...");
        }
        return Select.instance().selectIndex(this.items, comparator, n, this.size);
    }

    public void reverse() {
        T[] TArray = this.items;
        int n = this.size - 1;
        int n2 = this.size / 2;
        for (int i = 0; i < n2; ++i) {
            int n3 = n - i;
            T t = TArray[i];
            TArray[i] = TArray[n3];
            TArray[n3] = t;
        }
    }

    public void shuffle() {
        T[] TArray = this.items;
        for (int i = this.size - 1; i >= 0; --i) {
            int n = MathUtils.random(i);
            T t = TArray[i];
            TArray[i] = TArray[n];
            TArray[n] = t;
        }
    }

    @Override
    public Iterator<T> iterator() {
        if (this.iterable == null) {
            this.iterable = new ArrayIterable(this);
        }
        return this.iterable.iterator();
    }

    public Iterable<T> select(Predicate<T> predicate) {
        if (this.predicateIterable == null) {
            this.predicateIterable = new Predicate.PredicateIterable<T>(this, predicate);
        } else {
            this.predicateIterable.set(this, predicate);
        }
        return this.predicateIterable;
    }

    public void truncate(int n) {
        if (this.size <= n) {
            return;
        }
        for (int i = n; i < this.size; ++i) {
            this.items[i] = null;
        }
        this.size = n;
    }

    public T random() {
        if (this.size == 0) {
            return null;
        }
        return this.items[MathUtils.random(0, this.size - 1)];
    }

    public T[] toArray() {
        return this.toArray(this.items.getClass().getComponentType());
    }

    public <V> V[] toArray(Class clazz) {
        Object[] objectArray = (Object[])ArrayReflection.newInstance(clazz, this.size);
        System.arraycopy(this.items, 0, objectArray, 0, this.size);
        return objectArray;
    }

    public int hashCode() {
        if (!this.ordered) {
            return super.hashCode();
        }
        T[] TArray = this.items;
        int n = 1;
        int n2 = this.size;
        for (int i = 0; i < n2; ++i) {
            n *= 31;
            T t = TArray[i];
            if (t == null) continue;
            n += t.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!this.ordered) {
            return false;
        }
        if (!(object instanceof Array)) {
            return false;
        }
        Array array = (Array)object;
        if (!array.ordered) {
            return false;
        }
        int n = this.size;
        if (n != array.size) {
            return false;
        }
        T[] TArray = this.items;
        T[] TArray2 = array.items;
        for (int i = 0; i < n; ++i) {
            T t = TArray[i];
            T t2 = TArray2[i];
            if (t != null ? t.equals(t2) : t2 == null) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        T[] TArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        stringBuilder.append(TArray[0]);
        for (int i = 1; i < this.size; ++i) {
            stringBuilder.append(", ");
            stringBuilder.append(TArray[i]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public String toString(String string) {
        if (this.size == 0) {
            return "";
        }
        T[] TArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(TArray[0]);
        for (int i = 1; i < this.size; ++i) {
            stringBuilder.append(string);
            stringBuilder.append(TArray[i]);
        }
        return stringBuilder.toString();
    }

    public static <T> Array<T> of(Class<T> clazz) {
        return new Array<T>(clazz);
    }

    public static <T> Array<T> of(boolean bl, int n, Class<T> clazz) {
        return new Array<T>(bl, n, clazz);
    }

    public static <T> Array<T> with(T ... TArray) {
        return new Array<T>(TArray);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ArrayIterable<T>
    implements Iterable<T> {
        private final Array<T> array;
        private final boolean allowRemove;
        private ArrayIterator iterator1;
        private ArrayIterator iterator2;

        public ArrayIterable(Array<T> array) {
            this(array, true);
        }

        public ArrayIterable(Array<T> array, boolean bl) {
            this.array = array;
            this.allowRemove = bl;
        }

        @Override
        public Iterator<T> iterator() {
            if (this.iterator1 == null) {
                this.iterator1 = new ArrayIterator<T>(this.array, this.allowRemove);
                this.iterator2 = new ArrayIterator<T>(this.array, this.allowRemove);
            }
            if (!this.iterator1.valid) {
                this.iterator1.index = 0;
                this.iterator1.valid = true;
                this.iterator2.valid = false;
                return this.iterator1;
            }
            this.iterator2.index = 0;
            this.iterator2.valid = true;
            this.iterator1.valid = false;
            return this.iterator2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ArrayIterator<T>
    implements Iterator<T>,
    Iterable<T> {
        private final Array<T> array;
        private final boolean allowRemove;
        int index;
        boolean valid = true;

        public ArrayIterator(Array<T> array) {
            this(array, true);
        }

        public ArrayIterator(Array<T> array, boolean bl) {
            this.array = array;
            this.allowRemove = bl;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.index < this.array.size;
        }

        @Override
        public T next() {
            if (this.index >= this.array.size) {
                throw new NoSuchElementException(String.valueOf(this.index));
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.array.items[this.index++];
        }

        @Override
        public void remove() {
            if (!this.allowRemove) {
                throw new GdxRuntimeException("Remove not allowed.");
            }
            --this.index;
            this.array.removeIndex(this.index);
        }

        public void reset() {
            this.index = 0;
        }

        @Override
        public Iterator<T> iterator() {
            return this;
        }
    }
}

