/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.bridge.event;

import com.fr.stable.bridge.event.StableFactoryCustomer;
import com.fr.stable.bridge.event.StableFactoryProducer;
import com.fr.stable.bridge.event.StableFactoryResourceType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StableFactoryMessageTransponder {
    private static final StableFactoryMessageTransponder TRANSPONDER = new StableFactoryMessageTransponder();
    private Map<StableFactoryResourceType, LinkedHashSet<StableFactoryProducer>> producerMap = new HashMap<StableFactoryResourceType, LinkedHashSet<StableFactoryProducer>>();
    private final Object producerLock = new Object();
    private Map<StableFactoryResourceType, Set<StableFactoryCustomer>> customerMap = new HashMap<StableFactoryResourceType, Set<StableFactoryCustomer>>();
    private final Object customerLock = new Object();

    private StableFactoryMessageTransponder() {
    }

    public static StableFactoryMessageTransponder getInstance() {
        return TRANSPONDER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProducer(StableFactoryProducer stableFactoryProducer, StableFactoryResourceType stableFactoryResourceType) {
        if (stableFactoryProducer == null) {
            return;
        }
        Object object = this.producerLock;
        synchronized (object) {
            LinkedHashSet<StableFactoryProducer> linkedHashSet = this.producerMap.get((Object)stableFactoryResourceType);
            if (linkedHashSet == null) {
                linkedHashSet = new LinkedHashSet();
                this.producerMap.put(stableFactoryResourceType, linkedHashSet);
            }
            linkedHashSet.add(stableFactoryProducer);
        }
    }

    public void requestReInject(StableFactoryResourceType stableFactoryResourceType) {
        Set set = this.producerMap.get((Object)stableFactoryResourceType);
        if (set != null) {
            this.fireReInject(set, stableFactoryResourceType);
        }
    }

    public void informResourceUpdated(StableFactoryResourceType stableFactoryResourceType) {
        Set<StableFactoryCustomer> set = this.customerMap.get((Object)stableFactoryResourceType);
        if (set != null) {
            for (StableFactoryCustomer stableFactoryCustomer : set) {
                stableFactoryCustomer.resourceUpdated(stableFactoryResourceType);
            }
        }
    }

    private void fireReInject(Set<StableFactoryProducer> set, StableFactoryResourceType stableFactoryResourceType) {
        for (StableFactoryProducer stableFactoryProducer : set) {
            stableFactoryProducer.reInject(stableFactoryResourceType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCustomer(StableFactoryCustomer stableFactoryCustomer, StableFactoryResourceType stableFactoryResourceType) {
        if (stableFactoryCustomer == null) {
            return;
        }
        Object object = this.customerLock;
        synchronized (object) {
            Set<StableFactoryCustomer> set = this.customerMap.get((Object)stableFactoryResourceType);
            if (set == null) {
                set = new HashSet<StableFactoryCustomer>();
                this.customerMap.put(stableFactoryResourceType, set);
            }
            set.add(stableFactoryCustomer);
        }
    }

    public void addProducer(StableFactoryProducer stableFactoryProducer, StableFactoryResourceType[] stableFactoryResourceTypeArray) {
        if (stableFactoryResourceTypeArray == null) {
            return;
        }
        for (StableFactoryResourceType stableFactoryResourceType : stableFactoryResourceTypeArray) {
            this.addProducer(stableFactoryProducer, stableFactoryResourceType);
        }
    }

    public void addCustomer(StableFactoryCustomer stableFactoryCustomer, StableFactoryResourceType[] stableFactoryResourceTypeArray) {
        if (stableFactoryResourceTypeArray == null) {
            return;
        }
        for (StableFactoryResourceType stableFactoryResourceType : stableFactoryResourceTypeArray) {
            this.addCustomer(stableFactoryCustomer, stableFactoryResourceType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCustomer(StableFactoryCustomer stableFactoryCustomer) {
        Object object = this.customerLock;
        synchronized (object) {
            for (Map.Entry<StableFactoryResourceType, Set<StableFactoryCustomer>> entry : this.customerMap.entrySet()) {
                entry.getValue().remove(stableFactoryCustomer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProducer(StableFactoryProducer stableFactoryProducer) {
        Object object = this.producerLock;
        synchronized (object) {
            for (Map.Entry<StableFactoryResourceType, LinkedHashSet<StableFactoryProducer>> entry : this.producerMap.entrySet()) {
                entry.getValue().remove(stableFactoryProducer);
            }
        }
    }
}

