/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable;

import com.fr.stable.ColumnRowRelated;
import com.fr.stable.StableUtils;
import com.fr.stable.script.CalculatorKey;
import java.io.Serializable;

public class ColumnRow
implements Serializable,
Cloneable,
ColumnRowRelated {
    public static CalculatorKey CURRENT_CR_KEY = CalculatorKey.createKey("CURRENT_CR");
    private static final int CACHE_COLUMN = 50;
    private static final int CACHE_ROW = 10000;
    public final int column;
    public final int row;
    public static final ColumnRow ERROR = new ColumnRow(-1, -1);

    public static ColumnRow valueOf(int n, int n2) {
        if (ColumnRow.isInCache(n, n2)) {
            return ColumnRowCache.CACHE[n][n2];
        }
        return new ColumnRow(n, n2);
    }

    private static boolean isInCache(int n, int n2) {
        return n >= 0 && n < 50 && n2 >= 0 && n2 < 10000;
    }

    public static ColumnRow valueOf(String string) {
        ColumnRow columnRow = ERROR;
        try {
            char[] cArray = string.trim().toCharArray();
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                char c = cArray[i];
                if (!StableUtils.isNum(c)) continue;
                if (i > 0) {
                    String string2 = new String(cArray, 0, i);
                    String string3 = new String(cArray, i, n - i);
                    columnRow = ColumnRow.valueOf(StableUtils.convertABCToInt(string2) - 1, Integer.parseInt(string3) - 1);
                }
                break;
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return columnRow;
    }

    public static boolean validate(ColumnRow columnRow) {
        return columnRow != null && columnRow.getColumn() >= 0 && columnRow.getRow() >= 0;
    }

    protected ColumnRow(int n, int n2) {
        this.column = n;
        this.row = n2;
    }

    public int getColumn() {
        return this.column;
    }

    public int getRow() {
        return this.row;
    }

    public ColumnRow[] getRelatedColumnRows() {
        return new ColumnRow[]{this};
    }

    public String toString() {
        return StableUtils.convertIntToABC(this.column + 1) + (this.row + 1);
    }

    public String stateDescription() {
        return this.toString() + "_value_state";
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.column;
        n = 37 * n + this.row;
        return n;
    }

    public boolean equals(Object object) {
        return object instanceof ColumnRow && ((ColumnRow)object).row == this.row && ((ColumnRow)object).column == this.column;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private static class ColumnRowCache {
        static final ColumnRow[][] CACHE = new ColumnRow[50][10000];

        private ColumnRowCache() {
        }

        static {
            for (int i = 0; i < CACHE.length; ++i) {
                int n = CACHE[i].length;
                for (int j = 0; j < n; ++j) {
                    ColumnRowCache.CACHE[i][j] = new ColumnRow(i, j);
                }
            }
        }
    }
}

