/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable;

import com.fr.stable.StringUtils;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.fun.CustomPasswordCryptProcessor;
import com.fr.stable.plugin.ExtraClassManagerProvider;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CodeUtils {
    public static final int ENCODE_LEN = 4;
    public static final int HEX = 16;
    public static final double COEFFICIENT = 1.5;
    public static final int ASC_CODE_A = 65;
    public static final int ASC_CODE_Z = 90;
    public static final int ASC_CODEA = 97;
    public static final int ASC_CODEZ = 122;
    public static final int ASC_CODE_0 = 48;
    public static final int ASC_CODE_9 = 57;
    public static final int ASC_CODE_DEL = 127;
    public static final int ASC_CODE_LEFT_BRACKET = 91;
    public static final int ASC_CODE_RIGHT_BRACKET = 93;
    public static final int EIGHTTIMES2 = 256;
    private static final String[] HEXDIGITS;
    private static Pattern bracketPattern;
    private static Pattern textPattern;
    private static Pattern blankPattern;
    private static int JUDGE_HELPER_LEN;
    private static final boolean[] JUDGE_HELPER;
    private static final char[] APPEND_HELPER;
    private static final int COPYRIGHT_HELPER_LEN = 9000;
    private static final boolean[] COPYRIGHT_HELPER;
    private static final int[] PASSWORD_MASK_ARRAY;

    private CodeUtils() {
    }

    public static String javascriptEncode(String string) {
        StringBuilderHelper stringBuilderHelper = new StringBuilderHelper(string);
        if (StringUtils.isNotEmpty(string)) {
            char c = '\u0000';
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c2 = c;
                c = string.charAt(i);
                if (c < JUDGE_HELPER_LEN && c > '\uffffffff') {
                    if (JUDGE_HELPER[c]) {
                        stringBuilderHelper.append('\\', i);
                        stringBuilderHelper.append(CodeUtils.APPEND_HELPER[c], i);
                        stringBuilderHelper.move();
                        continue;
                    }
                    if (c == '/') {
                        if (c2 == '<') {
                            stringBuilderHelper.append('\\', i);
                        }
                        stringBuilderHelper.append(c, i);
                        stringBuilderHelper.move();
                        continue;
                    }
                }
                if (!CodeUtils.isCopyRightSymbol(c)) continue;
                String string2 = "000" + Integer.toHexString(c);
                stringBuilderHelper.append('\\', i);
                stringBuilderHelper.append('u', i).append(string2.substring(string2.length() - 4), i);
                stringBuilderHelper.move();
            }
        } else {
            return "";
        }
        return stringBuilderHelper.toString();
    }

    public static final boolean isCopyRightSymbol(char c) {
        return c < '\u2328' && c > '\uffffffff' && COPYRIGHT_HELPER[c] || c < '\u0000';
    }

    public static String javascriptDecode(String string) {
        return CodeUtils.encodeString(string, new String[][]{{"\\", "'", "\""}, {"\\\\", "\\'", "\\\""}});
    }

    public static String encodeString(String string, String[][] stringArray) {
        if (string == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        block0: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            for (int j = 0; j < stringArray[1].length; ++j) {
                if (c != stringArray[1][j].charAt(0)) continue;
                stringBuilder.append(stringArray[0][j]);
                continue block0;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String encodeURIComponent(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return CodeUtils.encodeString(string, new String[][]{{"%20", "%23", "%24", "%26", "%2B", "%2C", "%2F", "%3A", "%3B", "%3D", "%3F", "%40", "%25"}, {" ", "#", "$", "&", "+", ",", "/", ":", ";", "=", "?", "@", "%"}});
        }
    }

    public static String attributeHtmlEncode(CharSequence charSequence) {
        if (charSequence == null) {
            return "";
        }
        int n = charSequence.length();
        StringBuffer stringBuffer = new StringBuffer((int)((double)n * 1.5));
        for (int i = 0; i < n; ++i) {
            char c = charSequence.charAt(i);
            if (CodeUtils.isLetterOrNumber(c)) {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append("&#").append((int)c).append(';');
        }
        return stringBuffer.toString();
    }

    public static String attributeHtmlDecode(CharSequence charSequence) {
        if (charSequence == null) {
            return "";
        }
        int n = charSequence.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            int n2;
            char c = charSequence.charAt(i);
            boolean bl = false;
            if (c == '&' && i + 1 < n && charSequence.charAt(i + 1) == '#' && (n2 = charSequence.toString().indexOf(";", i + 1)) != -1 && n2 < i + 3 + 3) {
                String string = charSequence.subSequence(i + 2, n2).toString();
                char c2 = (char)Integer.parseInt(string);
                stringBuilder.append(c2);
                i = n2;
                bl = true;
            }
            if (bl) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private static boolean isLetterOrNumber(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9';
    }

    public static String htmlEncode(CharSequence charSequence) {
        if (charSequence == null) {
            return "";
        }
        int n = charSequence.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            char c = charSequence.charAt(i);
            i = CodeUtils.dealWithChar(c, stringBuilder, n, i, charSequence);
        }
        return CodeUtils.replaceBlankToHtmlBlank(stringBuilder.toString());
    }

    private static int dealWithChar(char c, StringBuilder stringBuilder, int n, int n2, CharSequence charSequence) {
        switch (c) {
            case '<': {
                stringBuilder.append("&lt;");
                break;
            }
            case '>': {
                stringBuilder.append("&gt;");
                break;
            }
            case '&': {
                stringBuilder.append("&amp;");
                break;
            }
            case '\"': {
                stringBuilder.append("&quot;");
                break;
            }
            case '\r': {
                if (n2 + 1 < n && charSequence.charAt(n2 + 1) == '\n') {
                    ++n2;
                }
                stringBuilder.append("<br>");
                break;
            }
            case '\\': {
                if (n2 + 1 < n && charSequence.charAt(n2 + 1) == 'n') {
                    ++n2;
                    stringBuilder.append("<br>");
                    break;
                }
                if (n2 + 1 < n && charSequence.charAt(n2 + 1) == '\\') {
                    ++n2;
                }
                stringBuilder.append(c);
                break;
            }
            case '\n': {
                stringBuilder.append("<br>");
                break;
            }
            default: {
                stringBuilder.append(c);
            }
        }
        return n2;
    }

    private static String replaceBlankToHtmlBlank(String string) {
        Matcher matcher = blankPattern.matcher(string);
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        while (matcher.find()) {
            n2 = matcher.start();
            stringBuffer.append(string.substring(n, n2));
            n = matcher.end();
            String string2 = matcher.group();
            stringBuffer.append(" ");
            int n3 = string2.length();
            if (n3 <= 1) continue;
            for (int i = n3; i > 1; --i) {
                stringBuffer.append("&nbsp;");
            }
            stringBuffer.append(" ");
        }
        if (n == 0) {
            return string;
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    public static String cjkEncode(String string) {
        if (string == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (CodeUtils.needToEncode(c)) {
                stringBuilder.append('[');
                stringBuilder.append(Integer.toString(c, 16));
                stringBuilder.append(']');
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private static boolean needToEncode(char c) {
        return c > '\u007f' || c == '[' || c == ']';
    }

    public static String cjkDecode(String string) throws Exception {
        if (string == null) {
            return "";
        }
        if (!CodeUtils.isCJKEncoded(string)) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            int n;
            char c = string.charAt(i);
            if (c == '[' && (n = string.indexOf(93, i + 1)) > i + 1) {
                String string2 = string.substring(i + 1, n);
                if (string2.length() > 0) {
                    c = (char)Integer.parseInt(string2, 16);
                }
                i = n;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static boolean isCJKEncoded(String string) {
        boolean bl = false;
        if (string == null) {
            return false;
        }
        Matcher matcher = bracketPattern.matcher(string);
        while (matcher.find()) {
            int n;
            bl = true;
            int n2 = matcher.start();
            String string2 = string.substring(n2 + 1, (n = matcher.end()) - 1);
            if (textPattern.matcher(string2).matches()) continue;
            return false;
        }
        return bl;
    }

    public static String passwordEncode(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("___");
        if (string == null) {
            return stringBuilder.toString();
        }
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (n == PASSWORD_MASK_ARRAY.length) {
                n = 0;
            }
            int n2 = string.charAt(i) ^ PASSWORD_MASK_ARRAY[n];
            String string2 = Integer.toHexString(n2);
            int n3 = string2.length();
            for (int j = 0; j < 4 - n3; ++j) {
                string2 = "0" + string2;
            }
            stringBuilder.append(string2);
            ++n;
        }
        return stringBuilder.toString();
    }

    public static String passwordDecode(String string) {
        if (string != null && string.startsWith("___")) {
            string = string.substring(3);
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            for (int i = 0; i <= string.length() - 4; i += 4) {
                if (n == PASSWORD_MASK_ARRAY.length) {
                    n = 0;
                }
                String string2 = string.substring(i, i + 4);
                int n2 = Integer.parseInt(string2, 16) ^ PASSWORD_MASK_ARRAY[n];
                stringBuilder.append((char)n2);
                ++n;
            }
            string = stringBuilder.toString();
        }
        return string;
    }

    public static String decodeText(String string) {
        if (string == null) {
            return null;
        }
        if (CodeUtils.isCJKEncoded(string)) {
            try {
                return CodeUtils.cjkDecode(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    public static String md5Encode(String string, Object object, String string2) {
        try {
            String string3;
            MessageDigest messageDigest = MessageDigest.getInstance(string2);
            String string4 = string3 = string == null ? "" : string;
            if (object != null && StringUtils.isNotEmpty(object.toString())) {
                string3 = string3 + "{" + object.toString() + "}";
            }
            byte[] byArray = messageDigest.digest(string3.getBytes("UTF-8"));
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < byArray.length; ++i) {
                stringBuilder.append(CodeUtils.byteToHexString(byArray[i]));
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String byteToHexString(byte n) {
        int n2 = n;
        if (n2 < 0) {
            n2 = 256 + n2;
        }
        int n3 = n2 / 16;
        int n4 = n2 % 16;
        return HEXDIGITS[n3] + HEXDIGITS[n4];
    }

    public static String customPasswordEncode(String string) {
        CustomPasswordCryptProcessor customPasswordCryptProcessor;
        ExtraClassManagerProvider extraClassManagerProvider = StableFactory.getMarkedObject("ExtraClassManager", ExtraClassManagerProvider.class);
        if (extraClassManagerProvider != null && (customPasswordCryptProcessor = (CustomPasswordCryptProcessor)extraClassManagerProvider.getSingle("CustomPasswordCryptProcessor")) != null) {
            return customPasswordCryptProcessor.encodePassword(string);
        }
        return CodeUtils.passwordEncode(string);
    }

    public static void main(String[] stringArray) {
    }

    static {
        int n;
        HEXDIGITS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
        bracketPattern = Pattern.compile("\\[[^\\]]*\\]");
        textPattern = Pattern.compile("[0-9a-f]{2,4}", 2);
        blankPattern = Pattern.compile("\\s+");
        JUDGE_HELPER_LEN = 100;
        JUDGE_HELPER = new boolean[JUDGE_HELPER_LEN];
        APPEND_HELPER = new char[JUDGE_HELPER_LEN];
        CodeUtils.JUDGE_HELPER[92] = true;
        CodeUtils.APPEND_HELPER[92] = 92;
        CodeUtils.JUDGE_HELPER[34] = true;
        CodeUtils.APPEND_HELPER[34] = 34;
        CodeUtils.JUDGE_HELPER[9] = true;
        CodeUtils.APPEND_HELPER[9] = 116;
        CodeUtils.JUDGE_HELPER[10] = true;
        CodeUtils.APPEND_HELPER[10] = 110;
        CodeUtils.JUDGE_HELPER[13] = true;
        CodeUtils.APPEND_HELPER[13] = 114;
        CodeUtils.JUDGE_HELPER[12] = true;
        CodeUtils.APPEND_HELPER[12] = 102;
        CodeUtils.JUDGE_HELPER[8] = true;
        CodeUtils.APPEND_HELPER[8] = 98;
        COPYRIGHT_HELPER = new boolean[9000];
        for (n = 0; n < 32; ++n) {
            CodeUtils.COPYRIGHT_HELPER[n] = true;
        }
        for (n = 128; n < 160; ++n) {
            CodeUtils.COPYRIGHT_HELPER[n] = true;
        }
        for (n = 8192; n < 8448; ++n) {
            CodeUtils.COPYRIGHT_HELPER[n] = true;
        }
        CodeUtils.COPYRIGHT_HELPER[169] = true;
        CodeUtils.COPYRIGHT_HELPER[174] = true;
        PASSWORD_MASK_ARRAY = new int[]{19, 78, 10, 15, 100, 213, 43, 23};
    }

    private static final class StringBuilderHelper {
        private StringBuilder sb;
        private String baseString;
        private int start = 0;

        private StringBuilderHelper(String string) {
            this.baseString = string;
        }

        private void initSB(int n) {
            if (this.sb == null) {
                this.sb = new StringBuilder(this.baseString.length());
            }
            if (this.start != n) {
                this.sb.append(this.baseString, this.start, n);
                this.start = n;
            }
        }

        private StringBuilderHelper append(char c, int n) {
            this.initSB(n);
            this.sb.append(c);
            return this;
        }

        private void move() {
            ++this.start;
        }

        private StringBuilderHelper append(String string, int n) {
            this.initSB(n);
            this.sb.append(string);
            return this;
        }

        public String toString() {
            if (this.sb == null) {
                return this.baseString;
            }
            this.initSB(this.baseString.length());
            return this.sb.toString();
        }
    }
}

