/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.dependence;

import com.fr.general.GeneralContext;
import com.fr.plugin.dependence.PluginServiceCreator;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.web.ServletContext;
import com.fr.stable.web.ServletContextAdapter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class PluginServiceManager {
    public static PluginServiceManager serviceManager = new PluginServiceManager();
    Map<String, PluginServiceCreator> serviceMap = new HashMap<String, PluginServiceCreator>();

    public void addService(String string, PluginServiceCreator pluginServiceCreator) {
        this.serviceMap.put(string, pluginServiceCreator);
    }

    public static PluginServiceCreator getService(String string) {
        PluginServiceCreator pluginServiceCreator = PluginServiceManager.serviceManager.serviceMap.get(string);
        return pluginServiceCreator;
    }

    private static synchronized void envChanged() {
        serviceManager.destroyService();
    }

    public void destroyService() {
        Set<Map.Entry<String, PluginServiceCreator>> set = this.serviceMap.entrySet();
        for (Map.Entry<String, PluginServiceCreator> entry : set) {
            PluginServiceCreator pluginServiceCreator = entry.getValue();
            pluginServiceCreator.destroyService();
        }
        this.serviceMap = new HashMap<String, PluginServiceCreator>();
    }

    private void cleanServiceInfo() {
        Set<Map.Entry<String, PluginServiceCreator>> set = this.serviceMap.entrySet();
        for (Map.Entry<String, PluginServiceCreator> entry : set) {
            PluginServiceCreator pluginServiceCreator = entry.getValue();
            pluginServiceCreator.cleanServiceLog();
        }
    }

    public static boolean serviceStarted(String string) {
        PluginServiceCreator pluginServiceCreator = PluginServiceManager.serviceManager.serviceMap.get(string);
        return pluginServiceCreator != null;
    }

    static {
        ServletContext.addServletContextListener(new ServletContextAdapter(){

            public void onServletStart() {
            }

            public void onServletStop() {
                if (serviceManager != null) {
                    serviceManager.cleanServiceInfo();
                    serviceManager.destroyService();
                }
            }
        });
        GeneralContext.addEnvChangedListener(new EnvChangedListener(){

            public void envChanged() {
                PluginServiceManager.envChanged();
            }
        });
    }
}

