/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.dependence;

import com.fr.base.FRContext;
import com.fr.base.io.XMLReadHelper;
import com.fr.general.FRLogger;
import com.fr.general.IOUtils;
import com.fr.general.Inter;
import com.fr.plugin.Plugin;
import com.fr.plugin.PluginLoader;
import com.fr.plugin.dependence.PluginDependenceType;
import com.fr.plugin.dependence.PluginServiceCreator;
import com.fr.plugin.dependence.PluginServiceManager;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;

public class PluginDependenceUnit
implements XMLReadable,
Serializable {
    private static final String XML_TAG = "Item";
    private String dependenceID;
    private PluginDependenceType dependenceType;
    private String dependenceDir;
    private String serviceClazz;
    private PluginServiceCreator service = null;

    public String getDependenceDir() {
        return this.dependenceDir;
    }

    public PluginDependenceType getDependenceType() {
        return this.dependenceType;
    }

    public boolean checkFileEnv() {
        if (this.dependenceType == PluginDependenceType.RESOURCE_FILE || this.dependenceType == PluginDependenceType.SERVICE) {
            return this.checkPath(this.dependenceDir);
        }
        return true;
    }

    public boolean isPlugin() {
        return this.dependenceType == PluginDependenceType.PLUGIN;
    }

    public String getDependenceID() {
        return this.dependenceID;
    }

    public void checkDependExist(String string) {
        String string2 = this.getDependenceID();
        Plugin plugin = this.findFromLoadedPlugins(string);
        switch (this.dependenceType) {
            case PLUGIN: {
                Plugin plugin2 = this.findFromLoadedPlugins(string2);
                if (plugin2 != null) break;
                try {
                    this.readDependPlugin();
                }
                catch (Exception exception) {
                    FRContext.getLogger().error(plugin.getName() + Inter.getLocText("FR-Plugin-Dependence_Plugin_Not_Found") + string2);
                }
                break;
            }
            case RESOURCE_FILE: {
                if (this.checkFileEnv()) break;
                FRContext.getLogger().error(plugin.getName() + Inter.getLocText("FR-Plugin-Dependence_File_Not_Found") + string2);
                break;
            }
            case SERVICE: {
                if (this.checkFileEnv()) break;
                FRContext.getLogger().error(plugin.getName() + Inter.getLocText("FR-Plugin-Dependence_Service_Not_Found") + string2);
                break;
            }
        }
    }

    private void readDependPlugin() throws Exception {
        if (StringUtils.isNotEmpty(this.dependenceDir)) {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(this.dependenceDir);
            if (inputStream != null) {
                XMLableReader xMLableReader = XMLReadHelper.createXMLableReader(inputStream, "UTF-8");
                Plugin plugin = new Plugin(this.dependenceID);
                xMLableReader.readXMLObject(plugin);
                if (plugin.checkIfJarExpired()) {
                    FRLogger.getLogger().error(Inter.getLocText("FR-Plugin-Jar_Expired") + plugin.getName());
                }
                PluginLoader.getLoader().addRemotePlugin(plugin);
                this.copyDependToEnv(plugin);
            }
        } else {
            throw new RuntimeException("No dependence plugin find.");
        }
    }

    private void copyDependToEnv(Plugin plugin) throws IOException {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(this.dependenceDir);
        IOUtils.copy(inputStream, "plugin.xml", new File(FRContext.getCurrentEnv().getPluginFilePath(plugin)));
    }

    public boolean startService() {
        if (this.dependenceType != PluginDependenceType.SERVICE) {
            return true;
        }
        if (PluginServiceManager.serviceStarted(this.getDependenceID())) {
            return true;
        }
        if (this.checkPath(this.dependenceDir) && this.dependenceType == PluginDependenceType.SERVICE && StringUtils.isNotEmpty(this.serviceClazz)) {
            try {
                Class<?> clazz = Class.forName(this.serviceClazz);
                this.service = (PluginServiceCreator)clazz.newInstance();
                PluginServiceManager.serviceManager.addService(this.dependenceID, this.service);
                FRContext.getCurrentEnv().pluginServiceStart(this.dependenceID);
                return true;
            }
            catch (Exception exception) {
                FRLogger.getLogger().error("class not found:" + exception.getMessage());
                return false;
            }
        }
        return false;
    }

    private Plugin findFromLoadedPlugins(String string) {
        return PluginLoader.getLoader().findPlugin(string);
    }

    private boolean checkPath(String string) {
        if (StringUtils.isEmpty(string)) {
            return true;
        }
        try {
            boolean bl = FRContext.getCurrentEnv().fileExists(string);
            return bl;
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
            return false;
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        String string = xMLableReader.getTagName();
        if (XML_TAG.equalsIgnoreCase(string)) {
            this.dependenceID = xMLableReader.getAttrAsString("key", "");
            this.dependenceDir = xMLableReader.getAttrAsString("location", "");
            String string2 = xMLableReader.getAttrAsString("type", "");
            this.dependenceType = PluginDependenceType.parse(string2);
            this.serviceClazz = xMLableReader.getAttrAsString("class", "");
        }
    }
}

