/*
 * Decompiled with CFR 0.152.
 */
package com.fr.js;

import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.base.ParameterMapNameSpace;
import com.fr.base.ResultFormula;
import com.fr.base.TemplateUtils;
import com.fr.general.ComparatorUtils;
import com.fr.general.FArray;
import com.fr.js.AbstractJavaScript;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.CodeUtils;
import com.fr.stable.ParameterProvider;
import com.fr.stable.Primitive;
import com.fr.stable.StringUtils;
import com.fr.stable.UtilEvalError;
import com.fr.stable.script.NameSpace;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import com.fr.web.core.SessionIDInfor;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaScriptImpl
extends AbstractJavaScript {
    private List jsImportList = null;
    private String content;
    private String defaultPara;

    public JavaScriptImpl() {
    }

    public void setDefaultPara(String string) {
        this.defaultPara = string;
    }

    public JavaScriptImpl(String string) {
        this.content = string;
    }

    @Override
    public String actionJS(Repository repository) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.getJSImportSize();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("FR.$import(\"" + CodeUtils.javascriptEncode(this.getJSImport(i)) + "\", 'js'); ");
        }
        if (StringUtils.isNotBlank(this.content)) {
            stringBuilder.append(this.createContentFunction(repository, true));
        }
        String string = stringBuilder.toString();
        try {
            return TemplateUtils.renderParameter4Tpl(string, this.createContext());
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), exception);
            return string;
        }
    }

    @Override
    public JSONObject createJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("type", "javascript");
        StringBuilder stringBuilder = new StringBuilder();
        if (StringUtils.isNotBlank(this.content)) {
            stringBuilder.append(this.createContentFunction(repository, false));
        }
        try {
            jSONObject.put("script", TemplateUtils.renderParameter4Tpl(stringBuilder.toString(), this.createContext()));
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), exception);
            jSONObject.put("script", stringBuilder.toString());
        }
        return jSONObject;
    }

    private Map<Object, Object> createContext() {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        hashMap.putAll(this.paraMap);
        ParameterProvider[] parameterProviderArray = this.getParameters();
        int n = parameterProviderArray.length;
        for (int i = 0; i < n; ++i) {
            Object object = parameterProviderArray[i].getValue();
            if (object instanceof Formula) {
                object = ((Formula)object).getResult() != null ? ((Formula)object).getResult() : object;
            }
            hashMap.put(parameterProviderArray[i].getName(), object);
        }
        return hashMap;
    }

    private String createContentFunction(Repository repository, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(function(");
        ParameterProvider[] parameterProviderArray = this.getParameters();
        int n = parameterProviderArray.length;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(parameterProviderArray[i].getName());
        }
        if (this.defaultPara != null) {
            stringBuffer.append(n > 0 ? "," : "").append(this.defaultPara);
        }
        stringBuffer.append("){try{").append(this.content == null ? "" : this.content + "\n").append("}catch(ex){FR.Msg").append(".toast(FR").append(".i18nText('Custom')+'JS'+FR.i18nText('Error')+' : '+ex.message);}})");
        stringBuffer.append(".createDelegate(this, [");
        this.dealWithParameter(repository, stringBuffer, n);
        stringBuffer.append("], 0).apply(this, arguments)");
        if (bl) {
            return ";return eval(" + this.quoteFrObject(stringBuffer.toString()) + ");";
        }
        return this.quoteFrObject(stringBuffer.toString()) + "";
    }

    private void dealWithParameter(Repository repository, StringBuffer stringBuffer, int n) {
        for (int i = 0; i < n; ++i) {
            Object object;
            if (i != 0) {
                stringBuffer.append(',');
            }
            if ((object = this.parameters[i].getValue()) instanceof Formula) {
                Object object2;
                Object object3;
                Calculator calculator = Calculator.createCalculator();
                if (repository != null) {
                    object3 = ParameterMapNameSpace.create(repository.getReportParameterMap());
                    calculator.pushNameSpace((NameSpace)object3);
                }
                if (!this.paraMap.isEmpty()) {
                    calculator.pushNameSpace(ParameterMapNameSpace.create(this.paraMap));
                }
                if ((object3 = ((Formula)object).getResult()) == null) {
                    try {
                        object2 = calculator.evalValue((Formula)object);
                        if (object2 == null || object2 == Primitive.NULL) {
                            calculator.pushNameSpace(SessionIDInfor.asNameSpace(repository.getSessionID()));
                        }
                        ((Formula)object).setResult(calculator.evalValue((Formula)object));
                    }
                    catch (UtilEvalError utilEvalError) {
                        FRContext.getLogger().error(utilEvalError.getMessage(), utilEvalError);
                    }
                }
                object2 = this.quoteFrObject(((Formula)object).getResult());
                object = "(FR.formulaEvaluator(" + this.quoteFrObject(((Formula)object).getContent()) + ", " + (object2 == null ? JSONObject.quote("null") : object2) + "," + (this.shouldRecalculate() ? "true" : "false") + "))()";
            } else {
                object = this.quoteFrObject(object);
            }
            stringBuffer.append(object);
        }
    }

    public int getJSImportSize() {
        return this.jsImportList == null ? 0 : this.jsImportList.size();
    }

    public String getJSImport(int n) {
        return this.jsImportList == null ? "" : (String)this.jsImportList.get(n);
    }

    public void addJSImort(String string) {
        if (this.jsImportList == null) {
            this.jsImportList = new ArrayList();
        }
        this.jsImportList.add(string);
    }

    public void clearJSImports() {
        if (this.jsImportList != null) {
            this.jsImportList.clear();
            this.jsImportList = null;
        }
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String string) {
        this.content = string;
    }

    private Object quoteFrObject(Object object) {
        if (object instanceof String) {
            return JSONObject.quote((String)object);
        }
        if (object instanceof FArray) {
            FArray fArray = (FArray)object;
            FArray<Object> fArray2 = new FArray<Object>();
            for (int i = 0; i < fArray.length(); ++i) {
                fArray2.add(this.quoteFrObject(fArray.elementAt(i)));
            }
            return "[" + fArray2 + "]";
        }
        if (object instanceof Date) {
            object = '\"' + object.toString() + '\"';
        } else if (object instanceof ResultFormula) {
            return ((ResultFormula)object).getResult();
        }
        if (object instanceof Primitive || ComparatorUtils.equals("", object.toString())) {
            object = null;
        }
        return object;
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isAttr()) {
            this.clearJSImports();
        }
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Content")) {
                String string2 = null;
                string2 = xMLableReader.getElementValue();
                if (string2 != null) {
                    this.setContent(string2);
                }
            } else if (string.equals("JSImport")) {
                String string3 = null;
                string3 = xMLableReader.getElementValue();
                if (string3 != null) {
                    this.addJSImort(string3);
                }
            }
        }
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        int n = this.getJSImportSize();
        for (int i = 0; i < n; ++i) {
            xMLPrintWriter.startTAG("JSImport").textNode(this.getJSImport(i)).end();
        }
        xMLPrintWriter.startTAG("Content").textNode(this.getContent()).end();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof JavaScriptImpl) || !super.equals(object)) {
            return false;
        }
        return ComparatorUtils.equals(this.getContent(), ((JavaScriptImpl)object).getContent()) && ComparatorUtils.equals((Object)this.jsImportList, (Object)((JavaScriptImpl)object).jsImportList);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        JavaScriptImpl javaScriptImpl = (JavaScriptImpl)super.clone();
        if (this.jsImportList != null) {
            javaScriptImpl.jsImportList = new ArrayList();
            javaScriptImpl.jsImportList.addAll(this.jsImportList);
        }
        return javaScriptImpl;
    }
}

