/*
 * Decompiled with CFR 0.152.
 */
package com.fr.general.script;

import com.fr.general.GeneralUtils;
import com.fr.stable.Primitive;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import java.math.BigDecimal;

public class FunctionHelper {
    private static final int TEN = 10;
    private static final int TWENTY = 20;
    private static final int THIRTY = 30;
    private static final int FORTY = 40;
    private static final int FIFTY = 50;
    private static final int SIXTY = 60;
    private static final int SEVENTY = 70;
    private static final int EIGHTY = 80;
    private static final int NINETY = 90;

    private FunctionHelper() {
    }

    public static String NumberToEnglish(BigDecimal bigDecimal) throws Exception {
        String[] stringArray;
        int n;
        String string = "";
        int n2 = bigDecimal.intValue();
        if (n2 >= 20) {
            int n3 = n2 / 10 * 10;
            n = n2 - n3;
            string = FunctionHelper.getNumAsLetter(n3);
            if (StringUtils.isNotEmpty(string)) {
                string = string + " ";
            }
        } else {
            n = n2;
        }
        if ((stringArray = new String[]{"ZERO", "ONE", "TWO", "THREE", "FOUR", "FIVE", "SIX", "SEVEN", "EIGHT", "NINE", "TEN", "ELEVEN", "TWELVE", "THIRTEEN", "FOURTEEN", "FIFTEEN", "SIXTEEN", "SEVENTEEN", "EIGHTEEN", "NINETEEN"}).length > n) {
            string = string + stringArray[n];
        }
        return string;
    }

    private static String getNumAsLetter(int n) {
        switch (n) {
            case 90: {
                return "NINETY";
            }
            case 80: {
                return "EIGHTY";
            }
            case 70: {
                return "SEVENTY";
            }
            case 60: {
                return "SIXTY";
            }
            case 50: {
                return "FIFTY";
            }
            case 40: {
                return "FORTY";
            }
            case 30: {
                return "THIRTY";
            }
            case 20: {
                return "TWENTY";
            }
        }
        return "";
    }

    public static Number asNumber(long l) {
        if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
            return new Long(l);
        }
        return new Integer((int)l);
    }

    public static Number asNumber(double d) {
        long l = (long)d;
        if (d != (double)l) {
            if (d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
                return new Double(d);
            }
            return Double.valueOf(StableUtils.doubleToString(d));
        }
        return FunctionHelper.asNumber(l);
    }

    public static Object roundUpOrDown(Object[] objectArray, boolean bl) {
        if (objectArray.length < 1) {
            return Primitive.ERROR_NAME;
        }
        double d = GeneralUtils.objectToNumber(objectArray[0], false).doubleValue();
        int n = objectArray.length < 2 ? 0 : GeneralUtils.objectToNumber(objectArray[1], false).intValue();
        double d2 = d;
        if (n >= 0) {
            d2 = new BigDecimal(d + "").setScale(n, bl ? 0 : 1).doubleValue();
        } else if (n < 0) {
            double d3 = Math.pow(10.0, -n * 2);
            d2 = new BigDecimal(d / d3 + "").setScale(-n, bl ? 0 : 1).doubleValue() * d3;
        }
        return FunctionHelper.asNumber(d2);
    }
}

