/*
 * Decompiled with CFR 0.152.
 */
package com.fr.general.jsqlparser.util.deparser;

import com.fr.general.jsqlparser.statement.StatementVisitor;
import com.fr.general.jsqlparser.statement.create.table.CreateTable;
import com.fr.general.jsqlparser.statement.delete.Delete;
import com.fr.general.jsqlparser.statement.drop.Drop;
import com.fr.general.jsqlparser.statement.insert.Insert;
import com.fr.general.jsqlparser.statement.replace.Replace;
import com.fr.general.jsqlparser.statement.select.Select;
import com.fr.general.jsqlparser.statement.select.WithItem;
import com.fr.general.jsqlparser.statement.truncate.Truncate;
import com.fr.general.jsqlparser.statement.update.Update;
import com.fr.general.jsqlparser.util.deparser.CreateTableDeParser;
import com.fr.general.jsqlparser.util.deparser.DeleteDeParser;
import com.fr.general.jsqlparser.util.deparser.ExpressionDeParser;
import com.fr.general.jsqlparser.util.deparser.InsertDeParser;
import com.fr.general.jsqlparser.util.deparser.ReplaceDeParser;
import com.fr.general.jsqlparser.util.deparser.SelectDeParser;
import com.fr.general.jsqlparser.util.deparser.UpdateDeParser;
import java.util.Iterator;

public class StatementDeParser
implements StatementVisitor {
    protected StringBuffer buffer;

    public StatementDeParser(StringBuffer stringBuffer) {
        this.buffer = stringBuffer;
    }

    public void visit(CreateTable createTable) {
        CreateTableDeParser createTableDeParser = new CreateTableDeParser(this.buffer);
        createTableDeParser.deParse(createTable);
    }

    public void visit(Delete delete) {
        SelectDeParser selectDeParser = new SelectDeParser();
        selectDeParser.setBuffer(this.buffer);
        ExpressionDeParser expressionDeParser = new ExpressionDeParser(selectDeParser, this.buffer);
        selectDeParser.setExpressionVisitor(expressionDeParser);
        DeleteDeParser deleteDeParser = new DeleteDeParser(expressionDeParser, this.buffer);
        deleteDeParser.deParse(delete);
    }

    public void visit(Drop drop) {
    }

    public void visit(Insert insert) {
        SelectDeParser selectDeParser = new SelectDeParser();
        selectDeParser.setBuffer(this.buffer);
        ExpressionDeParser expressionDeParser = new ExpressionDeParser(selectDeParser, this.buffer);
        selectDeParser.setExpressionVisitor(expressionDeParser);
        InsertDeParser insertDeParser = new InsertDeParser(expressionDeParser, selectDeParser, this.buffer);
        insertDeParser.deParse(insert);
    }

    public void visit(Replace replace) {
        SelectDeParser selectDeParser = new SelectDeParser();
        selectDeParser.setBuffer(this.buffer);
        ExpressionDeParser expressionDeParser = new ExpressionDeParser(selectDeParser, this.buffer);
        selectDeParser.setExpressionVisitor(expressionDeParser);
        ReplaceDeParser replaceDeParser = new ReplaceDeParser(expressionDeParser, selectDeParser, this.buffer);
        replaceDeParser.deParse(replace);
    }

    public void visit(Select select) {
        SelectDeParser selectDeParser = new SelectDeParser();
        selectDeParser.setBuffer(this.buffer);
        ExpressionDeParser expressionDeParser = new ExpressionDeParser(selectDeParser, this.buffer);
        selectDeParser.setExpressionVisitor(expressionDeParser);
        if (select.getWithItemsList() != null && !select.getWithItemsList().isEmpty()) {
            this.buffer.append("WITH ");
            Iterator iterator = select.getWithItemsList().iterator();
            while (iterator.hasNext()) {
                WithItem withItem = (WithItem)iterator.next();
                this.buffer.append(withItem);
                if (iterator.hasNext()) {
                    this.buffer.append(",");
                }
                this.buffer.append(" ");
            }
        }
        select.getSelectBody().accept(selectDeParser);
    }

    public void visit(Truncate truncate) {
    }

    public void visit(Update update) {
        SelectDeParser selectDeParser = new SelectDeParser();
        selectDeParser.setBuffer(this.buffer);
        ExpressionDeParser expressionDeParser = new ExpressionDeParser(selectDeParser, this.buffer);
        UpdateDeParser updateDeParser = new UpdateDeParser(expressionDeParser, this.buffer);
        selectDeParser.setExpressionVisitor(expressionDeParser);
        updateDeParser.deParse(update);
    }

    public StringBuffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuffer stringBuffer) {
        this.buffer = stringBuffer;
    }
}

