/*
 * Decompiled with CFR 0.152.
 */
package com.fr.general;

import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogFormatter;
import com.fr.general.FRLogLevel;
import com.fr.general.FRLogManager;
import com.fr.general.Inter;
import com.fr.general.LogConfig;
import com.fr.general.LogDeclare;
import com.fr.general.LogDuration;
import com.fr.general.LogPackedException;
import com.fr.general.LogRecordTime;
import com.fr.general.NoRecordManager;
import com.fr.general.RecordManager;
import com.fr.stable.ArrayUtils;
import com.fr.stable.BaseSessionFilterParameterManager;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.fun.LogProvider;
import com.fr.stable.plugin.ExtraClassManagerProvider;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class FRLogger {
    private static final List<String> EXPECT_PARAM = Arrays.asList(BaseSessionFilterParameterManager.getFilterParameters());
    private static FRLogger logger = null;
    private HashMap usersLogRecords = new HashMap();
    private static ThreadLocal<String> threadLocal = new ThreadLocal();
    protected Logger LOGGER;
    private RecordManager recordManager = new NoRecordManager();
    private boolean isForDesigner = false;
    private static Comparator entryNameComparator = new EntryNameComparator();

    public static FRLogger getLogger() {
        if (logger == null) {
            logger = new FRLogger();
        }
        return logger;
    }

    public FRLogger() {
        this.LOGGER = Logger.getLogger("FineReport");
        this.LOGGER.setLevel(FRLogLevel.ERROR);
        this.LOGGER.setUseParentHandlers(false);
        ConsoleHandler consoleHandler = new ConsoleHandler(){

            public void publish(LogRecord logRecord) {
                try {
                    logRecord.setSourceClassName("");
                    Date date = new Date();
                    LogRecordTime logRecordTime = new LogRecordTime(date, logRecord);
                    FRLogger.this.recordToExtra(logRecordTime);
                    FRLogger.this.addRecordToUsers((String)threadLocal.get(), logRecordTime);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                super.publish(logRecord);
            }
        };
        consoleHandler.setFormatter(new FRLogFormatter());
        this.LOGGER.addHandler(consoleHandler);
    }

    private void recordToExtra(LogRecordTime logRecordTime) {
        ExtraClassManagerProvider extraClassManagerProvider = StableFactory.getMarkedObject("ExtraClassManager", ExtraClassManagerProvider.class);
        if (extraClassManagerProvider != null) {
            Set set = extraClassManagerProvider.getArray("LogProvider");
            for (LogProvider logProvider : set) {
                logProvider.record(logRecordTime);
            }
        }
    }

    public boolean isRecordOK() {
        return this.getRecordManager().isOK();
    }

    public void addRecordToUsers(String string, LogRecordTime logRecordTime) {
        Set set = this.usersLogRecords.keySet();
        for (String string2 : set) {
            if (!ComparatorUtils.equals(string2, string)) continue;
            ((List)this.usersLogRecords.get(string2)).add(logRecordTime);
        }
    }

    public void registLoggger(String string) {
        if (!this.usersLogRecords.containsKey(string)) {
            this.usersLogRecords.put(string, new ArrayList());
        }
    }

    public void clearPrintedLogRecords(String string) {
        if (!this.usersLogRecords.containsKey(string)) {
            return;
        }
        ((List)this.usersLogRecords.get(string)).clear();
    }

    public void unRegistLogger(String string) {
        if (this.usersLogRecords.containsKey(string)) {
            this.usersLogRecords.remove(string);
        }
    }

    public List getUserLogRecords(String string) {
        if (!this.usersLogRecords.containsKey(string)) {
            this.usersLogRecords.put(string, new ArrayList());
        }
        return (List)this.usersLogRecords.get(string);
    }

    public void initRecord(RecordManager recordManager) {
        this.recordManager = recordManager;
    }

    public void closeRecord() {
        this.recordManager = new NoRecordManager();
    }

    public void addLogHandler(Handler handler) {
        this.LOGGER.addHandler(handler);
    }

    public void setLogLevel(Level level) {
        this.setLogLevel(level, false);
    }

    public void setLogLevel(Level level, boolean bl) {
        if (!this.isForDesigner || bl) {
            this.LOGGER.setLevel(level);
        }
        this.isForDesigner = bl;
    }

    public Level getLogLevel() {
        return this.LOGGER.getLevel();
    }

    public String getLogName() {
        return this.LOGGER.getName();
    }

    public boolean isLoggable(Level level) {
        return this.LOGGER.isLoggable(level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreadLocal(String string) {
        FRLogger fRLogger = this;
        synchronized (fRLogger) {
            threadLocal.set(string);
        }
    }

    public String getThreadLocal() {
        return threadLocal.get();
    }

    public void close() {
        this.removeHandlers(this.LOGGER);
        this.LOGGER = null;
    }

    private void removeHandlers(Logger logger) {
        Handler[] handlerArray = logger.getHandlers();
        for (int i = 0; i < handlerArray.length; ++i) {
            Handler handler = handlerArray[i];
            logger.removeHandler(handler);
            try {
                handler.close();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void debug(String string) {
        this.LOGGER.log(FRLogLevel.DEBUG, string);
    }

    public void info(String string) {
        this.info(string, FRLogLevel.INFO);
    }

    public void infoWithServerLevel(String string) {
        this.info(string, FRLogLevel.SEVERE);
    }

    private void info(String string, Level level) {
        this.LOGGER.log(level, string);
    }

    public void log(Level level, String string) {
        this.LOGGER.log(level, string);
    }

    public void log(Level level, String string, Throwable throwable) {
        this.LOGGER.log(level, string, throwable);
    }

    public void error(String string) {
        this.error(string, null);
    }

    public void error(String string, Throwable throwable) {
        this.error(string, throwable, FRLogLevel.ERROR);
    }

    public void errorWithServerLevel(String string) {
        this.error(string, null, FRLogLevel.SEVERE);
    }

    public void errorWithServerLevel(String string, Throwable throwable) {
        this.error(string, throwable, FRLogLevel.SEVERE);
    }

    private void error(String string, Throwable throwable, Level level) {
        this.logAndRecordErrorInfo(string, throwable, level);
    }

    public void scheduleInfo(String string, String string2) {
        this.scheduleInfo(string, string2, null);
    }

    public void scheduleError(String string, String string2, Throwable throwable) {
        this.scheduleError(string, string2, throwable, null);
    }

    public void scheduleInfo(String string, String string2, String string3) {
        this.logAndRecordScheduleInfo(string, string2, null, FRLogLevel.INFO, string3);
    }

    public void scheduleError(String string, String string2, Throwable throwable, String string3) {
        this.logAndRecordScheduleInfo(string, string2, throwable, FRLogLevel.ERROR, string3);
    }

    private void logAndRecordScheduleInfo(String string, String string2, Throwable throwable, Level level, String string3) {
        short s;
        if (throwable != null) {
            s = 8;
            this.LOGGER.log(level, string2, throwable);
        } else {
            s = 7;
            this.LOGGER.log(level, string2);
        }
        this.recordScheduleInfo(string, s, string2, throwable, string3);
    }

    public void sapSynInfo(String string, String string2) {
        this.sapSynInfo(string, string2, null);
    }

    public void sapSynInfo(String string, String string2, String string3) {
        this.logAndRecordSAPSynInfo(string, string2, null, FRLogLevel.INFO, string3);
    }

    public void sapSynError(String string, String string2, Throwable throwable) {
        this.sapSynError(string, string2, throwable, null);
    }

    public void sapSynError(String string, String string2, Throwable throwable, String string3) {
        this.logAndRecordSAPSynInfo(string, string2, throwable, FRLogLevel.ERROR, string3);
    }

    private void logAndRecordSAPSynInfo(String string, String string2, Throwable throwable, Level level, String string3) {
        short s;
        if (throwable != null) {
            s = 10;
            this.LOGGER.log(level, string2, throwable);
        } else {
            s = 9;
            this.LOGGER.log(level, string2);
        }
        this.recordScheduleInfo(string, s, string2, throwable, string3);
    }

    private void recordScheduleInfo(String string, short s, String string2, Throwable throwable, String string3) {
        try {
            String string4 = null;
            if (throwable != null) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                throwable.printStackTrace(printWriter);
                printWriter.close();
                string4 = stringWriter.toString();
            }
            this.recordScheduleInfo(string, s, null, string2, string4, string3);
        }
        catch (Exception exception) {
            string2 = "Log Error when recordErrorInfo : " + exception.getMessage();
            this.LOGGER.log(FRLogLevel.ERROR, string2, exception);
        }
    }

    private void logAndRecordErrorInfo(String string, Throwable throwable, Level level) {
        short s;
        CharSequence charSequence;
        Object object;
        LogDeclare logDeclare = null;
        LogDuration logDuration = null;
        boolean bl = false;
        for (Throwable throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            if (!(throwable2 instanceof LogPackedException)) continue;
            bl = true;
            object = (LogPackedException)throwable2;
            logDeclare = ((LogPackedException)object).getLogDeclare();
            logDuration = ((LogPackedException)object).getLogDuaration();
        }
        if (!bl) {
            logDeclare = FRLogManager.getCurrentDeclare();
            logDuration = FRLogManager.getSession();
        }
        object = logDuration != null ? (object = logDuration.getDurationPrefix()) : Inter.getLocText("FR-Engine_Error_With_Non_Template");
        String string2 = null;
        if (logDeclare != null) {
            charSequence = new StringBuffer(logDeclare.getDeclareContent());
            charSequence.append(" :").append("\n").append(string);
            string = charSequence.toString();
            s = logDeclare.getDeclareType();
            string2 = logDeclare.getDeclareInfo();
        } else {
            s = 6;
        }
        this.loglevel(string, throwable, level);
        try {
            charSequence = null;
            if (throwable != null) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                throwable.printStackTrace(printWriter);
                printWriter.close();
                charSequence = stringWriter.toString();
            }
            this.recordErrorInfo((String)object, s, string2, string, (String)charSequence);
        }
        catch (Exception exception) {
            string = "Log Error when recordErrorInfo : " + exception.getMessage();
            this.LOGGER.log(FRLogLevel.ERROR, string, exception);
        }
    }

    private void loglevel(String string, Throwable throwable, Level level) {
        if (throwable != null) {
            this.LOGGER.log(level, string, throwable);
        } else {
            this.LOGGER.log(level, string);
        }
    }

    private void recordErrorInfo(String string, short s, String string2, String string3, String string4) {
        if (!LogConfig.getLogConfig().isRecordErr()) {
            return;
        }
        try {
            this.getRecordManager().recordErrorInfo(string, s, string2, string3, string4);
        }
        catch (Throwable throwable) {
            this.LOGGER.log(Level.WARNING, throwable.getMessage(), throwable);
            this.LOGGER.log(Level.WARNING, "RecordManager error. Record is close.");
        }
    }

    private void recordScheduleInfo(String string, short s, String string2, String string3, String string4, String string5) {
        try {
            this.getRecordManager().recordScheduleInfo(string, s, string2, string3, string4, string5);
        }
        catch (Throwable throwable) {
            this.LOGGER.log(Level.WARNING, throwable.getMessage(), throwable);
            this.LOGGER.log(Level.WARNING, "RecordManager error. Record is close.");
        }
    }

    public static String createParamString(Map map) {
        return FRLogger.createParamString(map, ArrayUtils.EMPTY_STRING_ARRAY);
    }

    public static String createParamString(Map map, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (map != null) {
            Map.Entry entry;
            Set set = map.entrySet();
            Iterator iterator = set.iterator();
            ArrayList arrayList = new ArrayList(map.size());
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList2.addAll(Arrays.asList(stringArray));
            arrayList2.addAll(EXPECT_PARAM);
            while (iterator.hasNext()) {
                entry = iterator.next();
                if (arrayList2.contains(entry.getKey())) continue;
                arrayList.add(entry);
            }
            Collections.sort(arrayList, entryNameComparator);
            iterator = arrayList.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = true;
                }
                entry = iterator.next();
                Object v2 = entry.getValue();
                stringBuffer.append(entry.getKey()).append(" : ").append(v2);
                if (v2 == null) continue;
                stringBuffer.append("[").append(v2.getClass().getName()).append("]");
            }
        }
        return stringBuffer.toString();
    }

    public RecordManager getRecordManager() {
        return this.recordManager;
    }

    private static class EntryNameComparator
    implements Comparator {
        private EntryNameComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((Map.Entry)object).getKey().toString().toLowerCase().compareTo(((Map.Entry)object2).getKey().toString().toLowerCase());
        }
    }
}

