/*
 * Decompiled with CFR 0.152.
 */
package com.fr.function;

import com.fr.script.AbstractFunction;
import com.fr.stable.Primitive;
import com.fr.stable.script.Function;

public class NUMTO
extends AbstractFunction {
    static final String[] CHINESE_NUMBER = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
    static final String[] CHINESE_NUMBER_LEVEL_STR = new String[]{"", "\u5341", "\u767e", "\u5343", "\u4e07", "\u4ebf"};
    static final long[] CHINESE_NUMBER_LEVEL = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000000L};

    public Object run(Object[] objectArray) {
        if (objectArray.length < 1) {
            return Primitive.ERROR_NAME;
        }
        Object object = objectArray[0];
        Object object2 = objectArray.length > 1 ? objectArray[1] : Boolean.FALSE;
        String string = "";
        if (object instanceof Number && ((Number)object).longValue() >= 0L && object2 instanceof Boolean) {
            try {
                string = this.numberToChinese(((Number)object).longValue(), (Boolean)object2);
            }
            catch (Exception exception) {
                string = Primitive.ERROR_VALUE.toString();
            }
        } else {
            return Primitive.ERROR_NAME;
        }
        return string;
    }

    private String numberToChinese(long l, boolean bl) throws Exception {
        String string = "";
        if (bl) {
            while (l > 0L) {
                string = CHINESE_NUMBER[(int)l % 10] + string;
                l /= 10L;
            }
            return string;
        }
        return this.standardNumberToChinese(l, string);
    }

    private String standardNumberToChinese(long l, String string) throws Exception {
        for (int i = 5; i >= 4; --i) {
            if (l / CHINESE_NUMBER_LEVEL[i] > 0L) {
                string = i != 5 ? string + this.thousandToChinese(l / CHINESE_NUMBER_LEVEL[i], string) + CHINESE_NUMBER_LEVEL_STR[i] : this.standardNumberToChinese(l / CHINESE_NUMBER_LEVEL[i], string) + CHINESE_NUMBER_LEVEL_STR[i];
            } else if (string.length() > 0 && !string.endsWith(CHINESE_NUMBER[0]) && l % CHINESE_NUMBER_LEVEL[i] > 0L) {
                string = string + CHINESE_NUMBER[0];
            }
            l %= CHINESE_NUMBER_LEVEL[i];
        }
        string = string + this.thousandToChinese(l, string);
        return string;
    }

    private String thousandToChinese(long l, String string) throws Exception {
        String string2 = "";
        if (l == 10L && string.length() == 0) {
            return CHINESE_NUMBER_LEVEL_STR[1];
        }
        if (l > 10L && l < 20L && string.length() == 0) {
            return CHINESE_NUMBER_LEVEL_STR[1] + CHINESE_NUMBER[(int)l % 10];
        }
        for (int i = 3; i >= 0; --i) {
            if (l / CHINESE_NUMBER_LEVEL[i] > 0L) {
                string2 = string2 + CHINESE_NUMBER[(int)(l / CHINESE_NUMBER_LEVEL[i])] + CHINESE_NUMBER_LEVEL_STR[i];
            } else if (string2.length() > 0 && !string2.endsWith(CHINESE_NUMBER[0]) && l % CHINESE_NUMBER_LEVEL[i] > 0L) {
                string2 = string2 + CHINESE_NUMBER[0];
            }
            l %= CHINESE_NUMBER_LEVEL[i];
        }
        return string2;
    }

    public Function.Type getType() {
        return TEXT;
    }

    public String getCN() {
        return "NUMTO(number,bool)\u6216NUMTO(number):\u8fd4\u56denumber\u7684\u4e2d\u6587\u8868\u793a\u3002\u5176\u4e2dbool\u7528\u4e8e\u9009\u62e9\u4e2d\u6587\u8868\u793a\u7684\u65b9\u5f0f\uff0c\u5f53\u6ca1\u6709bool\u65f6\u91c7\u7528\u9ed8\u8ba4\u65b9\u5f0f\u663e\u793a\u3002\n\u793a\u4f8b\uff1aNUMTO(2345,true)\u7b49\u4e8e\u4e8c\u4e09\u56db\u4e94\u3002\n\u793a\u4f8b\uff1aNUMTO(2345,false)\u7b49\u4e8e\u4e8c\u5343\u4e09\u767e\u56db\u5341\u4e94\u3002\n\u793a\u4f8b\uff1aNUMTO(2345)\u7b49\u4e8e\u4e8c\u5343\u4e09\u767e\u56db\u5341\u4e94\u3002";
    }

    public String getEN() {
        return "NUMTO(number,bool)\u6216NUMTO(number):Returns the number of Chinese said\u3002The bool is used to select Chinese said\uff0cuse the default display when there is no bool .\nExample\uff1aNUMTO(2345,true) = \u4e8c\u4e09\u56db\u4e94\u3002\nExample\uff1aNUMTO(2345,false) = \u4e8c\u5343\u4e09\u767e\u56db\u5341\u4e94\u3002\nExample\uff1aNUMTO(2345) = \u4e8c\u5343\u4e09\u767e\u56db\u5341\u4e94\u3002";
    }
}

