/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui.tree;

import com.fr.base.Utils;
import com.fr.data.Dictionary;
import com.fr.data.impl.TreeAttr;
import com.fr.form.ui.TreeComboBoxDataFilter;
import com.fr.form.ui.tree.LayerConfig;
import com.fr.form.ui.tree.LayerData;
import com.fr.form.ui.tree.Node;
import com.fr.form.ui.tree.NodeValue;
import com.fr.form.ui.tree.TreeValuePath;
import com.fr.general.data.TableDataException;
import com.fr.json.JSONString;
import com.fr.script.Calculator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeComboboxData
implements JSONString {
    private List<LayerConfig> layerConfigList;
    private List<LayerData> layerDatas;
    private boolean removeRepeat = true;
    private List<Node<NodeValue>> nodes = new ArrayList<Node<NodeValue>>();
    private TreeAttr treeAttr;
    private List<NodePasser> nodePassers = new ArrayList<NodePasser>();
    private boolean hasFilter;

    public TreeComboboxData(List<LayerConfig> list, String string, TreeAttr treeAttr, boolean bl) {
        this.layerConfigList = list;
        this.layerDatas = new ArrayList<LayerData>();
        this.treeAttr = treeAttr;
        this.removeRepeat = bl;
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        TreeComboBoxDataFilter.createFilterArrayList(string, arrayList);
        boolean bl2 = this.hasFilter = !arrayList.isEmpty();
        if (this.hasFilter) {
            this.initDataPassers(arrayList);
        }
    }

    public void init(Calculator calculator) throws TableDataException {
        Collections.sort(this.layerConfigList, new Comparator<LayerConfig>(){

            @Override
            public int compare(LayerConfig layerConfig, LayerConfig layerConfig2) {
                return layerConfig.getIndex() - layerConfig2.getIndex();
            }
        });
        this.initAllLayers(calculator);
        this.initLayerNodes();
    }

    private void initAllLayers(Calculator calculator) {
        for (LayerConfig layerConfig : this.layerConfigList) {
            this.layerDatas.add(new LayerData(layerConfig, calculator, this.removeRepeat));
        }
    }

    private void initLayerNodes() throws TableDataException {
        this.initStructureAndMV();
        this.traversalTrees();
    }

    private void initStructureAndMV() throws TableDataException {
        LayerData layerData = this.layerDatas.get(0);
        int n = layerData.getRowCount();
        for (int i = 0; i < n; ++i) {
            String string = layerData.getModel(i);
            String string2 = layerData.getView(i);
            NodeValue nodeValue = new NodeValue(string, string2);
            Node<NodeValue> node = new Node<NodeValue>(nodeValue);
            TreeValuePath treeValuePath = new TreeValuePath(Collections.singletonList(string));
            this.initChildren(node, treeValuePath, 1);
            this.nodes.add(node);
        }
    }

    private void traversalTrees() {
        for (Node<NodeValue> node : this.nodes) {
            this.traversalTree(node);
        }
        this.setIds();
    }

    private void setIds() {
        int n = 1;
        for (Node<NodeValue> node : this.nodes) {
            if (!node.isValid()) continue;
            this.setRootAndChildrenID(null, node, n++);
        }
    }

    private void setRootAndChildrenID(String string, Node<NodeValue> node, int n) {
        String string2 = string == null ? String.valueOf(n) : string + "-" + n;
        node.getValue().setId(string2);
        int n2 = 1;
        for (Node<NodeValue> node2 : node.getChildren()) {
            if (!node2.isValid()) continue;
            this.setRootAndChildrenID(string2, node2, n2++);
        }
    }

    private void traversalTree(Node<NodeValue> node) {
        this.setIfPass(node);
        this.setIfExpend(node);
        this.setIfShowCheck(node);
    }

    private void setIfShowCheck(Node<NodeValue> node) {
        if (this.treeAttr.isMultipleSelection()) {
            this.setAllShowCheck(node);
        }
    }

    private void setAllShowCheck(Node<NodeValue> node) {
        node.getValue().setShowCheck(true);
        for (Node<NodeValue> node2 : node.getChildren()) {
            this.setAllShowCheck(node2);
        }
    }

    private void setIfExpend(Node<NodeValue> node) {
        if (this.hasFilter || !this.treeAttr.isAjax()) {
            node.getValue().setExpand(true);
            for (Node<NodeValue> node2 : node.getChildren()) {
                this.setIfExpend(node2);
            }
        }
    }

    private void setIfPass(Node<NodeValue> node) {
        if (this.hasFilter) {
            for (NodePasser nodePasser : this.nodePassers) {
                nodePasser.passTreeNodes(node, 0);
            }
        } else {
            node.setAllValid();
        }
    }

    private void initChildren(Node<NodeValue> node, TreeValuePath treeValuePath, int n) {
        if (n >= this.layerDatas.size()) {
            return;
        }
        List<Dictionary.MV> list = this.layerDatas.get(n).getMVsAsChildren(treeValuePath);
        for (Dictionary.MV mV : list) {
            String string = Utils.objectToString(mV.getModel());
            String string2 = Utils.objectToString(mV.getView());
            NodeValue nodeValue = new NodeValue(string, string2);
            Node<NodeValue> node2 = new Node<NodeValue>(nodeValue);
            TreeValuePath treeValuePath2 = new TreeValuePath(treeValuePath, string);
            this.initChildren(node2, treeValuePath2, n + 1);
            node.addChild(node2);
        }
    }

    @Override
    public String toJSONString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        if (this.hasValidNode()) {
            for (Node<NodeValue> node : this.nodes) {
                if (!node.isValid()) continue;
                stringBuilder.append(node.toJSONString()).append(",");
            }
            stringBuilder.replace(stringBuilder.length() - 1, stringBuilder.length(), "]");
        } else {
            stringBuilder.append("]");
        }
        return stringBuilder.toString();
    }

    private boolean hasValidNode() {
        boolean bl = false;
        for (Node<NodeValue> node : this.nodes) {
            if (!node.isValid()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void initDataPassers(List<String[]> list) {
        for (String[] stringArray : list) {
            if (stringArray.length > 1) {
                this.nodePassers.add(this.createLayerNodePasser(stringArray));
                continue;
            }
            if (stringArray.length != 1) continue;
            this.nodePassers.add(this.createSingleNodePasser(stringArray));
        }
    }

    private NodePasser createSingleNodePasser(final String[] stringArray) {
        return new NodePasser(){

            @Override
            public boolean passTreeNodes(Node<NodeValue> node, int n) {
                boolean bl = TreeComboBoxDataFilter.fixFilterValueOrText(stringArray, node.getValue().getView(), node.getValue().getModel(), n);
                boolean bl2 = false;
                if (bl) {
                    node.setAllValid();
                } else {
                    for (Node<NodeValue> node2 : node.getChildren()) {
                        if (!this.passTreeNodes(node2, n + 1)) continue;
                        bl2 = true;
                    }
                    if (bl2) {
                        node.setValid();
                    }
                }
                return bl || bl2;
            }
        };
    }

    private NodePasser createLayerNodePasser(final String[] stringArray) {
        return new NodePasser(){

            @Override
            public boolean passTreeNodes(Node<NodeValue> node, int n) {
                boolean bl = TreeComboBoxDataFilter.fixFilterValueOrText(stringArray, node.getValue().getView(), node.getValue().getModel(), n);
                if (bl) {
                    if (n >= stringArray.length - 1) {
                        node.setAllValid();
                    } else {
                        node.setValid();
                        for (Node<NodeValue> node2 : node.getChildren()) {
                            this.passTreeNodes(node2, n + 1);
                        }
                    }
                }
                return bl;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface NodePasser {
        public boolean passTreeNodes(Node<NodeValue> var1, int var2);
    }
}

