/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui;

import com.fr.base.BaseUtils;
import com.fr.base.BaseXMLUtils;
import com.fr.base.Formula;
import com.fr.form.data.DataBinding;
import com.fr.form.ui.AbstractDataControl;
import com.fr.form.ui.DataControl;
import com.fr.form.ui.WidgetValue;
import com.fr.general.Background;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRFont;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.core.NodeVisitor;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import com.fr.web.BaseHTMLWriterUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;

public class Label
extends AbstractDataControl {
    public static final int LEFT = 2;
    public static final int CENTER = 0;
    public static final int RIGHT = 4;
    public int textalign;
    public FRFont font = FRFont.getInstance();
    public boolean noWrap;
    public boolean verticalCenter = true;
    private boolean autoLine = true;
    private float fontRate = 0.75f;
    private Background background;
    private int border = 0;
    private Color color = new Color(244, 244, 244);
    private boolean corner = false;

    public String getXType() {
        return "label";
    }

    public Label() {
        this.widgetValue = new WidgetValue();
    }

    public String[] supportedEvents() {
        return new String[]{"afterinit", "click", "change"};
    }

    public int[] getValueType() {
        return new int[]{1, 3, 2};
    }

    public boolean isVerticalCenter() {
        return this.verticalCenter;
    }

    public void setVerticalCenter(boolean bl) {
        this.verticalCenter = bl;
    }

    public int getTextalign() {
        return this.textalign;
    }

    public void setTextalign(int n) {
        if (n == 2 || n == 0 || n == 4) {
            this.textalign = n;
        }
    }

    public boolean isAutoLine() {
        return this.autoLine;
    }

    public void setAutoLine(boolean bl) {
        this.autoLine = bl;
    }

    public FRFont getFont() {
        return this.font;
    }

    public void setFont(FRFont fRFont) {
        this.font = fRFont;
    }

    public void setWrap(boolean bl) {
        this.noWrap = !bl;
    }

    public boolean isWrap() {
        return !this.noWrap;
    }

    public static String decorationStr(FRFont fRFont) {
        String string = "none";
        if (fRFont.isStrikethrough()) {
            string = "line-through";
        }
        switch (fRFont.getUnderline()) {
            case 0: {
                return string;
            }
        }
        return "underline";
    }

    private String asAlignString(int n) {
        switch (n) {
            case 4: {
                return "right";
            }
            case 0: {
                return "center";
            }
        }
        return "left";
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 89 * n + this.textalign;
        n = 89 * n + (this.widgetValue != null ? this.widgetValue.hashCode() : 0);
        return n;
    }

    public Background getBackground() {
        return this.background;
    }

    public void setBackground(Background background) {
        this.background = background;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public boolean isCorner() {
        return this.corner;
    }

    public void setCorner(boolean bl) {
        this.corner = bl;
    }

    public int getBorder() {
        return this.border;
    }

    public void setBorder(int n) {
        this.border = n;
    }

    public void resize(double d, double d2, double d3) {
        FRFont fRFont = this.getFont();
        int n = (int)((double)fRFont.getSize() * d3);
        this.setFont(fRFont.applySize(n));
    }

    public void createValueResult(DataControl dataControl, Calculator calculator, JSONObject jSONObject, JSONObject jSONObject2) {
        WidgetValue.createWidgetValueResult(this, calculator, jSONObject, jSONObject2);
    }

    public JSONObject createJSONConfig(Repository repository, Calculator calculator, NodeVisitor nodeVisitor) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(repository, calculator, nodeVisitor);
        jSONObject.put("verticalcenter", this.verticalCenter);
        jSONObject.put("textalign", this.asAlignString(this.textalign));
        if (this.font != null) {
            jSONObject.put("decoration", Label.decorationStr(this.font));
            jSONObject.put("color", StableUtils.javaColorToCSSColor(this.font.getForeground()));
            jSONObject.put("textColor", StableUtils.javaColor2String(this.font.getForeground()));
            jSONObject.put("fontsize", this.font.getShowSize(repository.getResolution()));
            if (this.font.isBold()) {
                jSONObject.put("fontweight", "bold");
            }
            if (this.font.isItalic()) {
                jSONObject.put("fontstyle", "italic");
            }
            if (StringUtils.isNotEmpty(this.font.getName())) {
                jSONObject.put("fontfamily", this.font.getName());
            }
        }
        jSONObject.put("wrap", !this.noWrap);
        jSONObject.put("autoline", this.isAutoLine());
        if (this.background != null) {
            if (repository.getDevice().isMobile()) {
                jSONObject.put("widgetBackground", this.background.toJSONObject(repository, new Dimension(160, 160)));
            } else {
                jSONObject.put("widgetBackground", BaseHTMLWriterUtils.jsonBackground(this.background, repository));
            }
        }
        this.createBorderJSON(jSONObject);
        return jSONObject;
    }

    private void createBorderJSON(JSONObject jSONObject) throws JSONException {
        if (this.border != 0) {
            JSONObject jSONObject2 = new JSONObject();
            String string = StableUtils.javaColorToCSSColor(this.color);
            jSONObject2.put("width", BaseUtils.getBorderWidth(this.border)).put("type", BaseUtils.border2Style(this.border)).put("color", string).put("corner", this.corner);
            jSONObject.put("borderStyle", jSONObject2);
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("LabelAttr")) {
                String string2 = xMLableReader.getAttrAsString("text", null);
                if (string2 != null) {
                    if (string2.charAt(0) == '=') {
                        this.widgetValue.setValue(new Formula(string2));
                    } else {
                        this.widgetValue.setValue(string2);
                    }
                }
                this.verticalCenter = xMLableReader.getAttrAsBoolean("verticalcenter", false);
                this.textalign = xMLableReader.getAttrAsInt("textalign", 0);
                this.noWrap = xMLableReader.getAttrAsBoolean("noWrap", false);
                this.setAutoLine(xMLableReader.getAttrAsBoolean("autoline", false));
            } else if (string.equals("LabelFont")) {
                this.font = FRFont.getInstance(new Font(xMLableReader.getAttrAsString("fontfamily", null), xMLableReader.getAttrAsInt("fontstyle", 0), xMLableReader.getAttrAsInt("fontsize", 0)));
                if (!xMLableReader.getXMLVersion().isAfterREPORT_REFECT_FOR7_0_XML_VERSION()) {
                    this.font = this.font.applySize((float)this.font.getSize() * this.fontRate);
                }
            } else if (string.equals("FRFont")) {
                this.font = BaseXMLUtils.readFRFont(xMLableReader);
                if (!xMLableReader.getXMLVersion().isAfterREPORT_REFECT_FOR7_0_XML_VERSION()) {
                    this.font = this.font.applySize((float)this.font.getSize() * this.fontRate);
                }
            } else if ("text".equals(string)) {
                this.widgetValue = new WidgetValue(xMLableReader.getElementValue());
            } else if ("databinding".equals(string)) {
                this.widgetValue = new WidgetValue(DataBinding.String2DataBinding(xMLableReader.getElementValue()));
            } else if ("Background".equals(string)) {
                this.background = BaseXMLUtils.readBackground(xMLableReader);
            } else if (string.equals("border")) {
                this.setStyleFromReader(xMLableReader);
            }
        }
    }

    private void setStyleFromReader(XMLableReader xMLableReader) {
        this.setBorder(xMLableReader.getAttrAsInt("style", 0));
        this.setColor(xMLableReader.getAttrAsColor("color", Color.BLACK));
        this.setCorner(xMLableReader.getAttrAsBoolean("corner", false));
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("LabelAttr");
        if (this.verticalCenter) {
            xMLPrintWriter.attr("verticalcenter", this.verticalCenter);
        }
        xMLPrintWriter.attr("textalign", this.textalign);
        if (this.noWrap) {
            xMLPrintWriter.attr("noWrap", this.noWrap);
        }
        xMLPrintWriter.attr("autoline", this.isAutoLine()).end();
        if (this.font != null) {
            BaseXMLUtils.writeFRFont(xMLPrintWriter, this.font);
        }
        this.writeStyle(xMLPrintWriter);
    }

    private void writeStyle(XMLPrintWriter xMLPrintWriter) {
        if (this.background != null) {
            BaseXMLUtils.writeBackground(xMLPrintWriter, this.background);
        }
        xMLPrintWriter.startTAG("border").attr("style", this.border);
        if (this.color != Color.black) {
            xMLPrintWriter.attr("color", this.color.getRGB());
        }
        if (this.corner) {
            xMLPrintWriter.attr("corner", this.corner);
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        return object != null && object instanceof Label && super.equals(object) && ((Label)object).verticalCenter == this.verticalCenter && ((Label)object).textalign == this.textalign && ComparatorUtils.equals(((Label)object).font, this.font) && ((Label)object).noWrap == this.noWrap && ComparatorUtils.equals(((Label)object).widgetValue, this.widgetValue);
    }
}

