/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui;

import com.fr.form.ui.ComboBox;
import com.fr.form.ui.ComboCheckBoxDataFilter;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.json.JSONUtils;
import com.fr.script.Calculator;
import com.fr.stable.StringUtils;
import com.fr.stable.core.NodeVisitor;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import com.fr.ui.DataFilter;

public class ComboCheckBox
extends ComboBox {
    private String delimiter = ",";
    private String startSymbol = "";
    private String endSymbol = "";
    private boolean returnArray = true;
    private boolean supportTag = true;

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String string) {
        this.delimiter = string;
    }

    public String getStartSymbol() {
        return this.startSymbol;
    }

    public void setStartSymbol(String string) {
        this.startSymbol = string;
    }

    public String getEndSymbol() {
        return this.endSymbol;
    }

    public void setEndSymbol(String string) {
        this.endSymbol = string;
    }

    public boolean isReturnString() {
        return !this.returnArray;
    }

    public void setReturnString(boolean bl) {
        this.returnArray = !bl;
    }

    public String getXType() {
        if (this.supportTag) {
            return "tagcombocheckbox";
        }
        return "combocheckbox";
    }

    public boolean isSupportTag() {
        return this.supportTag;
    }

    public void setSupportTag(boolean bl) {
        this.supportTag = bl;
    }

    public JSONObject createJSONConfig(Repository repository, Calculator calculator, NodeVisitor nodeVisitor) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(repository, calculator, nodeVisitor);
        if (StringUtils.isNotEmpty(this.delimiter)) {
            jSONObject.put("delimiter", this.delimiter);
        }
        jSONObject.put("returnArray", this.returnArray);
        jSONObject.put("supportTag", this.supportTag);
        if (StringUtils.isNotEmpty(this.startSymbol)) {
            jSONObject.put("startSymbol", this.startSymbol);
        }
        if (StringUtils.isNotEmpty(this.endSymbol)) {
            jSONObject.put("endSymbol", this.endSymbol);
        }
        return jSONObject;
    }

    protected void filterAndPutData(Calculator calculator, JSONArray jSONArray, int n, int n2, String string) throws Exception {
        this.createDataFilterIfNeed().filterAndPutData(calculator, jSONArray, n2, n, string, this.isRemoveRepeat(), this.dictionary, null, this.delimiter);
    }

    protected DataFilter createDataFilter() {
        return new ComboCheckBoxDataFilter();
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("RAAttr")) {
            this.returnArray = xMLableReader.getAttrAsBoolean("isArray", this.returnArray);
            this.delimiter = xMLableReader.getAttrAsString("delimiter", this.delimiter);
            this.startSymbol = xMLableReader.getAttrAsString("start", this.startSymbol);
            this.endSymbol = xMLableReader.getAttrAsString("end", this.endSymbol);
            this.supportTag = xMLableReader.getAttrAsBoolean("supportTag", this.supportTag);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("RAAttr");
        if (!this.returnArray) {
            if (!",".equals(this.delimiter)) {
                xMLPrintWriter.attr("delimiter", this.delimiter);
            }
            xMLPrintWriter.attr("isArray", this.returnArray);
            if (StringUtils.isNotEmpty(this.startSymbol)) {
                xMLPrintWriter.attr("start", this.startSymbol);
            }
            if (StringUtils.isNotEmpty(this.endSymbol)) {
                xMLPrintWriter.attr("end", this.endSymbol);
            }
        }
        if (!this.supportTag) {
            xMLPrintWriter.attr("supportTag", this.supportTag);
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        return object instanceof ComboCheckBox && super.equals(object) && this.supportTag == ((ComboCheckBox)object).supportTag && ComparatorUtils.equals(this.delimiter, ((ComboCheckBox)object).delimiter) && this.returnArray == ((ComboCheckBox)object).returnArray;
    }

    public Object dealWithPresentableValue(String string) throws Exception {
        if (string != null && string.startsWith("[") && string.endsWith("]")) {
            JSONArray jSONArray = (JSONArray)JSONUtils.jsonDecode(string);
            return jSONArray;
        }
        return string;
    }
}

