/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.data;

import com.fr.base.FRContext;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StringUtils;
import java.io.Serializable;

public class DataBinding
implements Serializable {
    public static final String NAME = "Name";
    public static final String KEY = "Key";
    private String dataSourceName;
    private String dataBindingKey;
    public static DataBinding empty = new DataBinding();

    private DataBinding() {
    }

    public DataBinding(String[][] stringArray) {
        this(stringArray[0][0], stringArray[0][1]);
    }

    public DataBinding(String string, String string2) {
        this.dataBindingKey = string2;
        this.dataSourceName = string;
    }

    public static DataBinding String2DataBinding(String string) {
        if (StringUtils.isBlank(string)) {
            return new DataBinding();
        }
        DataBinding dataBinding = new DataBinding();
        try {
            JSONObject jSONObject = new JSONObject(string);
            if (jSONObject.has(NAME)) {
                dataBinding.setDataSourceName(jSONObject.getString(NAME));
            }
            if (jSONObject.has(KEY)) {
                dataBinding.setDataBindingKey(jSONObject.getString(KEY));
            }
        }
        catch (JSONException jSONException) {
            String[] stringArray = string.split("\\.");
            if (stringArray.length > 1) {
                dataBinding.setDataSourceName(stringArray[0]);
                dataBinding.setDataBindingKey(string);
            }
            FRContext.getLogger().error(jSONException.getMessage(), jSONException);
        }
        if (DataBinding.validDataBinding(dataBinding)) {
            dataBinding.dataBindingKey = dataBinding.dataBindingKey.substring(dataBinding.dataSourceName.length() + 1, dataBinding.dataBindingKey.length());
        }
        return dataBinding.validate() ? dataBinding : new DataBinding();
    }

    private static boolean validDataBinding(DataBinding dataBinding) {
        return StringUtils.isNotEmpty(dataBinding.dataBindingKey) && dataBinding.dataBindingKey.split("\\.").length > 1 && ComparatorUtils.equals(dataBinding.dataBindingKey.split("\\.")[0], dataBinding.dataSourceName);
    }

    public boolean validate() {
        return StringUtils.isNotEmpty(this.dataSourceName) && StringUtils.isNotEmpty(this.dataBindingKey);
    }

    public void setDataSourceName(String string) {
        this.dataSourceName = string;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataBindingKey(String string) {
        this.dataBindingKey = string;
    }

    public String getDataBindingKey() {
        return this.dataBindingKey;
    }

    public boolean equals(Object object) {
        return object instanceof DataBinding && ComparatorUtils.equals(((DataBinding)object).dataSourceName, this.dataSourceName) && ComparatorUtils.equals(((DataBinding)object).dataBindingKey, this.dataBindingKey);
    }

    public String toString() {
        return "{" + (StringUtils.isBlank(this.getDataSourceName()) ? "" : "Name:" + this.getDataSourceName()) + (StringUtils.isBlank(this.getDataSourceName()) || StringUtils.isBlank(this.getDataBindingKey()) ? "" : ",") + (StringUtils.isBlank(this.getDataBindingKey()) ? "" : "Key:" + this.getDataBindingKey()) + "}";
    }
}

