/*
 * Decompiled with CFR 0.152.
 */
package com.fr.file.filetree;

import com.fr.general.ComparatorUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.io.Serializable;

public class FileNode
implements XMLReadable,
Serializable,
Cloneable {
    protected boolean isDirectory;
    protected String envPath;
    protected String lock;
    protected String userID;
    private long page;
    private long write;
    private long design;

    public FileNode() {
    }

    public FileNode(String string, boolean bl) {
        this.envPath = string;
        this.isDirectory = bl;
    }

    public String getUserID() {
        return this.userID;
    }

    public void setUserID(String string) {
        this.userID = string;
    }

    public String getName() {
        if (this.envPath == null) {
            return null;
        }
        int n = Math.max(this.envPath.lastIndexOf("/"), this.envPath.lastIndexOf("\\"));
        if (n < 0) {
            return this.envPath;
        }
        return this.envPath.substring(n + 1);
    }

    public boolean isFileType(String string) {
        return this.getName().toLowerCase().endsWith(string);
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public void setDirectory(boolean bl) {
        this.isDirectory = bl;
    }

    public String getEnvPath() {
        return this.envPath;
    }

    public void setEnvPath(String string) {
        this.envPath = string;
    }

    public String getLock() {
        return this.lock;
    }

    public void setLock(String string) {
        this.lock = string;
    }

    public String getParent() {
        int n = this.envPath.lastIndexOf("/");
        return this.envPath.substring(0, n);
    }

    public boolean equals(Object object) {
        if (!(object instanceof FileNode)) {
            return false;
        }
        return ((FileNode)object).isDirectory == this.isDirectory && ComparatorUtils.equals(((FileNode)object).envPath, this.envPath) && ComparatorUtils.equals(((FileNode)object).lock, this.lock);
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            this.setDirectory(xMLableReader.getAttrAsBoolean("isDir", false));
            String string = xMLableReader.getAttrAsString("envPath", null);
            if (string != null) {
                this.setEnvPath(string);
            }
            if ((string = xMLableReader.getAttrAsString("lock", null)) != null) {
                this.setLock(string);
            }
            if ((string = xMLableReader.getAttrAsString("userID", null)) != null) {
                this.setUserID(string);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Node").attr("isDir", this.isDirectory()).attr("envPath", this.getEnvPath());
        if (this.getLock() != null) {
            xMLPrintWriter.attr("lock", this.getLock());
        }
        if (this.getUserID() != null) {
            xMLPrintWriter.attr("userID", this.getUserID());
        }
        xMLPrintWriter.end();
    }

    public String toString() {
        String string = this.getName();
        if (this.lock != null) {
            string = string + "(locked by " + this.lock + ")";
        }
        return string;
    }

    public long getPage() {
        return this.page;
    }

    public void setPage(long l) {
        this.page = l;
    }

    public long getWrite() {
        return this.write;
    }

    public void setWrite(long l) {
        this.write = l;
    }

    public long getDesign() {
        return this.design;
    }

    public void setDesign(long l) {
        this.design = l;
    }
}

