/*
 * Decompiled with CFR 0.152.
 */
package com.fr.file;

import com.fr.base.ModifiedTable;
import com.fr.base.StoreProcedureParameter;
import com.fr.base.TableData;
import com.fr.base.TableDataNameObserver;
import com.fr.cluster.rpc.RPC;
import com.fr.data.core.DataCoreUtils;
import com.fr.data.core.DataCoreXmlUtils;
import com.fr.data.impl.Connection;
import com.fr.data.impl.storeproc.StoreProcedure;
import com.fr.file.BaseClusterHelper;
import com.fr.file.DatasourceManagerProvider;
import com.fr.file.XMLFileManager;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.GeneralContext;
import com.fr.general.Inter;
import com.fr.json.JSONObject;
import com.fr.privilege.Authentication;
import com.fr.privilege.PrivilegeManager;
import com.fr.privilege.allocation.AuthorityAllocation;
import com.fr.privilege.filter.AuthorityControlFilter;
import com.fr.privilege.filter.AuthorityRoleDAOManager;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.LicUtils;
import com.fr.stable.ListMap;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLTools;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatasourceManager
extends XMLFileManager
implements TableDataNameObserver,
DatasourceManagerProvider {
    private static int MAX_CONNECTION_COUNT = 1;
    private static boolean registered = false;
    public static final String TABLEDATA = "TABLE_DATA";
    public static final String CONNECTION = "CONNECTION";
    public static final String STATEMENT_TIMEOUT_KEY = "STATEMENT_TIMEOUT_KEY";
    private static DatasourceManagerProvider datasourceManager = null;
    private ConnectionN nameConnectionMap = new ConnectionN();
    private TableDataN nameTableDataMap = new TableDataN();
    private TableDataN nameADHOCMap = new TableDataN();
    private ProcedureN nameProcedureMap = new ProcedureN();
    private static ModifiedTable connectionTotalModifiedTable;
    private static ModifiedTable connectionOnceModifyTable;
    private static ModifiedTable connectionLocalModifyTable;
    private static HashMap<String, Connection> connectionModifyDetails;
    private static ModifiedTable tableDataTotalModifiedTable;
    private static ModifiedTable tableDataOnceModifyTable;
    private static ModifiedTable tableDataLocalModifyTable;
    private static HashMap<String, TableData> tableDataModifyDetails;
    private static HashMap<String, String> userRelatedOperation;
    private int connectionRenameIndex = 1;
    private int tableDataRenameIndex = 1;
    private Iterator EMPTY_ITERATOR = new EmptyIterator();

    private DatasourceManager() {
    }

    private static void authenticateLicense() {
        LicUtils.retryLicLock();
        byte[] byArray = StableUtils.getBytes();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            LicUtils.decode(byArray, byteArrayOutputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            JSONObject jSONObject = new JSONObject(new String(byteArrayOutputStream.toByteArray(), "UTF-8"));
            if (jSONObject.getLong("DEADLINE") > Calendar.getInstance().getTimeInMillis()) {
                registered = true;
                int n = 0;
                if (jSONObject.has("MUTICONNECTION")) {
                    n = jSONObject.getInt("MUTICONNECTION");
                }
                MAX_CONNECTION_COUNT = n <= 0 ? Integer.MAX_VALUE : n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static synchronized DatasourceManager getInstance() {
        return (DatasourceManager)DatasourceManager.getProviderInstance();
    }

    public static synchronized DatasourceManagerProvider getProviderInstance() {
        if (datasourceManager == null) {
            if (DatasourceManager.isClusterMember()) {
                return datasourceManager;
            }
            datasourceManager.readXMLFile();
            if (GeneralContext.getEnvProvider() != null) {
                GeneralContext.getEnvProvider().removeNoPrivilegeConnection();
            }
            connectionTotalModifiedTable = new ModifiedTable();
            tableDataTotalModifiedTable = new ModifiedTable();
            DatasourceManager.authenticateLicense();
        }
        return datasourceManager;
    }

    private static synchronized boolean isClusterMember() {
        switch (BaseClusterHelper.getClusterState()) {
            case LEADER: {
                datasourceManager = new DatasourceManager();
                RPC.registerSkeleton(datasourceManager);
                return false;
            }
            case MEMBER: {
                String string = BaseClusterHelper.getMainServiceIP();
                datasourceManager = (DatasourceManagerProvider)RPC.getProxy(DatasourceManager.class, string);
                return true;
            }
        }
        datasourceManager = new DatasourceManager();
        return false;
    }

    public static synchronized void readInputStream(InputStream inputStream, String string) throws Exception {
        DatasourceManager datasourceManager = new DatasourceManager();
        XMLTools.readInputStreamXML(datasourceManager, inputStream);
        DatasourceManager.updateManager(datasourceManager, string);
        GeneralContext.getEnvProvider().writeResource(DatasourceManager.datasourceManager);
    }

    @Override
    public void updateUserRelatedOperationMap(String string, String string2) {
        if (userRelatedOperation.containsKey(string)) {
            userRelatedOperation.remove(string);
        }
        userRelatedOperation.put(string, string2);
    }

    private static void updateManager(DatasourceManager datasourceManager, String string) {
        if (!userRelatedOperation.containsKey(string)) {
            return;
        }
        String string2 = userRelatedOperation.get(string);
        if (ComparatorUtils.equals(string2, CONNECTION)) {
            for (Map.Entry<String, Integer> entry : connectionOnceModifyTable.getModifiedMap().entrySet()) {
                if (entry.getValue() == -1) {
                    DatasourceManager.datasourceManager.putConnection(entry.getKey(), (Connection)datasourceManager.nameConnectionMap.getValueByName(entry.getKey()));
                    continue;
                }
                if (entry.getValue() == 1) {
                    DatasourceManager.datasourceManager.removeConnection(entry.getKey());
                    continue;
                }
                if (entry.getValue() != 2) continue;
                ((DatasourceManager)DatasourceManager.datasourceManager).nameConnectionMap.map.remove(entry.getKey());
                ((DatasourceManager)DatasourceManager.datasourceManager).nameConnectionMap.map.put(entry.getKey(), datasourceManager.nameConnectionMap.getValueByName(entry.getKey()));
            }
        } else {
            for (Map.Entry<String, Integer> entry : tableDataOnceModifyTable.getModifiedMap().entrySet()) {
                if (entry.getValue() == -1) {
                    DatasourceManager.datasourceManager.putTableData(entry.getKey(), (TableData)datasourceManager.nameTableDataMap.getValueByName(entry.getKey()));
                    continue;
                }
                if (entry.getValue() == 1) {
                    DatasourceManager.datasourceManager.removeTableData(entry.getKey());
                    continue;
                }
                if (entry.getValue() != 2) continue;
                ((DatasourceManager)DatasourceManager.datasourceManager).nameTableDataMap.map.remove(entry.getKey());
                ((DatasourceManager)DatasourceManager.datasourceManager).nameTableDataMap.map.put(entry.getKey(), datasourceManager.nameTableDataMap.getValueByName(entry.getKey()));
            }
        }
        try {
            ((DatasourceManager)DatasourceManager.datasourceManager).nameADHOCMap = (TableDataN)datasourceManager.nameADHOCMap.clone();
            ((DatasourceManager)DatasourceManager.datasourceManager).nameProcedureMap = (ProcedureN)datasourceManager.nameProcedureMap.clone();
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
        }
    }

    public TableDataN getNameTableDataMap() {
        return this.nameTableDataMap;
    }

    public ConnectionN getNameConnectionMap() {
        return this.nameConnectionMap;
    }

    public TableDataN getNameADHOCMap() {
        return this.nameADHOCMap;
    }

    public ProcedureN getNameProcedureMap() {
        return this.nameProcedureMap;
    }

    public static synchronized String readInputStreamWithPrivilege(InputStream inputStream, HashSet<String> hashSet, HashSet<String> hashSet2, Authentication authentication) throws Exception {
        AuthorityControlFilter authorityControlFilter = AuthorityRoleDAOManager.getAuthControlFilter(false);
        if (authorityControlFilter != null) {
            String[] stringArray = PrivilegeManager.getRoleFromAuthentication(authentication);
            DatasourceManager datasourceManager = new DatasourceManager();
            XMLTools.readInputStreamXML(datasourceManager, inputStream);
            for (int i = 0; i < stringArray.length; ++i) {
                AuthorityAllocation authorityAllocation = AuthorityRoleDAOManager.getAuthorityAllocation(authorityControlFilter, stringArray[i]);
                HashSet<String> hashSet3 = authorityAllocation.getAllocation().getDSPrivilege();
                String string = DatasourceManager.removeAndAdd(datasourceManager, hashSet, hashSet2, hashSet3);
                if (!StringUtils.isNotEmpty(string)) continue;
                return string;
            }
        }
        GeneralContext.getEnvProvider().writeResource(datasourceManager);
        GeneralContext.getEnvProvider().writeResource(PrivilegeManager.getProviderInstance());
        return "";
    }

    private static synchronized String removeAndAdd(DatasourceManager datasourceManager, HashSet<String> hashSet, HashSet<String> hashSet2, HashSet<String> hashSet3) {
        DatasourceManager.removeNoPrivilege(datasourceManager, hashSet, hashSet2, hashSet3);
        return DatasourceManager.addPrivilege(datasourceManager, hashSet, hashSet2, hashSet3);
    }

    private static void removeNoPrivilege(DatasourceManager datasourceManager, HashSet<String> hashSet, HashSet<String> hashSet2, HashSet<String> hashSet3) {
        for (String string : hashSet) {
            if (datasourceManager.getConnection(string) != null) continue;
            DatasourceManager.datasourceManager.removeConnection(string);
            hashSet3.remove(string);
        }
        for (String string : hashSet2) {
            if (datasourceManager.getTableData(string) != null) continue;
            DatasourceManager.datasourceManager.removeTableData(string);
        }
    }

    private static String addPrivilege(DatasourceManager datasourceManager, HashSet<String> hashSet, HashSet<String> hashSet2, HashSet<String> hashSet3) {
        Object object;
        Object object2;
        Object object3;
        Iterator iterator = datasourceManager.getConnectionNameIterator();
        while (iterator.hasNext()) {
            object3 = (String)iterator.next();
            if (!hashSet.contains(object3) && DatasourceManager.datasourceManager.getConnection((String)object3) != null) {
                return object3;
            }
            object2 = datasourceManager.getConnection((String)object3);
            DatasourceManager.datasourceManager.putConnection((String)object3, (Connection)object2);
            hashSet3.add((String)object3);
        }
        object3 = datasourceManager.getTableDataNameIterator();
        while (object3.hasNext()) {
            object2 = (String)object3.next();
            if (!hashSet2.contains(object2) && DatasourceManager.datasourceManager.getTableData((String)object2) != null) {
                return object2;
            }
            object = datasourceManager.getTableData((String)object2);
            DatasourceManager.datasourceManager.putTableData((String)object2, (TableData)object);
        }
        object2 = datasourceManager.getProcedureNameIterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            if (!hashSet2.contains(object) && DatasourceManager.datasourceManager.getProcedureByName((String)object) != null) {
                return object;
            }
            StoreProcedure storeProcedure = datasourceManager.getStoredProcedure((String)object);
            DatasourceManager.datasourceManager.putProcedure((String)object, storeProcedure);
        }
        return "";
    }

    @Override
    public ModifiedTable getConnectionTotalModifiedtables() {
        return connectionTotalModifiedTable;
    }

    @Override
    public ModifiedTable getTableDataTotalModifiedTable() {
        return tableDataTotalModifiedTable;
    }

    private static synchronized void envChanged() {
        datasourceManager = null;
    }

    @Override
    public String fileName() {
        return "datasource.xml";
    }

    @Override
    public Iterator getConnectionNameIterator() {
        if (registered && this.calculateDifferenceConnectionCount() > MAX_CONNECTION_COUNT) {
            FRLogger.getLogger().error(Inter.getLocText("License-Your_license_is_not_support_multiple_connection"));
            return this.EMPTY_ITERATOR;
        }
        return this.nameConnectionMap.getNameIterator();
    }

    private int calculateDifferenceConnectionCount() {
        Iterator iterator = this.nameConnectionMap.getNameIterator();
        HashSet<String> hashSet = new HashSet<String>();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Connection connection = (Connection)this.nameConnectionMap.getValueByName(string);
            if (connection == null) continue;
            try {
                hashSet.add(connection.feature());
            }
            catch (Throwable throwable) {
                FRLogger.getLogger().error("Read Connection Failed: " + string);
            }
        }
        return hashSet.size();
    }

    @Override
    public Connection getConnection(String string) {
        if (registered && this.calculateDifferenceConnectionCount() > MAX_CONNECTION_COUNT) {
            FRLogger.getLogger().error(Inter.getLocText("License-Your_license_is_not_support_multiple_connection"));
            return null;
        }
        return (Connection)this.nameConnectionMap.getValueByName(string);
    }

    @Override
    public <T extends Connection> T getConnection(String string, Class<? extends Connection> clazz) {
        Connection connection = this.getConnection(string);
        if (StableUtils.objectInstanceOf(connection, clazz)) {
            return (T)connection;
        }
        return null;
    }

    @Override
    public boolean renameConnection(String string, String string2) {
        return this.nameConnectionMap.rename(string, string2);
    }

    @Override
    public void putConnection(String string, Connection connection) {
        if (registered && this.calculateDifferenceConnectionCount() > MAX_CONNECTION_COUNT) {
            FRLogger.getLogger().error(Inter.getLocText("License-Your_license_is_not_support_multiple_connection"));
            return;
        }
        this.nameConnectionMap.putValueByName(string, connection);
    }

    @Override
    public void removeConnection(String string) {
        this.nameConnectionMap.removeValueByName(string);
    }

    @Override
    public void clearAllConnection() {
        this.nameConnectionMap.clearAll();
    }

    @Override
    public void updateSelfConnectionTotalModifiedTable(ModifiedTable modifiedTable, String string) {
        connectionTotalModifiedTable.update(modifiedTable, string);
    }

    @Override
    public void updateSelfTableDataTotalModifiedTable(ModifiedTable modifiedTable, String string) {
        tableDataTotalModifiedTable.update(modifiedTable, string);
    }

    @Override
    public void acceptConnectionOnceModifyTable(ModifiedTable modifiedTable, String string) {
        connectionOnceModifyTable.clear();
        connectionOnceModifyTable.update(modifiedTable, string);
    }

    @Override
    public void acceptTableDataOnceModifyTable(ModifiedTable modifiedTable, String string) {
        tableDataOnceModifyTable.clear();
        tableDataOnceModifyTable.update(modifiedTable, string);
    }

    @Override
    public void clearModifiedTable() {
        connectionOnceModifyTable.clear();
        connectionLocalModifyTable.clear();
        connectionTotalModifiedTable.clear();
        tableDataTotalModifiedTable.clear();
        tableDataOnceModifyTable.clear();
        tableDataLocalModifyTable.clear();
    }

    @Override
    public HashMap<String, Connection> getConnectionModifyDetails() {
        return connectionModifyDetails;
    }

    @Override
    public HashMap<String, TableData> getTableDataModifyDetails() {
        return tableDataModifyDetails;
    }

    @Override
    public ModifiedTable checkTableDataModifyTable(DatasourceManager datasourceManager, String string) {
        String string2;
        int n;
        ListMap listMap = datasourceManager.nameTableDataMap.map;
        for (n = 0; n < listMap.size(); ++n) {
            string2 = (String)listMap.getKeyByIndex(n);
            if (!this.nameTableDataMap.map.containsKey(string2)) {
                tableDataLocalModifyTable.modifyTable(string2, 1);
                tableDataLocalModifyTable.modiferTable(string2, string);
                continue;
            }
            if (ComparatorUtils.equals(listMap.getByIndex(n), this.nameTableDataMap.map.get(string2))) continue;
            tableDataLocalModifyTable.modifyTable(string2, 2);
            tableDataModifyDetails.put(string2, (TableData)this.nameTableDataMap.map.get(string2));
            tableDataLocalModifyTable.modiferTable(string2, string);
        }
        for (n = 0; n < this.nameTableDataMap.map.size(); ++n) {
            string2 = (String)this.nameTableDataMap.map.getKeyByIndex(n);
            if (listMap.containsKey(string2)) continue;
            tableDataLocalModifyTable.modifyTable(string2, -1);
            tableDataModifyDetails.put(string2, (TableData)this.nameTableDataMap.map.get(string2));
            tableDataLocalModifyTable.modiferTable(string2, string);
        }
        return tableDataLocalModifyTable;
    }

    @Override
    public ModifiedTable getTableDataLocalModifyTable() {
        return tableDataLocalModifyTable;
    }

    @Override
    public ModifiedTable checkConnectionModifyTable(DatasourceManager datasourceManager, String string) {
        String string2;
        int n;
        ListMap listMap = datasourceManager.nameConnectionMap.map;
        for (n = 0; n < listMap.size(); ++n) {
            string2 = (String)listMap.getKeyByIndex(n);
            if (!this.nameConnectionMap.map.containsKey(string2)) {
                connectionLocalModifyTable.modifyTable(string2, 1);
                connectionLocalModifyTable.modiferTable(string2, string);
                continue;
            }
            if (ComparatorUtils.equals(listMap.getByIndex(n), this.nameConnectionMap.map.get(string2))) continue;
            connectionLocalModifyTable.modifyTable(string2, 2);
            connectionModifyDetails.put(string2, (Connection)this.nameConnectionMap.map.get(string2));
            connectionLocalModifyTable.modiferTable(string2, string);
        }
        for (n = 0; n < this.nameConnectionMap.map.size(); ++n) {
            string2 = (String)this.nameConnectionMap.map.getKeyByIndex(n);
            if (listMap.containsKey(string2)) continue;
            connectionLocalModifyTable.modifyTable(string2, -1);
            connectionModifyDetails.put(string2, (Connection)this.nameConnectionMap.map.get(string2));
            connectionLocalModifyTable.modiferTable(string2, string);
        }
        return connectionLocalModifyTable;
    }

    @Override
    public ModifiedTable getConnectionLocalModifyTable() {
        return connectionLocalModifyTable;
    }

    @Override
    public DatasourceManager getBackUpManager() {
        DatasourceManager datasourceManager = new DatasourceManager();
        try {
            datasourceManager.nameConnectionMap = (ConnectionN)this.nameConnectionMap.clone();
            datasourceManager.nameTableDataMap = (TableDataN)this.nameTableDataMap.clone();
            datasourceManager.nameProcedureMap = (ProcedureN)this.nameProcedureMap.clone();
            datasourceManager.nameADHOCMap = (TableDataN)this.nameADHOCMap.clone();
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
        }
        return datasourceManager;
    }

    @Override
    public void synchronizedWithServer(DatasourceManager datasourceManager, String string) {
        DatasourceManager datasourceManager2 = new DatasourceManager();
        datasourceManager2.readXMLFile();
        try {
            if (ComparatorUtils.equals(string, CONNECTION)) {
                this.nameConnectionMap = (ConnectionN)datasourceManager2.nameConnectionMap.clone();
                datasourceManager.nameConnectionMap = (ConnectionN)datasourceManager2.nameConnectionMap.clone();
            } else {
                this.nameTableDataMap = (TableDataN)datasourceManager2.nameTableDataMap.clone();
                datasourceManager.nameTableDataMap = (TableDataN)datasourceManager2.nameTableDataMap.clone();
            }
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
        }
        if (GeneralContext.getEnvProvider() != null) {
            GeneralContext.getEnvProvider().removeNoPrivilegeConnection();
        }
    }

    @Override
    public void synchronizedWithServer() {
        DatasourceManager datasourceManager = new DatasourceManager();
        datasourceManager.readXMLFile();
        try {
            DatasourceManager.datasourceManager = datasourceManager;
            this.nameConnectionMap = (ConnectionN)datasourceManager.nameConnectionMap.clone();
            this.nameTableDataMap = (TableDataN)datasourceManager.nameTableDataMap.clone();
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
        }
        if (GeneralContext.getEnvProvider() != null) {
            GeneralContext.getEnvProvider().removeNoPrivilegeConnection();
        }
    }

    @Override
    public void doWithTableDataConfilct(ModifiedTable modifiedTable) {
        HashMap<String, Integer> hashMap = modifiedTable.getWaringMap();
        for (Map.Entry<String, Integer> object : hashMap.entrySet()) {
            int entry = object.getValue();
            String string = object.getKey();
            if (entry == 0) {
                this.nameTableDataMap.map.put(Inter.getLocText("FR-Engine_Please_Rename") + this.tableDataRenameIndex + "!", tableDataModifyDetails.get(string));
                ++this.tableDataRenameIndex;
                tableDataModifyDetails.remove(string);
                continue;
            }
            if (entry == 2) {
                TableData tableData = tableDataModifyDetails.get(string);
                this.nameTableDataMap.map.remove(string);
                this.nameTableDataMap.map.put(string, tableData);
                tableDataModifyDetails.remove(string);
                continue;
            }
            if (entry != 1) continue;
            tableDataModifyDetails.remove(string);
            modifiedTable.getModifiedMap().remove(string);
        }
        for (Map.Entry<String, TableData> entry : tableDataModifyDetails.entrySet()) {
            this.nameTableDataMap.map.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void doWithConnectionConflict(ModifiedTable modifiedTable) {
        HashMap<String, Integer> hashMap = modifiedTable.getWaringMap();
        for (Map.Entry<String, Integer> object : hashMap.entrySet()) {
            int entry = object.getValue();
            String string = object.getKey();
            if (entry == 0) {
                this.nameConnectionMap.map.put(Inter.getLocText("FR-Engine_Please_Rename") + this.connectionRenameIndex + "!", connectionModifyDetails.get(string));
                ++this.connectionRenameIndex;
                connectionModifyDetails.remove(string);
                continue;
            }
            if (entry == 2) {
                Connection connection = connectionModifyDetails.get(string);
                this.nameConnectionMap.map.remove(string);
                this.nameConnectionMap.map.put(string, connection);
                connectionModifyDetails.remove(string);
                continue;
            }
            if (entry != 1) continue;
            connectionModifyDetails.remove(string);
            modifiedTable.getModifiedMap().remove(string);
        }
        for (Map.Entry<String, Connection> entry : connectionModifyDetails.entrySet()) {
            this.nameConnectionMap.map.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Iterator getTableDataNameIterator() {
        return this.nameTableDataMap.getNameIterator();
    }

    private TableData getStoredTableData(String string) {
        return (TableData)this.nameTableDataMap.getValueByName(string);
    }

    @Override
    public TableData getTableData(String string) {
        TableData tableData = this.isEmptyTableData(string);
        if (tableData == null) {
            tableData = DataCoreUtils.existsName(string, this);
        }
        try {
            return tableData == null ? null : (TableData)tableData.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            FRLogger.getLogger().error(cloneNotSupportedException.getMessage(), cloneNotSupportedException);
            return null;
        }
    }

    @Override
    public TableData isEmptyTableData(String string) {
        return this.getStoredTableData(string);
    }

    @Override
    public void putTableData(String string, TableData tableData) {
        this.nameTableDataMap.putValueByName(string, tableData);
    }

    @Override
    public boolean renameTableData(String string, String string2) {
        return this.nameTableDataMap.rename(string, string2);
    }

    @Override
    public int isConnectionMapContainsRename() {
        String string = Inter.getLocText("FR-Engine_Please_Rename") + "!";
        if (this.nameConnectionMap.map.containsKey(string)) {
            return this.nameConnectionMap.map.indexOf(string);
        }
        for (int i = this.connectionRenameIndex; i >= 1; --i) {
            string = Inter.getLocText("FR-Engine_Please_Rename") + i + "!";
            if (!this.nameConnectionMap.map.containsKey(string)) continue;
            return this.nameConnectionMap.map.indexOf(string);
        }
        return -1;
    }

    @Override
    public int isTableDataMapContainsRename() {
        String string = Inter.getLocText("FR-Engine_Please_Rename") + "!";
        if (this.nameTableDataMap.map.containsKey(string)) {
            return this.nameTableDataMap.map.indexOf(string);
        }
        for (int i = this.tableDataRenameIndex; i >= 1; --i) {
            string = Inter.getLocText("FR-Engine_Please_Rename") + i + "!";
            if (!this.nameTableDataMap.map.containsKey(string)) continue;
            return this.nameTableDataMap.map.indexOf(string);
        }
        return -1;
    }

    @Override
    public void removeTableData(String string) {
        this.nameTableDataMap.removeValueByName(string);
    }

    @Override
    public void clearAllTableData() {
        this.nameTableDataMap.clearAll();
    }

    @Override
    public Iterator getADHOCNameIterator() {
        return this.nameADHOCMap.getNameIterator();
    }

    private TableData getStoredADHOC(String string) {
        return (TableData)this.nameADHOCMap.getValueByName(string);
    }

    @Override
    public TableData getADHOC(String string) {
        TableData tableData = this.getStoredADHOC(string);
        try {
            return tableData == null ? null : (TableData)tableData.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            FRLogger.getLogger().error(cloneNotSupportedException.getMessage(), cloneNotSupportedException);
            return null;
        }
    }

    @Override
    public void putADHOC(String string, TableData tableData) {
        this.nameADHOCMap.putValueByName(string, tableData);
    }

    @Override
    public void removeADHOC(String string) {
        this.nameADHOCMap.removeValueByName(string);
    }

    @Override
    public void clearAllADHOC() {
        this.nameADHOCMap.clearAll();
    }

    @Override
    public Iterator getProcedureNameIterator() {
        return this.nameProcedureMap.getNameIterator();
    }

    @Override
    public List<String> getProcedureNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.nameProcedureMap.getNameIterator();
        while (iterator.hasNext()) {
            arrayList.add((String)iterator.next());
        }
        return arrayList;
    }

    private StoreProcedure getStoredProcedure(String string) {
        return (StoreProcedure)this.nameProcedureMap.getValueByName(string);
    }

    @Override
    public StoreProcedure getProcedure(String string) {
        StoreProcedure storeProcedure = this.getStoredProcedure(string);
        try {
            return storeProcedure == null ? null : (StoreProcedure)storeProcedure.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            FRLogger.getLogger().error(cloneNotSupportedException.getMessage(), cloneNotSupportedException);
            return null;
        }
    }

    @Override
    public StoreProcedure getProcedureBy_dsName(String string) {
        Iterator iterator = this.nameProcedureMap.getNameIterator();
        StoreProcedure storeProcedure = null;
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            storeProcedure = this.getProcedure(string2);
            StoreProcedureParameter[] storeProcedureParameterArray = storeProcedure.getParameters();
            ArrayList arrayList = storeProcedure.getResultNames();
            for (StoreProcedureParameter storeProcedureParameter : storeProcedureParameterArray) {
                if (!ComparatorUtils.equals(storeProcedureParameter.getName(), string)) continue;
                return storeProcedure;
            }
            if (arrayList.isEmpty()) continue;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                String string3 = (String)arrayList.get(i);
                if (!ComparatorUtils.equals(string3, string)) continue;
                return storeProcedure;
            }
        }
        return null;
    }

    @Override
    public boolean isProcedureName(String string) {
        return this.nameProcedureMap.map.containsKey(string);
    }

    @Override
    public StoreProcedure getProcedureByName(String string) {
        return this.isProcedureName(string) ? this.getProcedure(string) : this.getProcedureBy_dsName(string);
    }

    @Override
    public void putProcedure(String string, StoreProcedure storeProcedure) {
        this.nameProcedureMap.putValueByName(string, storeProcedure);
    }

    @Override
    public void clearAllProcedure() {
        this.nameProcedureMap.clearAll();
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            this.clearAllConnection();
            this.clearAllTableData();
            this.clearAllADHOC();
            this.clearAllProcedure();
        }
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("ConnectionMap".equals(string)) {
                xMLableReader.readXMLObject(this.nameConnectionMap);
            } else if ("TableDataMap".equals(string)) {
                xMLableReader.readXMLObject(this.nameTableDataMap);
            } else if ("ADHOCMap".equals(string)) {
                xMLableReader.readXMLObject(this.nameADHOCMap);
            } else if ("ProcedureMap".equals(string)) {
                xMLableReader.readXMLObject(this.nameProcedureMap);
            }
        }
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("DatasourceManager");
        this.nameConnectionMap.writeXML(xMLPrintWriter, "ConnectionMap");
        this.nameTableDataMap.writeXML(xMLPrintWriter, "TableDataMap");
        this.nameADHOCMap.writeXML(xMLPrintWriter, "ADHOCMap");
        this.nameProcedureMap.writeXML(xMLPrintWriter, "ProcedureMap");
        xMLPrintWriter.end();
    }

    @Override
    public boolean writeResource() throws Exception {
        return GeneralContext.getEnvProvider().writeResource(DatasourceManager.getProviderInstance());
    }

    public static void reinit() {
        DatasourceManager.envChanged();
        DatasourceManager.getProviderInstance();
    }

    static {
        connectionOnceModifyTable = new ModifiedTable();
        connectionLocalModifyTable = new ModifiedTable();
        connectionModifyDetails = new HashMap();
        tableDataOnceModifyTable = new ModifiedTable();
        tableDataLocalModifyTable = new ModifiedTable();
        tableDataModifyDetails = new HashMap();
        userRelatedOperation = new HashMap();
        GeneralContext.addEnvChangedListener(new EnvChangedListener(){

            public void envChanged() {
                DatasourceManager.envChanged();
            }
        });
    }

    private class EmptyIterator
    implements Iterator,
    Serializable {
        private EmptyIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            return null;
        }

        public void remove() {
        }
    }

    private static class ProcedureN
    extends N {
        private ProcedureN() {
        }

        protected XMLable readAsXMLable(XMLableReader xMLableReader) {
            StoreProcedure storeProcedure = new StoreProcedure();
            xMLableReader.readXMLObject(storeProcedure);
            return storeProcedure;
        }

        protected String tagNameOfXMLable() {
            return "StoreProcedure";
        }

        protected void writeXMLableByName(XMLPrintWriter xMLPrintWriter, XMLable xMLable, String string) {
            DataCoreXmlUtils.writeXMLStoreProcedure(xMLPrintWriter, (StoreProcedure)xMLable, string);
        }

        public Object clone() throws CloneNotSupportedException {
            ProcedureN procedureN = new ProcedureN();
            procedureN.map = (ListMap)this.map.clone();
            return procedureN;
        }
    }

    private static class TableDataN
    extends N {
        private TableDataN() {
        }

        protected XMLable readAsXMLable(XMLableReader xMLableReader) {
            return DataCoreXmlUtils.readXMLTableData(xMLableReader);
        }

        protected String tagNameOfXMLable() {
            return "TableData";
        }

        protected void writeXMLableByName(XMLPrintWriter xMLPrintWriter, XMLable xMLable, String string) {
            DataCoreXmlUtils.writeXMLTableData(xMLPrintWriter, (TableData)xMLable, string);
        }

        public Object clone() throws CloneNotSupportedException {
            TableDataN tableDataN = new TableDataN();
            tableDataN.map = (ListMap)this.map.clone();
            return tableDataN;
        }
    }

    private static class ConnectionN
    extends N {
        private ConnectionN() {
        }

        protected XMLable readAsXMLable(XMLableReader xMLableReader) {
            return DataCoreXmlUtils.readXMLConnection(xMLableReader);
        }

        protected String tagNameOfXMLable() {
            return "Connection";
        }

        protected void writeXMLableByName(XMLPrintWriter xMLPrintWriter, XMLable xMLable, String string) {
            DataCoreXmlUtils.writeXMLConnection(xMLPrintWriter, (Connection)xMLable, string);
        }

        public Object clone() throws CloneNotSupportedException {
            ConnectionN connectionN = new ConnectionN();
            connectionN.map = (ListMap)this.map.clone();
            return connectionN;
        }
    }

    public static abstract class N
    implements XMLReadable,
    Serializable {
        ListMap map = new ListMap();

        public int size() {
            return this.map.size();
        }

        public Iterator getNameIterator() {
            return this.map.keySet().iterator();
        }

        public XMLable getValueByName(String string) {
            return (XMLable)this.map.get(string);
        }

        public void putValueByName(String string, XMLable xMLable) {
            if (xMLable == null) {
                this.map.remove(string);
            } else {
                this.map.put(string, xMLable);
            }
        }

        public boolean rename(String string, String string2) {
            if (!this.map.containsKey(string) || this.map.containsKey(string2)) {
                return false;
            }
            int n = this.map.indexOf(string);
            this.map.put(n, string2, this.map.get(string));
            return true;
        }

        public void removeValueByName(String string) {
            this.map.remove(string);
        }

        public void clearAll() {
            this.map.clear();
        }

        public void writeXML(XMLPrintWriter xMLPrintWriter, String string) {
            Iterator iterator = this.getNameIterator();
            if (iterator.hasNext()) {
                xMLPrintWriter.startTAG(string);
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    XMLable xMLable = this.getValueByName(string2);
                    if (xMLable == null) continue;
                    this.writeXMLableByName(xMLPrintWriter, xMLable, string2);
                }
                xMLPrintWriter.end();
            }
        }

        protected abstract void writeXMLableByName(XMLPrintWriter var1, XMLable var2, String var3);

        public void readXML(XMLableReader xMLableReader) {
            if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals(this.tagNameOfXMLable())) {
                String string = null;
                String string2 = null;
                string2 = xMLableReader.getAttrAsString("name", null);
                if (string2 != null) {
                    string = string2;
                }
                if (string == null) {
                    return;
                }
                XMLable xMLable = this.readAsXMLable(xMLableReader);
                if (xMLable != null) {
                    this.map.put(string, xMLable);
                }
            }
        }

        protected abstract String tagNameOfXMLable();

        protected abstract XMLable readAsXMLable(XMLableReader var1);
    }
}

