/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.index;

import com.fr.data.index.AbstractIndex;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.general.data.index.IndexException;
import java.util.Arrays;

public class BinarySearchIndex
extends AbstractIndex {
    public BinarySearchIndex() {
    }

    public BinarySearchIndex(DataModel dataModel, int n) {
        super(dataModel, n);
    }

    public void buildIndex() throws IndexException {
        try {
            this.extractIndex();
            this.sort();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IndexException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
        catch (TableDataException tableDataException) {
            throw new IndexException(tableDataException.getMessage(), tableDataException);
        }
    }

    private void sort() {
        Arrays.sort(this.indexes, this.entryComparator);
    }

    protected int search(Object object) {
        int n = Arrays.binarySearch(this.indexes, object, this.entryComparator);
        if (this.isValid(n)) {
            return this.indexes[n].row;
        }
        return -1;
    }

    protected int[] searchAll(Object object) {
        int n = Arrays.binarySearch(this.indexes, object, this.entryComparator);
        if (!this.isValid(n)) {
            return new int[0];
        }
        int n2 = this.findBegin(object, n);
        int n3 = this.findEnd(object, n);
        return this.getRowsByRange(n2, n3);
    }

    private int[] getRowsByRange(int n, int n2) {
        int[] nArray = new int[n2 - n + 1];
        for (int i = n; i <= n2; ++i) {
            nArray[i - n] = this.indexes[i].row;
        }
        return nArray;
    }

    private int findBegin(Object object, int n) {
        return this.findSideRow(object, n, -1);
    }

    private int findEnd(Object object, int n) {
        return this.findSideRow(object, n, 1);
    }

    private int findSideRow(Object object, int n, int n2) {
        int n3 = n;
        while (this.isValid(n3 + n2) && this.entryComparator.compare(object, this.indexes[n3 + n2]) == 0) {
            n3 += n2;
        }
        return n3;
    }

    private boolean isValid(int n) {
        return n >= 0 && n < this.indexes.length;
    }
}

