/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.Parameter;
import com.fr.data.AbstractDataModel;
import com.fr.data.core.define.XMLColumnNameDateType;
import com.fr.data.core.define.XMLColumnNameType;
import com.fr.general.ComparatorUtils;
import com.fr.general.IOUtils;
import com.fr.general.data.DataSource;
import com.fr.general.data.TableDataException;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

public class XMLDataModel
extends AbstractDataModel {
    private static final String STARTTAG = "<XML>";
    private static final String ENDTAG = "</XML>";
    private static final String CHILDNODE = "CHILDNODE";
    private static final String ATTR = "ATTR";
    private DataSource dataSource;
    protected List row_list = null;
    private String[] xPath;
    private String charSet;
    private XMLColumnNameType[] columns;
    private Parameter[] params;

    public XMLDataModel(DataSource dataSource, Parameter[] parameterArray, String[] stringArray, String string, XMLColumnNameType[] xMLColumnNameTypeArray) {
        this.dataSource = dataSource;
        this.params = parameterArray;
        this.xPath = stringArray;
        this.charSet = string;
        this.columns = xMLColumnNameTypeArray;
    }

    public int getColumnCount() throws TableDataException {
        return this.columns.length;
    }

    public String getColumnName(int n) throws TableDataException {
        if (n < 0 || n >= this.columns.length) {
            return null;
        }
        String string = this.columns[n] == null ? null : this.columns[n].getName();
        return string;
    }

    public int getRowCount() throws TableDataException {
        this.init();
        return this.row_list == null ? 0 : this.row_list.size();
    }

    public Object getValueAt(int n, int n2) throws TableDataException {
        boolean bl;
        this.init();
        boolean bl2 = bl = n < 0 || n >= this.row_list.size() || n2 < 0 || n2 >= this.columns.length;
        if (bl) {
            return null;
        }
        return ((Object[])this.row_list.get(n))[n2];
    }

    protected void init() throws TableDataException {
        if (this.row_list != null) {
            return;
        }
        this.checkNameAndType();
        try {
            InputStream inputStream = this.getDataSourceStream();
            if (inputStream != null) {
                this.readerXMLSource(inputStream);
                inputStream.close();
            }
        }
        catch (Exception exception) {
            throw new TableDataException(exception.getMessage(), exception);
        }
    }

    protected InputStream getDataSourceStream() throws Exception {
        return this.dataSource.getSourceStream(this.params);
    }

    protected void readerXMLSource(InputStream inputStream) throws Exception {
        String string = new String(IOUtils.inputStream2Bytes(inputStream), this.charSet);
        String string2 = this.addTag(string);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes(this.charSet));
        this.readXMLSource(new InputStreamReader((InputStream)byteArrayInputStream, this.charSet));
    }

    private String addTag(String string) {
        int n = 0;
        int n2 = string.indexOf(">");
        int n3 = string.length();
        String string2 = string.substring(n, n2 + 1);
        String string3 = STARTTAG;
        String string4 = string.substring(n2 + 1, n3);
        String string5 = ENDTAG;
        String string6 = string2 + string3 + string4 + string5;
        return string6;
    }

    protected void readXMLSource(Reader reader) throws Exception {
        XMLableReader xMLableReader = XMLableReader.createXMLableReader(reader);
        if (xMLableReader != null) {
            this.row_list = new ArrayList();
            xMLableReader.readXMLObject(new ReadXMLLayer(0));
            this.dealWithRowList();
        }
    }

    private void dealWithRowList() {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        int n = this.row_list.size();
        if (n > 0) {
            int n2;
            Object[] objectArray;
            int n3;
            int n4;
            int n5;
            for (n5 = 0; n5 < n; ++n5) {
                int n6;
                n4 = 0;
                n3 = 0;
                objectArray = (Object[])this.row_list.get(n5);
                n2 = objectArray.length;
                Object[] objectArray2 = new Object[n2 - 1];
                if (ComparatorUtils.equals(objectArray[0], (Object)CHILDNODE)) {
                    for (n6 = 1; n6 < n2; ++n6) {
                        if (objectArray[n6] != null) {
                            n4 = -1;
                        }
                        objectArray2[n6 - 1] = objectArray[n6];
                    }
                } else if (ComparatorUtils.equals(objectArray[0], (Object)ATTR)) {
                    for (n6 = 1; n6 < n2; ++n6) {
                        if (objectArray[n6] == null) continue;
                        ++n4;
                        n3 = n6;
                    }
                }
                if (n4 > 0) {
                    arrayList2.add(objectArray[n3]);
                    arrayList3.add(n3 - 1);
                    continue;
                }
                if (n4 != -1) continue;
                arrayList.add(objectArray2);
            }
            n5 = arrayList.size();
            n4 = arrayList2.size();
            for (n3 = 0; n3 < n5; ++n3) {
                objectArray = (Object[])arrayList.get(n3);
                for (n2 = 0; n2 < n4; ++n2) {
                    int n7 = Integer.parseInt(arrayList3.get(n2).toString());
                    objectArray[n7] = arrayList2.get(n2);
                }
            }
            this.row_list = arrayList;
        }
    }

    protected void checkNameAndType() throws TableDataException {
        for (int i = 0; i < this.columns.length; ++i) {
            if (this.columns[i] == null) {
                throw new TableDataException("Column index:" + i + " is null");
            }
            if (StringUtils.isBlank(this.columns[i].getName())) {
                throw new TableDataException("ColumnName index:" + i + " is null");
            }
            if (this.columns[i].getType() != 2 || this.columns[i] instanceof XMLColumnNameDateType) continue;
            throw new TableDataException("ColumnType index:" + i + " is not a date");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object convertStringValue(String string, XMLColumnNameType xMLColumnNameType) throws Exception {
        if (xMLColumnNameType.getType() == 0) {
            return string;
        }
        if (xMLColumnNameType.getType() == 1) {
            return StableUtils.string2Number(string);
        }
        if (xMLColumnNameType.getType() == 3) {
            return Boolean.valueOf(string);
        }
        if (xMLColumnNameType.getType() == 2) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(((XMLColumnNameDateType)xMLColumnNameType).getFormat());
            try {
                String string2;
                String string3 = string2 = "";
                synchronized (string3) {
                    return simpleDateFormat.parse(string);
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    public void release() throws Exception {
    }

    private class ReadXMLColumn
    implements XMLReadable {
        private Object[] objects = null;

        public ReadXMLColumn(Object[] objectArray) {
            this.objects = objectArray;
        }

        public void readXML(XMLableReader xMLableReader) {
            if (xMLableReader.isChildNode() || xMLableReader.isAttr()) {
                this.objects[0] = xMLableReader.isChildNode() ? XMLDataModel.CHILDNODE : XMLDataModel.ATTR;
                String string = xMLableReader.getTagName();
                for (int i = 0; i < XMLDataModel.this.columns.length; ++i) {
                    if (!XMLDataModel.this.columns[i].getName().equals(string)) continue;
                    String string2 = xMLableReader.getElementValue();
                    Object object = null;
                    if (string2 != null) {
                        try {
                            object = XMLDataModel.convertStringValue(string2.trim(), XMLDataModel.this.columns[i]);
                        }
                        catch (Exception exception) {
                            throw new RuntimeException("Exception with ColumnName:" + string + ", Value:" + string2 + ".\n" + exception.getMessage(), exception);
                        }
                    }
                    if (this.objects[i + 1] != null) {
                        this.objects[i + 1] = this.objects[i + 1] + ";" + object;
                        break;
                    }
                    this.objects[i + 1] = object;
                    break;
                }
            }
        }
    }

    private class ReadXMLLayer
    implements XMLReadable {
        private int layer = -1;

        public ReadXMLLayer(int n) {
            this.layer = n;
        }

        public void readXML(XMLableReader xMLableReader) {
            String string;
            if (this.layer < 0) {
                return;
            }
            if (xMLableReader.isAttr() && !(string = XMLDataModel.this.xPath[this.layer]).equals(xMLableReader.getTagName())) {
                this.layer = -1;
            }
            if (xMLableReader.isChildNode() && XMLDataModel.this.xPath.length > this.layer + 1) {
                string = XMLDataModel.this.xPath[this.layer + 1];
                boolean bl = false;
                for (int i = 0; i < XMLDataModel.this.columns.length; ++i) {
                    if (!ComparatorUtils.equals(XMLDataModel.this.columns[i].getName(), xMLableReader.getTagName()) || this.layer + 2 < xMLableReader.getDeep()) continue;
                    bl = true;
                    break;
                }
                if (ComparatorUtils.equals(string, xMLableReader.getTagName()) || bl) {
                    if (XMLDataModel.this.xPath.length == this.layer + 2) {
                        Object[] objectArray = new Object[XMLDataModel.this.columns.length + 1];
                        xMLableReader.readXMLObject(new ReadXMLColumn(objectArray));
                        XMLDataModel.this.row_list.add(objectArray);
                    } else {
                        xMLableReader.readXMLObject(new ReadXMLLayer(this.layer + 1));
                    }
                }
            }
        }
    }
}

