/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.Parameter;
import com.fr.base.ParameterHelper;
import com.fr.data.AbstractDataModel;
import com.fr.general.FRLogger;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;

public class TextDataModel
extends AbstractDataModel {
    private String filePath = null;
    private Parameter[] params;
    private String delimiter = null;
    private List columnNameList = null;
    private List rowValueList = null;
    private int columnCount = 0;
    private int rowCount = 0;
    private boolean needColumnName = false;
    private boolean isIgnoreOneMoreDelimiter = true;
    private String charset = "";

    public TextDataModel(String string, String string2, boolean bl, boolean bl2, Parameter[] parameterArray, String string3) {
        this.filePath = string;
        this.delimiter = string2;
        this.needColumnName = bl;
        this.isIgnoreOneMoreDelimiter = bl2;
        this.params = parameterArray;
        this.charset = string3;
    }

    public int getColumnCount() {
        this.initial();
        return this.columnCount;
    }

    public String getColumnName(int n) {
        this.loadColumnName();
        if (this.needColumnName) {
            return n < this.columnNameList.size() ? this.columnNameList.get(n).toString() : null;
        }
        String string = "#";
        return string + (n + 1);
    }

    public int getRowCount() {
        this.initial();
        return this.rowCount;
    }

    public Object getValueAt(int n, int n2) {
        this.initial();
        List list = (List)this.rowValueList.get(n);
        return n2 < list.size() ? list.get(n2) : null;
    }

    private void loadColumnName() {
        if (this.columnNameList != null) {
            return;
        }
        this.columnNameList = new ArrayList();
        try {
            InputStreamReader inputStreamReader = StringUtils.isNotBlank(this.charset) ? new InputStreamReader(this.getfileInputStream(), this.charset) : new InputStreamReader(this.getfileInputStream());
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string = null;
            string = bufferedReader.readLine();
            if (string != null) {
                string = string.trim();
                String[] stringArray = StableUtils.splitString(string, this.delimiter);
                if (this.isIgnoreOneMoreDelimiter) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!StringUtils.isNotEmpty(stringArray[i])) continue;
                        this.columnNameList.add(stringArray[i].trim());
                    }
                } else {
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.columnNameList.add(stringArray[i].trim());
                    }
                }
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
        }
    }

    private InputStream getfileInputStream() {
        try {
            this.filePath = ParameterHelper.analyze4Templatee(this.filePath, this.params);
            if (this.filePath.indexOf("http") != -1) {
                URL uRL = new URL(this.filePath);
                URLConnection uRLConnection = uRL.openConnection();
                return uRLConnection.getInputStream();
            }
            return new FileInputStream(this.filePath);
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
            return null;
        }
    }

    private void initial() {
        if (this.rowValueList != null) {
            return;
        }
        this.rowValueList = new ArrayList();
        try {
            InputStreamReader inputStreamReader = StringUtils.isNotBlank(this.charset) ? new InputStreamReader(this.getfileInputStream(), this.charset) : new InputStreamReader(this.getfileInputStream());
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                int n;
                ArrayList<String> arrayList = new ArrayList<String>();
                string = string.replaceAll("\\s*$", "");
                String[] stringArray = StableUtils.splitString(string, this.delimiter);
                if (this.isIgnoreOneMoreDelimiter) {
                    for (n = 0; n < stringArray.length; ++n) {
                        if (StringUtils.isNotEmpty(stringArray[n])) {
                            arrayList.add(stringArray[n].trim());
                        }
                        this.columnCount = this.columnCount < arrayList.size() ? arrayList.size() : this.columnCount;
                    }
                } else {
                    for (n = 0; n < stringArray.length; ++n) {
                        arrayList.add(stringArray[n].trim());
                        this.columnCount = this.columnCount < arrayList.size() ? arrayList.size() : this.columnCount;
                    }
                }
                this.rowValueList.add(arrayList);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
        }
        if (this.needColumnName && !this.rowValueList.isEmpty()) {
            this.rowValueList.remove(0);
        }
        this.rowCount = this.rowValueList.size();
    }

    public void release() throws Exception {
    }
}

