/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.data.AbstractDataModel;
import com.fr.data.impl.AutoParentBuilder;
import com.fr.data.impl.Forest;
import com.fr.data.impl.Node;
import com.fr.general.ComparatorUtils;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.stable.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class RecursionDataModel
extends AbstractDataModel {
    private DataModel originalTableDataModel;
    private transient List columnNameList = new ArrayList();
    private int markField;
    private int parentMarkField;
    private AutoParentBuilder autoParentBuilder;
    private static final String GENFIELD = "FR_GEN_";
    private Object[][] valuePath;
    private String[] nodeIdArray;
    private Node[] nodeArray;

    public RecursionDataModel(DataModel dataModel, int n, int n2) {
        this.originalTableDataModel = dataModel;
        this.setMarkField(n);
        this.parentMarkField = n2;
    }

    public int getParentMarkField() {
        return this.parentMarkField;
    }

    public int getColumnCount() throws TableDataException {
        this.initColumn();
        return this.columnNameList.size();
    }

    private void build() throws TableDataException {
        Forest forest = this.buildForest();
        int n = this.originalTableDataModel.getRowCount();
        this.valuePath = forest.toTableArray(n);
        this.nodeIdArray = forest.createQNodeIdArray(n);
        this.nodeArray = forest.getNodeArrayOrderByRow(n);
    }

    private Forest buildForest() throws TableDataException {
        Forest forest = new Forest();
        for (int i = 0; i < this.originalTableDataModel.getRowCount(); ++i) {
            Object object = this.originalTableDataModel.getValueAt(i, this.getMarkField());
            String string = this.getParentValue(object, i);
            Node node = this.createNode(i, object);
            Node node2 = this.createNode(-1, string);
            forest.addNodePair(node2, node);
        }
        forest.mergeTrees();
        return forest;
    }

    private String getParentValue(Object object, int n) throws TableDataException {
        if (this.parentMarkField >= 0) {
            Object object2 = this.originalTableDataModel.getValueAt(n, this.parentMarkField);
            return object2 == null ? null : object2.toString();
        }
        return this.getAutoParentValue(object, n);
    }

    private String getAutoParentValue(Object object, int n) throws TableDataException {
        this.initAutoParentBuilder();
        return this.autoParentBuilder.getParentId(n);
    }

    private void initAutoParentBuilder() {
        if (this.autoParentBuilder == null) {
            this.autoParentBuilder = new AutoParentBuilder();
            this.autoParentBuilder.setDataModel(this.originalTableDataModel);
            this.autoParentBuilder.setMarkField(this.markField);
        }
    }

    private Node createNode(int n, Object object) {
        if (this.isBlank(object)) {
            return Node.NULL;
        }
        Node node = new Node(object.toString());
        node.setRow(n);
        return node;
    }

    private boolean isBlank(Object object) {
        if (object == null) {
            return true;
        }
        String string = object.toString();
        return StringUtils.isBlank(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initColumn() throws TableDataException {
        RecursionDataModel recursionDataModel = this;
        synchronized (recursionDataModel) {
            int n;
            if (!this.columnNameList.isEmpty()) {
                return;
            }
            this.init();
            for (n = 0; n < this.originalTableDataModel.getColumnCount(); ++n) {
                this.columnNameList.add(this.originalTableDataModel.getColumnName(n));
            }
            if (this.valuePath.length == 0) {
                return;
            }
            for (n = 0; n < this.valuePath[0].length; ++n) {
                this.columnNameList.add(GENFIELD + n);
            }
        }
    }

    public String getColumnName(int n) throws TableDataException {
        this.initColumn();
        return (String)this.columnNameList.get(n);
    }

    public int getRowCount() throws TableDataException {
        return this.originalTableDataModel.getRowCount();
    }

    public Object getValueAt(int n, int n2) throws TableDataException {
        if (n < 0 || n2 < 0) {
            return null;
        }
        if (n2 < this.originalTableDataModel.getColumnCount()) {
            return this.originalTableDataModel.getValueAt(n, n2);
        }
        return this.getValueFromLayerList(n, n2 - this.originalTableDataModel.getColumnCount());
    }

    private Object getValueFromLayerList(int n, int n2) throws TableDataException {
        if (this.valuePath == null) {
            this.init();
        }
        return this.valuePath[n][n2];
    }

    public void release() throws Exception {
    }

    public Object[][] getValuePath() throws TableDataException {
        this.initColumn();
        if (this.valuePath == null) {
            this.init();
        }
        return this.valuePath;
    }

    private void init() throws TableDataException {
        if (this.valuePath == null) {
            this.build();
        }
    }

    public boolean hasChildren(int n) throws TableDataException {
        this.initColumn();
        Node node = this.nodeArray[n];
        if (Node.isNULL(node)) {
            return false;
        }
        return node.getChildSize() != 0;
    }

    private int getParentIndex(int n) throws TableDataException {
        this.initColumn();
        String string = this._getParentValue(n);
        int n2 = this.getRowCount();
        for (int i = 0; i < n2; ++i) {
            if (!ComparatorUtils.equals(this.getValueAt(i, this.markField).toString(), string)) continue;
            return i;
        }
        return -1;
    }

    private String _getParentValue(int n) throws TableDataException {
        Object object = null;
        if (this.parentMarkField > 0) {
            object = this.originalTableDataModel.getValueAt(n, this.parentMarkField);
        } else {
            Object object2 = this.originalTableDataModel.getValueAt(n, this.markField);
            object = this.getAutoParentValue(object2, n);
        }
        return object == null ? "" : object.toString();
    }

    public String getParentValue(int n) throws TableDataException {
        this.initColumn();
        return this._getParentValue(n);
    }

    public String getParentId(int n) throws TableDataException {
        this.initColumn();
        Node node = this.nodeArray[n];
        Node node2 = node.getParent();
        if (Node.isNULL(node2) || !node2.hasIdentifyRow()) {
            return "0";
        }
        String string = this.nodeIdArray[node2.getRow()];
        return string == null ? "0" : string;
    }

    public String getId(int n) throws TableDataException {
        this.initColumn();
        if (this.nodeIdArray == null) {
            this.init();
        }
        return this.nodeIdArray[n];
    }

    public static int getNotNullLength(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != null) continue;
            return i;
        }
        return objectArray.length;
    }

    public int getMarkField() {
        return this.markField;
    }

    public void setMarkField(int n) {
        this.markField = n;
    }
}

