/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.data.Dictionary;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.stable.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class JQNode {
    public static final String ID_SPLIT = "-";
    private String id;
    private String text;
    private String value;
    private boolean isExpand;
    private boolean hasChildren;
    private boolean showCheck;
    private boolean complete;
    private int checkState;

    public JQNode(String string, String string2, String string3, boolean bl) {
        this(string, string2, string3, bl, true);
    }

    public JQNode(String string, String string2, String string3, boolean bl, boolean bl2) {
        this(string, string2, string3, bl, bl2, false, false, 0);
    }

    public JQNode(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n) {
        this.id = string;
        this.text = string3;
        this.value = string2;
        this.isExpand = bl3;
        this.hasChildren = bl;
        this.showCheck = bl2;
        this.complete = bl4;
        this.checkState = n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof JQNode)) {
            return false;
        }
        JQNode jQNode = (JQNode)object;
        return this.id == jQNode.id;
    }

    public static JSONArray toJSONArray(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        for (JQNode jQNode : list) {
            stringBuffer.append("{id:");
            stringBuffer.append("\"" + jQNode.id + "\"");
            stringBuffer.append(",text:");
            stringBuffer.append("\"" + (jQNode.text != null ? jQNode.text.replaceAll("\"", "\\\\\"") : "") + "\"");
            stringBuffer.append(",value:");
            stringBuffer.append("\"" + jQNode.value + "\"");
            stringBuffer.append(",showcheck:");
            stringBuffer.append(jQNode.showCheck);
            stringBuffer.append(",complete:");
            stringBuffer.append(jQNode.complete);
            stringBuffer.append(",isexpand:");
            stringBuffer.append(jQNode.isExpand);
            stringBuffer.append(",checkstate:");
            stringBuffer.append(jQNode.checkState);
            stringBuffer.append(",hasChildren:");
            stringBuffer.append(jQNode.hasChildren);
            stringBuffer.append("},");
        }
        if (stringBuffer.length() > 2) {
            stringBuffer.substring(0, stringBuffer.length() - 3);
        }
        stringBuffer.append(']');
        try {
            return new JSONArray(stringBuffer.toString().replaceAll(",]", "]"));
        }
        catch (JSONException jSONException) {
            return new JSONArray();
        }
    }

    public static class Node {
        private String layer;
        private Dictionary.MV mv;

        public Node(String string, Dictionary.MV mV) {
            this.layer = string;
            this.mv = mV;
        }

        public int hashCode() {
            int n = 17;
            n = 37 * n + this.layer.hashCode();
            n = 37 * n + this.mv.hashCode();
            return n;
        }

        public boolean equals(Object object) {
            return object instanceof Node && ComparatorUtils.equals(((Node)object).layer, this.layer) && ComparatorUtils.equals(((Node)object).mv, this.mv);
        }
    }

    private static class Recursion {
        protected StringBuffer sb = new StringBuffer();

        public String generateJSONString(List list) throws Exception {
            return this.generateJSONString(list, true);
        }

        public String generateJSONString(List list, boolean bl) throws Exception {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                QNode qNode = (QNode)list.get(i);
                if (this.hasParent(list, qNode)) continue;
                this.recursionFn(list, qNode, bl);
            }
            return this.modify(this.sb.toString());
        }

        public void recursionFn(List list, QNode qNode) throws Exception {
            this.recursionFn(list, qNode, true);
        }

        public void recursionFn(List list, QNode qNode, boolean bl) throws Exception {
            if (this.hasChild(list, qNode, bl)) {
                this.sb.append("{id:");
                this.sb.append(qNode.id);
                this.sb.append(",text:");
                this.sb.append("\"" + qNode.text + "\"");
                this.sb.append(",value:");
                this.sb.append("\"" + qNode.value + "\"");
                this.sb.append(",showcheck:");
                this.sb.append(qNode.showCheck);
                this.sb.append(",complete:true");
                this.sb.append(",isexpand:");
                this.sb.append(qNode.isExpand);
                this.sb.append(",checkstate:");
                this.sb.append(qNode.checkState);
                this.sb.append(",hasChildren:");
                this.sb.append(qNode.hasChildren);
                this.sb.append(",ChildNodes:[");
                List list2 = this.getChildList(list, qNode);
                for (QNode qNode2 : list2) {
                    this.recursionFn(list, qNode2, bl);
                }
                this.sb.append("]},");
            } else {
                this.sb.append("{id:");
                this.sb.append(qNode.id);
                this.sb.append(",text:");
                this.sb.append("\"" + qNode.text + "\"");
                this.sb.append(",value:");
                this.sb.append("\"" + qNode.value + "\"");
                this.sb.append(",showcheck:");
                this.sb.append(qNode.showCheck);
                this.sb.append(",complete:true");
                this.sb.append(",isexpand:");
                this.sb.append(qNode.isExpand);
                this.sb.append(",checkstate:");
                this.sb.append(qNode.checkState);
                this.sb.append(",hasChildren:");
                this.sb.append(qNode.hasChildren);
                this.sb.append("},");
            }
        }

        public boolean hasChild(List list, QNode qNode) {
            return qNode.hasChildren && qNode.isExpand;
        }

        public boolean hasChild(List list, QNode qNode, boolean bl) {
            return qNode.hasChildren && (qNode.isExpand || !bl);
        }

        public boolean hasParent(List list, QNode qNode) {
            return StringUtils.isNotEmpty(qNode.parentId) && !ComparatorUtils.equals("0", qNode.parentId);
        }

        public List getChildList(List list, QNode qNode) {
            ArrayList<QNode> arrayList = new ArrayList<QNode>();
            for (QNode qNode2 : list) {
                if (!ComparatorUtils.equals(qNode2.parentId, qNode.id)) continue;
                arrayList.add(qNode2);
            }
            return arrayList;
        }

        public String modify(String string) {
            return ("[" + string + "]").replaceAll(",]", "]");
        }
    }

    public static class QNode {
        protected String id;
        protected String parentId;
        protected String text;
        protected String value;
        protected boolean showCheck;
        protected int checkState;
        protected boolean isExpand;
        protected boolean hasChildren;

        public QNode(String string, String string2) {
            this(string, string2, "root", "root");
        }

        public QNode(String string, String string2, String string3, String string4) {
            this(string, string2, string3, string4, false, 1, true, true);
        }

        public QNode(String string, String string2, String string3, String string4, boolean bl, int n, boolean bl2, boolean bl3) {
            this.id = string;
            this.parentId = string2;
            this.text = string4;
            this.value = string3;
            this.showCheck = bl;
            this.checkState = n;
            this.isExpand = bl2;
            this.hasChildren = bl3;
        }

        public boolean isExpand() {
            return this.isExpand;
        }

        public void setExpand(boolean bl) {
            this.isExpand = bl;
        }

        public void setCheckState(int n) {
            this.checkState = n;
        }

        public String getParentID() {
            return this.parentId;
        }

        public static JSONArray createTreeNode(List list) throws Exception {
            return QNode.createTreeNode(list, true);
        }

        public static JSONArray createTreeNode(List list, boolean bl) throws Exception {
            Recursion recursion = new Recursion();
            String string = recursion.generateJSONString(list, bl);
            return new JSONArray(string);
        }
    }
}

